/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.Comment;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.cobol.tree.SequenceArea;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class CommentLine
implements CobolLine,
Comment {
    private final Markers markers;
    @Nullable
    private final SequenceArea sequenceArea;
    private final IndicatorArea indicatorArea;
    private final String contentArea;
    @Nullable
    private final CommentArea commentArea;
    private final boolean isCopiedSource;
    private static final UnaryOperator<String> COBOL_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public <P> void printCobolLine(CobolPreprocessorSourcePrinter<P> sourcePrinter, Cursor cursor, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)this), COBOL_MARKER_WRAPPER));
        }
        if (!this.isCopiedSource) {
            if (this.sequenceArea != null) {
                this.sequenceArea.printColumnArea(sourcePrinter, cursor, true, p);
            }
            this.indicatorArea.printColumnArea(sourcePrinter, cursor, true, p);
            p.append(this.contentArea);
            if (this.commentArea != null) {
                this.commentArea.printColumnArea(sourcePrinter, cursor, true, p);
            }
        }
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)this), COBOL_MARKER_WRAPPER));
        }
    }

    @Override
    public <P> void printCobolLine(CobolSourcePrinter<P> sourcePrinter, Cursor cursor, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)this), COBOL_MARKER_WRAPPER));
        }
        if (!this.isCopiedSource) {
            if (this.sequenceArea != null) {
                this.sequenceArea.printColumnArea(sourcePrinter, cursor, true, p);
            }
            this.indicatorArea.printColumnArea(sourcePrinter, cursor, true, p);
            p.append(this.contentArea);
            if (this.commentArea != null) {
                this.commentArea.printColumnArea(sourcePrinter, cursor, true, p);
            }
        }
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)this), COBOL_MARKER_WRAPPER));
        }
    }

    public CommentLine(Markers markers, SequenceArea sequenceArea, IndicatorArea indicatorArea, String contentArea, CommentArea commentArea, boolean isCopiedSource) {
        this.markers = markers;
        this.sequenceArea = sequenceArea;
        this.indicatorArea = indicatorArea;
        this.contentArea = contentArea;
        this.commentArea = commentArea;
        this.isCopiedSource = isCopiedSource;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    public SequenceArea getSequenceArea() {
        return this.sequenceArea;
    }

    @Override
    public IndicatorArea getIndicatorArea() {
        return this.indicatorArea;
    }

    public String getContentArea() {
        return this.contentArea;
    }

    @Override
    public CommentArea getCommentArea() {
        return this.commentArea;
    }

    @Override
    public boolean isCopiedSource() {
        return this.isCopiedSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentLine)) {
            return false;
        }
        CommentLine other = (CommentLine)o;
        if (this.isCopiedSource() != other.isCopiedSource()) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        SequenceArea this$sequenceArea = this.getSequenceArea();
        SequenceArea other$sequenceArea = other.getSequenceArea();
        if (this$sequenceArea == null ? other$sequenceArea != null : !((Object)this$sequenceArea).equals(other$sequenceArea)) {
            return false;
        }
        IndicatorArea this$indicatorArea = this.getIndicatorArea();
        IndicatorArea other$indicatorArea = other.getIndicatorArea();
        if (this$indicatorArea == null ? other$indicatorArea != null : !((Object)this$indicatorArea).equals(other$indicatorArea)) {
            return false;
        }
        String this$contentArea = this.getContentArea();
        String other$contentArea = other.getContentArea();
        if (this$contentArea == null ? other$contentArea != null : !this$contentArea.equals(other$contentArea)) {
            return false;
        }
        CommentArea this$commentArea = this.getCommentArea();
        CommentArea other$commentArea = other.getCommentArea();
        return !(this$commentArea == null ? other$commentArea != null : !((Object)this$commentArea).equals(other$commentArea));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCopiedSource() ? 79 : 97);
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        SequenceArea $sequenceArea = this.getSequenceArea();
        result = result * 59 + ($sequenceArea == null ? 43 : ((Object)$sequenceArea).hashCode());
        IndicatorArea $indicatorArea = this.getIndicatorArea();
        result = result * 59 + ($indicatorArea == null ? 43 : ((Object)$indicatorArea).hashCode());
        String $contentArea = this.getContentArea();
        result = result * 59 + ($contentArea == null ? 43 : $contentArea.hashCode());
        CommentArea $commentArea = this.getCommentArea();
        result = result * 59 + ($commentArea == null ? 43 : ((Object)$commentArea).hashCode());
        return result;
    }

    public String toString() {
        return "CommentLine(markers=" + this.getMarkers() + ", sequenceArea=" + this.getSequenceArea() + ", indicatorArea=" + this.getIndicatorArea() + ", contentArea=" + this.getContentArea() + ", commentArea=" + this.getCommentArea() + ", isCopiedSource=" + this.isCopiedSource() + ")";
    }

    public CommentLine withMarkers(Markers markers) {
        return this.markers == markers ? this : new CommentLine(markers, this.sequenceArea, this.indicatorArea, this.contentArea, this.commentArea, this.isCopiedSource);
    }

    public CommentLine withSequenceArea(SequenceArea sequenceArea) {
        return this.sequenceArea == sequenceArea ? this : new CommentLine(this.markers, sequenceArea, this.indicatorArea, this.contentArea, this.commentArea, this.isCopiedSource);
    }

    public CommentLine withIndicatorArea(IndicatorArea indicatorArea) {
        return this.indicatorArea == indicatorArea ? this : new CommentLine(this.markers, this.sequenceArea, indicatorArea, this.contentArea, this.commentArea, this.isCopiedSource);
    }

    public CommentLine withContentArea(String contentArea) {
        return this.contentArea == contentArea ? this : new CommentLine(this.markers, this.sequenceArea, this.indicatorArea, contentArea, this.commentArea, this.isCopiedSource);
    }

    public CommentLine withCommentArea(CommentArea commentArea) {
        return this.commentArea == commentArea ? this : new CommentLine(this.markers, this.sequenceArea, this.indicatorArea, this.contentArea, commentArea, this.isCopiedSource);
    }

    public CommentLine withCopiedSource(boolean isCopiedSource) {
        return this.isCopiedSource == isCopiedSource ? this : new CommentLine(this.markers, this.sequenceArea, this.indicatorArea, this.contentArea, this.commentArea, isCopiedSource);
    }
}

