/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public class CobolRightPadded<T> {
    private final T element;
    private final Space after;
    private final Markers markers;

    public CobolRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    public static <T> List<T> getElements(List<CobolRightPadded<T>> ls) {
        ArrayList<T> list = new ArrayList<T>();
        for (CobolRightPadded<T> l : ls) {
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <P extends Cobol> List<CobolRightPadded<P>> withElements(List<CobolRightPadded<P>> before, List<P> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        }
        ArrayList<CobolRightPadded<P>> after = new ArrayList<CobolRightPadded<P>>(elements.size());
        Map beforeById = before.stream().collect(Collectors.toMap(j -> ((Cobol)j.getElement()).getId(), Function.identity()));
        for (Cobol t : elements) {
            if (beforeById.get(t.getId()) != null) {
                CobolRightPadded found = (CobolRightPadded)beforeById.get(t.getId());
                after.add(found.withElement(t));
                continue;
            }
            after.add(new CobolRightPadded<Cobol>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T> CobolRightPadded<T> build(T element) {
        return new CobolRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    @Nullable
    public static <T> CobolRightPadded<T> withElement(@Nullable CobolRightPadded<T> before, @Nullable T elements) {
        if (before == null) {
            if (elements == null) {
                return null;
            }
            return new CobolRightPadded<T>(elements, Space.EMPTY, Markers.EMPTY);
        }
        if (elements == null) {
            return null;
        }
        return before.withElement(elements);
    }

    public String toString() {
        return "CobolRightPadded(element=" + this.element.getClass().getSimpleName() + ", after=" + this.after + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CobolRightPadded)) {
            return false;
        }
        CobolRightPadded other = (CobolRightPadded)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CobolRightPadded;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public CobolRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    public T getElement() {
        return this.element;
    }

    public Space getAfter() {
        return this.after;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public CobolRightPadded<T> withElement(T element) {
        return this.element == element ? this : new CobolRightPadded<T>(element, this.after, this.markers);
    }

    public CobolRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new CobolRightPadded<T>(this.element, after, this.markers);
    }

    public CobolRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new CobolRightPadded<T>(this.element, this.after, markers);
    }
}

