/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolPreprocessorVisitor;
import org.openrewrite.cobol.internal.CobolPreprocessorPrinter;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolSourceFile;
import org.openrewrite.cobol.tree.Comment;
import org.openrewrite.cobol.tree.CopybookSource;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public interface CobolPreprocessor
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptCobolPreprocessor((CobolPreprocessorVisitor)v.adapt(CobolPreprocessorVisitor.class), p);
    }

    @Nullable
    default public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
        return (CobolPreprocessor)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(CobolPreprocessorVisitor.class);
    }

    public Space getPrefix();

    public <P extends CobolPreprocessor> P withPrefix(Space var1);

    default public UUID getId() {
        return Cobol.CompilationUnit.id;
    }

    default public <T extends Tree> T withId(UUID id) {
        return (T)this;
    }

    public static final class Word
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final Cobol.Word cobolWord;

        @Override
        public Space getPrefix() {
            return this.cobolWord.getPrefix();
        }

        public Word withPrefix(Space prefix) {
            return this.cobolWord.getPrefix() == prefix ? this : this.withCobolWord(this.cobolWord.withPrefix(prefix));
        }

        public Markers getMarkers() {
            return this.cobolWord.getMarkers();
        }

        public Word withMarkers(Markers markers) {
            return this.cobolWord.getMarkers() == markers ? this : this.withCobolWord(this.cobolWord.withMarkers(markers));
        }

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitWord(this, p);
        }

        public Word(Space prefix, Markers markers, Cobol.Word cobolWord) {
            this.prefix = prefix;
            this.markers = markers;
            this.cobolWord = cobolWord;
        }

        public Cobol.Word getCobolWord() {
            return this.cobolWord;
        }

        public String toString() {
            return "CobolPreprocessor.Word(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cobolWord=" + this.getCobolWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Word)) {
                return false;
            }
            Word other = (Word)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Cobol.Word this$cobolWord = this.getCobolWord();
            Cobol.Word other$cobolWord = other.getCobolWord();
            return !(this$cobolWord == null ? other$cobolWord != null : !((Object)this$cobolWord).equals(other$cobolWord));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Cobol.Word $cobolWord = this.getCobolWord();
            result = result * 59 + ($cobolWord == null ? 43 : ((Object)$cobolWord).hashCode());
            return result;
        }

        public Word withCobolWord(Cobol.Word cobolWord) {
            return this.cobolWord == cobolWord ? this : new Word(this.prefix, this.markers, cobolWord);
        }
    }

    public static final class TitleStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word first;
        private final Word second;
        @Nullable
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitTitleStatement(this, p);
        }

        public TitleStatement(UUID id, Space prefix, Markers markers, Word first, Word second, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.first = first;
            this.second = second;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getFirst() {
            return this.first;
        }

        public Word getSecond() {
            return this.second;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.TitleStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", first=" + this.getFirst() + ", second=" + this.getSecond() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TitleStatement)) {
                return false;
            }
            TitleStatement other = (TitleStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$first = this.getFirst();
            Word other$first = other.getFirst();
            if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
                return false;
            }
            Word this$second = this.getSecond();
            Word other$second = other.getSecond();
            if (this$second == null ? other$second != null : !((Object)this$second).equals(other$second)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
            Word $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public TitleStatement withId(UUID id) {
            return this.id == id ? this : new TitleStatement(id, this.prefix, this.markers, this.first, this.second, this.dot);
        }

        public TitleStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TitleStatement(this.id, prefix, this.markers, this.first, this.second, this.dot);
        }

        public TitleStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new TitleStatement(this.id, this.prefix, markers, this.first, this.second, this.dot);
        }

        public TitleStatement withFirst(Word first) {
            return this.first == first ? this : new TitleStatement(this.id, this.prefix, this.markers, first, this.second, this.dot);
        }

        public TitleStatement withSecond(Word second) {
            return this.second == second ? this : new TitleStatement(this.id, this.prefix, this.markers, this.first, second, this.dot);
        }

        public TitleStatement withDot(Word dot) {
            return this.dot == dot ? this : new TitleStatement(this.id, this.prefix, this.markers, this.first, this.second, dot);
        }
    }

    public static final class SkipStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        @Nullable
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitSkipStatement(this, p);
        }

        public SkipStatement(UUID id, Space prefix, Markers markers, Word word, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.SkipStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkipStatement)) {
                return false;
            }
            SkipStatement other = (SkipStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public SkipStatement withId(UUID id) {
            return this.id == id ? this : new SkipStatement(id, this.prefix, this.markers, this.word, this.dot);
        }

        public SkipStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SkipStatement(this.id, prefix, this.markers, this.word, this.dot);
        }

        public SkipStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new SkipStatement(this.id, this.prefix, markers, this.word, this.dot);
        }

        public SkipStatement withWord(Word word) {
            return this.word == word ? this : new SkipStatement(this.id, this.prefix, this.markers, word, this.dot);
        }

        public SkipStatement withDot(Word dot) {
            return this.dot == dot ? this : new SkipStatement(this.id, this.prefix, this.markers, this.word, dot);
        }
    }

    public static final class ReplacingPhrase
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final List<ReplaceClause> clauses;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitReplacingPhrase(this, p);
        }

        public ReplacingPhrase(UUID id, Space prefix, Markers markers, Word word, List<ReplaceClause> clauses) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.clauses = clauses;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public List<ReplaceClause> getClauses() {
            return this.clauses;
        }

        public String toString() {
            return "CobolPreprocessor.ReplacingPhrase(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", clauses=" + this.getClauses() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplacingPhrase)) {
                return false;
            }
            ReplacingPhrase other = (ReplacingPhrase)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            List<ReplaceClause> this$clauses = this.getClauses();
            List<ReplaceClause> other$clauses = other.getClauses();
            return !(this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            List<ReplaceClause> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            return result;
        }

        public ReplacingPhrase withId(UUID id) {
            return this.id == id ? this : new ReplacingPhrase(id, this.prefix, this.markers, this.word, this.clauses);
        }

        public ReplacingPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReplacingPhrase(this.id, prefix, this.markers, this.word, this.clauses);
        }

        public ReplacingPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReplacingPhrase(this.id, this.prefix, markers, this.word, this.clauses);
        }

        public ReplacingPhrase withWord(Word word) {
            return this.word == word ? this : new ReplacingPhrase(this.id, this.prefix, this.markers, word, this.clauses);
        }

        public ReplacingPhrase withClauses(List<ReplaceClause> clauses) {
            return this.clauses == clauses ? this : new ReplacingPhrase(this.id, this.prefix, this.markers, this.word, clauses);
        }
    }

    public static final class ReplaceOffStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitReplaceOffStatement(this, p);
        }

        public ReplaceOffStatement(UUID id, Space prefix, Markers markers, List<Word> words, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.ReplaceOffStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceOffStatement)) {
                return false;
            }
            ReplaceOffStatement other = (ReplaceOffStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReplaceOffStatement withId(UUID id) {
            return this.id == id ? this : new ReplaceOffStatement(id, this.prefix, this.markers, this.words, this.dot);
        }

        public ReplaceOffStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReplaceOffStatement(this.id, prefix, this.markers, this.words, this.dot);
        }

        public ReplaceOffStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReplaceOffStatement(this.id, this.prefix, markers, this.words, this.dot);
        }

        public ReplaceOffStatement withWords(List<Word> words) {
            return this.words == words ? this : new ReplaceOffStatement(this.id, this.prefix, this.markers, words, this.dot);
        }

        public ReplaceOffStatement withDot(Word dot) {
            return this.dot == dot ? this : new ReplaceOffStatement(this.id, this.prefix, this.markers, this.words, dot);
        }
    }

    public static final class ReplaceClause
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final CobolPreprocessor replaceable;
        private final Word by;
        private final CobolPreprocessor replacement;
        @Nullable
        private final List<CobolPreprocessor> subscript;
        @Nullable
        private final List<DirectoryPhrase> directoryPhrases;
        @Nullable
        private final FamilyPhrase familyPhrase;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitReplaceClause(this, p);
        }

        public ReplaceClause(UUID id, Space prefix, Markers markers, CobolPreprocessor replaceable, Word by, CobolPreprocessor replacement, List<CobolPreprocessor> subscript, List<DirectoryPhrase> directoryPhrases, FamilyPhrase familyPhrase) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.replaceable = replaceable;
            this.by = by;
            this.replacement = replacement;
            this.subscript = subscript;
            this.directoryPhrases = directoryPhrases;
            this.familyPhrase = familyPhrase;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public CobolPreprocessor getReplaceable() {
            return this.replaceable;
        }

        public Word getBy() {
            return this.by;
        }

        public CobolPreprocessor getReplacement() {
            return this.replacement;
        }

        public List<CobolPreprocessor> getSubscript() {
            return this.subscript;
        }

        public List<DirectoryPhrase> getDirectoryPhrases() {
            return this.directoryPhrases;
        }

        public FamilyPhrase getFamilyPhrase() {
            return this.familyPhrase;
        }

        public String toString() {
            return "CobolPreprocessor.ReplaceClause(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", replaceable=" + this.getReplaceable() + ", by=" + this.getBy() + ", replacement=" + this.getReplacement() + ", subscript=" + this.getSubscript() + ", directoryPhrases=" + this.getDirectoryPhrases() + ", familyPhrase=" + this.getFamilyPhrase() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceClause)) {
                return false;
            }
            ReplaceClause other = (ReplaceClause)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            CobolPreprocessor this$replaceable = this.getReplaceable();
            CobolPreprocessor other$replaceable = other.getReplaceable();
            if (this$replaceable == null ? other$replaceable != null : !this$replaceable.equals(other$replaceable)) {
                return false;
            }
            Word this$by = this.getBy();
            Word other$by = other.getBy();
            if (this$by == null ? other$by != null : !((Object)this$by).equals(other$by)) {
                return false;
            }
            CobolPreprocessor this$replacement = this.getReplacement();
            CobolPreprocessor other$replacement = other.getReplacement();
            if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
                return false;
            }
            List<CobolPreprocessor> this$subscript = this.getSubscript();
            List<CobolPreprocessor> other$subscript = other.getSubscript();
            if (this$subscript == null ? other$subscript != null : !((Object)this$subscript).equals(other$subscript)) {
                return false;
            }
            List<DirectoryPhrase> this$directoryPhrases = this.getDirectoryPhrases();
            List<DirectoryPhrase> other$directoryPhrases = other.getDirectoryPhrases();
            if (this$directoryPhrases == null ? other$directoryPhrases != null : !((Object)this$directoryPhrases).equals(other$directoryPhrases)) {
                return false;
            }
            FamilyPhrase this$familyPhrase = this.getFamilyPhrase();
            FamilyPhrase other$familyPhrase = other.getFamilyPhrase();
            return !(this$familyPhrase == null ? other$familyPhrase != null : !((Object)this$familyPhrase).equals(other$familyPhrase));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            CobolPreprocessor $replaceable = this.getReplaceable();
            result = result * 59 + ($replaceable == null ? 43 : $replaceable.hashCode());
            Word $by = this.getBy();
            result = result * 59 + ($by == null ? 43 : ((Object)$by).hashCode());
            CobolPreprocessor $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            List<CobolPreprocessor> $subscript = this.getSubscript();
            result = result * 59 + ($subscript == null ? 43 : ((Object)$subscript).hashCode());
            List<DirectoryPhrase> $directoryPhrases = this.getDirectoryPhrases();
            result = result * 59 + ($directoryPhrases == null ? 43 : ((Object)$directoryPhrases).hashCode());
            FamilyPhrase $familyPhrase = this.getFamilyPhrase();
            result = result * 59 + ($familyPhrase == null ? 43 : ((Object)$familyPhrase).hashCode());
            return result;
        }

        public ReplaceClause withId(UUID id) {
            return this.id == id ? this : new ReplaceClause(id, this.prefix, this.markers, this.replaceable, this.by, this.replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReplaceClause(this.id, prefix, this.markers, this.replaceable, this.by, this.replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReplaceClause(this.id, this.prefix, markers, this.replaceable, this.by, this.replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withReplaceable(CobolPreprocessor replaceable) {
            return this.replaceable == replaceable ? this : new ReplaceClause(this.id, this.prefix, this.markers, replaceable, this.by, this.replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withBy(Word by) {
            return this.by == by ? this : new ReplaceClause(this.id, this.prefix, this.markers, this.replaceable, by, this.replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withReplacement(CobolPreprocessor replacement) {
            return this.replacement == replacement ? this : new ReplaceClause(this.id, this.prefix, this.markers, this.replaceable, this.by, replacement, this.subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withSubscript(List<CobolPreprocessor> subscript) {
            return this.subscript == subscript ? this : new ReplaceClause(this.id, this.prefix, this.markers, this.replaceable, this.by, this.replacement, subscript, this.directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withDirectoryPhrases(List<DirectoryPhrase> directoryPhrases) {
            return this.directoryPhrases == directoryPhrases ? this : new ReplaceClause(this.id, this.prefix, this.markers, this.replaceable, this.by, this.replacement, this.subscript, directoryPhrases, this.familyPhrase);
        }

        public ReplaceClause withFamilyPhrase(FamilyPhrase familyPhrase) {
            return this.familyPhrase == familyPhrase ? this : new ReplaceClause(this.id, this.prefix, this.markers, this.replaceable, this.by, this.replacement, this.subscript, this.directoryPhrases, familyPhrase);
        }
    }

    public static final class ReplaceByStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final List<ReplaceClause> clauses;
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitReplaceByStatement(this, p);
        }

        public ReplaceByStatement(UUID id, Space prefix, Markers markers, Word word, List<ReplaceClause> clauses, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.clauses = clauses;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public List<ReplaceClause> getClauses() {
            return this.clauses;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.ReplaceByStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", clauses=" + this.getClauses() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceByStatement)) {
                return false;
            }
            ReplaceByStatement other = (ReplaceByStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            List<ReplaceClause> this$clauses = this.getClauses();
            List<ReplaceClause> other$clauses = other.getClauses();
            if (this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            List<ReplaceClause> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReplaceByStatement withId(UUID id) {
            return this.id == id ? this : new ReplaceByStatement(id, this.prefix, this.markers, this.word, this.clauses, this.dot);
        }

        public ReplaceByStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReplaceByStatement(this.id, prefix, this.markers, this.word, this.clauses, this.dot);
        }

        public ReplaceByStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReplaceByStatement(this.id, this.prefix, markers, this.word, this.clauses, this.dot);
        }

        public ReplaceByStatement withWord(Word word) {
            return this.word == word ? this : new ReplaceByStatement(this.id, this.prefix, this.markers, word, this.clauses, this.dot);
        }

        public ReplaceByStatement withClauses(List<ReplaceClause> clauses) {
            return this.clauses == clauses ? this : new ReplaceByStatement(this.id, this.prefix, this.markers, this.word, clauses, this.dot);
        }

        public ReplaceByStatement withDot(Word dot) {
            return this.dot == dot ? this : new ReplaceByStatement(this.id, this.prefix, this.markers, this.word, this.clauses, dot);
        }
    }

    public static final class ReplaceArea
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ReplaceByStatement replaceByStatement;
        @Nullable
        private final List<CobolPreprocessor> cobols;
        @Nullable
        private final ReplaceOffStatement replaceOffStatement;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitReplaceArea(this, p);
        }

        public ReplaceArea(UUID id, Space prefix, Markers markers, ReplaceByStatement replaceByStatement, List<CobolPreprocessor> cobols, ReplaceOffStatement replaceOffStatement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.replaceByStatement = replaceByStatement;
            this.cobols = cobols;
            this.replaceOffStatement = replaceOffStatement;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ReplaceByStatement getReplaceByStatement() {
            return this.replaceByStatement;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public ReplaceOffStatement getReplaceOffStatement() {
            return this.replaceOffStatement;
        }

        public String toString() {
            return "CobolPreprocessor.ReplaceArea(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", replaceByStatement=" + this.getReplaceByStatement() + ", cobols=" + this.getCobols() + ", replaceOffStatement=" + this.getReplaceOffStatement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceArea)) {
                return false;
            }
            ReplaceArea other = (ReplaceArea)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ReplaceByStatement this$replaceByStatement = this.getReplaceByStatement();
            ReplaceByStatement other$replaceByStatement = other.getReplaceByStatement();
            if (this$replaceByStatement == null ? other$replaceByStatement != null : !((Object)this$replaceByStatement).equals(other$replaceByStatement)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            if (this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols)) {
                return false;
            }
            ReplaceOffStatement this$replaceOffStatement = this.getReplaceOffStatement();
            ReplaceOffStatement other$replaceOffStatement = other.getReplaceOffStatement();
            return !(this$replaceOffStatement == null ? other$replaceOffStatement != null : !((Object)this$replaceOffStatement).equals(other$replaceOffStatement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ReplaceByStatement $replaceByStatement = this.getReplaceByStatement();
            result = result * 59 + ($replaceByStatement == null ? 43 : ((Object)$replaceByStatement).hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            ReplaceOffStatement $replaceOffStatement = this.getReplaceOffStatement();
            result = result * 59 + ($replaceOffStatement == null ? 43 : ((Object)$replaceOffStatement).hashCode());
            return result;
        }

        public ReplaceArea withId(UUID id) {
            return this.id == id ? this : new ReplaceArea(id, this.prefix, this.markers, this.replaceByStatement, this.cobols, this.replaceOffStatement);
        }

        public ReplaceArea withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReplaceArea(this.id, prefix, this.markers, this.replaceByStatement, this.cobols, this.replaceOffStatement);
        }

        public ReplaceArea withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReplaceArea(this.id, this.prefix, markers, this.replaceByStatement, this.cobols, this.replaceOffStatement);
        }

        public ReplaceArea withReplaceByStatement(ReplaceByStatement replaceByStatement) {
            return this.replaceByStatement == replaceByStatement ? this : new ReplaceArea(this.id, this.prefix, this.markers, replaceByStatement, this.cobols, this.replaceOffStatement);
        }

        public ReplaceArea withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new ReplaceArea(this.id, this.prefix, this.markers, this.replaceByStatement, cobols, this.replaceOffStatement);
        }

        public ReplaceArea withReplaceOffStatement(ReplaceOffStatement replaceOffStatement) {
            return this.replaceOffStatement == replaceOffStatement ? this : new ReplaceArea(this.id, this.prefix, this.markers, this.replaceByStatement, this.cobols, replaceOffStatement);
        }
    }

    public static final class PseudoText
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final Word doubleEqualOpen;
        @Nullable
        private final CharData charData;
        private final Word doubleEqualClose;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitPseudoText(this, p);
        }

        public PseudoText(Space prefix, Markers markers, Word doubleEqualOpen, CharData charData, Word doubleEqualClose) {
            this.prefix = prefix;
            this.markers = markers;
            this.doubleEqualOpen = doubleEqualOpen;
            this.charData = charData;
            this.doubleEqualClose = doubleEqualClose;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getDoubleEqualOpen() {
            return this.doubleEqualOpen;
        }

        public CharData getCharData() {
            return this.charData;
        }

        public Word getDoubleEqualClose() {
            return this.doubleEqualClose;
        }

        public String toString() {
            return "CobolPreprocessor.PseudoText(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", doubleEqualOpen=" + this.getDoubleEqualOpen() + ", charData=" + this.getCharData() + ", doubleEqualClose=" + this.getDoubleEqualClose() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PseudoText)) {
                return false;
            }
            PseudoText other = (PseudoText)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$doubleEqualOpen = this.getDoubleEqualOpen();
            Word other$doubleEqualOpen = other.getDoubleEqualOpen();
            if (this$doubleEqualOpen == null ? other$doubleEqualOpen != null : !((Object)this$doubleEqualOpen).equals(other$doubleEqualOpen)) {
                return false;
            }
            CharData this$charData = this.getCharData();
            CharData other$charData = other.getCharData();
            if (this$charData == null ? other$charData != null : !((Object)this$charData).equals(other$charData)) {
                return false;
            }
            Word this$doubleEqualClose = this.getDoubleEqualClose();
            Word other$doubleEqualClose = other.getDoubleEqualClose();
            return !(this$doubleEqualClose == null ? other$doubleEqualClose != null : !((Object)this$doubleEqualClose).equals(other$doubleEqualClose));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $doubleEqualOpen = this.getDoubleEqualOpen();
            result = result * 59 + ($doubleEqualOpen == null ? 43 : ((Object)$doubleEqualOpen).hashCode());
            CharData $charData = this.getCharData();
            result = result * 59 + ($charData == null ? 43 : ((Object)$charData).hashCode());
            Word $doubleEqualClose = this.getDoubleEqualClose();
            result = result * 59 + ($doubleEqualClose == null ? 43 : ((Object)$doubleEqualClose).hashCode());
            return result;
        }

        public PseudoText withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new PseudoText(prefix, this.markers, this.doubleEqualOpen, this.charData, this.doubleEqualClose);
        }

        public PseudoText withMarkers(Markers markers) {
            return this.markers == markers ? this : new PseudoText(this.prefix, markers, this.doubleEqualOpen, this.charData, this.doubleEqualClose);
        }

        public PseudoText withDoubleEqualOpen(Word doubleEqualOpen) {
            return this.doubleEqualOpen == doubleEqualOpen ? this : new PseudoText(this.prefix, this.markers, doubleEqualOpen, this.charData, this.doubleEqualClose);
        }

        public PseudoText withCharData(CharData charData) {
            return this.charData == charData ? this : new PseudoText(this.prefix, this.markers, this.doubleEqualOpen, charData, this.doubleEqualClose);
        }

        public PseudoText withDoubleEqualClose(Word doubleEqualClose) {
            return this.doubleEqualClose == doubleEqualClose ? this : new PseudoText(this.prefix, this.markers, this.doubleEqualOpen, this.charData, doubleEqualClose);
        }
    }

    public static final class FamilyPhrase
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Word name;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitFamilyPhrase(this, p);
        }

        public FamilyPhrase(UUID id, Space prefix, Markers markers, Word word, Word name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.name = name;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getName() {
            return this.name;
        }

        public String toString() {
            return "CobolPreprocessor.FamilyPhrase(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FamilyPhrase)) {
                return false;
            }
            FamilyPhrase other = (FamilyPhrase)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            return result;
        }

        public FamilyPhrase withId(UUID id) {
            return this.id == id ? this : new FamilyPhrase(id, this.prefix, this.markers, this.word, this.name);
        }

        public FamilyPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FamilyPhrase(this.id, prefix, this.markers, this.word, this.name);
        }

        public FamilyPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new FamilyPhrase(this.id, this.prefix, markers, this.word, this.name);
        }

        public FamilyPhrase withWord(Word word) {
            return this.word == word ? this : new FamilyPhrase(this.id, this.prefix, this.markers, word, this.name);
        }

        public FamilyPhrase withName(Word name) {
            return this.name == name ? this : new FamilyPhrase(this.id, this.prefix, this.markers, this.word, name);
        }
    }

    public static final class ExecSqlIncludeStatement
    implements CobolPreprocessor,
    CopybookSource {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word copySource;
        private final Word endExec;
        @Nullable
        private final Word dot;
        @Nullable
        private final Copybook copybook;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitExecSqlIncludeStatement(this, p);
        }

        public ExecSqlIncludeStatement(UUID id, Space prefix, Markers markers, List<Word> words, Word copySource, Word endExec, Word dot, Copybook copybook) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.copySource = copySource;
            this.endExec = endExec;
            this.dot = dot;
            this.copybook = copybook;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getCopySource() {
            return this.copySource;
        }

        public Word getEndExec() {
            return this.endExec;
        }

        public Word getDot() {
            return this.dot;
        }

        @Override
        public Copybook getCopybook() {
            return this.copybook;
        }

        public String toString() {
            return "CobolPreprocessor.ExecSqlIncludeStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", copySource=" + this.getCopySource() + ", endExec=" + this.getEndExec() + ", dot=" + this.getDot() + ", copybook=" + this.getCopybook() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecSqlIncludeStatement)) {
                return false;
            }
            ExecSqlIncludeStatement other = (ExecSqlIncludeStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$copySource = this.getCopySource();
            Word other$copySource = other.getCopySource();
            if (this$copySource == null ? other$copySource != null : !((Object)this$copySource).equals(other$copySource)) {
                return false;
            }
            Word this$endExec = this.getEndExec();
            Word other$endExec = other.getEndExec();
            if (this$endExec == null ? other$endExec != null : !((Object)this$endExec).equals(other$endExec)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            Copybook this$copybook = this.getCopybook();
            Copybook other$copybook = other.getCopybook();
            return !(this$copybook == null ? other$copybook != null : !((Object)this$copybook).equals(other$copybook));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $copySource = this.getCopySource();
            result = result * 59 + ($copySource == null ? 43 : ((Object)$copySource).hashCode());
            Word $endExec = this.getEndExec();
            result = result * 59 + ($endExec == null ? 43 : ((Object)$endExec).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            Copybook $copybook = this.getCopybook();
            result = result * 59 + ($copybook == null ? 43 : ((Object)$copybook).hashCode());
            return result;
        }

        public ExecSqlIncludeStatement withId(UUID id) {
            return this.id == id ? this : new ExecSqlIncludeStatement(id, this.prefix, this.markers, this.words, this.copySource, this.endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExecSqlIncludeStatement(this.id, prefix, this.markers, this.words, this.copySource, this.endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExecSqlIncludeStatement(this.id, this.prefix, markers, this.words, this.copySource, this.endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withWords(List<Word> words) {
            return this.words == words ? this : new ExecSqlIncludeStatement(this.id, this.prefix, this.markers, words, this.copySource, this.endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withCopySource(Word copySource) {
            return this.copySource == copySource ? this : new ExecSqlIncludeStatement(this.id, this.prefix, this.markers, this.words, copySource, this.endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withEndExec(Word endExec) {
            return this.endExec == endExec ? this : new ExecSqlIncludeStatement(this.id, this.prefix, this.markers, this.words, this.copySource, endExec, this.dot, this.copybook);
        }

        public ExecSqlIncludeStatement withDot(Word dot) {
            return this.dot == dot ? this : new ExecSqlIncludeStatement(this.id, this.prefix, this.markers, this.words, this.copySource, this.endExec, dot, this.copybook);
        }

        public ExecSqlIncludeStatement withCopybook(Copybook copybook) {
            return this.copybook == copybook ? this : new ExecSqlIncludeStatement(this.id, this.prefix, this.markers, this.words, this.copySource, this.endExec, this.dot, copybook);
        }
    }

    public static final class ExecStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final CobolPreprocessor cobol;
        private final Word endExec;
        @Nullable
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitExecStatement(this, p);
        }

        public ExecStatement(UUID id, Space prefix, Markers markers, List<Word> words, CobolPreprocessor cobol, Word endExec, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.cobol = cobol;
            this.endExec = endExec;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public CobolPreprocessor getCobol() {
            return this.cobol;
        }

        public Word getEndExec() {
            return this.endExec;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.ExecStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", cobol=" + this.getCobol() + ", endExec=" + this.getEndExec() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecStatement)) {
                return false;
            }
            ExecStatement other = (ExecStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            CobolPreprocessor this$cobol = this.getCobol();
            CobolPreprocessor other$cobol = other.getCobol();
            if (this$cobol == null ? other$cobol != null : !this$cobol.equals(other$cobol)) {
                return false;
            }
            Word this$endExec = this.getEndExec();
            Word other$endExec = other.getEndExec();
            if (this$endExec == null ? other$endExec != null : !((Object)this$endExec).equals(other$endExec)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            CobolPreprocessor $cobol = this.getCobol();
            result = result * 59 + ($cobol == null ? 43 : $cobol.hashCode());
            Word $endExec = this.getEndExec();
            result = result * 59 + ($endExec == null ? 43 : ((Object)$endExec).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ExecStatement withId(UUID id) {
            return this.id == id ? this : new ExecStatement(id, this.prefix, this.markers, this.words, this.cobol, this.endExec, this.dot);
        }

        public ExecStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExecStatement(this.id, prefix, this.markers, this.words, this.cobol, this.endExec, this.dot);
        }

        public ExecStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExecStatement(this.id, this.prefix, markers, this.words, this.cobol, this.endExec, this.dot);
        }

        public ExecStatement withWords(List<Word> words) {
            return this.words == words ? this : new ExecStatement(this.id, this.prefix, this.markers, words, this.cobol, this.endExec, this.dot);
        }

        public ExecStatement withCobol(CobolPreprocessor cobol) {
            return this.cobol == cobol ? this : new ExecStatement(this.id, this.prefix, this.markers, this.words, cobol, this.endExec, this.dot);
        }

        public ExecStatement withEndExec(Word endExec) {
            return this.endExec == endExec ? this : new ExecStatement(this.id, this.prefix, this.markers, this.words, this.cobol, endExec, this.dot);
        }

        public ExecStatement withDot(Word dot) {
            return this.dot == dot ? this : new ExecStatement(this.id, this.prefix, this.markers, this.words, this.cobol, this.endExec, dot);
        }
    }

    public static final class EjectStatement
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        @Nullable
        private final Word dot;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitEjectStatement(this, p);
        }

        public EjectStatement(UUID id, Space prefix, Markers markers, Word word, Word dot) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dot = dot;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "CobolPreprocessor.EjectStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EjectStatement)) {
                return false;
            }
            EjectStatement other = (EjectStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public EjectStatement withId(UUID id) {
            return this.id == id ? this : new EjectStatement(id, this.prefix, this.markers, this.word, this.dot);
        }

        public EjectStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EjectStatement(this.id, prefix, this.markers, this.word, this.dot);
        }

        public EjectStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new EjectStatement(this.id, this.prefix, markers, this.word, this.dot);
        }

        public EjectStatement withWord(Word word) {
            return this.word == word ? this : new EjectStatement(this.id, this.prefix, this.markers, word, this.dot);
        }

        public EjectStatement withDot(Word dot) {
            return this.dot == dot ? this : new EjectStatement(this.id, this.prefix, this.markers, this.word, dot);
        }
    }

    public static final class DirectoryPhrase
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Word name;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitDirectoryPhrase(this, p);
        }

        public DirectoryPhrase(UUID id, Space prefix, Markers markers, Word word, Word name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.name = name;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getName() {
            return this.name;
        }

        public String toString() {
            return "CobolPreprocessor.DirectoryPhrase(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectoryPhrase)) {
                return false;
            }
            DirectoryPhrase other = (DirectoryPhrase)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            return result;
        }

        public DirectoryPhrase withId(UUID id) {
            return this.id == id ? this : new DirectoryPhrase(id, this.prefix, this.markers, this.word, this.name);
        }

        public DirectoryPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DirectoryPhrase(this.id, prefix, this.markers, this.word, this.name);
        }

        public DirectoryPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new DirectoryPhrase(this.id, this.prefix, markers, this.word, this.name);
        }

        public DirectoryPhrase withWord(Word word) {
            return this.word == word ? this : new DirectoryPhrase(this.id, this.prefix, this.markers, word, this.name);
        }

        public DirectoryPhrase withName(Word name) {
            return this.name == name ? this : new DirectoryPhrase(this.id, this.prefix, this.markers, this.word, name);
        }
    }

    public static final class CopyStatement
    implements CobolPreprocessor,
    CopybookSource {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final CopySource copySource;
        private final List<CobolPreprocessor> cobols;
        private final Word dot;
        @Nullable
        private final Copybook copybook;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCopyStatement(this, p);
        }

        public CopyStatement(UUID id, Space prefix, Markers markers, Word word, CopySource copySource, List<CobolPreprocessor> cobols, Word dot, Copybook copybook) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.copySource = copySource;
            this.cobols = cobols;
            this.dot = dot;
            this.copybook = copybook;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public CopySource getCopySource() {
            return this.copySource;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public Word getDot() {
            return this.dot;
        }

        @Override
        public Copybook getCopybook() {
            return this.copybook;
        }

        public String toString() {
            return "CobolPreprocessor.CopyStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", copySource=" + this.getCopySource() + ", cobols=" + this.getCobols() + ", dot=" + this.getDot() + ", copybook=" + this.getCopybook() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyStatement)) {
                return false;
            }
            CopyStatement other = (CopyStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            CopySource this$copySource = this.getCopySource();
            CopySource other$copySource = other.getCopySource();
            if (this$copySource == null ? other$copySource != null : !((Object)this$copySource).equals(other$copySource)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            if (this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            Copybook this$copybook = this.getCopybook();
            Copybook other$copybook = other.getCopybook();
            return !(this$copybook == null ? other$copybook != null : !((Object)this$copybook).equals(other$copybook));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            CopySource $copySource = this.getCopySource();
            result = result * 59 + ($copySource == null ? 43 : ((Object)$copySource).hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            Copybook $copybook = this.getCopybook();
            result = result * 59 + ($copybook == null ? 43 : ((Object)$copybook).hashCode());
            return result;
        }

        public CopyStatement withId(UUID id) {
            return this.id == id ? this : new CopyStatement(id, this.prefix, this.markers, this.word, this.copySource, this.cobols, this.dot, this.copybook);
        }

        public CopyStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CopyStatement(this.id, prefix, this.markers, this.word, this.copySource, this.cobols, this.dot, this.copybook);
        }

        public CopyStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new CopyStatement(this.id, this.prefix, markers, this.word, this.copySource, this.cobols, this.dot, this.copybook);
        }

        public CopyStatement withWord(Word word) {
            return this.word == word ? this : new CopyStatement(this.id, this.prefix, this.markers, word, this.copySource, this.cobols, this.dot, this.copybook);
        }

        public CopyStatement withCopySource(CopySource copySource) {
            return this.copySource == copySource ? this : new CopyStatement(this.id, this.prefix, this.markers, this.word, copySource, this.cobols, this.dot, this.copybook);
        }

        public CopyStatement withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new CopyStatement(this.id, this.prefix, this.markers, this.word, this.copySource, cobols, this.dot, this.copybook);
        }

        public CopyStatement withDot(Word dot) {
            return this.dot == dot ? this : new CopyStatement(this.id, this.prefix, this.markers, this.word, this.copySource, this.cobols, dot, this.copybook);
        }

        public CopyStatement withCopybook(Copybook copybook) {
            return this.copybook == copybook ? this : new CopyStatement(this.id, this.prefix, this.markers, this.word, this.copySource, this.cobols, this.dot, copybook);
        }
    }

    public static final class CopySource
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final Word name;
        @Nullable
        private final Word word;
        @Nullable
        private final Word copyLibrary;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCopySource(this, p);
        }

        public CopySource(Space prefix, Markers markers, Word name, Word word, Word copyLibrary) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.word = word;
            this.copyLibrary = copyLibrary;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getName() {
            return this.name;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getCopyLibrary() {
            return this.copyLibrary;
        }

        public String toString() {
            return "CobolPreprocessor.CopySource(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", word=" + this.getWord() + ", copyLibrary=" + this.getCopyLibrary() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopySource)) {
                return false;
            }
            CopySource other = (CopySource)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$copyLibrary = this.getCopyLibrary();
            Word other$copyLibrary = other.getCopyLibrary();
            return !(this$copyLibrary == null ? other$copyLibrary != null : !((Object)this$copyLibrary).equals(other$copyLibrary));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $copyLibrary = this.getCopyLibrary();
            result = result * 59 + ($copyLibrary == null ? 43 : ((Object)$copyLibrary).hashCode());
            return result;
        }

        public CopySource withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CopySource(prefix, this.markers, this.name, this.word, this.copyLibrary);
        }

        public CopySource withMarkers(Markers markers) {
            return this.markers == markers ? this : new CopySource(this.prefix, markers, this.name, this.word, this.copyLibrary);
        }

        public CopySource withName(Word name) {
            return this.name == name ? this : new CopySource(this.prefix, this.markers, name, this.word, this.copyLibrary);
        }

        public CopySource withWord(Word word) {
            return this.word == word ? this : new CopySource(this.prefix, this.markers, this.name, word, this.copyLibrary);
        }

        public CopySource withCopyLibrary(Word copyLibrary) {
            return this.copyLibrary == copyLibrary ? this : new CopySource(this.prefix, this.markers, this.name, this.word, copyLibrary);
        }
    }

    public static final class Copybook
    implements CobolPreprocessor,
    CobolSourceFile {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<CobolPreprocessor> lst;
        private final Word eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCopybook(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new CobolPreprocessorPrinter(true, true);
        }

        public Copybook(UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<CobolPreprocessor> lst, Word eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.lst = lst;
            this.eof = eof;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<CobolPreprocessor> getLst() {
            return this.lst;
        }

        public Word getEof() {
            return this.eof;
        }

        public String toString() {
            return "CobolPreprocessor.Copybook(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", lst=" + this.getLst() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Copybook)) {
                return false;
            }
            Copybook other = (Copybook)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            FileAttributes this$fileAttributes = this.getFileAttributes();
            FileAttributes other$fileAttributes = other.getFileAttributes();
            if (this$fileAttributes == null ? other$fileAttributes != null : !this$fileAttributes.equals(other$fileAttributes)) {
                return false;
            }
            String this$charsetName = this.getCharsetName();
            String other$charsetName = other.getCharsetName();
            if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
                return false;
            }
            Checksum this$checksum = this.getChecksum();
            Checksum other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            List<CobolPreprocessor> this$lst = this.getLst();
            List<CobolPreprocessor> other$lst = other.getLst();
            if (this$lst == null ? other$lst != null : !((Object)this$lst).equals(other$lst)) {
                return false;
            }
            Word this$eof = this.getEof();
            Word other$eof = other.getEof();
            return !(this$eof == null ? other$eof != null : !((Object)this$eof).equals(other$eof));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            FileAttributes $fileAttributes = this.getFileAttributes();
            result = result * 59 + ($fileAttributes == null ? 43 : $fileAttributes.hashCode());
            String $charsetName = this.getCharsetName();
            result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
            Checksum $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            List<CobolPreprocessor> $lst = this.getLst();
            result = result * 59 + ($lst == null ? 43 : ((Object)$lst).hashCode());
            Word $eof = this.getEof();
            result = result * 59 + ($eof == null ? 43 : ((Object)$eof).hashCode());
            return result;
        }

        public Copybook withId(UUID id) {
            return this.id == id ? this : new Copybook(id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Copybook(this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withMarkers(Markers markers) {
            return this.markers == markers ? this : new Copybook(this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Copybook(this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.lst, this.eof);
        }

        public Copybook withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.lst, this.eof);
        }

        public Copybook withLst(List<CobolPreprocessor> lst) {
            return this.lst == lst ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, lst, this.eof);
        }

        public Copybook withEof(Word eof) {
            return this.eof == eof ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.lst, eof);
        }

        private Copybook withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new Copybook(this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.lst, this.eof);
        }
    }

    public static final class CompilerXOpts
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Word leftParen;
        private final List<CobolPreprocessor> compilerOptions;
        private final Word rightParen;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCompilerXOpts(this, p);
        }

        public CompilerXOpts(Space prefix, Markers markers, Word word, Word leftParen, List<CobolPreprocessor> compilerOptions, Word rightParen) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.leftParen = leftParen;
            this.compilerOptions = compilerOptions;
            this.rightParen = rightParen;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getLeftParen() {
            return this.leftParen;
        }

        public List<CobolPreprocessor> getCompilerOptions() {
            return this.compilerOptions;
        }

        public Word getRightParen() {
            return this.rightParen;
        }

        public String toString() {
            return "CobolPreprocessor.CompilerXOpts(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", leftParen=" + this.getLeftParen() + ", compilerOptions=" + this.getCompilerOptions() + ", rightParen=" + this.getRightParen() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerXOpts)) {
                return false;
            }
            CompilerXOpts other = (CompilerXOpts)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$leftParen = this.getLeftParen();
            Word other$leftParen = other.getLeftParen();
            if (this$leftParen == null ? other$leftParen != null : !((Object)this$leftParen).equals(other$leftParen)) {
                return false;
            }
            List<CobolPreprocessor> this$compilerOptions = this.getCompilerOptions();
            List<CobolPreprocessor> other$compilerOptions = other.getCompilerOptions();
            if (this$compilerOptions == null ? other$compilerOptions != null : !((Object)this$compilerOptions).equals(other$compilerOptions)) {
                return false;
            }
            Word this$rightParen = this.getRightParen();
            Word other$rightParen = other.getRightParen();
            return !(this$rightParen == null ? other$rightParen != null : !((Object)this$rightParen).equals(other$rightParen));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $leftParen = this.getLeftParen();
            result = result * 59 + ($leftParen == null ? 43 : ((Object)$leftParen).hashCode());
            List<CobolPreprocessor> $compilerOptions = this.getCompilerOptions();
            result = result * 59 + ($compilerOptions == null ? 43 : ((Object)$compilerOptions).hashCode());
            Word $rightParen = this.getRightParen();
            result = result * 59 + ($rightParen == null ? 43 : ((Object)$rightParen).hashCode());
            return result;
        }

        public CompilerXOpts withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilerXOpts(prefix, this.markers, this.word, this.leftParen, this.compilerOptions, this.rightParen);
        }

        public CompilerXOpts withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilerXOpts(this.prefix, markers, this.word, this.leftParen, this.compilerOptions, this.rightParen);
        }

        public CompilerXOpts withWord(Word word) {
            return this.word == word ? this : new CompilerXOpts(this.prefix, this.markers, word, this.leftParen, this.compilerOptions, this.rightParen);
        }

        public CompilerXOpts withLeftParen(Word leftParen) {
            return this.leftParen == leftParen ? this : new CompilerXOpts(this.prefix, this.markers, this.word, leftParen, this.compilerOptions, this.rightParen);
        }

        public CompilerXOpts withCompilerOptions(List<CobolPreprocessor> compilerOptions) {
            return this.compilerOptions == compilerOptions ? this : new CompilerXOpts(this.prefix, this.markers, this.word, this.leftParen, compilerOptions, this.rightParen);
        }

        public CompilerXOpts withRightParen(Word rightParen) {
            return this.rightParen == rightParen ? this : new CompilerXOpts(this.prefix, this.markers, this.word, this.leftParen, this.compilerOptions, rightParen);
        }
    }

    public static final class CompilerOptions
    implements CobolPreprocessor {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final List<CobolPreprocessor> cobols;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCompilerOptions(this, p);
        }

        public CompilerOptions(UUID id, Space prefix, Markers markers, Word word, List<CobolPreprocessor> cobols) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.cobols = cobols;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public String toString() {
            return "CobolPreprocessor.CompilerOptions(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", cobols=" + this.getCobols() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerOptions)) {
                return false;
            }
            CompilerOptions other = (CompilerOptions)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            return !(this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            return result;
        }

        public CompilerOptions withId(UUID id) {
            return this.id == id ? this : new CompilerOptions(id, this.prefix, this.markers, this.word, this.cobols);
        }

        public CompilerOptions withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilerOptions(this.id, prefix, this.markers, this.word, this.cobols);
        }

        public CompilerOptions withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilerOptions(this.id, this.prefix, markers, this.word, this.cobols);
        }

        public CompilerOptions withWord(Word word) {
            return this.word == word ? this : new CompilerOptions(this.id, this.prefix, this.markers, word, this.cobols);
        }

        public CompilerOptions withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new CompilerOptions(this.id, this.prefix, this.markers, this.word, cobols);
        }
    }

    public static final class CompilerOption
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final List<CobolPreprocessor> cobols;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCompilerOption(this, p);
        }

        public CompilerOption(Space prefix, Markers markers, List<CobolPreprocessor> cobols) {
            this.prefix = prefix;
            this.markers = markers;
            this.cobols = cobols;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public String toString() {
            return "CobolPreprocessor.CompilerOption(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cobols=" + this.getCobols() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerOption)) {
                return false;
            }
            CompilerOption other = (CompilerOption)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            return !(this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            return result;
        }

        public CompilerOption withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilerOption(prefix, this.markers, this.cobols);
        }

        public CompilerOption withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilerOption(this.prefix, markers, this.cobols);
        }

        public CompilerOption withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new CompilerOption(this.prefix, this.markers, cobols);
        }
    }

    public static final class CommentEntry
    implements CobolPreprocessor,
    Comment {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> comments;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCommentEntry(this, p);
        }

        public CommentEntry(Space prefix, Markers markers, List<Word> comments) {
            this.prefix = prefix;
            this.markers = markers;
            this.comments = comments;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getComments() {
            return this.comments;
        }

        public String toString() {
            return "CobolPreprocessor.CommentEntry(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", comments=" + this.getComments() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommentEntry)) {
                return false;
            }
            CommentEntry other = (CommentEntry)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$comments = this.getComments();
            List<Word> other$comments = other.getComments();
            return !(this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $comments = this.getComments();
            result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
            return result;
        }

        public CommentEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CommentEntry(prefix, this.markers, this.comments);
        }

        public CommentEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new CommentEntry(this.prefix, markers, this.comments);
        }

        public CommentEntry withComments(List<Word> comments) {
            return this.comments == comments ? this : new CommentEntry(this.prefix, this.markers, comments);
        }
    }

    public static final class CharDataSql
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final List<CobolPreprocessor> cobols;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCharDataSql(this, p);
        }

        public CharDataSql(Space prefix, Markers markers, List<CobolPreprocessor> cobols) {
            this.prefix = prefix;
            this.markers = markers;
            this.cobols = cobols;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public String toString() {
            return "CobolPreprocessor.CharDataSql(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cobols=" + this.getCobols() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharDataSql)) {
                return false;
            }
            CharDataSql other = (CharDataSql)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            return !(this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            return result;
        }

        public CharDataSql withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CharDataSql(prefix, this.markers, this.cobols);
        }

        public CharDataSql withMarkers(Markers markers) {
            return this.markers == markers ? this : new CharDataSql(this.prefix, markers, this.cobols);
        }

        public CharDataSql withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new CharDataSql(this.prefix, this.markers, cobols);
        }
    }

    public static final class CharDataLine
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final List<CobolPreprocessor> words;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCharDataLine(this, p);
        }

        public CharDataLine(Space prefix, Markers markers, List<CobolPreprocessor> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<CobolPreprocessor> getWords() {
            return this.words;
        }

        public String toString() {
            return "CobolPreprocessor.CharDataLine(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharDataLine)) {
                return false;
            }
            CharDataLine other = (CharDataLine)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<CobolPreprocessor> this$words = this.getWords();
            List<CobolPreprocessor> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<CobolPreprocessor> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public CharDataLine withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CharDataLine(prefix, this.markers, this.words);
        }

        public CharDataLine withMarkers(Markers markers) {
            return this.markers == markers ? this : new CharDataLine(this.prefix, markers, this.words);
        }

        public CharDataLine withWords(List<CobolPreprocessor> words) {
            return this.words == words ? this : new CharDataLine(this.prefix, this.markers, words);
        }
    }

    public static final class CharData
    implements CobolPreprocessor {
        private final Space prefix;
        private final Markers markers;
        private final List<CharDataLine> cobols;

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCharData(this, p);
        }

        public CharData(Space prefix, Markers markers, List<CharDataLine> cobols) {
            this.prefix = prefix;
            this.markers = markers;
            this.cobols = cobols;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<CharDataLine> getCobols() {
            return this.cobols;
        }

        public String toString() {
            return "CobolPreprocessor.CharData(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cobols=" + this.getCobols() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharData)) {
                return false;
            }
            CharData other = (CharData)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<CharDataLine> this$cobols = this.getCobols();
            List<CharDataLine> other$cobols = other.getCobols();
            return !(this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<CharDataLine> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            return result;
        }

        public CharData withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CharData(prefix, this.markers, this.cobols);
        }

        public CharData withMarkers(Markers markers) {
            return this.markers == markers ? this : new CharData(this.prefix, markers, this.cobols);
        }

        public CharData withCobols(List<CharDataLine> cobols) {
            return this.cobols == cobols ? this : new CharData(this.prefix, this.markers, cobols);
        }
    }

    public static final class CompilationUnit
    implements CobolPreprocessor,
    SourceFile {
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final Map<String, CobolPreprocessor> preprocessorStatements;
        private final Map<String, Replacement> replacements;
        private final List<CobolPreprocessor> cobols;
        private final Word eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> CobolPreprocessor acceptCobolPreprocessor(CobolPreprocessorVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new CobolPreprocessorPrinter(true, true);
        }

        public CompilationUnit(Path sourcePath, FileAttributes fileAttributes, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, Checksum checksum, Map<String, CobolPreprocessor> preprocessorStatements, Map<String, Replacement> replacements, List<CobolPreprocessor> cobols, Word eof) {
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.preprocessorStatements = preprocessorStatements;
            this.replacements = replacements;
            this.cobols = cobols;
            this.eof = eof;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public Map<String, CobolPreprocessor> getPreprocessorStatements() {
            return this.preprocessorStatements;
        }

        public Map<String, Replacement> getReplacements() {
            return this.replacements;
        }

        public List<CobolPreprocessor> getCobols() {
            return this.cobols;
        }

        public Word getEof() {
            return this.eof;
        }

        public String toString() {
            return "CobolPreprocessor.CompilationUnit(sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", preprocessorStatements=" + this.getPreprocessorStatements() + ", replacements=" + this.getReplacements() + ", cobols=" + this.getCobols() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            FileAttributes this$fileAttributes = this.getFileAttributes();
            FileAttributes other$fileAttributes = other.getFileAttributes();
            if (this$fileAttributes == null ? other$fileAttributes != null : !this$fileAttributes.equals(other$fileAttributes)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            String this$charsetName = this.getCharsetName();
            String other$charsetName = other.getCharsetName();
            if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
                return false;
            }
            Checksum this$checksum = this.getChecksum();
            Checksum other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            Map<String, CobolPreprocessor> this$preprocessorStatements = this.getPreprocessorStatements();
            Map<String, CobolPreprocessor> other$preprocessorStatements = other.getPreprocessorStatements();
            if (this$preprocessorStatements == null ? other$preprocessorStatements != null : !((Object)this$preprocessorStatements).equals(other$preprocessorStatements)) {
                return false;
            }
            Map<String, Replacement> this$replacements = this.getReplacements();
            Map<String, Replacement> other$replacements = other.getReplacements();
            if (this$replacements == null ? other$replacements != null : !((Object)this$replacements).equals(other$replacements)) {
                return false;
            }
            List<CobolPreprocessor> this$cobols = this.getCobols();
            List<CobolPreprocessor> other$cobols = other.getCobols();
            if (this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols)) {
                return false;
            }
            Word this$eof = this.getEof();
            Word other$eof = other.getEof();
            return !(this$eof == null ? other$eof != null : !((Object)this$eof).equals(other$eof));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            FileAttributes $fileAttributes = this.getFileAttributes();
            result = result * 59 + ($fileAttributes == null ? 43 : $fileAttributes.hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            String $charsetName = this.getCharsetName();
            result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
            Checksum $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            Map<String, CobolPreprocessor> $preprocessorStatements = this.getPreprocessorStatements();
            result = result * 59 + ($preprocessorStatements == null ? 43 : ((Object)$preprocessorStatements).hashCode());
            Map<String, Replacement> $replacements = this.getReplacements();
            result = result * 59 + ($replacements == null ? 43 : ((Object)$replacements).hashCode());
            List<CobolPreprocessor> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            Word $eof = this.getEof();
            result = result * 59 + ($eof == null ? 43 : ((Object)$eof).hashCode());
            return result;
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withPreprocessorStatements(Map<String, CobolPreprocessor> preprocessorStatements) {
            return this.preprocessorStatements == preprocessorStatements ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, preprocessorStatements, this.replacements, this.cobols, this.eof);
        }

        public CompilationUnit withReplacements(Map<String, Replacement> replacements) {
            return this.replacements == replacements ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, replacements, this.cobols, this.eof);
        }

        public CompilationUnit withCobols(List<CobolPreprocessor> cobols) {
            return this.cobols == cobols ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, cobols, this.eof);
        }

        public CompilationUnit withEof(Word eof) {
            return this.eof == eof ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, eof);
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.preprocessorStatements, this.replacements, this.cobols, this.eof);
        }
    }
}

