/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public final class UsesCopybook
extends CobolIsoVisitor<ExecutionContext> {
    @Nullable
    private final String copybookName;

    public UsesCopybook(@Nullable String copybookName) {
        this.copybookName = copybookName;
    }

    @Override
    public Cobol.CompilationUnit visitCompilationUnit(Cobol.CompilationUnit compilationUnit, ExecutionContext ctx) {
        Cobol.CompilationUnit cu = compilationUnit;
        if (FindCopySource.find(cu, this.copybookName)) {
            cu = (Cobol.CompilationUnit)SearchResult.found((Tree)cu);
        }
        return cu;
    }

    public String getCopybookName() {
        return this.copybookName;
    }

    public String toString() {
        return "UsesCopybook(copybookName=" + this.getCopybookName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsesCopybook)) {
            return false;
        }
        UsesCopybook other = (UsesCopybook)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$copybookName = this.getCopybookName();
        String other$copybookName = other.getCopybookName();
        return !(this$copybookName == null ? other$copybookName != null : !this$copybookName.equals(other$copybookName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UsesCopybook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $copybookName = this.getCopybookName();
        result = result * 59 + ($copybookName == null ? 43 : $copybookName.hashCode());
        return result;
    }

    private static class FindCopySource
    extends CobolIsoVisitor<ExecutionContext> {
        private FindCopySource() {
        }

        public static boolean find(Cobol cobol, final @Nullable String bookName) {
            CobolIsoVisitor<AtomicBoolean> visitor = new CobolIsoVisitor<AtomicBoolean>(){

                @Override
                public Cobol.Word visitWord(Cobol.Word word, AtomicBoolean found) {
                    Cobol w = super.visitWord(word, found);
                    if (!found.get()) {
                        for (CobolPreprocessor preprocessorStatement : ((Cobol.Word)w).getPreprocessorStatements()) {
                            if (preprocessorStatement instanceof CobolPreprocessor.CopyStatement) {
                                CobolPreprocessor.CopyStatement copyStatement = (CobolPreprocessor.CopyStatement)preprocessorStatement;
                                if (bookName != null && !bookName.isEmpty() && !bookName.equals(copyStatement.getCopySource().getName().getCobolWord().getWord())) continue;
                                found.set(true);
                                continue;
                            }
                            if (!(preprocessorStatement instanceof CobolPreprocessor.ExecSqlIncludeStatement)) continue;
                            CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement = (CobolPreprocessor.ExecSqlIncludeStatement)preprocessorStatement;
                            if (bookName != null && !bookName.isEmpty() && !bookName.equals(execSqlIncludeStatement.getCopySource().getCobolWord().getWord())) continue;
                            found.set(true);
                        }
                    }
                    return w;
                }
            };
            AtomicBoolean found = new AtomicBoolean(false);
            visitor.visit(cobol, found);
            return found.get();
        }
    }
}

