/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.NameVisitor;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public final class FindWord
extends Recipe {
    @Option(displayName="Term to search for", description="A word or regex pattern to find. By default the search term is case insensitive.", example="CM102M or cm1.*")
    private final String searchTerm;
    @Nullable
    @Option(displayName="Only match exact word", description="Search for a word based on an exact match of the search term.", example="true")
    private final Boolean exactMatch;

    public String getDisplayName() {
        return "Find matching words in the source code";
    }

    public String getDescription() {
        return "Search for COBOL words based on a search term.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SearchForWord(this.searchTerm, this.exactMatch);
    }

    public FindWord(String searchTerm, Boolean exactMatch) {
        this.searchTerm = searchTerm;
        this.exactMatch = exactMatch;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public Boolean getExactMatch() {
        return this.exactMatch;
    }

    public String toString() {
        return "FindWord(searchTerm=" + this.getSearchTerm() + ", exactMatch=" + this.getExactMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindWord)) {
            return false;
        }
        FindWord other = (FindWord)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$exactMatch = this.getExactMatch();
        Boolean other$exactMatch = other.getExactMatch();
        if (this$exactMatch == null ? other$exactMatch != null : !((Object)this$exactMatch).equals(other$exactMatch)) {
            return false;
        }
        String this$searchTerm = this.getSearchTerm();
        String other$searchTerm = other.getSearchTerm();
        return !(this$searchTerm == null ? other$searchTerm != null : !this$searchTerm.equals(other$searchTerm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindWord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $exactMatch = this.getExactMatch();
        result = result * 59 + ($exactMatch == null ? 43 : ((Object)$exactMatch).hashCode());
        String $searchTerm = this.getSearchTerm();
        result = result * 59 + ($searchTerm == null ? 43 : $searchTerm.hashCode());
        return result;
    }

    private static class SearchForWord
    extends NameVisitor<ExecutionContext> {
        private final PreprocessorSearch preprocessorSearch;
        private final String searchTerm;
        @Nullable
        private final Pattern pattern;

        public SearchForWord(String searchTerm, @Nullable Boolean exactMatch) {
            this.searchTerm = searchTerm;
            this.pattern = Boolean.TRUE.equals(exactMatch) ? null : Pattern.compile(searchTerm.toLowerCase());
            this.preprocessorSearch = new PreprocessorSearch();
        }

        @Override
        public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
            Cobol w = super.visitWord(word, executionContext);
            AtomicBoolean hasCopyStatement = new AtomicBoolean(false);
            w = ((Cobol.Word)w).withPreprocessorStatements(ListUtils.map(((Cobol.Word)w).getPreprocessorStatements(), it -> {
                if (it instanceof CobolPreprocessor.CopyStatement && !hasCopyStatement.get()) {
                    hasCopyStatement.set(true);
                }
                return (CobolPreprocessor)this.preprocessorSearch.visit((Tree)it, executionContext);
            }));
            if (hasCopyStatement.get() || ((Cobol.Word)w).getMarkers().findFirst(CopiedWord.class).isPresent()) {
                return w;
            }
            if (((Cobol.Word)w).getReplacement() != null) {
                if (((Cobol.Word)w).getReplacement().getType() == Replacement.Type.EQUAL || ((Cobol.Word)w).getReplacement().getType() == Replacement.Type.REDUCTIVE) {
                    w = ((Cobol.Word)w).withReplacement(((Cobol.Word)w).getReplacement().withOriginalWords(ListUtils.map(((Cobol.Word)w).getReplacement().getOriginalWords(), it -> it.withOriginal((Cobol.Word)this.visitAndCast(it.getOriginal(), executionContext)))));
                }
                return w;
            }
            if (this.matches(((Cobol.Word)w).getWord())) {
                return (Cobol.Word)SearchResult.found((Tree)word);
            }
            return w;
        }

        private boolean matches(String word) {
            return this.pattern != null && this.pattern.matcher(word.toLowerCase()).matches() || this.pattern == null && word.equals(this.searchTerm);
        }

        private class PreprocessorSearch
        extends CobolPreprocessorIsoVisitor<ExecutionContext> {
            private PreprocessorSearch() {
            }

            @Override
            public CobolPreprocessor.Word visitWord(CobolPreprocessor.Word word, ExecutionContext executionContext) {
                if (SearchForWord.this.matches(word.getCobolWord().getWord())) {
                    return (CobolPreprocessor.Word)SearchResult.found((Tree)word);
                }
                return word;
            }
        }
    }
}

