/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.marker.CopiedStatement;
import org.openrewrite.cobol.marker.MissingCopybook;
import org.openrewrite.cobol.table.CobolRelationships;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Name;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class FindRelationships
extends Recipe {
    transient CobolRelationships cobolRelationships = new CobolRelationships(this);

    public String getDisplayName() {
        return "Find COBOL relationships";
    }

    public String getDescription() {
        return "Build a list of relationships for diagramming and exploration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        CobolPreprocessorIsoVisitor<ExecutionContext> preprocessorVisitor = new CobolPreprocessorIsoVisitor<ExecutionContext>(){
            final Set<String> seenIncludes = new HashSet<String>();
            final Set<String> seenCursorAccess = new HashSet<String>();
            final Set<String> seenTableAccess = new HashSet<String>();
            String sourceName = "UNKNOWN";
            boolean isSourceName = false;

            @Override
            public CobolPreprocessor.CompilationUnit visitCompilationUnit(CobolPreprocessor.CompilationUnit compilationUnit, ExecutionContext executionContext) {
                this.sourceName = compilationUnit.getSourcePath().getFileName().toString();
                this.sourceName = this.sourceName.contains(".") ? this.sourceName.substring(0, this.sourceName.indexOf(".")) : this.sourceName;
                this.isSourceName = true;
                return super.visitCompilationUnit(compilationUnit, executionContext);
            }

            @Override
            public CobolPreprocessor.Copybook visitCopybook(CobolPreprocessor.Copybook copybook, ExecutionContext executionContext) {
                if (!this.isSourceName) {
                    this.sourceName = copybook.getSourcePath().getFileName().toString();
                    this.sourceName = this.sourceName.contains(".") ? this.sourceName.substring(0, this.sourceName.indexOf(".")) : this.sourceName;
                }
                return super.visitCopybook(copybook, executionContext);
            }

            @Override
            public CobolPreprocessor.ExecSqlIncludeStatement visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, ExecutionContext ctx) {
                String copybookName = execSqlIncludeStatement.getCopySource().getCobolWord().getWord();
                if (this.seenIncludes.add(copybookName)) {
                    FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(this.sourceName, CobolRelationships.ResourceType.COPYBOOK, CobolRelationships.ResourceAction.INCLUDE, copybookName, CobolRelationships.ResourceType.COPYBOOK, false, ""));
                    return execSqlIncludeStatement.withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)execSqlIncludeStatement.getCopySource()));
                }
                return super.visitExecSqlIncludeStatement(execSqlIncludeStatement, ctx);
            }

            @Override
            public CobolPreprocessor.CharDataSql visitCharDataSql(CobolPreprocessor.CharDataSql charDataSql, ExecutionContext ctx) {
                CobolPreprocessor sql = super.visitCharDataSql(charDataSql, ctx);
                return FindRelationships.this.getSqlRelationships((CobolPreprocessor.CharDataSql)sql, this.sourceName, CobolRelationships.ResourceType.COPYBOOK, this.seenIncludes, this.seenCursorAccess, this.seenTableAccess, ctx);
            }
        };
        final CobolIsoVisitor<ExecutionContext> cobolVisitor = new CobolIsoVisitor<ExecutionContext>(){
            final Set<String> seenCopies = new HashSet<String>();
            final Set<String> seenCalls = new HashSet<String>();
            final Set<String> seenIncludes = new HashSet<String>();
            final Set<String> seenCursorAccess = new HashSet<String>();
            final Set<String> seenTableAccess = new HashSet<String>();
            String programName = "UNKNOWN";

            @Override
            public Cobol.ProgramIdParagraph visitProgramIdParagraph(Cobol.ProgramIdParagraph programIdParagraph, ExecutionContext executionContext) {
                Name rawName = programIdParagraph.getProgramName();
                if (rawName instanceof Cobol.Word) {
                    this.programName = ((Cobol.Word)rawName).getWord();
                }
                return super.visitProgramIdParagraph(programIdParagraph, executionContext);
            }

            @Override
            public Cobol.Word visitWord(Cobol.Word word, ExecutionContext ctx) {
                Cobol w = super.visitWord(word, ctx);
                w = ((Cobol.Word)w).withPreprocessorStatements(ListUtils.map(((Cobol.Word)w).getPreprocessorStatements(), ps -> {
                    CobolPreprocessor.ExecStatement execStatement;
                    if (ps instanceof CobolPreprocessor.CopyStatement) {
                        CobolPreprocessor.CopyStatement copyStatement = (CobolPreprocessor.CopyStatement)ps;
                        String copyName = copyStatement.getCopySource().getName().getCobolWord().getWord();
                        if (this.seenCopies.add(copyName)) {
                            Optional cs = copyStatement.getMarkers().findFirst(CopiedStatement.class);
                            FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(cs.isPresent() && StringUtils.isNotEmpty((String)((CopiedStatement)cs.get()).getSourceCopybook()) ? ((CopiedStatement)cs.get()).getSourceCopybook() : this.programName, cs.isPresent() && StringUtils.isNotEmpty((String)((CopiedStatement)cs.get()).getSourceCopybook()) ? CobolRelationships.ResourceType.COPYBOOK : CobolRelationships.ResourceType.COBOL, CobolRelationships.ResourceAction.COPY, copyStatement.getCopySource().getName().getCobolWord().getWord(), CobolRelationships.ResourceType.COPYBOOK, copyStatement.getMarkers().findFirst(MissingCopybook.class).isPresent(), ""));
                        }
                        return copyStatement.withCopySource(copyStatement.getCopySource().withName((CobolPreprocessor.Word)SearchResult.found((Tree)copyStatement.getCopySource().getName())));
                    }
                    if (ps instanceof CobolPreprocessor.ExecSqlIncludeStatement) {
                        CobolPreprocessor.ExecSqlIncludeStatement includeStatement = (CobolPreprocessor.ExecSqlIncludeStatement)ps;
                        if (includeStatement.getCopybook() != null) {
                            String copyName = includeStatement.getCopySource().getCobolWord().getWord();
                            if (this.seenCopies.add(copyName)) {
                                Optional cs = includeStatement.getMarkers().findFirst(CopiedStatement.class);
                                FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(cs.isPresent() && StringUtils.isNotEmpty((String)((CopiedStatement)cs.get()).getSourceCopybook()) ? ((CopiedStatement)cs.get()).getSourceCopybook() : this.programName, cs.isPresent() && StringUtils.isNotEmpty((String)((CopiedStatement)cs.get()).getSourceCopybook()) ? CobolRelationships.ResourceType.COPYBOOK : CobolRelationships.ResourceType.COBOL, CobolRelationships.ResourceAction.INCLUDE, includeStatement.getCopySource().getCobolWord().getWord(), CobolRelationships.ResourceType.COPYBOOK, includeStatement.getMarkers().findFirst(MissingCopybook.class).isPresent(), ""));
                            }
                            return includeStatement.withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)includeStatement.getCopySource()));
                        }
                    } else if (ps instanceof CobolPreprocessor.ExecStatement && (execStatement = (CobolPreprocessor.ExecStatement)ps).getCobol() instanceof CobolPreprocessor.CharDataSql && !((CobolPreprocessor.CharDataSql)execStatement.getCobol()).getCobols().isEmpty()) {
                        CobolPreprocessor.CharDataSql sql = (CobolPreprocessor.CharDataSql)execStatement.getCobol();
                        execStatement = execStatement.withCobol(FindRelationships.this.getSqlRelationships(sql, this.programName, CobolRelationships.ResourceType.COBOL, this.seenIncludes, this.seenCursorAccess, this.seenTableAccess, ctx));
                        return execStatement;
                    }
                    return ps;
                }));
                return w;
            }

            @Override
            public Cobol.Call visitCall(Cobol.Call call, ExecutionContext ctx) {
                Cobol.Word word;
                if (call.getIdentifier() instanceof Cobol.Word && (word = (Cobol.Word)call.getIdentifier()).getWord().startsWith("\"")) {
                    String callName = word.getWord().replace("\"", "");
                    if (this.seenCalls.add(callName)) {
                        FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(this.programName, CobolRelationships.ResourceType.COBOL, CobolRelationships.ResourceAction.CALL, word.getWord().replace("\"", ""), CobolRelationships.ResourceType.COBOL, false, ""));
                    }
                    return call.withIdentifier((Name)SearchResult.found((Tree)call.getIdentifier()));
                }
                return super.visitCall(call, ctx);
            }
        };
        PlainTextVisitor<ExecutionContext> linkEditVisitor = new PlainTextVisitor<ExecutionContext>(){
            final Pattern includePattern = Pattern.compile("^INCLUDE\\s+(SYS|OBJ)LIB\\((?<include>[A-Z0-9]+)\\)", 8);

            public PlainText visitText(PlainText pt, ExecutionContext ctx) {
                String text = pt.getText();
                Matcher m = this.includePattern.matcher(text);
                while (m.find()) {
                    String programName = m.group("include");
                    FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(pt.getSourcePath().getFileName().toString(), CobolRelationships.ResourceType.LINKEDIT, CobolRelationships.ResourceAction.INCLUDE, programName, CobolRelationships.ResourceType.COBOL, false, ""));
                }
                return pt;
            }
        };
        PlainTextVisitor<ExecutionContext> bindCardVisitor = new PlainTextVisitor<ExecutionContext>(){
            final Pattern bindPattern = Pattern.compile("^BIND\\s+(?<keyword>PACKAGE|PLAN)\\((?<linkedit>[&.A-Z0-9]+)\\)\\s+OWNER\\(([&A-Z0-9]+)\\)", 8);
            final Pattern memberPattern = Pattern.compile("\\s+MEMBER\\((?<member>[A-Z0-9]+)\\)", 8);

            public PlainText visitText(PlainText pt, ExecutionContext ctx) {
                String text = pt.getText();
                Matcher m = this.bindPattern.matcher(text);
                if (m.find()) {
                    String packageOrPlan = m.group("keyword");
                    if ("PLAN".equals(packageOrPlan)) {
                        String linkedit = m.group("linkedit");
                        FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(pt.getSourcePath().getFileName().toString(), CobolRelationships.ResourceType.BINDPLAN, CobolRelationships.ResourceAction.PLAN, linkedit, CobolRelationships.ResourceType.LINKEDIT, false, ""));
                    } else {
                        Matcher memberMatcher = this.memberPattern.matcher(text);
                        while (memberMatcher.find()) {
                            String member = memberMatcher.group("member");
                            FindRelationships.this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(pt.getSourcePath().getFileName().toString(), CobolRelationships.ResourceType.BINDPACKAGE, CobolRelationships.ResourceAction.MEMBER, member, CobolRelationships.ResourceType.COBOL, false, ""));
                        }
                    }
                }
                return pt;
            }
        };
        return new TreeVisitor<Tree, ExecutionContext>((PlainTextVisitor)linkEditVisitor, (PlainTextVisitor)bindCardVisitor, (CobolPreprocessorIsoVisitor)preprocessorVisitor){
            final /* synthetic */ PlainTextVisitor val$linkEditVisitor;
            final /* synthetic */ PlainTextVisitor val$bindCardVisitor;
            final /* synthetic */ CobolPreprocessorIsoVisitor val$preprocessorVisitor;
            {
                this.val$linkEditVisitor = plainTextVisitor;
                this.val$bindCardVisitor = plainTextVisitor2;
                this.val$preprocessorVisitor = cobolPreprocessorIsoVisitor;
            }

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                Tree t = tree;
                if (tree instanceof Cobol) {
                    t = cobolVisitor.visit(t, ctx);
                } else if (tree instanceof PlainText) {
                    t = this.val$linkEditVisitor.visit(t, (Object)ctx);
                    t = this.val$bindCardVisitor.visit(t, (Object)ctx);
                } else if (tree instanceof CobolPreprocessor) {
                    t = this.val$preprocessorVisitor.visit(t, ctx);
                }
                return t;
            }
        };
    }

    public CobolPreprocessor.CharDataSql getSqlRelationships(CobolPreprocessor.CharDataSql sql, String sourceName, CobolRelationships.ResourceType dependentType, Set<String> seenIncludes, Set<String> cursorNames, Set<String> seenTableAccess, ExecutionContext ctx) {
        return sql.withCobols(ListUtils.map(sql.getCobols(), (i, c) -> {
            if (c instanceof CobolPreprocessor.CharDataLine) {
                CobolPreprocessor.CharDataLine line = (CobolPreprocessor.CharDataLine)c;
                AtomicBoolean tableNameNext = new AtomicBoolean(false);
                AtomicReference<Object> cursorTo = new AtomicReference<Object>(null);
                return line.withWords(ListUtils.map(line.getWords(), (j, w) -> {
                    if (w instanceof CobolPreprocessor.Word) {
                        String tableName;
                        CobolPreprocessor.Word word = (CobolPreprocessor.Word)w;
                        if ("include".equalsIgnoreCase(word.getCobolWord().getWord()) && j == 0 && 2 <= line.getWords().size() && line.getWords().get(1) instanceof CobolPreprocessor.Word) {
                            String copybookName = ((CobolPreprocessor.Word)line.getWords().get(1)).getCobolWord().getWord();
                            if (seenIncludes.add(copybookName)) {
                                this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(sourceName, dependentType, CobolRelationships.ResourceAction.INCLUDE, copybookName, CobolRelationships.ResourceType.COPYBOOK, false, ""));
                                return (CobolPreprocessor)SearchResult.found((Tree)word);
                            }
                        } else if ("update".equalsIgnoreCase(word.getCobolWord().getWord()) && j == 0 && 2 < line.getWords().size() && line.getWords().get(1) instanceof CobolPreprocessor.Word) {
                            String tableName2 = ((CobolPreprocessor.Word)line.getWords().get(1)).getCobolWord().getWord();
                            if (seenTableAccess.add(tableName2 + "_UPDATE") && !cursorNames.contains(tableName2)) {
                                this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(sourceName, dependentType, CobolRelationships.ResourceAction.ACCESS, tableName2, CobolRelationships.ResourceType.SQL_TABLE, false, "UPDATE"));
                                return (CobolPreprocessor)SearchResult.found((Tree)word);
                            }
                        } else if ("insert".equalsIgnoreCase(word.getCobolWord().getWord()) && j == 0 && 3 < line.getWords().size() && line.getWords().get(2) instanceof CobolPreprocessor.Word) {
                            String tableName3 = ((CobolPreprocessor.Word)line.getWords().get(2)).getCobolWord().getWord();
                            if (seenTableAccess.add(tableName3 + "_INSERT") && !cursorNames.contains(tableName3)) {
                                this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(sourceName, dependentType, CobolRelationships.ResourceAction.ACCESS, tableName3, CobolRelationships.ResourceType.SQL_TABLE, false, "INSERT"));
                                return (CobolPreprocessor)SearchResult.found((Tree)word);
                            }
                        } else if ("from".equalsIgnoreCase(word.getCobolWord().getWord()) || "join".equalsIgnoreCase(word.getCobolWord().getWord())) {
                            tableNameNext.set(true);
                        } else if (tableNameNext.get()) {
                            tableNameNext.set(false);
                            String metadata = j - 2 >= 0 && line.getWords().get(j - 2) instanceof CobolPreprocessor.Word && "delete".equalsIgnoreCase(((CobolPreprocessor.Word)line.getWords().get(j - 2)).getCobolWord().getWord()) ? "DELETE" : "READ";
                            String tableName4 = word.getCobolWord().getWord();
                            if (cursorTo.get() != null) {
                                cursorTo.set(null);
                            } else if (seenTableAccess.add(tableName4 + "_" + metadata) && !cursorNames.contains(tableName4)) {
                                this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(sourceName, dependentType, CobolRelationships.ResourceAction.ACCESS, tableName4, CobolRelationships.ResourceType.SQL_TABLE, false, metadata));
                                return (CobolPreprocessor)SearchResult.found((Tree)word);
                            }
                        } else if ("declare".equalsIgnoreCase(word.getCobolWord().getWord()) && j + 2 < line.getWords().size() && line.getWords().get(j + 1) instanceof CobolPreprocessor.Word && line.getWords().get(j + 2) instanceof CobolPreprocessor.Word && seenTableAccess.add((tableName = ((CobolPreprocessor.Word)line.getWords().get(j + 1)).getCobolWord().getWord()) + "_CREATE")) {
                            if ("table".equalsIgnoreCase(((CobolPreprocessor.Word)line.getWords().get(j + 2)).getCobolWord().getWord())) {
                                this.cobolRelationships.insertRow(ctx, new CobolRelationships.Row(sourceName, dependentType, CobolRelationships.ResourceAction.ACCESS, tableName, CobolRelationships.ResourceType.SQL_TABLE, false, "CREATE"));
                            } else {
                                cursorNames.add(tableName);
                            }
                            return (CobolPreprocessor)SearchResult.found((Tree)word);
                        }
                    }
                    return w;
                }));
            }
            return c;
        }));
    }
}

