/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.CobolPreprocessorVisitor;
import org.openrewrite.cobol.CobolVisitor;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.marker.CopiedStatement;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.marker.MissingCopybook;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.CopybookSource;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class CobolSourcePrinter<P>
extends CobolVisitor<PrintOutputCapture<P>> {
    public static final UnaryOperator<String> COBOL_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";
    private int originalReplaceLength;
    private final boolean printColumns;

    public CobolSourcePrinter(boolean printColumns) {
        this.printColumns = printColumns;
    }

    @Override
    protected CobolPreprocessorVisitor<PrintOutputCapture<P>> getCobolPreprocessorVisitor() {
        return new CobolPreprocessorSourcePrinter(this.printColumns);
    }

    @Override
    public Cobol visitAbbreviation(Cobol.Abbreviation abbreviation, PrintOutputCapture<P> p) {
        this.beforeSyntax(abbreviation, Space.Location.ABBREVIATION_PREFIX, p);
        this.visit(abbreviation.getNot(), p);
        this.visit(abbreviation.getRelationalOperator(), p);
        if (abbreviation.getLeftParen() != null) {
            this.visit(abbreviation.getLeftParen(), p);
        }
        this.visit(abbreviation.getArithmeticExpression(), p);
        this.visit(abbreviation.getAbbreviation(), p);
        if (abbreviation.getRightParen() != null) {
            this.visit(abbreviation.getRightParen(), p);
        }
        this.afterSyntax(abbreviation, p);
        return abbreviation;
    }

    @Override
    public Cobol visitAccept(Cobol.Accept accept, PrintOutputCapture<P> p) {
        this.beforeSyntax(accept, Space.Location.ACCEPT_PREFIX, p);
        this.visit(accept.getAccept(), p);
        this.visit(accept.getIdentifier(), p);
        this.visit(accept.getOperation(), p);
        this.visit(accept.getOnExceptionClause(), p);
        this.visit(accept.getNotOnExceptionClause(), p);
        this.visit(accept.getEndAccept(), p);
        this.afterSyntax(accept, p);
        return accept;
    }

    @Override
    public Cobol visitAcceptFromDateStatement(Cobol.AcceptFromDateStatement acceptFromDateStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(acceptFromDateStatement, Space.Location.ACCEPT_FROM_DATE_STATEMENT_PREFIX, p);
        this.visit(acceptFromDateStatement.getWords(), p);
        this.afterSyntax(acceptFromDateStatement, p);
        return acceptFromDateStatement;
    }

    @Override
    public Cobol visitAcceptFromEscapeKeyStatement(Cobol.AcceptFromEscapeKeyStatement acceptFromEscapeKeyStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(acceptFromEscapeKeyStatement, Space.Location.ACCEPT_FROM_ESCAPE_KEY_STATEMENT_PREFIX, p);
        this.visit(acceptFromEscapeKeyStatement.getWords(), p);
        this.afterSyntax(acceptFromEscapeKeyStatement, p);
        return acceptFromEscapeKeyStatement;
    }

    @Override
    public Cobol visitAcceptFromMnemonicStatement(Cobol.AcceptFromMnemonicStatement acceptFromMnemonicStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(acceptFromMnemonicStatement, Space.Location.ACCEPT_FROM_MNEMONIC_STATEMENT_PREFIX, p);
        this.visit(acceptFromMnemonicStatement.getFrom(), p);
        this.visit(acceptFromMnemonicStatement.getMnemonicName(), p);
        this.afterSyntax(acceptFromMnemonicStatement, p);
        return acceptFromMnemonicStatement;
    }

    @Override
    public Cobol visitAcceptMessageCountStatement(Cobol.AcceptMessageCountStatement acceptMessageCountStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(acceptMessageCountStatement, Space.Location.ACCEPT_MESSAGE_COUNT_STATEMENT_PREFIX, p);
        this.visit(acceptMessageCountStatement.getWords(), p);
        this.afterSyntax(acceptMessageCountStatement, p);
        return acceptMessageCountStatement;
    }

    @Override
    public Cobol visitAccessModeClause(Cobol.AccessModeClause accessModeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(accessModeClause, Space.Location.ACCESS_MODE_CLAUSE_PREFIX, p);
        this.visit(accessModeClause.getWords(), p);
        this.visit(accessModeClause.getType(), p);
        this.afterSyntax(accessModeClause, p);
        return accessModeClause;
    }

    @Override
    public Cobol visitAdd(Cobol.Add add, PrintOutputCapture<P> p) {
        this.beforeSyntax(add, Space.Location.ADD_PREFIX, p);
        this.visit(add.getAdd(), p);
        this.visit(add.getOperation(), p);
        this.visit(add.getOnSizeError(), p);
        this.visit(add.getNotOnSizeError(), p);
        this.visit(add.getEndAdd(), p);
        this.afterSyntax(add, p);
        return add;
    }

    @Override
    public Cobol visitAddCorresponding(Cobol.AddCorresponding addCorresponding, PrintOutputCapture<P> p) {
        this.beforeSyntax(addCorresponding, Space.Location.ADD_CORRESPONDING_PREFIX, p);
        this.visit(addCorresponding.getCorresponding(), p);
        this.visit(addCorresponding.getIdentifier(), p);
        this.visit(addCorresponding.getTo(), p);
        this.visit(addCorresponding.getRoundable(), p);
        this.afterSyntax(addCorresponding, p);
        return addCorresponding;
    }

    @Override
    public Cobol visitAddTo(Cobol.AddTo addTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(addTo, Space.Location.ADD_TO_PREFIX, p);
        this.visit(addTo.getFrom(), p);
        this.visit(addTo.getTo(), p);
        this.visit(addTo.getRoundables(), p);
        this.afterSyntax(addTo, p);
        return addTo;
    }

    @Override
    public Cobol visitAddToGiving(Cobol.AddToGiving addToGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(addToGiving, Space.Location.ADD_TO_GIVING_PREFIX, p);
        this.visit(addToGiving.getFrom(), p);
        this.visit(addToGiving.getTo(), p);
        this.visit(addToGiving.getNames(), p);
        this.visit(addToGiving.getGiving(), p);
        this.visit(addToGiving.getRoundables(), p);
        this.afterSyntax(addToGiving, p);
        return addToGiving;
    }

    @Override
    public Cobol visitAlphabetAlso(Cobol.AlphabetAlso alphabetAlso, PrintOutputCapture<P> p) {
        this.beforeSyntax(alphabetAlso, Space.Location.ALPHABET_ALSO_PREFIX, p);
        this.visit(alphabetAlso.getWord(), p);
        this.visit(alphabetAlso.getLiterals(), p);
        this.afterSyntax(alphabetAlso, p);
        return alphabetAlso;
    }

    @Override
    public Cobol visitAlphabetClause(Cobol.AlphabetClause alphabetClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(alphabetClause, Space.Location.ALPHABET_CLAUSE_PREFIX, p);
        this.visit(alphabetClause.getAlphabet(), p);
        this.visit(alphabetClause.getName(), p);
        this.visit(alphabetClause.getWords(), p);
        this.afterSyntax(alphabetClause, p);
        return alphabetClause;
    }

    @Override
    public Cobol visitAlphabetLiteral(Cobol.AlphabetLiteral alphabetLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax(alphabetLiteral, Space.Location.ALPHABET_LITERAL_PREFIX, p);
        this.visit(alphabetLiteral.getLiteral(), p);
        this.visit(alphabetLiteral.getAlphabetThrough(), p);
        this.visit(alphabetLiteral.getAlphabetAlso(), p);
        this.afterSyntax(alphabetLiteral, p);
        return alphabetLiteral;
    }

    @Override
    public Cobol visitAlphabetThrough(Cobol.AlphabetThrough alphabetThrough, PrintOutputCapture<P> p) {
        this.beforeSyntax(alphabetThrough, Space.Location.ALPHABET_THROUGH_PREFIX, p);
        this.visit(alphabetThrough.getWord(), p);
        this.visit(alphabetThrough.getLiteral(), p);
        this.afterSyntax(alphabetThrough, p);
        return alphabetThrough;
    }

    @Override
    public Cobol visitAlterProceedTo(Cobol.AlterProceedTo alterProceedTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(alterProceedTo, Space.Location.ALTER_PROCEED_TO_PREFIX, p);
        this.visit(alterProceedTo.getFrom(), p);
        this.visit(alterProceedTo.getWords(), p);
        this.visit(alterProceedTo.getTo(), p);
        this.afterSyntax(alterProceedTo, p);
        return alterProceedTo;
    }

    @Override
    public Cobol visitAlterStatement(Cobol.AlterStatement alterStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(alterStatement, Space.Location.ALTER_STATEMENT_PREFIX, p);
        this.visit(alterStatement.getWord(), p);
        this.visit(alterStatement.getAlterProceedTo(), p);
        this.afterSyntax(alterStatement, p);
        return alterStatement;
    }

    @Override
    public Cobol visitAlteredGoTo(Cobol.AlteredGoTo alteredGoTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(alteredGoTo, Space.Location.ALTERED_GO_TO_PREFIX, p);
        this.visit(alteredGoTo.getWords(), p);
        this.visit(alteredGoTo.getDot(), p);
        this.afterSyntax(alteredGoTo, p);
        return alteredGoTo;
    }

    @Override
    public Cobol visitAlternateRecordKeyClause(Cobol.AlternateRecordKeyClause alternateRecordKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(alternateRecordKeyClause, Space.Location.ALTERNATE_RECORD_KEY_CLAUSE_PREFIX, p);
        this.visit(alternateRecordKeyClause.getAlternateWords(), p);
        this.visit(alternateRecordKeyClause.getQualifiedDataName(), p);
        this.visit(alternateRecordKeyClause.getPasswordClause(), p);
        this.visit(alternateRecordKeyClause.getDuplicates(), p);
        this.afterSyntax(alternateRecordKeyClause, p);
        return alternateRecordKeyClause;
    }

    @Override
    public Cobol visitAndOrCondition(Cobol.AndOrCondition andOrCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(andOrCondition, Space.Location.AND_OR_CONDITION_PREFIX, p);
        this.visit(andOrCondition.getLogicalOperator(), p);
        this.visit(andOrCondition.getCombinableCondition(), p);
        this.visit(andOrCondition.getAbbreviations(), p);
        this.afterSyntax(andOrCondition, p);
        return andOrCondition;
    }

    @Override
    public Cobol visitArgument(Cobol.Argument argument, PrintOutputCapture<P> p) {
        this.beforeSyntax(argument, Space.Location.ARGUMENT_PREFIX, p);
        this.visit(argument.getFirst(), p);
        this.visit(argument.getIntegerLiteral(), p);
        this.afterSyntax(argument, p);
        return argument;
    }

    @Override
    public Cobol visitArithmeticExpression(Cobol.ArithmeticExpression arithmeticExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax(arithmeticExpression, Space.Location.ARITHMETIC_EXPRESSION_PREFIX, p);
        this.visit(arithmeticExpression.getMultDivs(), p);
        this.visit(arithmeticExpression.getPlusMinuses(), p);
        this.afterSyntax(arithmeticExpression, p);
        return arithmeticExpression;
    }

    @Override
    public Cobol visitAssignClause(Cobol.AssignClause assignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(assignClause, Space.Location.ASSIGN_CLAUSE_PREFIX, p);
        this.visit(assignClause.getWords(), p);
        this.visit(assignClause.getName(), p);
        this.afterSyntax(assignClause, p);
        return assignClause;
    }

    @Override
    public Cobol visitBlockContainsClause(Cobol.BlockContainsClause blockContainsClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(blockContainsClause, Space.Location.BLOCK_CONTAINS_PREFIX, p);
        this.visit(blockContainsClause.getFirstWords(), p);
        this.visit(blockContainsClause.getIntegerLiteral(), p);
        this.visit(blockContainsClause.getBlockContainsTo(), p);
        this.visit(blockContainsClause.getLastWord(), p);
        this.afterSyntax(blockContainsClause, p);
        return blockContainsClause;
    }

    @Override
    public Cobol visitBlockContainsTo(Cobol.BlockContainsTo blockContainsTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(blockContainsTo, Space.Location.BLOCK_CONTAINS_TO_PREFIX, p);
        this.visit(blockContainsTo.getTo(), p);
        this.visit(blockContainsTo.getIntegerLiteral(), p);
        this.afterSyntax(blockContainsTo, p);
        return blockContainsTo;
    }

    @Override
    public Cobol visitCall(Cobol.Call call, PrintOutputCapture<P> p) {
        this.beforeSyntax(call, Space.Location.CALL_PREFIX, p);
        this.visit(call.getCall(), p);
        this.visit(call.getIdentifier(), p);
        this.visit(call.getCallUsingPhrase(), p);
        this.visit(call.getCallGivingPhrase(), p);
        this.visit(call.getOnOverflowPhrase(), p);
        this.visit(call.getOnExceptionClause(), p);
        this.visit(call.getNotOnExceptionClause(), p);
        this.visit(call.getEndCall(), p);
        this.afterSyntax(call, p);
        return call;
    }

    @Override
    public Cobol visitCallBy(Cobol.CallBy callBy, PrintOutputCapture<P> p) {
        this.beforeSyntax(callBy, Space.Location.CALL_BY_PREFIX, p);
        this.visit(callBy.getWords(), p);
        this.visit(callBy.getIdentifier(), p);
        this.afterSyntax(callBy, p);
        return callBy;
    }

    @Override
    public Cobol visitCallGivingPhrase(Cobol.CallGivingPhrase callGivingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(callGivingPhrase, Space.Location.CALL_GIVING_PHRASE_PREFIX, p);
        this.visit(callGivingPhrase.getWord(), p);
        this.visit(callGivingPhrase.getIdentifier(), p);
        this.afterSyntax(callGivingPhrase, p);
        return callGivingPhrase;
    }

    @Override
    public Cobol visitCallPhrase(Cobol.CallPhrase callPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(callPhrase, Space.Location.CALL_PHRASE_PREFIX, p);
        this.visit(callPhrase.getWords(), p);
        this.visit(callPhrase.getParameters(), p);
        this.afterSyntax(callPhrase, p);
        return callPhrase;
    }

    @Override
    public Cobol visitCancel(Cobol.Cancel cancel, PrintOutputCapture<P> p) {
        this.beforeSyntax(cancel, Space.Location.CANCEL_PREFIX, p);
        this.visit(cancel.getCancel(), p);
        this.visit(cancel.getCancelCalls(), p);
        this.afterSyntax(cancel, p);
        return cancel;
    }

    @Override
    public Cobol visitCancelCall(Cobol.CancelCall cancelCall, PrintOutputCapture<P> p) {
        this.beforeSyntax(cancelCall, Space.Location.CANCEL_CALL_PREFIX, p);
        this.visit(cancelCall.getLibraryName(), p);
        this.visit(cancelCall.getBy(), p);
        this.visit(cancelCall.getIdentifier(), p);
        this.visit(cancelCall.getLiteral(), p);
        this.afterSyntax(cancelCall, p);
        return cancelCall;
    }

    @Override
    public Cobol visitChannelClause(Cobol.ChannelClause channelClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(channelClause, Space.Location.CHANNEL_CLAUSE_PREFIX, p);
        this.visit(channelClause.getWord(), p);
        this.visit(channelClause.getLiteral(), p);
        this.visit(channelClause.getIs(), p);
        this.visit(channelClause.getMnemonicName(), p);
        this.afterSyntax(channelClause, p);
        return channelClause;
    }

    @Override
    public Cobol visitClassClause(Cobol.ClassClause classClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(classClause, Space.Location.CLASS_CLAUSE_PREFIX, p);
        this.visit(classClause.getClazz(), p);
        this.visit(classClause.getClassName(), p);
        this.visit(classClause.getWords(), p);
        this.visit(classClause.getThroughs(), p);
        this.afterSyntax(classClause, p);
        return classClause;
    }

    @Override
    public Cobol visitClassClauseThrough(Cobol.ClassClauseThrough classClauseThrough, PrintOutputCapture<P> p) {
        this.beforeSyntax(classClauseThrough, Space.Location.CLASS_CLAUSE_THROUGH_PREFIX, p);
        this.visit(classClauseThrough.getFrom(), p);
        this.visit(classClauseThrough.getThrough(), p);
        this.visit(classClauseThrough.getTo(), p);
        this.afterSyntax(classClauseThrough, p);
        return classClauseThrough;
    }

    @Override
    public Cobol visitClassCondition(Cobol.ClassCondition classCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(classCondition, Space.Location.CLASS_CONDITION_PREFIX, p);
        this.visit(classCondition.getName(), p);
        this.visit(classCondition.getWords(), p);
        this.visit(classCondition.getType(), p);
        this.afterSyntax(classCondition, p);
        return classCondition;
    }

    @Override
    public Cobol visitClose(Cobol.Close close, PrintOutputCapture<P> p) {
        this.beforeSyntax(close, Space.Location.CLOSE_PREFIX, p);
        this.visit(close.getClose(), p);
        this.visit(close.getCloseFiles(), p);
        this.afterSyntax(close, p);
        return close;
    }

    @Override
    public Cobol visitCloseFile(Cobol.CloseFile closeFile, PrintOutputCapture<P> p) {
        this.beforeSyntax(closeFile, Space.Location.CLOSE_FILE_PREFIX, p);
        this.visit(closeFile.getFileName(), p);
        this.visit(closeFile.getCloseStatement(), p);
        this.afterSyntax(closeFile, p);
        return closeFile;
    }

    @Override
    public Cobol visitClosePortFileIOStatement(Cobol.ClosePortFileIOStatement closePortFileIOStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(closePortFileIOStatement, Space.Location.CLOSE_PORT_FILE_IO_STATEMENT_PREFIX, p);
        this.visit(closePortFileIOStatement.getWords(), p);
        this.visit(closePortFileIOStatement.getClosePortFileIOUsing(), p);
        this.afterSyntax(closePortFileIOStatement, p);
        return closePortFileIOStatement;
    }

    @Override
    public Cobol visitClosePortFileIOUsingAssociatedData(Cobol.ClosePortFileIOUsingAssociatedData closePortFileIOUsingAssociatedData, PrintOutputCapture<P> p) {
        this.beforeSyntax(closePortFileIOUsingAssociatedData, Space.Location.CLOSE_PORT_FILE_IO_USING_ASSOCIATED_DATA_PREFIX, p);
        this.visit(closePortFileIOUsingAssociatedData.getAssociatedData(), p);
        this.visit(closePortFileIOUsingAssociatedData.getIdentifier(), p);
        this.afterSyntax(closePortFileIOUsingAssociatedData, p);
        return closePortFileIOUsingAssociatedData;
    }

    @Override
    public Cobol visitClosePortFileIOUsingAssociatedDataLength(Cobol.ClosePortFileIOUsingAssociatedDataLength closePortFileIOUsingAssociatedDataLength, PrintOutputCapture<P> p) {
        this.beforeSyntax(closePortFileIOUsingAssociatedDataLength, Space.Location.CLOSE_PORT_FILE_IO_USING_ASSOCIATED_DATA_LENGTH_PREFIX, p);
        this.visit(closePortFileIOUsingAssociatedDataLength.getWords(), p);
        this.visit(closePortFileIOUsingAssociatedDataLength.getIdentifier(), p);
        this.afterSyntax(closePortFileIOUsingAssociatedDataLength, p);
        return closePortFileIOUsingAssociatedDataLength;
    }

    @Override
    public Cobol visitClosePortFileIOUsingCloseDisposition(Cobol.ClosePortFileIOUsingCloseDisposition closePortFileIOUsingCloseDisposition, PrintOutputCapture<P> p) {
        this.beforeSyntax(closePortFileIOUsingCloseDisposition, Space.Location.CLOSE_PORT_FILE_IO_USING_CLOSE_DISPOSITION_PREFIX, p);
        this.visit(closePortFileIOUsingCloseDisposition.getWords(), p);
        this.afterSyntax(closePortFileIOUsingCloseDisposition, p);
        return closePortFileIOUsingCloseDisposition;
    }

    @Override
    public Cobol visitCloseReelUnitStatement(Cobol.CloseReelUnitStatement closeReelUnitStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(closeReelUnitStatement, Space.Location.CLOSE_REEL_UNIT_STATEMENT_PREFIX, p);
        this.visit(closeReelUnitStatement.getWords(), p);
        this.afterSyntax(closeReelUnitStatement, p);
        return closeReelUnitStatement;
    }

    @Override
    public Cobol visitCloseRelativeStatement(Cobol.CloseRelativeStatement closeRelativeStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(closeRelativeStatement, Space.Location.CLOSE_RELATIVE_STATEMENT_PREFIX, p);
        this.visit(closeRelativeStatement.getWords(), p);
        this.afterSyntax(closeRelativeStatement, p);
        return closeRelativeStatement;
    }

    @Override
    public Cobol visitCodeSetClause(Cobol.CodeSetClause codeSetClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(codeSetClause, Space.Location.CLOSE_SET_CLAUSE_PREFIX, p);
        this.visit(codeSetClause.getWords(), p);
        this.visit(codeSetClause.getAlphabetName(), p);
        this.afterSyntax(codeSetClause, p);
        return codeSetClause;
    }

    @Override
    public Cobol visitCollatingSequenceAlphabet(Cobol.CollatingSequenceAlphabet collatingSequenceAlphabet, PrintOutputCapture<P> p) {
        this.beforeSyntax(collatingSequenceAlphabet, Space.Location.COLLATING_SEQUENCE_ALPHABET_PREFIX, p);
        this.visit(collatingSequenceAlphabet.getWords(), p);
        this.visit(collatingSequenceAlphabet.getAlphabetName(), p);
        this.afterSyntax(collatingSequenceAlphabet, p);
        return collatingSequenceAlphabet;
    }

    @Override
    public Cobol visitCollatingSequenceClause(Cobol.CollatingSequenceClause collatingSequenceClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(collatingSequenceClause, Space.Location.COLLATING_SEQUENCE_CLAUSE_PREFIX, p);
        this.visit(collatingSequenceClause.getWords(), p);
        this.visit(collatingSequenceClause.getIs(), p);
        this.visit(collatingSequenceClause.getAlphabetName(), p);
        this.visit(collatingSequenceClause.getAlphanumeric(), p);
        this.visit(collatingSequenceClause.getNational(), p);
        this.afterSyntax(collatingSequenceClause, p);
        return collatingSequenceClause;
    }

    @Override
    public Cobol visitCombinableCondition(Cobol.CombinableCondition combinableCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(combinableCondition, Space.Location.COMBINABLE_CONDITION_PREFIX, p);
        this.visit(combinableCondition.getNot(), p);
        this.visit(combinableCondition.getSimpleCondition(), p);
        this.afterSyntax(combinableCondition, p);
        return combinableCondition;
    }

    @Override
    public Cobol visitCommentEntry(Cobol.CommentEntry commentEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(commentEntry, Space.Location.COMMENT_ENTRY_PREFIX, p);
        this.visit(commentEntry.getComments(), p);
        this.afterSyntax(commentEntry, p);
        return commentEntry;
    }

    @Override
    public Cobol visitCommitmentControlClause(Cobol.CommitmentControlClause commitmentControlClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(commitmentControlClause, Space.Location.COMMITMENT_CONTROL_PREFIX, p);
        this.visit(commitmentControlClause.getWords(), p);
        this.visit(commitmentControlClause.getFileName(), p);
        this.afterSyntax(commitmentControlClause, p);
        return commitmentControlClause;
    }

    @Override
    public Cobol visitCommunicationDescriptionEntryFormat1(Cobol.CommunicationDescriptionEntryFormat1 communicationDescriptionEntryFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(communicationDescriptionEntryFormat1, Space.Location.COMMUNICATION_DESCRIPTION_ENTRY_FORMAT_1_PREFIX, p);
        this.visit(communicationDescriptionEntryFormat1.getCd(), p);
        this.visit(communicationDescriptionEntryFormat1.getName(), p);
        this.visit(communicationDescriptionEntryFormat1.getWords(), p);
        this.visit(communicationDescriptionEntryFormat1.getInputs(), p);
        this.visit(communicationDescriptionEntryFormat1.getDot(), p);
        this.afterSyntax(communicationDescriptionEntryFormat1, p);
        return communicationDescriptionEntryFormat1;
    }

    @Override
    public Cobol visitCommunicationDescriptionEntryFormat2(Cobol.CommunicationDescriptionEntryFormat2 communicationDescriptionEntryFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(communicationDescriptionEntryFormat2, Space.Location.COMMUNICATION_DESCRIPTION_ENTRY_FORMAT_2_PREFIX, p);
        this.visit(communicationDescriptionEntryFormat2.getCd(), p);
        this.visit(communicationDescriptionEntryFormat2.getName(), p);
        this.visit(communicationDescriptionEntryFormat2.getWords(), p);
        this.visit(communicationDescriptionEntryFormat2.getOutputs(), p);
        this.visit(communicationDescriptionEntryFormat2.getDot(), p);
        this.afterSyntax(communicationDescriptionEntryFormat2, p);
        return communicationDescriptionEntryFormat2;
    }

    @Override
    public Cobol visitCommunicationDescriptionEntryFormat3(Cobol.CommunicationDescriptionEntryFormat3 communicationDescriptionEntryFormat3, PrintOutputCapture<P> p) {
        this.beforeSyntax(communicationDescriptionEntryFormat3, Space.Location.COMMUNICATION_DESCRIPTION_ENTRY_FORMAT_3_PREFIX, p);
        this.visit(communicationDescriptionEntryFormat3.getCd(), p);
        this.visit(communicationDescriptionEntryFormat3.getName(), p);
        this.visit(communicationDescriptionEntryFormat3.getWords(), p);
        this.visit(communicationDescriptionEntryFormat3.getInitialIOs(), p);
        this.visit(communicationDescriptionEntryFormat3.getDot(), p);
        this.afterSyntax(communicationDescriptionEntryFormat3, p);
        return communicationDescriptionEntryFormat3;
    }

    @Override
    public Cobol visitCommunicationSection(Cobol.CommunicationSection communicationSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(communicationSection, Space.Location.COMMUNICATION_SECTION_PREFIX, p);
        this.visit(communicationSection.getWords(), p);
        this.visit(communicationSection.getDot(), p);
        this.visit(communicationSection.getEntries(), p);
        this.afterSyntax(communicationSection, p);
        return communicationSection;
    }

    @Override
    public Cobol visitCompilationUnit(Cobol.CompilationUnit compilationUnit, PrintOutputCapture<P> p) {
        this.beforeSyntax(compilationUnit, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(compilationUnit.getProgramUnits(), p);
        this.visit(compilationUnit.getEof(), p);
        this.afterSyntax(compilationUnit, p);
        return compilationUnit;
    }

    @Override
    public Cobol visitCompute(Cobol.Compute compute, PrintOutputCapture<P> p) {
        this.beforeSyntax(compute, Space.Location.COMPUTE_PREFIX, p);
        this.visit(compute.getCompute(), p);
        this.visit(compute.getRoundables(), p);
        this.visit(compute.getEqualWord(), p);
        this.visit(compute.getArithmeticExpression(), p);
        this.visit(compute.getOnSizeErrorPhrase(), p);
        this.visit(compute.getNotOnSizeErrorPhrase(), p);
        this.visit(compute.getEndCompute(), p);
        this.afterSyntax(compute, p);
        return compute;
    }

    @Override
    public Cobol visitCondition(Cobol.Condition condition, PrintOutputCapture<P> p) {
        this.beforeSyntax(condition, Space.Location.CONDITION_PREFIX, p);
        this.visit(condition.getCombinableCondition(), p);
        this.visit(condition.getAndOrConditions(), p);
        this.afterSyntax(condition, p);
        return condition;
    }

    @Override
    public Cobol visitConditionNameReference(Cobol.ConditionNameReference conditionNameReference, PrintOutputCapture<P> p) {
        this.beforeSyntax(conditionNameReference, Space.Location.CONDITION_NAME_REFERENCE_PREFIX, p);
        this.visit(conditionNameReference.getName(), p);
        this.visit(conditionNameReference.getInDatas(), p);
        this.visit(conditionNameReference.getInFile(), p);
        this.visit(conditionNameReference.getReferences(), p);
        this.visit(conditionNameReference.getInMnemonics(), p);
        this.afterSyntax(conditionNameReference, p);
        return conditionNameReference;
    }

    @Override
    public Cobol visitConditionNameSubscriptReference(Cobol.ConditionNameSubscriptReference conditionNameSubscriptReference, PrintOutputCapture<P> p) {
        this.beforeSyntax(conditionNameSubscriptReference, Space.Location.CONDITION_NAME_SUBSCRIPT_REFERENCE_PREFIX, p);
        this.visit(conditionNameSubscriptReference.getLeftParen(), p);
        this.visit(conditionNameSubscriptReference.getSubscripts(), p);
        this.visit(conditionNameSubscriptReference.getRightParen(), p);
        this.afterSyntax(conditionNameSubscriptReference, p);
        return conditionNameSubscriptReference;
    }

    @Override
    public Cobol visitConfigurationSection(Cobol.ConfigurationSection configurationSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(configurationSection, Space.Location.CONFIGURATION_SECTION_PREFIX, p);
        this.visit(configurationSection.getWords(), p);
        this.visit(configurationSection.getDot(), p);
        this.visit(configurationSection.getParagraphs(), p);
        this.afterSyntax(configurationSection, p);
        return configurationSection;
    }

    @Override
    public Cobol visitContinue(Cobol.Continue continuez, PrintOutputCapture<P> p) {
        this.beforeSyntax(continuez, Space.Location.CONTINUE_PREFIX, p);
        this.visit(continuez.getWord(), p);
        this.afterSyntax(continuez, p);
        return continuez;
    }

    @Override
    public Cobol visitCurrencyClause(Cobol.CurrencyClause currencyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(currencyClause, Space.Location.CURRENCY_CLAUSE_PREFIX, p);
        this.visit(currencyClause.getWords(), p);
        this.visit(currencyClause.getLiteral(), p);
        this.visit(currencyClause.getPictureSymbols(), p);
        this.visit(currencyClause.getPictureSymbolLiteral(), p);
        this.afterSyntax(currencyClause, p);
        return currencyClause;
    }

    @Override
    public Cobol visitDataAlignedClause(Cobol.DataAlignedClause dataAlignedClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataAlignedClause, Space.Location.DATA_ALIGNED_CLAUSE_PREFIX, p);
        this.visit(dataAlignedClause.getAligned(), p);
        this.afterSyntax(dataAlignedClause, p);
        return dataAlignedClause;
    }

    @Override
    public Cobol visitDataBaseSection(Cobol.DataBaseSection dataBaseSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataBaseSection, Space.Location.DATA_BASE_SECTION_PREFIX, p);
        this.visit(dataBaseSection.getWords(), p);
        this.visit(dataBaseSection.getDot(), p);
        this.visit(dataBaseSection.getEntries(), p);
        this.afterSyntax(dataBaseSection, p);
        return dataBaseSection;
    }

    @Override
    public Cobol visitDataBaseSectionEntry(Cobol.DataBaseSectionEntry dataBaseSectionEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataBaseSectionEntry, Space.Location.DATA_BASE_SECTION_ENTRY_PREFIX, p);
        this.visit(dataBaseSectionEntry.getDb(), p);
        this.visit(dataBaseSectionEntry.getFrom(), p);
        this.visit(dataBaseSectionEntry.getInvoke(), p);
        this.visit(dataBaseSectionEntry.getTo(), p);
        this.afterSyntax(dataBaseSectionEntry, p);
        return dataBaseSectionEntry;
    }

    @Override
    public Cobol visitDataBlankWhenZeroClause(Cobol.DataBlankWhenZeroClause dataBlankWhenZeroClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataBlankWhenZeroClause, Space.Location.DATA_BLANK_WHEN_ZERO_CLAUSE_PREFIX, p);
        this.visit(dataBlankWhenZeroClause.getWords(), p);
        this.afterSyntax(dataBlankWhenZeroClause, p);
        return dataBlankWhenZeroClause;
    }

    @Override
    public Cobol visitDataCommonOwnLocalClause(Cobol.DataCommonOwnLocalClause dataCommonOwnLocalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataCommonOwnLocalClause, Space.Location.DATA_COMMON_OWN_LOCAL_CLAUSE_PREFIX, p);
        this.visit(dataCommonOwnLocalClause.getWord(), p);
        this.afterSyntax(dataCommonOwnLocalClause, p);
        return dataCommonOwnLocalClause;
    }

    @Override
    public Cobol visitDataDescriptionEntry(Cobol.DataDescriptionEntry dataDescriptionEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataDescriptionEntry, Space.Location.DATA_DESCRIPTION_ENTRY_PREFIX, p);
        this.visit(dataDescriptionEntry.getWords(), p);
        this.visit(dataDescriptionEntry.getName(), p);
        this.visit(dataDescriptionEntry.getClauses(), p);
        this.visit(dataDescriptionEntry.getDot(), p);
        this.afterSyntax(dataDescriptionEntry, p);
        return dataDescriptionEntry;
    }

    @Override
    public Cobol visitDataDivision(Cobol.DataDivision dataDivision, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataDivision, Space.Location.DATA_DIVISION_PREFIX, p);
        this.visit(dataDivision.getWords(), p);
        this.visit(dataDivision.getDot(), p);
        this.visit(dataDivision.getSections(), p);
        this.afterSyntax(dataDivision, p);
        return dataDivision;
    }

    @Override
    public Cobol visitDataExternalClause(Cobol.DataExternalClause dataExternalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataExternalClause, Space.Location.DATA_EXTERNAL_CLAUSE_PREFIX, p);
        this.visit(dataExternalClause.getRedefines(), p);
        this.afterSyntax(dataExternalClause, p);
        return dataExternalClause;
    }

    @Override
    public Cobol visitDataGlobalClause(Cobol.DataGlobalClause dataGlobalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataGlobalClause, Space.Location.DATA_GLOBAL_CLAUSE_PREFIX, p);
        this.visit(dataGlobalClause.getWords(), p);
        this.afterSyntax(dataGlobalClause, p);
        return dataGlobalClause;
    }

    @Override
    public Cobol visitDataIntegerStringClause(Cobol.DataIntegerStringClause dataIntegerStringClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataIntegerStringClause, Space.Location.DATA_INTEGER_STRING_CLAUSE_PREFIX, p);
        this.visit(dataIntegerStringClause.getWord(), p);
        this.afterSyntax(dataIntegerStringClause, p);
        return dataIntegerStringClause;
    }

    @Override
    public Cobol visitDataJustifiedClause(Cobol.DataJustifiedClause dataJustifiedClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataJustifiedClause, Space.Location.DATA_JUSTIFIED_CLAUSE_PREFIX, p);
        this.visit(dataJustifiedClause.getWords(), p);
        this.afterSyntax(dataJustifiedClause, p);
        return dataJustifiedClause;
    }

    @Override
    public Cobol visitDataOccursClause(Cobol.DataOccursClause dataOccursClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataOccursClause, Space.Location.DATA_OCCURS_CLAUSE_PREFIX, p);
        this.visit(dataOccursClause.getOccurs(), p);
        this.visit(dataOccursClause.getName(), p);
        this.visit(dataOccursClause.getDataOccursTo(), p);
        this.visit(dataOccursClause.getTimes(), p);
        this.visit(dataOccursClause.getDataOccursDepending(), p);
        this.visit(dataOccursClause.getSortIndexed(), p);
        this.afterSyntax(dataOccursClause, p);
        return dataOccursClause;
    }

    @Override
    public Cobol visitDataOccursDepending(Cobol.DataOccursDepending dataOccursDepending, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataOccursDepending, Space.Location.DATA_OCCURS_DEPENDING_PREFIX, p);
        this.visit(dataOccursDepending.getWords(), p);
        this.visit(dataOccursDepending.getQualifiedDataName(), p);
        this.afterSyntax(dataOccursDepending, p);
        return dataOccursDepending;
    }

    @Override
    public Cobol visitDataOccursIndexed(Cobol.DataOccursIndexed dataOccursIndexed, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataOccursIndexed, Space.Location.DATA_OCCURS_INDEXED_PREFIX, p);
        this.visit(dataOccursIndexed.getWords(), p);
        this.visit(dataOccursIndexed.getIndexNames(), p);
        this.afterSyntax(dataOccursIndexed, p);
        return dataOccursIndexed;
    }

    @Override
    public Cobol visitDataOccursSort(Cobol.DataOccursSort dataOccursSort, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataOccursSort, Space.Location.DATA_OCCURS_SORT_PREFIX, p);
        this.visit(dataOccursSort.getWords(), p);
        this.visit(dataOccursSort.getQualifiedDataNames(), p);
        this.afterSyntax(dataOccursSort, p);
        return dataOccursSort;
    }

    @Override
    public Cobol visitDataOccursTo(Cobol.DataOccursTo dataOccursTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataOccursTo, Space.Location.DATA_OCCURS_TO_PREFIX, p);
        this.visit(dataOccursTo.getTo(), p);
        this.visit(dataOccursTo.getIntegerLiteral(), p);
        this.afterSyntax(dataOccursTo, p);
        return dataOccursTo;
    }

    @Override
    public Cobol visitDataPictureClause(Cobol.DataPictureClause dataPictureClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataPictureClause, Space.Location.DATA_PICTURE_CLAUSE_PREFIX, p);
        this.visit(dataPictureClause.getWords(), p);
        this.visit(dataPictureClause.getPictures(), p);
        this.afterSyntax(dataPictureClause, p);
        return dataPictureClause;
    }

    @Override
    public Cobol visitDataReceivedByClause(Cobol.DataReceivedByClause dataReceivedByClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataReceivedByClause, Space.Location.DATA_RECEIVED_BY_CLAUSE_PREFIX, p);
        this.visit(dataReceivedByClause.getWords(), p);
        this.afterSyntax(dataReceivedByClause, p);
        return dataReceivedByClause;
    }

    @Override
    public Cobol visitDataRecordAreaClause(Cobol.DataRecordAreaClause dataRecordAreaClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataRecordAreaClause, Space.Location.DATA_RECORD_AREA_CLAUSE_PREFIX, p);
        this.visit(dataRecordAreaClause.getWords(), p);
        this.afterSyntax(dataRecordAreaClause, p);
        return dataRecordAreaClause;
    }

    @Override
    public Cobol visitDataRecordsClause(Cobol.DataRecordsClause dataRecordsClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataRecordsClause, Space.Location.DATA_RECORDS_CLAUSE_PREFIX, p);
        this.visit(dataRecordsClause.getWords(), p);
        this.visit(dataRecordsClause.getDataName(), p);
        this.afterSyntax(dataRecordsClause, p);
        return dataRecordsClause;
    }

    @Override
    public Cobol visitDataRedefinesClause(Cobol.DataRedefinesClause dataRedefinesClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataRedefinesClause, Space.Location.DATA_REDEFINES_CLAUSE_PREFIX, p);
        this.visit(dataRedefinesClause.getRedefines(), p);
        this.visit(dataRedefinesClause.getDataName(), p);
        this.afterSyntax(dataRedefinesClause, p);
        return dataRedefinesClause;
    }

    @Override
    public Cobol visitDataRenamesClause(Cobol.DataRenamesClause dataRenamesClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataRenamesClause, Space.Location.DATA_RENAMES_CLAUSE_PREFIX, p);
        this.visit(dataRenamesClause.getRenames(), p);
        this.visit(dataRenamesClause.getFromName(), p);
        this.visit(dataRenamesClause.getThrough(), p);
        this.visit(dataRenamesClause.getToName(), p);
        this.afterSyntax(dataRenamesClause, p);
        return dataRenamesClause;
    }

    @Override
    public Cobol visitDataSignClause(Cobol.DataSignClause dataSignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataSignClause, Space.Location.DATA_SIGN_CLAUSE_PREFIX, p);
        this.visit(dataSignClause.getWords(), p);
        this.afterSyntax(dataSignClause, p);
        return dataSignClause;
    }

    @Override
    public Cobol visitDataSynchronizedClause(Cobol.DataSynchronizedClause dataSynchronizedClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataSynchronizedClause, Space.Location.DATA_SYNCHRONIZED_CLAUSE_PREFIX, p);
        this.visit(dataSynchronizedClause.getWords(), p);
        this.afterSyntax(dataSynchronizedClause, p);
        return dataSynchronizedClause;
    }

    @Override
    public Cobol visitDataThreadLocalClause(Cobol.DataThreadLocalClause dataThreadLocalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataThreadLocalClause, Space.Location.DATA_THREAD_LOCAL_CLAUSE_PREFIX, p);
        this.visit(dataThreadLocalClause.getWords(), p);
        this.afterSyntax(dataThreadLocalClause, p);
        return dataThreadLocalClause;
    }

    @Override
    public Cobol visitDataTypeClause(Cobol.DataTypeClause dataTypeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataTypeClause, Space.Location.DATA_TYPE_CLAUSE_PREFIX, p);
        this.visit(dataTypeClause.getWords(), p);
        this.visit(dataTypeClause.getParenthesized(), p);
        this.afterSyntax(dataTypeClause, p);
        return dataTypeClause;
    }

    @Override
    public Cobol visitDataTypeDefClause(Cobol.DataTypeDefClause dataTypeDefClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataTypeDefClause, Space.Location.DATA_TYPE_DEF_CLAUSE_PREFIX, p);
        this.visit(dataTypeDefClause.getWords(), p);
        this.afterSyntax(dataTypeDefClause, p);
        return dataTypeDefClause;
    }

    @Override
    public Cobol visitDataUsageClause(Cobol.DataUsageClause dataUsageClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataUsageClause, Space.Location.DATA_USAGE_CLAUSE_PREFIX, p);
        this.visit(dataUsageClause.getWords(), p);
        this.afterSyntax(dataUsageClause, p);
        return dataUsageClause;
    }

    @Override
    public Cobol visitDataUsingClause(Cobol.DataUsingClause dataUsingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataUsingClause, Space.Location.DATA_USING_CLAUSE_PREFIX, p);
        this.visit(dataUsingClause.getWords(), p);
        this.afterSyntax(dataUsingClause, p);
        return dataUsingClause;
    }

    @Override
    public Cobol visitDataValueClause(Cobol.DataValueClause dataValueClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataValueClause, Space.Location.DATA_VALUE_CLAUSE_PREFIX, p);
        this.visit(dataValueClause.getWords(), p);
        this.visit(dataValueClause.getCobols(), p);
        this.afterSyntax(dataValueClause, p);
        return dataValueClause;
    }

    @Override
    public Cobol visitDataValueInterval(Cobol.DataValueInterval dataValueInterval, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataValueInterval, Space.Location.DATA_VALUE_INTERVAL_PREFIX, p);
        this.visit(dataValueInterval.getFrom(), p);
        this.visit(dataValueInterval.getTo(), p);
        this.afterSyntax(dataValueInterval, p);
        return dataValueInterval;
    }

    @Override
    public Cobol visitDataValueIntervalTo(Cobol.DataValueIntervalTo dataValueIntervalTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataValueIntervalTo, Space.Location.DATA_VALUE_INTERVAL_TO_PREFIX, p);
        this.visit(dataValueIntervalTo.getThrough(), p);
        this.visit(dataValueIntervalTo.getLiteral(), p);
        this.afterSyntax(dataValueIntervalTo, p);
        return dataValueIntervalTo;
    }

    @Override
    public Cobol visitDataWithLowerBoundsClause(Cobol.DataWithLowerBoundsClause dataWithLowerBoundsClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataWithLowerBoundsClause, Space.Location.DATA_WITH_LOWER_BOUNDS_CLAUSE_PREFIX, p);
        this.visit(dataWithLowerBoundsClause.getWords(), p);
        this.afterSyntax(dataWithLowerBoundsClause, p);
        return dataWithLowerBoundsClause;
    }

    @Override
    public Cobol visitDecimalPointClause(Cobol.DecimalPointClause decimalPointClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(decimalPointClause, Space.Location.DECIMAL_POINT_CLAUSE_PREFIX, p);
        this.visit(decimalPointClause.getWords(), p);
        this.afterSyntax(decimalPointClause, p);
        return decimalPointClause;
    }

    @Override
    public Cobol visitDefaultComputationalSignClause(Cobol.DefaultComputationalSignClause defaultComputationalSignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(defaultComputationalSignClause, Space.Location.DEFAULT_COMPUTATIONAL_SIGN_CLAUSE_PREFIX, p);
        this.visit(defaultComputationalSignClause.getWords(), p);
        this.afterSyntax(defaultComputationalSignClause, p);
        return defaultComputationalSignClause;
    }

    @Override
    public Cobol visitDefaultDisplaySignClause(Cobol.DefaultDisplaySignClause defaultDisplaySignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(defaultDisplaySignClause, Space.Location.DEFAULT_DISPLAY_SIGN_CLAUSE_PREFIX, p);
        this.visit(defaultDisplaySignClause.getWords(), p);
        this.afterSyntax(defaultDisplaySignClause, p);
        return defaultDisplaySignClause;
    }

    @Override
    public Cobol visitDelete(Cobol.Delete delete, PrintOutputCapture<P> p) {
        this.beforeSyntax(delete, Space.Location.DELETE_PREFIX, p);
        this.visit(delete.getDelete(), p);
        this.visit(delete.getFileName(), p);
        this.visit(delete.getRecord(), p);
        this.visit(delete.getInvalidKey(), p);
        this.visit(delete.getNotInvalidKey(), p);
        this.visit(delete.getEndDelete(), p);
        this.afterSyntax(delete, p);
        return delete;
    }

    @Override
    public Cobol visitDestinationCountClause(Cobol.DestinationCountClause destinationCountClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(destinationCountClause, Space.Location.DESTINATION_COUNT_CLAUSE_PREFIX, p);
        this.visit(destinationCountClause.getWords(), p);
        this.visit(destinationCountClause.getDataDescName(), p);
        this.afterSyntax(destinationCountClause, p);
        return destinationCountClause;
    }

    @Override
    public Cobol visitDestinationTableClause(Cobol.DestinationTableClause destinationTableClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(destinationTableClause, Space.Location.DESTINATION_TABLE_CLAUSE_PREFIX, p);
        this.visit(destinationTableClause.getFirstWords(), p);
        this.visit(destinationTableClause.getIntegerLiteral(), p);
        this.visit(destinationTableClause.getSecondWords(), p);
        this.visit(destinationTableClause.getIndexNames(), p);
        this.afterSyntax(destinationTableClause, p);
        return destinationTableClause;
    }

    @Override
    public Cobol visitDisable(Cobol.Disable disable, PrintOutputCapture<P> p) {
        this.beforeSyntax(disable, Space.Location.DISABLE_PREFIX, p);
        this.visit(disable.getDisable(), p);
        this.visit(disable.getTypes(), p);
        this.visit(disable.getCdName(), p);
        this.visit(disable.getWith(), p);
        this.visit(disable.getKey(), p);
        this.visit(disable.getKeyName(), p);
        this.afterSyntax(disable, p);
        return disable;
    }

    @Override
    public Cobol visitDisplay(Cobol.Display display, PrintOutputCapture<P> p) {
        this.beforeSyntax(display, Space.Location.DISPLAY_PREFIX, p);
        this.visit(display.getDisplay(), p);
        this.visit(display.getOperands(), p);
        this.visit(display.getDisplayAt(), p);
        this.visit(display.getDisplayUpon(), p);
        this.visit(display.getDisplayWith(), p);
        this.visit(display.getOnExceptionClause(), p);
        this.visit(display.getNotOnExceptionClause(), p);
        this.visit(display.getEndDisplay(), p);
        this.afterSyntax(display, p);
        return display;
    }

    @Override
    public Cobol visitDisplayAt(Cobol.DisplayAt displayAt, PrintOutputCapture<P> p) {
        this.beforeSyntax(displayAt, Space.Location.DISPLAY_AT_PREFIX, p);
        this.visit(displayAt.getAt(), p);
        this.visit(displayAt.getName(), p);
        this.afterSyntax(displayAt, p);
        return displayAt;
    }

    @Override
    public Cobol visitDisplayUpon(Cobol.DisplayUpon displayUpon, PrintOutputCapture<P> p) {
        this.beforeSyntax(displayUpon, Space.Location.DISPLAY_UPON_PREFIX, p);
        this.visit(displayUpon.getUpon(), p);
        this.visit(displayUpon.getName(), p);
        this.afterSyntax(displayUpon, p);
        return displayUpon;
    }

    @Override
    public Cobol visitDivide(Cobol.Divide divide, PrintOutputCapture<P> p) {
        this.beforeSyntax(divide, Space.Location.DIVIDE_PREFIX, p);
        this.visit(divide.getDivide(), p);
        this.visit(divide.getName(), p);
        this.visit(divide.getAction(), p);
        this.visit(divide.getDivideRemainder(), p);
        this.visit(divide.getOnSizeErrorPhrase(), p);
        this.visit(divide.getNotOnSizeErrorPhrase(), p);
        this.visit(divide.getEndDivide(), p);
        this.afterSyntax(divide, p);
        return divide;
    }

    @Override
    public Cobol visitDivideGiving(Cobol.DivideGiving divideGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(divideGiving, Space.Location.DIVIDE_GIVING_PREFIX, p);
        this.visit(divideGiving.getWord(), p);
        this.visit(divideGiving.getName(), p);
        this.visit(divideGiving.getDivideGivingPhrase(), p);
        this.afterSyntax(divideGiving, p);
        return divideGiving;
    }

    @Override
    public Cobol visitDivideGivingPhrase(Cobol.DivideGivingPhrase divideGivingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(divideGivingPhrase, Space.Location.DIVIDE_GIVING_PHRASE_PREFIX, p);
        this.visit(divideGivingPhrase.getGiving(), p);
        this.visit(divideGivingPhrase.getRoundables(), p);
        this.afterSyntax(divideGivingPhrase, p);
        return divideGivingPhrase;
    }

    @Override
    public Cobol visitDivideInto(Cobol.DivideInto divideInto, PrintOutputCapture<P> p) {
        this.beforeSyntax(divideInto, Space.Location.DIVIDE_INTO_PREFIX, p);
        this.visit(divideInto.getInto(), p);
        this.visit(divideInto.getRoundables(), p);
        this.afterSyntax(divideInto, p);
        return divideInto;
    }

    @Override
    public Cobol visitDivideRemainder(Cobol.DivideRemainder divideRemainder, PrintOutputCapture<P> p) {
        this.beforeSyntax(divideRemainder, Space.Location.DIVIDE_REMAINDER_PREFIX, p);
        this.visit(divideRemainder.getRemainder(), p);
        this.visit(divideRemainder.getName(), p);
        this.afterSyntax(divideRemainder, p);
        return divideRemainder;
    }

    @Override
    public Cobol visitEnable(Cobol.Enable enable, PrintOutputCapture<P> p) {
        this.beforeSyntax(enable, Space.Location.ENABLE_PREFIX, p);
        this.visit(enable.getEnable(), p);
        this.visit(enable.getTypes(), p);
        this.visit(enable.getCdName(), p);
        this.visit(enable.getWith(), p);
        this.visit(enable.getKey(), p);
        this.visit(enable.getKeyName(), p);
        this.afterSyntax(enable, p);
        return enable;
    }

    @Override
    public Cobol visitEndKeyClause(Cobol.EndKeyClause endKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(endKeyClause, Space.Location.END_KEY_CLAUSE_PREFIX, p);
        this.visit(endKeyClause.getWords(), p);
        this.visit(endKeyClause.getName(), p);
        this.afterSyntax(endKeyClause, p);
        return endKeyClause;
    }

    @Override
    public Cobol visitEndProgram(Cobol.EndProgram endProgram, PrintOutputCapture<P> p) {
        this.beforeSyntax(endProgram, Space.Location.END_PROGRAM_PREFIX, p);
        this.visit(endProgram.getWords(), p);
        this.visit(endProgram.getProgramName(), p);
        this.visit(endProgram.getDot(), p);
        this.afterSyntax(endProgram, p);
        return endProgram;
    }

    @Override
    public Cobol.Entry visitEntry(Cobol.Entry entry, PrintOutputCapture<P> p) {
        this.beforeSyntax(entry, Space.Location.ENTRY_PREFIX, p);
        this.visit(entry.getEntry(), p);
        this.visit(entry.getLiteral(), p);
        this.visit(entry.getUsing(), p);
        this.visit(entry.getIdentifiers(), p);
        this.afterSyntax(entry, p);
        return entry;
    }

    @Override
    public Cobol visitEnvironmentDivision(Cobol.EnvironmentDivision environmentDivision, PrintOutputCapture<P> p) {
        this.beforeSyntax(environmentDivision, Space.Location.ENVIRONMENT_DIVISION_PREFIX, p);
        this.visit(environmentDivision.getWords(), p);
        this.visit(environmentDivision.getDot(), p);
        this.visit(environmentDivision.getBody(), p);
        this.afterSyntax(environmentDivision, p);
        return environmentDivision;
    }

    @Override
    public Cobol visitEvaluate(Cobol.Evaluate evaluate, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluate, Space.Location.EVALUATE_PREFIX, p);
        this.visit(evaluate.getEvaluate(), p);
        this.visit(evaluate.getSelect(), p);
        this.visit(evaluate.getAlsoSelect(), p);
        this.visit(evaluate.getWhenPhrase(), p);
        this.visit(evaluate.getWhenOther(), p);
        this.visit(evaluate.getEndPhrase(), p);
        this.afterSyntax(evaluate, p);
        return evaluate;
    }

    @Override
    public Cobol visitEvaluateAlso(Cobol.EvaluateAlso evaluateAlso, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateAlso, Space.Location.EVALUATE_ALSO_PREFIX, p);
        this.visit(evaluateAlso.getAlso(), p);
        this.visit(evaluateAlso.getSelect(), p);
        this.afterSyntax(evaluateAlso, p);
        return evaluateAlso;
    }

    @Override
    public Cobol visitEnvironmentSwitchNameClause(Cobol.EnvironmentSwitchNameClause environmentSwitchNameClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(environmentSwitchNameClause, Space.Location.ENVIRONMENT_SWITCH_NAME_CLAUSE_PREFIX, p);
        this.visit(environmentSwitchNameClause.getEnvironmentName(), p);
        this.visit(environmentSwitchNameClause.getIs(), p);
        this.visit(environmentSwitchNameClause.getMnemonicName(), p);
        this.visit(environmentSwitchNameClause.getEnvironmentSwitchNameSpecialNamesStatusPhrase(), p);
        this.afterSyntax(environmentSwitchNameClause, p);
        return environmentSwitchNameClause;
    }

    @Override
    public Cobol visitEnvironmentSwitchNameSpecialNamesStatusPhrase(Cobol.EnvironmentSwitchNameSpecialNamesStatusPhrase environmentSwitchNameSpecialNamesStatusPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(environmentSwitchNameSpecialNamesStatusPhrase, Space.Location.ENVIRONMENT_SWITCH_NAME_SPECIAL_NAMES_STATUS_PHRASE_PREFIX, p);
        this.visit(environmentSwitchNameSpecialNamesStatusPhrase.getCobols(), p);
        this.afterSyntax(environmentSwitchNameSpecialNamesStatusPhrase, p);
        return environmentSwitchNameSpecialNamesStatusPhrase;
    }

    @Override
    public Cobol visitErrorKeyClause(Cobol.ErrorKeyClause errorKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(errorKeyClause, Space.Location.ERROR_KEY_CLAUSE_PREFIX, p);
        this.visit(errorKeyClause.getWords(), p);
        this.visit(errorKeyClause.getName(), p);
        this.afterSyntax(errorKeyClause, p);
        return errorKeyClause;
    }

    @Override
    public Cobol visitEvaluateAlsoCondition(Cobol.EvaluateAlsoCondition evaluateAlsoCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateAlsoCondition, Space.Location.EVALUATE_ALSO_CONDITION_PREFIX, p);
        this.visit(evaluateAlsoCondition.getAlso(), p);
        this.visit(evaluateAlsoCondition.getCondition(), p);
        this.afterSyntax(evaluateAlsoCondition, p);
        return evaluateAlsoCondition;
    }

    @Override
    public Cobol visitEvaluateCondition(Cobol.EvaluateCondition evaluateCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateCondition, Space.Location.EVALUATE_CONDITION_PREFIX, p);
        this.visit(evaluateCondition.getWords(), p);
        this.visit(evaluateCondition.getCondition(), p);
        this.visit(evaluateCondition.getEvaluateThrough(), p);
        this.afterSyntax(evaluateCondition, p);
        return evaluateCondition;
    }

    @Override
    public Cobol visitEvaluateThrough(Cobol.EvaluateThrough evaluateThrough, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateThrough, Space.Location.EVALUATE_THROUGH_PREFIX, p);
        this.visit(evaluateThrough.getThrough(), p);
        this.visit(evaluateThrough.getValue(), p);
        this.afterSyntax(evaluateThrough, p);
        return evaluateThrough;
    }

    @Override
    public Cobol visitEvaluateWhen(Cobol.EvaluateWhen evaluateWhen, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateWhen, Space.Location.EVALUATE_WHEN_PREFIX, p);
        this.visit(evaluateWhen.getWhen(), p);
        this.visit(evaluateWhen.getCondition(), p);
        this.visit(evaluateWhen.getAlsoCondition(), p);
        this.afterSyntax(evaluateWhen, p);
        return evaluateWhen;
    }

    @Override
    public Cobol visitEvaluateWhenPhrase(Cobol.EvaluateWhenPhrase evaluateWhenPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(evaluateWhenPhrase, Space.Location.EVALUATE_WHEN_PHRASE_PREFIX, p);
        this.visit(evaluateWhenPhrase.getWhens(), p);
        this.visit(evaluateWhenPhrase.getStatements(), p);
        this.afterSyntax(evaluateWhenPhrase, p);
        return evaluateWhenPhrase;
    }

    @Override
    public Cobol visitExecCicsStatement(Cobol.ExecCicsStatement execCicsStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execCicsStatement, Space.Location.EXEC_CICS_STATEMENT_PREFIX, p);
        this.visit(execCicsStatement.getExecCicsLines(), p);
        this.afterSyntax(execCicsStatement, p);
        return execCicsStatement;
    }

    @Override
    public Cobol visitExecSqlImsStatement(Cobol.ExecSqlImsStatement execSqlImsStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execSqlImsStatement, Space.Location.EXEC_SQL_IMS_STATEMENT_PREFIX, p);
        this.visit(execSqlImsStatement.getExecSqlLmsLines(), p);
        this.afterSyntax(execSqlImsStatement, p);
        return execSqlImsStatement;
    }

    @Override
    public Cobol visitExecSqlStatement(Cobol.ExecSqlStatement execSqlStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execSqlStatement, Space.Location.EXEC_SQL_STATEMENT_PREFIX, p);
        this.visit(execSqlStatement.getExecSqlLines(), p);
        this.afterSyntax(execSqlStatement, p);
        return execSqlStatement;
    }

    @Override
    public Cobol visitExhibit(Cobol.Exhibit exhibit, PrintOutputCapture<P> p) {
        this.beforeSyntax(exhibit, Space.Location.EXHIBIT_PREFIX, p);
        this.visit(exhibit.getWords(), p);
        this.visit(exhibit.getOperands(), p);
        this.afterSyntax(exhibit, p);
        return exhibit;
    }

    @Override
    public Cobol visitExit(Cobol.Exit exit, PrintOutputCapture<P> p) {
        this.beforeSyntax(exit, Space.Location.EXIT_PREFIX, p);
        this.visit(exit.getWords(), p);
        this.afterSyntax(exit, p);
        return exit;
    }

    @Override
    public Cobol visitExternalClause(Cobol.ExternalClause externalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(externalClause, Space.Location.EXTERNAL_CLAUSE_PREFIX, p);
        this.visit(externalClause.getWords(), p);
        this.afterSyntax(externalClause, p);
        return externalClause;
    }

    @Override
    public Cobol visitFigurativeConstant(Cobol.FigurativeConstant figurativeConstant, PrintOutputCapture<P> p) {
        this.beforeSyntax(figurativeConstant, Space.Location.FIGURATIVE_CONSTANT_PREFIX, p);
        this.visit(figurativeConstant.getWord(), p);
        this.visit(figurativeConstant.getLiteral(), p);
        this.afterSyntax(figurativeConstant, p);
        return figurativeConstant;
    }

    @Override
    public Cobol visitFileControlEntry(Cobol.FileControlEntry fileControlEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(fileControlEntry, Space.Location.FILE_CONTROL_ENTRY_PREFIX, p);
        this.visit(fileControlEntry.getSelectClause(), p);
        this.visit(fileControlEntry.getControlClauses(), p);
        this.afterSyntax(fileControlEntry, p);
        return fileControlEntry;
    }

    @Override
    public Cobol visitFileControlParagraph(Cobol.FileControlParagraph fileControlParagraph, PrintOutputCapture<P> p) {
        this.beforeSyntax(fileControlParagraph, Space.Location.FILE_CONTROL_PARAGRAPH_PREFIX, p);
        this.visit(fileControlParagraph.getFileControl(), p);
        this.visit(fileControlParagraph.getControlEntries(), p);
        this.afterSyntax(fileControlParagraph, p);
        return fileControlParagraph;
    }

    @Override
    public Cobol visitFileDescriptionEntry(Cobol.FileDescriptionEntry fileDescriptionEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(fileDescriptionEntry, Space.Location.FILE_DESCRIPTION_ENTRY_PREFIX, p);
        this.visit(fileDescriptionEntry.getWord(), p);
        this.visit(fileDescriptionEntry.getName(), p);
        this.visit(fileDescriptionEntry.getClauses(), p);
        this.visit(fileDescriptionEntry.getDataDescriptions(), p);
        this.afterSyntax(fileDescriptionEntry, p);
        return fileDescriptionEntry;
    }

    @Override
    public Cobol visitFileSection(Cobol.FileSection fileSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(fileSection, Space.Location.FILE_SECTION_PREFIX, p);
        this.visit(fileSection.getWords(), p);
        this.visit(fileSection.getDot(), p);
        this.visit(fileSection.getFileDescriptionEntry(), p);
        this.afterSyntax(fileSection, p);
        return fileSection;
    }

    @Override
    public Cobol visitFileStatusClause(Cobol.FileStatusClause fileStatusClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(fileStatusClause, Space.Location.FILE_STATUS_CLAUSE_PREFIX, p);
        this.visit(fileStatusClause.getWords(), p);
        this.visit(fileStatusClause.getQualifiedDataNames(), p);
        this.afterSyntax(fileStatusClause, p);
        return fileStatusClause;
    }

    @Override
    public Cobol visitFunctionCall(Cobol.FunctionCall functionCall, PrintOutputCapture<P> p) {
        this.beforeSyntax(functionCall, Space.Location.FUNCTION_CALL_PREFIX, p);
        this.visit(functionCall.getFunction(), p);
        this.visit(functionCall.getFunctionName(), p);
        this.visit(functionCall.getArguments(), p);
        this.visit(functionCall.getReferenceModifier(), p);
        this.afterSyntax(functionCall, p);
        return functionCall;
    }

    @Override
    public Cobol visitGenerate(Cobol.Generate generate, PrintOutputCapture<P> p) {
        this.beforeSyntax(generate, Space.Location.GENERATE_PREFIX, p);
        this.visit(generate.getGenerate(), p);
        this.visit(generate.getReportName(), p);
        this.afterSyntax(generate, p);
        return generate;
    }

    @Override
    public Cobol visitGlobalClause(Cobol.GlobalClause globalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(globalClause, Space.Location.GLOBAL_CLAUSE_PREFIX, p);
        this.visit(globalClause.getWords(), p);
        this.afterSyntax(globalClause, p);
        return globalClause;
    }

    @Override
    public Cobol visitGoBack(Cobol.GoBack goBack, PrintOutputCapture<P> p) {
        this.beforeSyntax(goBack, Space.Location.GO_BACK_PREFIX, p);
        this.visit(goBack.getGoBack(), p);
        this.afterSyntax(goBack, p);
        return goBack;
    }

    @Override
    public Cobol visitGoTo(Cobol.GoTo _goTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(_goTo, Space.Location.GO_TO_PREFIX, p);
        this.visit(_goTo.getWords(), p);
        this.visit(_goTo.getStatement(), p);
        this.afterSyntax(_goTo, p);
        return _goTo;
    }

    @Override
    public Cobol visitGoToDependingOnStatement(Cobol.GoToDependingOnStatement goToDependingOnStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(goToDependingOnStatement, Space.Location.GO_TO_DEPENDING_ON_STATEMENT_PREFIX, p);
        this.visit(goToDependingOnStatement.getProcedureNames(), p);
        this.visit(goToDependingOnStatement.getWords(), p);
        this.visit(goToDependingOnStatement.getIdentifier(), p);
        this.afterSyntax(goToDependingOnStatement, p);
        return goToDependingOnStatement;
    }

    @Override
    public Cobol visitIdentificationDivision(Cobol.IdentificationDivision identificationDivision, PrintOutputCapture<P> p) {
        this.beforeSyntax(identificationDivision, Space.Location.IDENTIFICATION_DIVISION_PREFIX, p);
        this.visit(identificationDivision.getWords(), p);
        this.visit(identificationDivision.getProgramIdParagraph(), p);
        this.visit(identificationDivision.getParagraphs(), p);
        this.afterSyntax(identificationDivision, p);
        return identificationDivision;
    }

    @Override
    public Cobol visitIdentificationDivisionParagraph(Cobol.IdentificationDivisionParagraph identificationDivisionParagraph, PrintOutputCapture<P> p) {
        this.beforeSyntax(identificationDivisionParagraph, Space.Location.IDENTIFICATION_DIVISION_PARAGRAPH_PREFIX, p);
        this.visit(identificationDivisionParagraph.getWord(), p);
        this.visit(identificationDivisionParagraph.getDot(), p);
        this.visit(identificationDivisionParagraph.getCommentEntry(), p);
        this.visit(identificationDivisionParagraph.getWords(), p);
        this.visit(identificationDivisionParagraph.getDot2(), p);
        this.afterSyntax(identificationDivisionParagraph, p);
        return identificationDivisionParagraph;
    }

    @Override
    public Cobol visitIf(Cobol.If _if, PrintOutputCapture<P> p) {
        this.beforeSyntax(_if, Space.Location.IF_PREFIX, p);
        this.visit(_if.getWord(), p);
        this.visit(_if.getCondition(), p);
        this.visit(_if.getIfThen(), p);
        this.visit(_if.getIfElse(), p);
        this.visit(_if.getEndIf(), p);
        this.afterSyntax(_if, p);
        return _if;
    }

    @Override
    public Cobol visitIfElse(Cobol.IfElse ifElse, PrintOutputCapture<P> p) {
        this.beforeSyntax(ifElse, Space.Location.IF_ELSE_PREFIX, p);
        this.visit(ifElse.getWord(), p);
        this.visit(ifElse.getNextSentences(), p);
        this.visit(ifElse.getStatements(), p);
        this.afterSyntax(ifElse, p);
        return ifElse;
    }

    @Override
    public Cobol visitIfThen(Cobol.IfThen ifThen, PrintOutputCapture<P> p) {
        this.beforeSyntax(ifThen, Space.Location.IF_THEN_PREFIX, p);
        this.visit(ifThen.getWord(), p);
        this.visit(ifThen.getNextSentences(), p);
        this.visit(ifThen.getStatements(), p);
        this.afterSyntax(ifThen, p);
        return ifThen;
    }

    @Override
    public Cobol visitInData(Cobol.InData inData, PrintOutputCapture<P> p) {
        this.beforeSyntax(inData, Space.Location.IN_DATA_PREFIX, p);
        this.visit(inData.getWord(), p);
        this.visit(inData.getName(), p);
        this.afterSyntax(inData, p);
        return inData;
    }

    @Override
    public Cobol visitInFile(Cobol.InFile inFile, PrintOutputCapture<P> p) {
        this.beforeSyntax(inFile, Space.Location.IN_FILE_PREFIX, p);
        this.visit(inFile.getWord(), p);
        this.visit(inFile.getName(), p);
        this.afterSyntax(inFile, p);
        return inFile;
    }

    @Override
    public Cobol visitInLibrary(Cobol.InLibrary inLibrary, PrintOutputCapture<P> p) {
        this.beforeSyntax(inLibrary, Space.Location.IN_LIBRARY_PREFIX, p);
        this.visit(inLibrary.getWord(), p);
        this.visit(inLibrary.getName(), p);
        this.afterSyntax(inLibrary, p);
        return inLibrary;
    }

    @Override
    public Cobol visitInMnemonic(Cobol.InMnemonic inMnemonic, PrintOutputCapture<P> p) {
        this.beforeSyntax(inMnemonic, Space.Location.IN_MNEMONIC_PREFIX, p);
        this.visit(inMnemonic.getWord(), p);
        this.visit(inMnemonic.getName(), p);
        this.afterSyntax(inMnemonic, p);
        return inMnemonic;
    }

    @Override
    public Cobol visitInSection(Cobol.InSection inSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(inSection, Space.Location.IN_SECTION_PREFIX, p);
        this.visit(inSection.getWord(), p);
        this.visit(inSection.getName(), p);
        this.afterSyntax(inSection, p);
        return inSection;
    }

    @Override
    public Cobol visitInTable(Cobol.InTable inTable, PrintOutputCapture<P> p) {
        this.beforeSyntax(inTable, Space.Location.IN_TABLE_PREFIX, p);
        this.visit(inTable.getWord(), p);
        this.visit(inTable.getTableCall(), p);
        this.afterSyntax(inTable, p);
        return inTable;
    }

    @Override
    public Cobol visitInitialize(Cobol.Initialize initialize, PrintOutputCapture<P> p) {
        this.beforeSyntax(initialize, Space.Location.INITIALIZE_PREFIX, p);
        this.visit(initialize.getInitialize(), p);
        this.visit(initialize.getIdentifiers(), p);
        this.visit(initialize.getInitializeReplacingPhrase(), p);
        this.afterSyntax(initialize, p);
        return initialize;
    }

    @Override
    public Cobol visitInitializeReplacingBy(Cobol.InitializeReplacingBy initializeReplacingBy, PrintOutputCapture<P> p) {
        this.beforeSyntax(initializeReplacingBy, Space.Location.INITIALIZE_REPLACING_BY_PREFIX, p);
        this.visit(initializeReplacingBy.getWords(), p);
        this.visit(initializeReplacingBy.getIdentifier(), p);
        this.afterSyntax(initializeReplacingBy, p);
        return initializeReplacingBy;
    }

    @Override
    public Cobol visitInitializeReplacingPhrase(Cobol.InitializeReplacingPhrase initializeReplacingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(initializeReplacingPhrase, Space.Location.INITIALIZE_REPLACING_PHRASE_PREFIX, p);
        this.visit(initializeReplacingPhrase.getReplacing(), p);
        this.visit(initializeReplacingPhrase.getInitializeReplacingBy(), p);
        this.afterSyntax(initializeReplacingPhrase, p);
        return initializeReplacingPhrase;
    }

    @Override
    public Cobol visitInitiate(Cobol.Initiate initiate, PrintOutputCapture<P> p) {
        this.beforeSyntax(initiate, Space.Location.INITIATE_PREFIX, p);
        this.visit(initiate.getInitiate(), p);
        this.visit(initiate.getReportNames(), p);
        this.afterSyntax(initiate, p);
        return initiate;
    }

    @Override
    public Cobol visitInputOutputSection(Cobol.InputOutputSection inputOutputSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(inputOutputSection, Space.Location.INPUT_OUTPUT_SECTION_PREFIX, p);
        this.visit(inputOutputSection.getWords(), p);
        this.visit(inputOutputSection.getParagraphs(), p);
        this.afterSyntax(inputOutputSection, p);
        return inputOutputSection;
    }

    @Override
    public Cobol visitInspect(Cobol.Inspect inspect, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspect, Space.Location.INSPECT_PREFIX, p);
        this.visit(inspect.getInspect(), p);
        this.visit(inspect.getIdentifier(), p);
        this.visit(inspect.getPhrase(), p);
        this.afterSyntax(inspect, p);
        return inspect;
    }

    @Override
    public Cobol visitInspectAllLeading(Cobol.InspectAllLeading inspectAllLeading, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectAllLeading, Space.Location.INSPECT_ALL_LEADING_PREFIX, p);
        this.visit(inspectAllLeading.getName(), p);
        this.visit(inspectAllLeading.getInspections(), p);
        this.afterSyntax(inspectAllLeading, p);
        return inspectAllLeading;
    }

    @Override
    public Cobol visitInspectAllLeadings(Cobol.InspectAllLeadings inspectAllLeadings, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectAllLeadings, Space.Location.INSPECT_ALL_LEADINGS_PREFIX, p);
        this.visit(inspectAllLeadings.getWord(), p);
        this.visit(inspectAllLeadings.getLeadings(), p);
        this.afterSyntax(inspectAllLeadings, p);
        return inspectAllLeadings;
    }

    @Override
    public Cobol visitInspectBeforeAfter(Cobol.InspectBeforeAfter inspectBeforeAfter, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectBeforeAfter, Space.Location.INSPECT_BEFORE_AFTER_PREFIX, p);
        this.visit(inspectBeforeAfter.getWords(), p);
        this.visit(inspectBeforeAfter.getIdentifier(), p);
        this.afterSyntax(inspectBeforeAfter, p);
        return inspectBeforeAfter;
    }

    @Override
    public Cobol visitInspectBy(Cobol.InspectBy inspectBy, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectBy, Space.Location.INSPECT_BY_PREFIX, p);
        this.visit(inspectBy.getBy(), p);
        this.visit(inspectBy.getIdentifier(), p);
        this.afterSyntax(inspectBy, p);
        return inspectBy;
    }

    @Override
    public Cobol visitInspectCharacters(Cobol.InspectCharacters inspectCharacters, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectCharacters, Space.Location.DATA_WITH_LOWER_BOUNDS_CLAUSE_PREFIX, p);
        this.visit(inspectCharacters.getCharacter(), p);
        this.visit(inspectCharacters.getInspections(), p);
        this.afterSyntax(inspectCharacters, p);
        return inspectCharacters;
    }

    @Override
    public Cobol visitInspectConvertingPhrase(Cobol.InspectConvertingPhrase inspectConvertingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectConvertingPhrase, Space.Location.INSPECT_CONVERTING_PHRASE_PREFIX, p);
        this.visit(inspectConvertingPhrase.getConverting(), p);
        this.visit(inspectConvertingPhrase.getIdentifier(), p);
        this.visit(inspectConvertingPhrase.getInspectTo(), p);
        this.visit(inspectConvertingPhrase.getInspections(), p);
        this.afterSyntax(inspectConvertingPhrase, p);
        return inspectConvertingPhrase;
    }

    @Override
    public Cobol visitInspectFor(Cobol.InspectFor inspectFor, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectFor, Space.Location.INSPECT_FOR_PREFIX, p);
        this.visit(inspectFor.getIdentifier(), p);
        this.visit(inspectFor.getWord(), p);
        this.visit(inspectFor.getInspects(), p);
        this.afterSyntax(inspectFor, p);
        return inspectFor;
    }

    @Override
    public Cobol visitInspectReplacingAllLeading(Cobol.InspectReplacingAllLeading inspectReplacingAllLeading, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectReplacingAllLeading, Space.Location.INSPECT_REPLACING_ALL_LEADING_PREFIX, p);
        this.visit(inspectReplacingAllLeading.getIdentifier(), p);
        this.visit(inspectReplacingAllLeading.getInspectBy(), p);
        this.visit(inspectReplacingAllLeading.getInspections(), p);
        this.afterSyntax(inspectReplacingAllLeading, p);
        return inspectReplacingAllLeading;
    }

    @Override
    public Cobol visitInspectReplacingAllLeadings(Cobol.InspectReplacingAllLeadings inspectReplacingAllLeadings, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectReplacingAllLeadings, Space.Location.INSPECT_REPLACING_ALL_LEADINGS_PREFIX, p);
        this.visit(inspectReplacingAllLeadings.getWord(), p);
        this.visit(inspectReplacingAllLeadings.getInspections(), p);
        this.afterSyntax(inspectReplacingAllLeadings, p);
        return inspectReplacingAllLeadings;
    }

    @Override
    public Cobol visitInspectReplacingCharacters(Cobol.InspectReplacingCharacters inspectReplacingCharacters, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectReplacingCharacters, Space.Location.INSPECT_REPLACING_CHARACTERS_PREFIX, p);
        this.visit(inspectReplacingCharacters.getWord(), p);
        this.visit(inspectReplacingCharacters.getInspectBy(), p);
        this.visit(inspectReplacingCharacters.getInspections(), p);
        this.afterSyntax(inspectReplacingCharacters, p);
        return inspectReplacingCharacters;
    }

    @Override
    public Cobol visitInspectReplacingPhrase(Cobol.InspectReplacingPhrase inspectReplacingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectReplacingPhrase, Space.Location.INSPECT_REPLACING_PHRASE_PREFIX, p);
        this.visit(inspectReplacingPhrase.getWord(), p);
        this.visit(inspectReplacingPhrase.getInspections(), p);
        this.afterSyntax(inspectReplacingPhrase, p);
        return inspectReplacingPhrase;
    }

    @Override
    public Cobol visitInspectTallyingPhrase(Cobol.InspectTallyingPhrase inspectTallyingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectTallyingPhrase, Space.Location.INSPECT_TALLYING_PHRASE_PREFIX, p);
        this.visit(inspectTallyingPhrase.getTallying(), p);
        this.visit(inspectTallyingPhrase.getInspectFors(), p);
        this.afterSyntax(inspectTallyingPhrase, p);
        return inspectTallyingPhrase;
    }

    @Override
    public Cobol visitInspectTallyingReplacingPhrase(Cobol.InspectTallyingReplacingPhrase inspectTallyingReplacingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectTallyingReplacingPhrase, Space.Location.INSPECT_TALLYING_REPLACING_PHRASE_PREFIX, p);
        this.visit(inspectTallyingReplacingPhrase.getTallying(), p);
        this.visit(inspectTallyingReplacingPhrase.getInspectFors(), p);
        this.visit(inspectTallyingReplacingPhrase.getReplacingPhrases(), p);
        this.afterSyntax(inspectTallyingReplacingPhrase, p);
        return inspectTallyingReplacingPhrase;
    }

    @Override
    public Cobol visitInspectTo(Cobol.InspectTo inspectTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(inspectTo, Space.Location.INSPECT_TO_PREFIX, p);
        this.visit(inspectTo.getTo(), p);
        this.visit(inspectTo.getIdentifier(), p);
        this.afterSyntax(inspectTo, p);
        return inspectTo;
    }

    @Override
    public Cobol visitIoControlParagraph(Cobol.IoControlParagraph ioControlParagraph, PrintOutputCapture<P> p) {
        this.beforeSyntax(ioControlParagraph, Space.Location.IO_CONTROL_PARAGRAPH_PREFIX, p);
        this.visit(ioControlParagraph.getIOControl(), p);
        this.visit(ioControlParagraph.getDot(), p);
        this.visit(ioControlParagraph.getFileName(), p);
        this.visit(ioControlParagraph.getFileNameDot(), p);
        this.visit(ioControlParagraph.getClauses(), p);
        this.visit(ioControlParagraph.getDot2(), p);
        this.afterSyntax(ioControlParagraph, p);
        return ioControlParagraph;
    }

    @Override
    public Cobol visitLabelRecordsClause(Cobol.LabelRecordsClause labelRecordsClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(labelRecordsClause, Space.Location.LABEL_RECORDS_CLAUSE_PREFIX, p);
        this.visit(labelRecordsClause.getWords(), p);
        this.visit(labelRecordsClause.getDataNames(), p);
        this.afterSyntax(labelRecordsClause, p);
        return labelRecordsClause;
    }

    @Override
    public Cobol visitLibraryAttributeClauseFormat1(Cobol.LibraryAttributeClauseFormat1 libraryAttributeClauseFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryAttributeClauseFormat1, Space.Location.LIBRARY_ATTRIBUTE_CLAUSE_1_PREFIX, p);
        this.visit(libraryAttributeClauseFormat1.getWords(), p);
        this.afterSyntax(libraryAttributeClauseFormat1, p);
        return libraryAttributeClauseFormat1;
    }

    @Override
    public Cobol visitLibraryAttributeClauseFormat2(Cobol.LibraryAttributeClauseFormat2 libraryAttributeClauseFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryAttributeClauseFormat2, Space.Location.LIBRARY_ATTRIBUTE_CLAUSE_2_PREFIX, p);
        this.visit(libraryAttributeClauseFormat2.getAttribute(), p);
        this.visit(libraryAttributeClauseFormat2.getLibraryAttributeFunction(), p);
        this.visit(libraryAttributeClauseFormat2.getWords(), p);
        this.visit(libraryAttributeClauseFormat2.getLibraryAttributeParameter(), p);
        this.visit(libraryAttributeClauseFormat2.getLibraryAttributeTitle(), p);
        this.afterSyntax(libraryAttributeClauseFormat2, p);
        return libraryAttributeClauseFormat2;
    }

    @Override
    public Cobol visitLibraryAttributeFunction(Cobol.LibraryAttributeFunction libraryAttributeFunction, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryAttributeFunction, Space.Location.LIBRARY_ATTRIBUTE_FUNCTION_PREFIX, p);
        this.visit(libraryAttributeFunction.getWords(), p);
        this.visit(libraryAttributeFunction.getLiteral(), p);
        this.afterSyntax(libraryAttributeFunction, p);
        return libraryAttributeFunction;
    }

    @Override
    public Cobol visitLibraryAttributeParameter(Cobol.LibraryAttributeParameter libraryAttributeParameter, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryAttributeParameter, Space.Location.LIBRARY_ATTRIBUTE_PARAMETER_PREFIX, p);
        this.visit(libraryAttributeParameter.getWords(), p);
        this.visit(libraryAttributeParameter.getLiteral(), p);
        this.afterSyntax(libraryAttributeParameter, p);
        return libraryAttributeParameter;
    }

    @Override
    public Cobol visitLibraryAttributeTitle(Cobol.LibraryAttributeTitle libraryAttributeTitle, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryAttributeTitle, Space.Location.LIBRARY_ATTRIBUTE_TITLE_PREFIX, p);
        this.visit(libraryAttributeTitle.getWords(), p);
        this.visit(libraryAttributeTitle.getLiteral(), p);
        this.afterSyntax(libraryAttributeTitle, p);
        return libraryAttributeTitle;
    }

    @Override
    public Cobol visitLibraryDescriptionEntryFormat1(Cobol.LibraryDescriptionEntryFormat1 libraryDescriptionEntryFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryDescriptionEntryFormat1, Space.Location.LIBRARY_DESCRIPTION_ENTRY_FORMAT_1_PREFIX, p);
        this.visit(libraryDescriptionEntryFormat1.getLd(), p);
        this.visit(libraryDescriptionEntryFormat1.getLibraryName(), p);
        this.visit(libraryDescriptionEntryFormat1.getExport(), p);
        this.visit(libraryDescriptionEntryFormat1.getLibraryAttributeClauseFormat1(), p);
        this.visit(libraryDescriptionEntryFormat1.getLibraryEntryProcedureClauseFormat1(), p);
        this.afterSyntax(libraryDescriptionEntryFormat1, p);
        return libraryDescriptionEntryFormat1;
    }

    @Override
    public Cobol visitLibraryDescriptionEntryFormat2(Cobol.LibraryDescriptionEntryFormat2 libraryDescriptionEntryFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryDescriptionEntryFormat2, Space.Location.LIBRARY_DESCRIPTION_ENTRY_FORMAT_2_PREFIX, p);
        this.visit(libraryDescriptionEntryFormat2.getLb(), p);
        this.visit(libraryDescriptionEntryFormat2.getLibraryName(), p);
        this.visit(libraryDescriptionEntryFormat2.getExport(), p);
        this.visit(libraryDescriptionEntryFormat2.getLibraryIsGlobalClause(), p);
        this.visit(libraryDescriptionEntryFormat2.getLibraryIsCommonClause(), p);
        this.visit(libraryDescriptionEntryFormat2.getClauseFormats(), p);
        this.afterSyntax(libraryDescriptionEntryFormat2, p);
        return libraryDescriptionEntryFormat2;
    }

    @Override
    public Cobol visitLibraryEntryProcedureClauseFormat1(Cobol.LibraryEntryProcedureClauseFormat1 libraryEntryProcedureClauseFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureClauseFormat1, Space.Location.LIBRARY_ENTRY_PROCEDURE_CLAUSE_FORMAT_1_PREFIX, p);
        this.visit(libraryEntryProcedureClauseFormat1.getEntryProcedure(), p);
        this.visit(libraryEntryProcedureClauseFormat1.getProgramName(), p);
        this.visit(libraryEntryProcedureClauseFormat1.getLibraryEntryProcedureForClause(), p);
        this.afterSyntax(libraryEntryProcedureClauseFormat1, p);
        return libraryEntryProcedureClauseFormat1;
    }

    @Override
    public Cobol visitLibraryEntryProcedureClauseFormat2(Cobol.LibraryEntryProcedureClauseFormat2 libraryEntryProcedureClauseFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureClauseFormat2, Space.Location.LIBRARY_ENTRY_PROCEDURE_CLAUSE_FORMAT_2_PREFIX, p);
        this.visit(libraryEntryProcedureClauseFormat2.getEntryProcedure(), p);
        this.visit(libraryEntryProcedureClauseFormat2.getProgramName(), p);
        this.visit(libraryEntryProcedureClauseFormat2.getLibraryEntryProcedureForClause(), p);
        this.visit(libraryEntryProcedureClauseFormat2.getLibraryEntryProcedureWithClause(), p);
        this.visit(libraryEntryProcedureClauseFormat2.getLibraryEntryProcedureUsingClause(), p);
        this.visit(libraryEntryProcedureClauseFormat2.getLibraryEntryProcedureGivingClause(), p);
        this.afterSyntax(libraryEntryProcedureClauseFormat2, p);
        return libraryEntryProcedureClauseFormat2;
    }

    @Override
    public Cobol visitLibraryEntryProcedureForClause(Cobol.LibraryEntryProcedureForClause libraryEntryProcedureForClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureForClause, Space.Location.LIBRARY_ENTRY_PROCEDURE_FOR_CLAUSE_PREFIX, p);
        this.visit(libraryEntryProcedureForClause.getWord(), p);
        this.visit(libraryEntryProcedureForClause.getLiteral(), p);
        this.afterSyntax(libraryEntryProcedureForClause, p);
        return libraryEntryProcedureForClause;
    }

    @Override
    public Cobol visitLibraryEntryProcedureGivingClause(Cobol.LibraryEntryProcedureGivingClause libraryEntryProcedureGivingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureGivingClause, Space.Location.LIBRARY_ENTRY_PROCEDURE_GIVING_CLAUSE_PREFIX, p);
        this.visit(libraryEntryProcedureGivingClause.getGiving(), p);
        this.visit(libraryEntryProcedureGivingClause.getDataName(), p);
        this.afterSyntax(libraryEntryProcedureGivingClause, p);
        return libraryEntryProcedureGivingClause;
    }

    @Override
    public Cobol visitLibraryEntryProcedureUsingClause(Cobol.LibraryEntryProcedureUsingClause libraryEntryProcedureUsingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureUsingClause, Space.Location.LIBRARY_ENTRY_PROCEDURE_USING_CLAUSE_PREFIX, p);
        this.visit(libraryEntryProcedureUsingClause.getUsing(), p);
        this.visit(libraryEntryProcedureUsingClause.getNames(), p);
        this.afterSyntax(libraryEntryProcedureUsingClause, p);
        return libraryEntryProcedureUsingClause;
    }

    @Override
    public Cobol visitLibraryEntryProcedureWithClause(Cobol.LibraryEntryProcedureWithClause libraryEntryProcedureWithClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryEntryProcedureWithClause, Space.Location.LIBRARY_ENTRY_PROCEDURE_WITH_CLAUSE_PREFIX, p);
        this.visit(libraryEntryProcedureWithClause.getWith(), p);
        this.visit(libraryEntryProcedureWithClause.getNames(), p);
        this.afterSyntax(libraryEntryProcedureWithClause, p);
        return libraryEntryProcedureWithClause;
    }

    @Override
    public Cobol visitLibraryIsCommonClause(Cobol.LibraryIsCommonClause libraryIsCommonClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryIsCommonClause, Space.Location.LIBRARY_IS_COMMON_CLAUSE_PREFIX, p);
        this.visit(libraryIsCommonClause.getWords(), p);
        this.afterSyntax(libraryIsCommonClause, p);
        return libraryIsCommonClause;
    }

    @Override
    public Cobol visitLibraryIsGlobalClause(Cobol.LibraryIsGlobalClause libraryIsGlobalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(libraryIsGlobalClause, Space.Location.LIBRARY_IS_GLOBAL_CLAUSE_PREFIX, p);
        this.visit(libraryIsGlobalClause.getWords(), p);
        this.afterSyntax(libraryIsGlobalClause, p);
        return libraryIsGlobalClause;
    }

    @Override
    public Cobol visitLinageClause(Cobol.LinageClause linageClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(linageClause, Space.Location.LINAGE_CLAUSE_PREFIX, p);
        this.visit(linageClause.getWords(), p);
        this.visit(linageClause.getName(), p);
        this.visit(linageClause.getLine(), p);
        this.visit(linageClause.getLinageAt(), p);
        this.afterSyntax(linageClause, p);
        return linageClause;
    }

    @Override
    public Cobol visitLinageFootingAt(Cobol.LinageFootingAt linageFootingAt, PrintOutputCapture<P> p) {
        this.beforeSyntax(linageFootingAt, Space.Location.LINAGE_FOOTING_AT_PREFIX, p);
        this.visit(linageFootingAt.getWords(), p);
        this.visit(linageFootingAt.getName(), p);
        this.afterSyntax(linageFootingAt, p);
        return linageFootingAt;
    }

    @Override
    public Cobol visitLinageLinesAtBottom(Cobol.LinageLinesAtBottom linageLinesAtBottom, PrintOutputCapture<P> p) {
        this.beforeSyntax(linageLinesAtBottom, Space.Location.LINAGE_LINES_AT_BOTTOM_PREFIX, p);
        this.visit(linageLinesAtBottom.getWords(), p);
        this.visit(linageLinesAtBottom.getName(), p);
        this.afterSyntax(linageLinesAtBottom, p);
        return linageLinesAtBottom;
    }

    @Override
    public Cobol visitLinageLinesAtTop(Cobol.LinageLinesAtTop linageLinesAtTop, PrintOutputCapture<P> p) {
        this.beforeSyntax(linageLinesAtTop, Space.Location.LINAGE_LINES_AT_TOP_PREFIX, p);
        this.visit(linageLinesAtTop.getWords(), p);
        this.visit(linageLinesAtTop.getName(), p);
        this.afterSyntax(linageLinesAtTop, p);
        return linageLinesAtTop;
    }

    @Override
    public Cobol visitLinkageSection(Cobol.LinkageSection linkageSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(linkageSection, Space.Location.LINKAGE_SECTION_PREFIX, p);
        this.visit(linkageSection.getWords(), p);
        this.visit(linkageSection.getDot(), p);
        this.visit(linkageSection.getDataDescriptions(), p);
        this.afterSyntax(linkageSection, p);
        return linkageSection;
    }

    @Override
    public Cobol visitLocalStorageSection(Cobol.LocalStorageSection localStorageSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(localStorageSection, Space.Location.LOCAL_STORAGE_SECTION_PREFIX, p);
        this.visit(localStorageSection.getWords(), p);
        this.visit(localStorageSection.getDot(), p);
        this.visit(localStorageSection.getLocalName(), p);
        this.visit(localStorageSection.getLocalData(), p);
        this.visit(localStorageSection.getDataDescriptions(), p);
        this.afterSyntax(localStorageSection, p);
        return localStorageSection;
    }

    @Override
    public Cobol visitMerge(Cobol.Merge merge, PrintOutputCapture<P> p) {
        this.beforeSyntax(merge, Space.Location.MERGE_PREFIX, p);
        this.visit(merge.getWord(), p);
        this.visit(merge.getFileName(), p);
        this.visit(merge.getMergeOnKeyClause(), p);
        this.visit(merge.getMergeCollatingSequencePhrase(), p);
        this.visit(merge.getMergeUsing(), p);
        this.visit(merge.getMergeOutputProcedurePhrase(), p);
        this.visit(merge.getMergeGivingPhrase(), p);
        this.afterSyntax(merge, p);
        return merge;
    }

    @Override
    public Cobol visitMergeCollatingSequencePhrase(Cobol.MergeCollatingSequencePhrase mergeCollatingSequencePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeCollatingSequencePhrase, Space.Location.MERGE_COLLATING_SEQUENCE_PHRASE_PREFIX, p);
        this.visit(mergeCollatingSequencePhrase.getWords(), p);
        this.visit(mergeCollatingSequencePhrase.getName(), p);
        this.visit(mergeCollatingSequencePhrase.getMergeCollatingAlphanumeric(), p);
        this.visit(mergeCollatingSequencePhrase.getMergeCollatingNational(), p);
        this.afterSyntax(mergeCollatingSequencePhrase, p);
        return mergeCollatingSequencePhrase;
    }

    @Override
    public Cobol visitMergeGiving(Cobol.MergeGiving mergeGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeGiving, Space.Location.MERGE_GIVING_PREFIX, p);
        this.visit(mergeGiving.getName(), p);
        this.visit(mergeGiving.getWords(), p);
        this.afterSyntax(mergeGiving, p);
        return mergeGiving;
    }

    @Override
    public Cobol visitMergeGivingPhrase(Cobol.MergeGivingPhrase mergeGivingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeGivingPhrase, Space.Location.MERGE_GIVING_PHRASE_PREFIX, p);
        this.visit(mergeGivingPhrase.getWord(), p);
        this.visit(mergeGivingPhrase.getMergeGiving(), p);
        this.afterSyntax(mergeGivingPhrase, p);
        return mergeGivingPhrase;
    }

    @Override
    public Cobol visitMergeOnKeyClause(Cobol.MergeOnKeyClause mergeOnKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeOnKeyClause, Space.Location.MERGE_ON_KEY_CLAUSE_PREFIX, p);
        this.visit(mergeOnKeyClause.getWords(), p);
        this.visit(mergeOnKeyClause.getQualifiedDataName(), p);
        this.afterSyntax(mergeOnKeyClause, p);
        return mergeOnKeyClause;
    }

    @Override
    public Cobol visitMergeOutputProcedurePhrase(Cobol.MergeOutputProcedurePhrase mergeOutputProcedurePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeOutputProcedurePhrase, Space.Location.MERGE_OUTPUT_PROCEDURE_PHRASE_PREFIX, p);
        this.visit(mergeOutputProcedurePhrase.getWords(), p);
        this.visit(mergeOutputProcedurePhrase.getProcedureName(), p);
        this.visit(mergeOutputProcedurePhrase.getMergeOutputThrough(), p);
        this.afterSyntax(mergeOutputProcedurePhrase, p);
        return mergeOutputProcedurePhrase;
    }

    @Override
    public Cobol visitMergeOutputThrough(Cobol.MergeOutputThrough mergeOutputThrough, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeOutputThrough, Space.Location.MERGE_OUTPUT_THROUGH_PREFIX, p);
        this.visit(mergeOutputThrough.getWord(), p);
        this.afterSyntax(mergeOutputThrough, p);
        return mergeOutputThrough;
    }

    @Override
    public Cobol visitMergeUsing(Cobol.MergeUsing mergeUsing, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeUsing, Space.Location.MERGE_USING_PREFIX, p);
        this.visit(mergeUsing.getWord(), p);
        this.visit(mergeUsing.getFileNames(), p);
        this.afterSyntax(mergeUsing, p);
        return mergeUsing;
    }

    @Override
    public Cobol visitMergeable(Cobol.Mergeable mergeable, PrintOutputCapture<P> p) {
        this.beforeSyntax(mergeable, Space.Location.MERGEABLE_PREFIX, p);
        this.visit(mergeable.getWords(), p);
        this.visit(mergeable.getName(), p);
        this.afterSyntax(mergeable, p);
        return mergeable;
    }

    @Override
    public Cobol visitMessageCountClause(Cobol.MessageCountClause messageCountClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(messageCountClause, Space.Location.MESSAGE_COUNT_CLAUSE_PREFIX, p);
        this.visit(messageCountClause.getWords(), p);
        this.visit(messageCountClause.getDataDescName(), p);
        this.afterSyntax(messageCountClause, p);
        return messageCountClause;
    }

    @Override
    public Cobol visitMessageDateClause(Cobol.MessageDateClause messageDateClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(messageDateClause, Space.Location.MESSAGE_DATA_CLAUSE_PREFIX, p);
        this.visit(messageDateClause.getWords(), p);
        this.visit(messageDateClause.getDataDescName(), p);
        this.afterSyntax(messageDateClause, p);
        return messageDateClause;
    }

    @Override
    public Cobol visitMessageTimeClause(Cobol.MessageTimeClause messageTimeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(messageTimeClause, Space.Location.MESSAGE_TIME_CLAUSE_PREFIX, p);
        this.visit(messageTimeClause.getWords(), p);
        this.visit(messageTimeClause.getDataDescName(), p);
        this.afterSyntax(messageTimeClause, p);
        return messageTimeClause;
    }

    @Override
    public Cobol visitMoveCorrespondingToStatement(Cobol.MoveCorrespondingToStatement moveCorrespondingToStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(moveCorrespondingToStatement, Space.Location.MOVE_CORRESPONDING_TO_STATEMENT_PREFIX, p);
        this.visit(moveCorrespondingToStatement.getWord(), p);
        this.visit(moveCorrespondingToStatement.getMoveCorrespondingToSendingArea(), p);
        this.visit(moveCorrespondingToStatement.getTo(), p);
        this.visit(moveCorrespondingToStatement.getIdentifiers(), p);
        this.afterSyntax(moveCorrespondingToStatement, p);
        return moveCorrespondingToStatement;
    }

    @Override
    public Cobol visitMoveStatement(Cobol.MoveStatement moveStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(moveStatement, Space.Location.MOVE_STATEMENT_PREFIX, p);
        this.visit(moveStatement.getWords(), p);
        this.visit(moveStatement.getMoveToStatement(), p);
        this.afterSyntax(moveStatement, p);
        return moveStatement;
    }

    @Override
    public Cobol visitMoveToStatement(Cobol.MoveToStatement moveToStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(moveToStatement, Space.Location.MOVE_TO_STATEMENT_PREFIX, p);
        this.visit(moveToStatement.getFrom(), p);
        this.visit(moveToStatement.getTo(), p);
        this.visit(moveToStatement.getNames(), p);
        this.afterSyntax(moveToStatement, p);
        return moveToStatement;
    }

    @Override
    public Cobol visitMultDiv(Cobol.MultDiv multDiv, PrintOutputCapture<P> p) {
        this.beforeSyntax(multDiv, Space.Location.MULT_DIV_PREFIX, p);
        this.visit(multDiv.getWord(), p);
        this.visit(multDiv.getPowers(), p);
        this.afterSyntax(multDiv, p);
        return multDiv;
    }

    @Override
    public Cobol visitMultDivs(Cobol.MultDivs multDivs, PrintOutputCapture<P> p) {
        this.beforeSyntax(multDivs, Space.Location.MULT_DIVS_PREFIX, p);
        this.visit(multDivs.getPowers(), p);
        this.visit(multDivs.getMultDivs(), p);
        this.afterSyntax(multDivs, p);
        return multDivs;
    }

    @Override
    public Cobol visitMultipleFileClause(Cobol.MultipleFileClause multipleFileClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(multipleFileClause, Space.Location.MULTIPLE_FILE_CLAUSE_PREFIX, p);
        this.visit(multipleFileClause.getWords(), p);
        this.visit(multipleFileClause.getFilePositions(), p);
        this.afterSyntax(multipleFileClause, p);
        return multipleFileClause;
    }

    @Override
    public Cobol visitMultipleFilePosition(Cobol.MultipleFilePosition multipleFilePosition, PrintOutputCapture<P> p) {
        this.beforeSyntax(multipleFilePosition, Space.Location.MULTIPLE_FILE_POSITION_PREFIX, p);
        this.visit(multipleFilePosition.getFileName(), p);
        this.visit(multipleFilePosition.getPosition(), p);
        this.visit(multipleFilePosition.getIntegerLiteral(), p);
        this.afterSyntax(multipleFilePosition, p);
        return multipleFilePosition;
    }

    @Override
    public Cobol visitMultiply(Cobol.Multiply multiply, PrintOutputCapture<P> p) {
        this.beforeSyntax(multiply, Space.Location.MULTIPLY_PREFIX, p);
        this.visit(multiply.getWord(), p);
        this.visit(multiply.getMultiplicand(), p);
        this.visit(multiply.getBy(), p);
        this.visit(multiply.getMultiply(), p);
        this.visit(multiply.getOnSizeErrorPhrase(), p);
        this.visit(multiply.getNotOnSizeErrorPhrase(), p);
        this.visit(multiply.getEndMultiply(), p);
        this.afterSyntax(multiply, p);
        return multiply;
    }

    @Override
    public Cobol visitMultiplyGiving(Cobol.MultiplyGiving multiplyGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(multiplyGiving, Space.Location.MULTIPLY_GIVING_PREFIX, p);
        this.visit(multiplyGiving.getOperand(), p);
        this.visit(multiplyGiving.getGiving(), p);
        this.visit(multiplyGiving.getResult(), p);
        this.afterSyntax(multiplyGiving, p);
        return multiplyGiving;
    }

    @Override
    public Cobol visitMultiplyRegular(Cobol.MultiplyRegular multiplyRegular, PrintOutputCapture<P> p) {
        this.beforeSyntax(multiplyRegular, Space.Location.MULTIPLY_REGULAR_PREFIX, p);
        this.visit(multiplyRegular.getOperand(), p);
        this.afterSyntax(multiplyRegular, p);
        return multiplyRegular;
    }

    @Override
    public Cobol visitNextSentence(Cobol.NextSentence nextSentence, PrintOutputCapture<P> p) {
        this.beforeSyntax(nextSentence, Space.Location.NEXT_SENTENCE_PREFIX, p);
        this.visit(nextSentence.getWords(), p);
        this.afterSyntax(nextSentence, p);
        return nextSentence;
    }

    @Override
    public Cobol visitObjectComputer(Cobol.ObjectComputer objectComputer, PrintOutputCapture<P> p) {
        this.beforeSyntax(objectComputer, Space.Location.OBJECT_COMPUTER_PREFIX, p);
        this.visit(objectComputer.getWords(), p);
        this.visit(objectComputer.getComputer(), p);
        this.afterSyntax(objectComputer, p);
        return objectComputer;
    }

    @Override
    public Cobol visitObjectComputerDefinition(Cobol.ObjectComputerDefinition objectComputerDefinition, PrintOutputCapture<P> p) {
        this.beforeSyntax(objectComputerDefinition, Space.Location.OBJECT_COMPUTER_DEFINITION_PREFIX, p);
        this.visit(objectComputerDefinition.getComputerName(), p);
        this.visit(objectComputerDefinition.getSpecifications(), p);
        this.visit(objectComputerDefinition.getDot(), p);
        this.afterSyntax(objectComputerDefinition, p);
        return objectComputerDefinition;
    }

    @Override
    public Cobol visitOdtClause(Cobol.OdtClause odtClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(odtClause, Space.Location.ODT_CLAUSE_PREFIX, p);
        this.visit(odtClause.getWords(), p);
        this.visit(odtClause.getMnemonicName(), p);
        this.afterSyntax(odtClause, p);
        return odtClause;
    }

    @Override
    public Cobol visitOpen(Cobol.Open open, PrintOutputCapture<P> p) {
        this.beforeSyntax(open, Space.Location.OPEN_PREFIX, p);
        this.visit(open.getWord(), p);
        this.visit(open.getOpen(), p);
        this.afterSyntax(open, p);
        return open;
    }

    @Override
    public Cobol visitOpenIOExtendStatement(Cobol.OpenIOExtendStatement openIOExtendStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(openIOExtendStatement, Space.Location.OPEN_IO_EXTEND_STATEMENT_PREFIX, p);
        this.visit(openIOExtendStatement.getWord(), p);
        this.visit(openIOExtendStatement.getFileNames(), p);
        this.afterSyntax(openIOExtendStatement, p);
        return openIOExtendStatement;
    }

    @Override
    public Cobol visitOpenInputOutputStatement(Cobol.OpenInputOutputStatement openInputOutputStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(openInputOutputStatement, Space.Location.OPEN_INPUT_OUTPUT_STATEMENT_PREFIX, p);
        this.visit(openInputOutputStatement.getWord(), p);
        this.visit(openInputOutputStatement.getOpenInput(), p);
        this.afterSyntax(openInputOutputStatement, p);
        return openInputOutputStatement;
    }

    @Override
    public Cobol visitOpenable(Cobol.Openable openable, PrintOutputCapture<P> p) {
        this.beforeSyntax(openable, Space.Location.OPENABLE_PREFIX, p);
        this.visit(openable.getFileName(), p);
        this.visit(openable.getWords(), p);
        this.afterSyntax(openable, p);
        return openable;
    }

    @Override
    public Cobol visitOrganizationClause(Cobol.OrganizationClause organizationClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(organizationClause, Space.Location.ORGANIZATION_CLAUSE_PREFIX, p);
        this.visit(organizationClause.getWords(), p);
        this.afterSyntax(organizationClause, p);
        return organizationClause;
    }

    @Override
    public Cobol visitPaddingCharacterClause(Cobol.PaddingCharacterClause paddingCharacterClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(paddingCharacterClause, Space.Location.PADDING_CHARACTER_CLAUSE_PREFIX, p);
        this.visit(paddingCharacterClause.getWords(), p);
        this.visit(paddingCharacterClause.getName(), p);
        this.afterSyntax(paddingCharacterClause, p);
        return paddingCharacterClause;
    }

    @Override
    public Cobol visitParagraph(Cobol.Paragraph paragraph, PrintOutputCapture<P> p) {
        this.beforeSyntax(paragraph, Space.Location.PARAGRAPH_PREFIX, p);
        this.visit(paragraph.getParagraphName(), p);
        this.visit(paragraph.getDot(), p);
        this.visit(paragraph.getAlteredGoTo(), p);
        this.visit(paragraph.getSentences(), p);
        this.afterSyntax(paragraph, p);
        return paragraph;
    }

    @Override
    public Cobol visitParagraphs(Cobol.Paragraphs paragraphs, PrintOutputCapture<P> p) {
        this.beforeSyntax(paragraphs, Space.Location.PARAGRAPHS_PREFIX, p);
        this.visit(paragraphs.getSentences(), p);
        this.visit(paragraphs.getParagraphs(), p);
        this.afterSyntax(paragraphs, p);
        return paragraphs;
    }

    @Override
    public Cobol visitParenthesized(Cobol.Parenthesized parenthesized, PrintOutputCapture<P> p) {
        this.beforeSyntax(parenthesized, Space.Location.PARENTHESIZED_PREFIX, p);
        this.visit(parenthesized.getLeftParen(), p);
        this.visit(parenthesized.getContents(), p);
        this.visit(parenthesized.getRightParen(), p);
        this.afterSyntax(parenthesized, p);
        return parenthesized;
    }

    @Override
    public Cobol visitPasswordClause(Cobol.PasswordClause passwordClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(passwordClause, Space.Location.PASSWORD_CLAUSE_PREFIX, p);
        this.visit(passwordClause.getWords(), p);
        this.visit(passwordClause.getDataName(), p);
        this.afterSyntax(passwordClause, p);
        return passwordClause;
    }

    @Override
    public Cobol visitPerform(Cobol.Perform perform, PrintOutputCapture<P> p) {
        this.beforeSyntax(perform, Space.Location.PERFORM_PREFIX, p);
        this.visit(perform.getWord(), p);
        this.visit(perform.getStatement(), p);
        this.afterSyntax(perform, p);
        return perform;
    }

    @Override
    public Cobol visitPerformInlineStatement(Cobol.PerformInlineStatement performInlineStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(performInlineStatement, Space.Location.PERFORM_IN_LINE_STATEMENT_PREFIX, p);
        this.visit(performInlineStatement.getPerformType(), p);
        this.visit(performInlineStatement.getStatements(), p);
        this.visit(performInlineStatement.getWord(), p);
        this.afterSyntax(performInlineStatement, p);
        return performInlineStatement;
    }

    @Override
    public Cobol visitPerformProcedureStatement(Cobol.PerformProcedureStatement performProcedureStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(performProcedureStatement, Space.Location.PERFORM_PROCEDURE_STATEMENT_PREFIX, p);
        this.visit(performProcedureStatement.getProcedureName(), p);
        this.visit(performProcedureStatement.getWord(), p);
        this.visit(performProcedureStatement.getThroughProcedure(), p);
        this.visit(performProcedureStatement.getPerformType(), p);
        this.afterSyntax(performProcedureStatement, p);
        return performProcedureStatement;
    }

    @Override
    public Cobol visitPerformTestClause(Cobol.PerformTestClause performTestClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(performTestClause, Space.Location.PERFORM_TEST_CLAUSE_PREFIX, p);
        this.visit(performTestClause.getWords(), p);
        this.afterSyntax(performTestClause, p);
        return performTestClause;
    }

    @Override
    public Cobol visitPerformTimes(Cobol.PerformTimes performTimes, PrintOutputCapture<P> p) {
        this.beforeSyntax(performTimes, Space.Location.PERFORM_TIMES_PREFIX, p);
        this.visit(performTimes.getValue(), p);
        this.visit(performTimes.getWord(), p);
        this.afterSyntax(performTimes, p);
        return performTimes;
    }

    @Override
    public Cobol visitPerformUntil(Cobol.PerformUntil performUntil, PrintOutputCapture<P> p) {
        this.beforeSyntax(performUntil, Space.Location.PERFORM_UNTIL_PREFIX, p);
        this.visit(performUntil.getPerformTestClause(), p);
        this.visit(performUntil.getWord(), p);
        this.visit(performUntil.getCondition(), p);
        this.afterSyntax(performUntil, p);
        return performUntil;
    }

    @Override
    public Cobol visitPerformVarying(Cobol.PerformVarying performVarying, PrintOutputCapture<P> p) {
        this.beforeSyntax(performVarying, Space.Location.PERFORM_VARYING_PREFIX, p);
        this.visit(performVarying.getCobols(), p);
        this.afterSyntax(performVarying, p);
        return performVarying;
    }

    @Override
    public Cobol visitPerformVaryingClause(Cobol.PerformVaryingClause performVaryingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(performVaryingClause, Space.Location.PERFORM_VARYING_CLAUSE_PREFIX, p);
        this.visit(performVaryingClause.getWord(), p);
        this.visit(performVaryingClause.getPerformVaryingPhrase(), p);
        this.visit(performVaryingClause.getPerformAfter(), p);
        this.afterSyntax(performVaryingClause, p);
        return performVaryingClause;
    }

    @Override
    public Cobol visitPerformVaryingPhrase(Cobol.PerformVaryingPhrase performVaryingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(performVaryingPhrase, Space.Location.PERFORM_VARYING_PHRASE_PREFIX, p);
        this.visit(performVaryingPhrase.getName(), p);
        this.visit(performVaryingPhrase.getFrom(), p);
        this.visit(performVaryingPhrase.getBy(), p);
        this.visit(performVaryingPhrase.getUntil(), p);
        this.afterSyntax(performVaryingPhrase, p);
        return performVaryingPhrase;
    }

    @Override
    public Cobol visitPerformable(Cobol.Performable performable, PrintOutputCapture<P> p) {
        this.beforeSyntax(performable, Space.Location.PERFORMABLE_PREFIX, p);
        this.visit(performable.getWord(), p);
        this.visit(performable.getExpression(), p);
        this.afterSyntax(performable, p);
        return performable;
    }

    @Override
    public Cobol visitPicture(Cobol.Picture picture, PrintOutputCapture<P> p) {
        this.beforeSyntax(picture, Space.Location.PICTURE_PREFIX, p);
        this.visit(picture.getWords(), p);
        this.visit(picture.getParenthesized(), p);
        this.afterSyntax(picture, p);
        return picture;
    }

    @Override
    public Cobol visitPictureString(Cobol.PictureString pictureString, PrintOutputCapture<P> p) {
        this.beforeSyntax(pictureString, Space.Location.PICTURE_STRING_PREFIX, p);
        this.visit(pictureString.getPictures(), p);
        this.afterSyntax(pictureString, p);
        return pictureString;
    }

    @Override
    public Cobol visitPlusMinus(Cobol.PlusMinus plusMinus, PrintOutputCapture<P> p) {
        this.beforeSyntax(plusMinus, Space.Location.PLUS_MINUS_PREFIX, p);
        this.visit(plusMinus.getWord(), p);
        this.visit(plusMinus.getMultDivs(), p);
        this.afterSyntax(plusMinus, p);
        return plusMinus;
    }

    @Override
    public Cobol visitPower(Cobol.Power power, PrintOutputCapture<P> p) {
        this.beforeSyntax(power, Space.Location.POWER_PREFIX, p);
        this.visit(power.getPower(), p);
        this.visit(power.getExpression(), p);
        this.afterSyntax(power, p);
        return power;
    }

    @Override
    public Cobol visitPowers(Cobol.Powers powers, PrintOutputCapture<P> p) {
        this.beforeSyntax(powers, Space.Location.POWERS_PREFIX, p);
        this.visit(powers.getPlusMinusChar(), p);
        this.visit(powers.getExpression(), p);
        this.visit(powers.getPowers(), p);
        this.afterSyntax(powers, p);
        return powers;
    }

    @Override
    public Cobol visitProcedureDeclarative(Cobol.ProcedureDeclarative procedureDeclarative, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDeclarative, Space.Location.PROCEDURE_DECLARATIVE_PREFIX, p);
        this.visit(procedureDeclarative.getProcedureSectionHeader(), p);
        this.visit(procedureDeclarative.getDot(), p);
        this.visit(procedureDeclarative.getUseStatement(), p);
        this.visit(procedureDeclarative.getDot2(), p);
        this.visit(procedureDeclarative.getParagraphs(), p);
        this.afterSyntax(procedureDeclarative, p);
        return procedureDeclarative;
    }

    @Override
    public Cobol visitProcedureDeclaratives(Cobol.ProcedureDeclaratives procedureDeclaratives, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDeclaratives, Space.Location.PROCEDURE_DECLARATIVES_PREFIX, p);
        this.visit(procedureDeclaratives.getDeclaratives(), p);
        this.visit(procedureDeclaratives.getDot(), p);
        this.visit(procedureDeclaratives.getProcedureDeclarative(), p);
        this.visit(procedureDeclaratives.getEndDeclaratives(), p);
        this.visit(procedureDeclaratives.getDot2(), p);
        this.afterSyntax(procedureDeclaratives, p);
        return procedureDeclaratives;
    }

    @Override
    public Cobol visitProcedureDivision(Cobol.ProcedureDivision procedureDivision, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivision, Space.Location.PROCEDURE_DIVISION_PREFIX, p);
        this.visit(procedureDivision.getWords(), p);
        this.visit(procedureDivision.getProcedureDivisionUsingClause(), p);
        this.visit(procedureDivision.getProcedureDivisionGivingClause(), p);
        this.visit(procedureDivision.getDot(), p);
        this.visit(procedureDivision.getProcedureDeclaratives(), p);
        this.visit(procedureDivision.getBody(), p);
        this.afterSyntax(procedureDivision, p);
        return procedureDivision;
    }

    @Override
    public Cobol visitProcedureDivisionBody(Cobol.ProcedureDivisionBody procedureDivisionBody, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionBody, Space.Location.PROCEDURE_DIVISION_BODY_PREFIX, p);
        this.visit(procedureDivisionBody.getParagraphs(), p);
        this.visit(procedureDivisionBody.getProcedureSection(), p);
        this.afterSyntax(procedureDivisionBody, p);
        return procedureDivisionBody;
    }

    @Override
    public Cobol visitProcedureDivisionByReference(Cobol.ProcedureDivisionByReference procedureDivisionByReference, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionByReference, Space.Location.PROCEDURE_DIVISION_BY_REFERENCE_PREFIX, p);
        this.visit(procedureDivisionByReference.getWord(), p);
        this.visit(procedureDivisionByReference.getReference(), p);
        this.afterSyntax(procedureDivisionByReference, p);
        return procedureDivisionByReference;
    }

    @Override
    public Cobol visitProcedureDivisionByReferencePhrase(Cobol.ProcedureDivisionByReferencePhrase procedureDivisionByReferencePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionByReferencePhrase, Space.Location.PROCEDURE_DIVISION_BY_REFERENCE_PHRASE_PREFIX, p);
        this.visit(procedureDivisionByReferencePhrase.getWords(), p);
        this.visit(procedureDivisionByReferencePhrase.getProcedureDivisionByReference(), p);
        this.afterSyntax(procedureDivisionByReferencePhrase, p);
        return procedureDivisionByReferencePhrase;
    }

    @Override
    public Cobol visitProcedureDivisionByValuePhrase(Cobol.ProcedureDivisionByValuePhrase procedureDivisionByValuePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionByValuePhrase, Space.Location.PROCEDURE_DIVISION_BY_VALUE_PHRASE_PREFIX, p);
        this.visit(procedureDivisionByValuePhrase.getWords(), p);
        this.visit(procedureDivisionByValuePhrase.getPhrases(), p);
        this.afterSyntax(procedureDivisionByValuePhrase, p);
        return procedureDivisionByValuePhrase;
    }

    @Override
    public Cobol visitProcedureDivisionGivingClause(Cobol.ProcedureDivisionGivingClause procedureDivisionGivingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionGivingClause, Space.Location.PROCEDURE_DIVISION_GIVING_CLAUSE_PREFIX, p);
        this.visit(procedureDivisionGivingClause.getWord(), p);
        this.visit(procedureDivisionGivingClause.getDataName(), p);
        this.afterSyntax(procedureDivisionGivingClause, p);
        return procedureDivisionGivingClause;
    }

    @Override
    public Cobol visitProcedureDivisionUsingClause(Cobol.ProcedureDivisionUsingClause procedureDivisionUsingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureDivisionUsingClause, Space.Location.PROCEDURE_DIVISION_USING_CLAUSE_PREFIX, p);
        this.visit(procedureDivisionUsingClause.getWord(), p);
        this.visit(procedureDivisionUsingClause.getProcedureDivisionUsingParameter(), p);
        this.afterSyntax(procedureDivisionUsingClause, p);
        return procedureDivisionUsingClause;
    }

    @Override
    public Cobol visitProcedureName(Cobol.ProcedureName procedureName, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureName, Space.Location.PROCEDURE_NAME_PREFIX, p);
        this.visit(procedureName.getParagraphName(), p);
        this.visit(procedureName.getInSection(), p);
        this.visit(procedureName.getSectionName(), p);
        this.afterSyntax(procedureName, p);
        return procedureName;
    }

    @Override
    public Cobol visitProcedureSection(Cobol.ProcedureSection procedureSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureSection, Space.Location.PROCEDURE_SECTION_PREFIX, p);
        this.visit(procedureSection.getProcedureSectionHeader(), p);
        this.visit(procedureSection.getDot(), p);
        this.visit(procedureSection.getParagraphs(), p);
        this.afterSyntax(procedureSection, p);
        return procedureSection;
    }

    @Override
    public Cobol visitProcedureSectionHeader(Cobol.ProcedureSectionHeader procedureSectionHeader, PrintOutputCapture<P> p) {
        this.beforeSyntax(procedureSectionHeader, Space.Location.PROCEDURE_SECTION_HEADER_PREFIX, p);
        this.visit(procedureSectionHeader.getSectionName(), p);
        this.visit(procedureSectionHeader.getSection(), p);
        this.visit(procedureSectionHeader.getIdentifier(), p);
        this.afterSyntax(procedureSectionHeader, p);
        return procedureSectionHeader;
    }

    @Override
    public Cobol visitProgramIdParagraph(Cobol.ProgramIdParagraph programIdParagraph, PrintOutputCapture<P> p) {
        this.beforeSyntax(programIdParagraph, Space.Location.PROGRAM_ID_PARAGRAPH_PREFIX, p);
        this.visit(programIdParagraph.getProgramId(), p);
        this.visit(programIdParagraph.getDot(), p);
        this.visit(programIdParagraph.getProgramName(), p);
        this.visit(programIdParagraph.getProgramAttributes(), p);
        this.visit(programIdParagraph.getDot2(), p);
        this.visit(programIdParagraph.getCommentEntry(), p);
        this.afterSyntax(programIdParagraph, p);
        return programIdParagraph;
    }

    @Override
    public Cobol visitProgramLibrarySection(Cobol.ProgramLibrarySection programLibrarySection, PrintOutputCapture<P> p) {
        this.beforeSyntax(programLibrarySection, Space.Location.PROGRAM_LIBRARY_SECTION_PREFIX, p);
        this.visit(programLibrarySection.getWords(), p);
        this.visit(programLibrarySection.getLibraryDescriptionEntries(), p);
        this.afterSyntax(programLibrarySection, p);
        return programLibrarySection;
    }

    @Override
    public Cobol visitProgramUnit(Cobol.ProgramUnit programUnit, PrintOutputCapture<P> p) {
        this.beforeSyntax(programUnit, Space.Location.PROGRAM_UNIT_PREFIX, p);
        this.getCobolPreprocessorVisitor().visit(programUnit.getCompilerOptions(), p);
        this.visit(programUnit.getIdentificationDivision(), p);
        this.visit(programUnit.getEnvironmentDivision(), p);
        this.visit(programUnit.getDataDivision(), p);
        this.visit(programUnit.getProcedureDivision(), p);
        this.visit(programUnit.getProgramUnits(), p);
        this.visit(programUnit.getEndProgram(), p);
        this.afterSyntax(programUnit, p);
        return programUnit;
    }

    @Override
    public Cobol visitPurge(Cobol.Purge purge, PrintOutputCapture<P> p) {
        this.beforeSyntax(purge, Space.Location.PURGE_PREFIX, p);
        this.visit(purge.getPurge(), p);
        this.visit(purge.getNames(), p);
        this.afterSyntax(purge, p);
        return purge;
    }

    @Override
    public Cobol visitQualifiedDataName(Cobol.QualifiedDataName qualifiedDataName, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedDataName, Space.Location.QUALIFIED_DATA_NAME_PREFIX, p);
        this.visit(qualifiedDataName.getDataName(), p);
        this.afterSyntax(qualifiedDataName, p);
        return qualifiedDataName;
    }

    @Override
    public Cobol visitQualifiedDataNameFormat1(Cobol.QualifiedDataNameFormat1 qualifiedDataNameFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedDataNameFormat1, Space.Location.QUALIFIED_DATA_NAME_FORMAT_1_PREFIX, p);
        this.visit(qualifiedDataNameFormat1.getName(), p);
        this.visit(qualifiedDataNameFormat1.getQualifiedInData(), p);
        this.visit(qualifiedDataNameFormat1.getInFile(), p);
        this.afterSyntax(qualifiedDataNameFormat1, p);
        return qualifiedDataNameFormat1;
    }

    @Override
    public Cobol visitQualifiedDataNameFormat2(Cobol.QualifiedDataNameFormat2 qualifiedDataNameFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedDataNameFormat2, Space.Location.QUALIFIED_DATA_NAME_FORMAT_2_PREFIX, p);
        this.visit(qualifiedDataNameFormat2.getParagraphName(), p);
        this.visit(qualifiedDataNameFormat2.getInSection(), p);
        this.afterSyntax(qualifiedDataNameFormat2, p);
        return qualifiedDataNameFormat2;
    }

    @Override
    public Cobol visitQualifiedDataNameFormat3(Cobol.QualifiedDataNameFormat3 qualifiedDataNameFormat3, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedDataNameFormat3, Space.Location.QUALIFIED_DATA_NAME_FORMAT_3_PREFIX, p);
        this.visit(qualifiedDataNameFormat3.getTextName(), p);
        this.visit(qualifiedDataNameFormat3.getInLibrary(), p);
        this.afterSyntax(qualifiedDataNameFormat3, p);
        return qualifiedDataNameFormat3;
    }

    @Override
    public Cobol visitQualifiedDataNameFormat4(Cobol.QualifiedDataNameFormat4 qualifiedDataNameFormat4, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedDataNameFormat4, Space.Location.QUALIFIED_DATA_NAME_FORMAT_4_PREFIX, p);
        this.visit(qualifiedDataNameFormat4.getLinageCounter(), p);
        this.visit(qualifiedDataNameFormat4.getInFile(), p);
        this.afterSyntax(qualifiedDataNameFormat4, p);
        return qualifiedDataNameFormat4;
    }

    @Override
    public Cobol visitQualifiedInData(Cobol.QualifiedInData qualifiedInData, PrintOutputCapture<P> p) {
        this.beforeSyntax(qualifiedInData, Space.Location.QUALIFIED_IN_DATA_PREFIX, p);
        this.visit(qualifiedInData.getIn(), p);
        this.afterSyntax(qualifiedInData, p);
        return qualifiedInData;
    }

    @Override
    public Cobol visitRead(Cobol.Read read, PrintOutputCapture<P> p) {
        this.beforeSyntax(read, Space.Location.READ_PREFIX, p);
        this.visit(read.getWord(), p);
        this.visit(read.getFileName(), p);
        this.visit(read.getNextRecord(), p);
        this.visit(read.getReadInto(), p);
        this.visit(read.getReadWith(), p);
        this.visit(read.getReadKey(), p);
        this.visit(read.getInvalidKeyPhrase(), p);
        this.visit(read.getNotInvalidKeyPhrase(), p);
        this.visit(read.getAtEndPhrase(), p);
        this.visit(read.getNotAtEndPhrase(), p);
        this.visit(read.getEndRead(), p);
        this.afterSyntax(read, p);
        return read;
    }

    @Override
    public Cobol visitReadInto(Cobol.ReadInto readInto, PrintOutputCapture<P> p) {
        this.beforeSyntax(readInto, Space.Location.READ_INTO_PREFIX, p);
        this.visit(readInto.getWord(), p);
        this.visit(readInto.getIdentifier(), p);
        this.afterSyntax(readInto, p);
        return readInto;
    }

    @Override
    public Cobol visitReadKey(Cobol.ReadKey readKey, PrintOutputCapture<P> p) {
        this.beforeSyntax(readKey, Space.Location.READ_KEY_PREFIX, p);
        this.visit(readKey.getWords(), p);
        this.visit(readKey.getQualifiedDataName(), p);
        this.afterSyntax(readKey, p);
        return readKey;
    }

    @Override
    public Cobol visitReadWith(Cobol.ReadWith readWith, PrintOutputCapture<P> p) {
        this.beforeSyntax(readWith, Space.Location.READ_WITH_PREFIX, p);
        this.visit(readWith.getWords(), p);
        this.afterSyntax(readWith, p);
        return readWith;
    }

    @Override
    public Cobol visitReceivable(Cobol.Receivable receivable, PrintOutputCapture<P> p) {
        this.beforeSyntax(receivable, Space.Location.RECEIVABLE_PREFIX, p);
        this.visit(receivable.getWords(), p);
        this.visit(receivable.getValue(), p);
        this.afterSyntax(receivable, p);
        return receivable;
    }

    @Override
    public Cobol visitReceiveWith(Cobol.ReceiveWith receiveWith, PrintOutputCapture<P> p) {
        this.beforeSyntax(receiveWith, Space.Location.RECEIVE_WITH_PREFIX, p);
        this.visit(receiveWith.getWords(), p);
        this.afterSyntax(receiveWith, p);
        return receiveWith;
    }

    @Override
    public Cobol visitReceive(Cobol.Receive receive, PrintOutputCapture<P> p) {
        this.beforeSyntax(receive, Space.Location.RECEIVE_PREFIX, p);
        this.visit(receive.getReceive(), p);
        this.visit(receive.getFromOrInto(), p);
        this.visit(receive.getOnExceptionClause(), p);
        this.visit(receive.getNotOnExceptionClause(), p);
        this.visit(receive.getEndReceive(), p);
        this.afterSyntax(receive, p);
        return receive;
    }

    @Override
    public Cobol visitReceiveFrom(Cobol.ReceiveFrom receiveFrom, PrintOutputCapture<P> p) {
        this.beforeSyntax(receiveFrom, Space.Location.RECEIVE_FROM_PREFIX, p);
        this.visit(receiveFrom.getWords(), p);
        this.visit(receiveFrom.getDataName(), p);
        this.afterSyntax(receiveFrom, p);
        return receiveFrom;
    }

    @Override
    public Cobol visitReceiveFromStatement(Cobol.ReceiveFromStatement receiveFromStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(receiveFromStatement, Space.Location.RECEIVE_FROM_STATEMENT_PREFIX, p);
        this.visit(receiveFromStatement.getDataName(), p);
        this.visit(receiveFromStatement.getFrom(), p);
        this.visit(receiveFromStatement.getReceiveFrom(), p);
        this.visit(receiveFromStatement.getBeforeWithThreadSizeStatus(), p);
        this.afterSyntax(receiveFromStatement, p);
        return receiveFromStatement;
    }

    @Override
    public Cobol visitReceiveIntoStatement(Cobol.ReceiveIntoStatement receiveIntoStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(receiveIntoStatement, Space.Location.RECEIVE_INTO_STATEMENT_PREFIX, p);
        this.visit(receiveIntoStatement.getCdName(), p);
        this.visit(receiveIntoStatement.getWords(), p);
        this.visit(receiveIntoStatement.getIdentifier(), p);
        this.visit(receiveIntoStatement.getReceiveNoData(), p);
        this.visit(receiveIntoStatement.getReceiveWithData(), p);
        this.afterSyntax(receiveIntoStatement, p);
        return receiveIntoStatement;
    }

    @Override
    public Cobol visitRecordContainsClause(Cobol.RecordContainsClause recordContainsClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordContainsClause, Space.Location.RECORD_CONTAINS_CLAUSE_PREFIX, p);
        this.visit(recordContainsClause.getRecord(), p);
        this.visit(recordContainsClause.getClause(), p);
        this.afterSyntax(recordContainsClause, p);
        return recordContainsClause;
    }

    @Override
    public Cobol visitRecordContainsClauseFormat1(Cobol.RecordContainsClauseFormat1 recordContainsClauseFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordContainsClauseFormat1, Space.Location.RECORD_CONTAINS_CLAUSE_FORMAT_1_PREFIX, p);
        this.visit(recordContainsClauseFormat1.getContains(), p);
        this.visit(recordContainsClauseFormat1.getIntegerLiteral(), p);
        this.visit(recordContainsClauseFormat1.getCharacters(), p);
        this.afterSyntax(recordContainsClauseFormat1, p);
        return recordContainsClauseFormat1;
    }

    @Override
    public Cobol visitRecordContainsClauseFormat2(Cobol.RecordContainsClauseFormat2 recordContainsClauseFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordContainsClauseFormat2, Space.Location.RECORD_CONTAINS_CLAUSE_FORMAT_2_PREFIX, p);
        this.visit(recordContainsClauseFormat2.getWords(), p);
        this.visit(recordContainsClauseFormat2.getFromClause(), p);
        this.visit(recordContainsClauseFormat2.getQualifiedDataName(), p);
        this.afterSyntax(recordContainsClauseFormat2, p);
        return recordContainsClauseFormat2;
    }

    @Override
    public Cobol visitRecordContainsClauseFormat3(Cobol.RecordContainsClauseFormat3 recordContainsClauseFormat3, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordContainsClauseFormat3, Space.Location.RECORD_CONTAINS_CLAUSE_FORMAT_3_PREFIX, p);
        this.visit(recordContainsClauseFormat3.getContains(), p);
        this.visit(recordContainsClauseFormat3.getIntegerLiteral(), p);
        this.visit(recordContainsClauseFormat3.getRecordContainsTo(), p);
        this.visit(recordContainsClauseFormat3.getCharacters(), p);
        this.afterSyntax(recordContainsClauseFormat3, p);
        return recordContainsClauseFormat3;
    }

    @Override
    public Cobol visitRecordContainsTo(Cobol.RecordContainsTo recordContainsTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordContainsTo, Space.Location.RECORD_CONTAINS_TO_PREFIX, p);
        this.visit(recordContainsTo.getTo(), p);
        this.visit(recordContainsTo.getIntegerLiteral(), p);
        this.afterSyntax(recordContainsTo, p);
        return recordContainsTo;
    }

    @Override
    public Cobol visitRecordDelimiterClause(Cobol.RecordDelimiterClause recordDelimiterClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordDelimiterClause, Space.Location.RECORD_DELIMITER_CLAUSE_PREFIX, p);
        this.visit(recordDelimiterClause.getWords(), p);
        this.visit(recordDelimiterClause.getName(), p);
        this.afterSyntax(recordDelimiterClause, p);
        return recordDelimiterClause;
    }

    @Override
    public Cobol visitRecordKeyClause(Cobol.RecordKeyClause recordKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordKeyClause, Space.Location.RECORD_KEY_CLAUSE_PREFIX, p);
        this.visit(recordKeyClause.getRecordWords(), p);
        this.visit(recordKeyClause.getQualifiedDataName(), p);
        this.visit(recordKeyClause.getPasswordClause(), p);
        this.visit(recordKeyClause.getDuplicates(), p);
        this.afterSyntax(recordKeyClause, p);
        return recordKeyClause;
    }

    @Override
    public Cobol visitRecordingModeClause(Cobol.RecordingModeClause recordingModeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(recordingModeClause, Space.Location.RECORDING_MODE_CLAUSE_PREFIX, p);
        this.visit(recordingModeClause.getWords(), p);
        this.visit(recordingModeClause.getMode(), p);
        this.afterSyntax(recordingModeClause, p);
        return recordingModeClause;
    }

    @Override
    public Cobol visitReferenceModifier(Cobol.ReferenceModifier referenceModifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(referenceModifier, Space.Location.REFERENCE_MODIFIER_PREFIX, p);
        this.visit(referenceModifier.getLeftParen(), p);
        this.visit(referenceModifier.getCharacterPosition(), p);
        this.visit(referenceModifier.getColon(), p);
        this.visit(referenceModifier.getLength(), p);
        this.visit(referenceModifier.getRightParen(), p);
        this.afterSyntax(referenceModifier, p);
        return referenceModifier;
    }

    @Override
    public Cobol visitRelationArithmeticComparison(Cobol.RelationArithmeticComparison relationArithmeticComparison, PrintOutputCapture<P> p) {
        this.beforeSyntax(relationArithmeticComparison, Space.Location.RELATION_ARITHMETIC_COMPARISON_PREFIX, p);
        this.visit(relationArithmeticComparison.getArithmeticExpressionA(), p);
        this.visit(relationArithmeticComparison.getRelationalOperator(), p);
        this.visit(relationArithmeticComparison.getArithmeticExpressionB(), p);
        this.afterSyntax(relationArithmeticComparison, p);
        return relationArithmeticComparison;
    }

    @Override
    public Cobol visitRelationCombinedComparison(Cobol.RelationCombinedComparison relationCombinedComparison, PrintOutputCapture<P> p) {
        this.beforeSyntax(relationCombinedComparison, Space.Location.RELATION_COMBINED_COMPARISON_PREFIX, p);
        this.visit(relationCombinedComparison.getArithmeticExpression(), p);
        this.visit(relationCombinedComparison.getRelationalOperator(), p);
        this.visit(relationCombinedComparison.getCombinedCondition(), p);
        this.afterSyntax(relationCombinedComparison, p);
        return relationCombinedComparison;
    }

    @Override
    public Cobol visitRelationCombinedCondition(Cobol.RelationCombinedCondition relationCombinedCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(relationCombinedCondition, Space.Location.RELATION_COMBINED_CONDITION_PREFIX, p);
        this.visit(relationCombinedCondition.getRelationalArithmeticExpressions(), p);
        this.afterSyntax(relationCombinedCondition, p);
        return relationCombinedCondition;
    }

    @Override
    public Cobol visitRelationSignCondition(Cobol.RelationSignCondition relationSignCondition, PrintOutputCapture<P> p) {
        this.beforeSyntax(relationSignCondition, Space.Location.RELATION_SIGN_CONDITION_PREFIX, p);
        this.visit(relationSignCondition.getArithmeticExpression(), p);
        this.visit(relationSignCondition.getWords(), p);
        this.afterSyntax(relationSignCondition, p);
        return relationSignCondition;
    }

    @Override
    public Cobol visitRelationalOperator(Cobol.RelationalOperator relationalOperator, PrintOutputCapture<P> p) {
        this.beforeSyntax(relationalOperator, Space.Location.RELATIONAL_OPERATOR_PREFIX, p);
        this.visit(relationalOperator.getWords(), p);
        this.afterSyntax(relationalOperator, p);
        return relationalOperator;
    }

    @Override
    public Cobol visitRelativeKeyClause(Cobol.RelativeKeyClause relativeKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(relativeKeyClause, Space.Location.RELATIVE_KEY_CLAUSE_PREFIX, p);
        this.visit(relativeKeyClause.getWords(), p);
        this.visit(relativeKeyClause.getQualifiedDataName(), p);
        this.afterSyntax(relativeKeyClause, p);
        return relativeKeyClause;
    }

    @Override
    public Cobol visitRelease(Cobol.Release release, PrintOutputCapture<P> p) {
        this.beforeSyntax(release, Space.Location.RELEASE_PREFIX, p);
        this.visit(release.getRelease(), p);
        this.visit(release.getRecordName(), p);
        this.visit(release.getFrom(), p);
        this.visit(release.getQualifiedDataName(), p);
        this.afterSyntax(release, p);
        return release;
    }

    @Override
    public Cobol visitReportClause(Cobol.ReportClause reportClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportClause, Space.Location.REPORT_CLAUSE_PREFIX, p);
        this.visit(reportClause.getWords(), p);
        this.visit(reportClause.getReportName(), p);
        this.afterSyntax(reportClause, p);
        return reportClause;
    }

    @Override
    public Cobol visitReportDescription(Cobol.ReportDescription reportDescription, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescription, Space.Location.REPORT_DESCRIPTION_PREFIX, p);
        this.visit(reportDescription.getReportDescriptionEntry(), p);
        this.visit(reportDescription.getGroupDescriptionEntries(), p);
        this.afterSyntax(reportDescription, p);
        return reportDescription;
    }

    @Override
    public Cobol visitReportDescriptionEntry(Cobol.ReportDescriptionEntry reportDescriptionEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionEntry, Space.Location.REPORT_DESCRIPTION_ENTRY_PREFIX, p);
        this.visit(reportDescriptionEntry.getRd(), p);
        this.visit(reportDescriptionEntry.getQualifiedDataName(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionGlobalClause(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionPageLimitClause(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionHeadingClause(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionFirstDetailClause(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionLastDetailClause(), p);
        this.visit(reportDescriptionEntry.getReportDescriptionFootingClause(), p);
        this.visit(reportDescriptionEntry.getDot(), p);
        this.afterSyntax(reportDescriptionEntry, p);
        return reportDescriptionEntry;
    }

    @Override
    public Cobol visitReportDescriptionFirstDetailClause(Cobol.ReportDescriptionFirstDetailClause reportDescriptionFirstDetailClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionFirstDetailClause, Space.Location.REPORT_DESCRIPTION_FIRST_DETAIL_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionFirstDetailClause.getWords(), p);
        this.visit(reportDescriptionFirstDetailClause.getDataName(), p);
        this.afterSyntax(reportDescriptionFirstDetailClause, p);
        return reportDescriptionFirstDetailClause;
    }

    @Override
    public Cobol visitReportDescriptionFootingClause(Cobol.ReportDescriptionFootingClause reportDescriptionFootingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionFootingClause, Space.Location.REPORT_DESCRIPTION_FOOTING_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionFootingClause.getWord(), p);
        this.visit(reportDescriptionFootingClause.getDataName(), p);
        this.afterSyntax(reportDescriptionFootingClause, p);
        return reportDescriptionFootingClause;
    }

    @Override
    public Cobol visitReportDescriptionGlobalClause(Cobol.ReportDescriptionGlobalClause reportDescriptionGlobalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionGlobalClause, Space.Location.REPORT_DESCRIPTION_GLOBAL_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionGlobalClause.getWords(), p);
        this.afterSyntax(reportDescriptionGlobalClause, p);
        return reportDescriptionGlobalClause;
    }

    @Override
    public Cobol visitReportDescriptionHeadingClause(Cobol.ReportDescriptionHeadingClause reportDescriptionHeadingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionHeadingClause, Space.Location.REPORT_DESCRIPTION_HEADING_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionHeadingClause.getWord(), p);
        this.visit(reportDescriptionHeadingClause.getDataName(), p);
        this.afterSyntax(reportDescriptionHeadingClause, p);
        return reportDescriptionHeadingClause;
    }

    @Override
    public Cobol visitReportDescriptionLastDetailClause(Cobol.ReportDescriptionLastDetailClause reportDescriptionLastDetailClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionLastDetailClause, Space.Location.REPORT_DESCRIPTION_LAST_DETAIL_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionLastDetailClause.getWords(), p);
        this.visit(reportDescriptionLastDetailClause.getDataName(), p);
        this.afterSyntax(reportDescriptionLastDetailClause, p);
        return reportDescriptionLastDetailClause;
    }

    @Override
    public Cobol visitReportDescriptionPageLimitClause(Cobol.ReportDescriptionPageLimitClause reportDescriptionPageLimitClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportDescriptionPageLimitClause, Space.Location.REPORT_DESCRIPTION_PAGE_LIMIT_CLAUSE_PREFIX, p);
        this.visit(reportDescriptionPageLimitClause.getFirstWords(), p);
        this.visit(reportDescriptionPageLimitClause.getIntegerLiteral(), p);
        this.visit(reportDescriptionPageLimitClause.getSecondWords(), p);
        this.afterSyntax(reportDescriptionPageLimitClause, p);
        return reportDescriptionPageLimitClause;
    }

    @Override
    public Cobol visitReportGroupBlankWhenZeroClause(Cobol.ReportGroupBlankWhenZeroClause reportGroupBlankWhenZeroClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupBlankWhenZeroClause, Space.Location.REPORT_GROUP_BLANK_WHEN_ZERO_CLAUSE_PREFIX, p);
        this.visit(reportGroupBlankWhenZeroClause.getWords(), p);
        this.afterSyntax(reportGroupBlankWhenZeroClause, p);
        return reportGroupBlankWhenZeroClause;
    }

    @Override
    public Cobol visitReportGroupColumnNumberClause(Cobol.ReportGroupColumnNumberClause reportGroupColumnNumberClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupColumnNumberClause, Space.Location.REPORT_GROUP_COLUMN_NUMBER_CLAUSE_PREFIX, p);
        this.visit(reportGroupColumnNumberClause.getWords(), p);
        this.visit(reportGroupColumnNumberClause.getDataName(), p);
        this.afterSyntax(reportGroupColumnNumberClause, p);
        return reportGroupColumnNumberClause;
    }

    @Override
    public Cobol visitReportGroupDescriptionEntryFormat1(Cobol.ReportGroupDescriptionEntryFormat1 reportGroupDescriptionEntryFormat1, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupDescriptionEntryFormat1, Space.Location.REPORT_GROUP_DESCRIPTION_ENTRY_FORMAT_1_PREFIX, p);
        this.visit(reportGroupDescriptionEntryFormat1.getIntegerLiteral(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getDataName(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getGroupLineNumberClause(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getGroupNextGroupClause(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getGroupTypeClause(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getGroupUsageClause(), p);
        this.visit(reportGroupDescriptionEntryFormat1.getDot(), p);
        this.afterSyntax(reportGroupDescriptionEntryFormat1, p);
        return reportGroupDescriptionEntryFormat1;
    }

    @Override
    public Cobol visitReportGroupDescriptionEntryFormat2(Cobol.ReportGroupDescriptionEntryFormat2 reportGroupDescriptionEntryFormat2, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupDescriptionEntryFormat2, Space.Location.REPORT_GROUP_DESCRIPTION_ENTRY_FORMAT_2_PREFIX, p);
        this.visit(reportGroupDescriptionEntryFormat2.getIntegerLiteral(), p);
        this.visit(reportGroupDescriptionEntryFormat2.getDataName(), p);
        this.visit(reportGroupDescriptionEntryFormat2.getReportGroupLineNumberClause(), p);
        this.visit(reportGroupDescriptionEntryFormat2.getGroupUsageClause(), p);
        this.visit(reportGroupDescriptionEntryFormat2.getDot(), p);
        this.afterSyntax(reportGroupDescriptionEntryFormat2, p);
        return reportGroupDescriptionEntryFormat2;
    }

    @Override
    public Cobol visitReportGroupDescriptionEntryFormat3(Cobol.ReportGroupDescriptionEntryFormat3 reportGroupDescriptionEntryFormat3, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupDescriptionEntryFormat3, Space.Location.REPORT_GROUP_DESCRIPTION_ENTRY_FORMAT_3_PREFIX, p);
        this.visit(reportGroupDescriptionEntryFormat3.getIntegerLiteral(), p);
        this.visit(reportGroupDescriptionEntryFormat3.getDataName(), p);
        this.visit(reportGroupDescriptionEntryFormat3.getClauses(), p);
        this.visit(reportGroupDescriptionEntryFormat3.getDot(), p);
        this.afterSyntax(reportGroupDescriptionEntryFormat3, p);
        return reportGroupDescriptionEntryFormat3;
    }

    @Override
    public Cobol visitReportGroupIndicateClause(Cobol.ReportGroupIndicateClause reportGroupIndicateClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupIndicateClause, Space.Location.REPORT_GROUP_INDICATOR_CLAUSE_PREFIX, p);
        this.visit(reportGroupIndicateClause.getWords(), p);
        this.afterSyntax(reportGroupIndicateClause, p);
        return reportGroupIndicateClause;
    }

    @Override
    public Cobol visitReportGroupJustifiedClause(Cobol.ReportGroupJustifiedClause reportGroupJustifiedClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupJustifiedClause, Space.Location.REPORT_GROUP_JUSTIFIED_CLAUSE_PREFIX, p);
        this.visit(reportGroupJustifiedClause.getWords(), p);
        this.afterSyntax(reportGroupJustifiedClause, p);
        return reportGroupJustifiedClause;
    }

    @Override
    public Cobol visitReportGroupLineNumberClause(Cobol.ReportGroupLineNumberClause reportGroupLineNumberClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupLineNumberClause, Space.Location.REPORT_GROUP_LINE_NUMBER_CLAUSE_PREFIX, p);
        this.visit(reportGroupLineNumberClause.getWords(), p);
        this.visit(reportGroupLineNumberClause.getClause(), p);
        this.afterSyntax(reportGroupLineNumberClause, p);
        return reportGroupLineNumberClause;
    }

    @Override
    public Cobol visitReportGroupLineNumberNextPage(Cobol.ReportGroupLineNumberNextPage reportGroupLineNumberNextPage, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupLineNumberNextPage, Space.Location.REPORT_GROUP_LINE_NUMBER_NEXT_PAGE_PREFIX, p);
        this.visit(reportGroupLineNumberNextPage.getIntegerLiteral(), p);
        this.visit(reportGroupLineNumberNextPage.getWords(), p);
        this.afterSyntax(reportGroupLineNumberNextPage, p);
        return reportGroupLineNumberNextPage;
    }

    @Override
    public Cobol visitReportGroupLineNumberPlus(Cobol.ReportGroupLineNumberPlus reportGroupLineNumberPlus, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupLineNumberPlus, Space.Location.REPORT_GROUP_LINE_NUMBER_PLUS_PREFIX, p);
        this.visit(reportGroupLineNumberPlus.getPlus(), p);
        this.visit(reportGroupLineNumberPlus.getIntegerLiteral(), p);
        this.afterSyntax(reportGroupLineNumberPlus, p);
        return reportGroupLineNumberPlus;
    }

    @Override
    public Cobol visitReportGroupNextGroupClause(Cobol.ReportGroupNextGroupClause reportGroupNextGroupClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupNextGroupClause, Space.Location.REPORT_GROUP_NEXT_GROUP_CLAUSE_PREFIX, p);
        this.visit(reportGroupNextGroupClause.getWords(), p);
        this.visit(reportGroupNextGroupClause.getClause(), p);
        this.afterSyntax(reportGroupNextGroupClause, p);
        return reportGroupNextGroupClause;
    }

    @Override
    public Cobol visitReportGroupNextGroupNextPage(Cobol.ReportGroupNextGroupNextPage reportGroupNextGroupNextPage, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupNextGroupNextPage, Space.Location.REPORT_GROUP_NEXT_GROUP_NEXT_PAGE_PREFIX, p);
        this.visit(reportGroupNextGroupNextPage.getNextPage(), p);
        this.afterSyntax(reportGroupNextGroupNextPage, p);
        return reportGroupNextGroupNextPage;
    }

    @Override
    public Cobol visitReportGroupNextGroupPlus(Cobol.ReportGroupNextGroupPlus reportGroupNextGroupPlus, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupNextGroupPlus, Space.Location.REPORT_GROUP_NEXT_GROUP_PLUS_PREFIX, p);
        this.visit(reportGroupNextGroupPlus.getPlus(), p);
        this.visit(reportGroupNextGroupPlus.getIntegerLiteral(), p);
        this.afterSyntax(reportGroupNextGroupPlus, p);
        return reportGroupNextGroupPlus;
    }

    @Override
    public Cobol visitReportGroupPictureClause(Cobol.ReportGroupPictureClause reportGroupPictureClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupPictureClause, Space.Location.REPORT_GROUP_PICTURE_CLAUSE_PREFIX, p);
        this.visit(reportGroupPictureClause.getWords(), p);
        this.visit(reportGroupPictureClause.getPictureString(), p);
        this.afterSyntax(reportGroupPictureClause, p);
        return reportGroupPictureClause;
    }

    @Override
    public Cobol visitReportGroupResetClause(Cobol.ReportGroupResetClause reportGroupResetClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupResetClause, Space.Location.REPORT_GROUP_RESET_CLAUSE_PREFIX, p);
        this.visit(reportGroupResetClause.getWords(), p);
        this.afterSyntax(reportGroupResetClause, p);
        return reportGroupResetClause;
    }

    @Override
    public Cobol visitReportGroupSignClause(Cobol.ReportGroupSignClause reportGroupSignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupSignClause, Space.Location.REPORT_GROUP_SIGN_CLAUSE_PREFIX, p);
        this.visit(reportGroupSignClause.getWords(), p);
        this.afterSyntax(reportGroupSignClause, p);
        return reportGroupSignClause;
    }

    @Override
    public Cobol visitReportGroupSourceClause(Cobol.ReportGroupSourceClause reportGroupSourceClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupSourceClause, Space.Location.REPORT_GROUP_SOURCE_CLAUSE_PREFIX, p);
        this.visit(reportGroupSourceClause.getWords(), p);
        this.visit(reportGroupSourceClause.getIdentifier(), p);
        this.afterSyntax(reportGroupSourceClause, p);
        return reportGroupSourceClause;
    }

    @Override
    public Cobol visitReportGroupSumClause(Cobol.ReportGroupSumClause reportGroupSumClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupSumClause, Space.Location.REPORT_GROUP_SUM_CLAUSE_PREFIX, p);
        this.visit(reportGroupSumClause.getCobols(), p);
        this.afterSyntax(reportGroupSumClause, p);
        return reportGroupSumClause;
    }

    @Override
    public Cobol visitReportGroupTypeClause(Cobol.ReportGroupTypeClause reportGroupTypeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeClause, Space.Location.REPORT_GROUP_TYPE_CLAUSE_PREFIX, p);
        this.visit(reportGroupTypeClause.getWords(), p);
        this.visit(reportGroupTypeClause.getType(), p);
        this.afterSyntax(reportGroupTypeClause, p);
        return reportGroupTypeClause;
    }

    @Override
    public Cobol visitReportGroupTypeControlFooting(Cobol.ReportGroupTypeControlFooting reportGroupTypeControlFooting, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeControlFooting, Space.Location.REPORT_GROUP_TYPE_CONTROL_FOOTING_PREFIX, p);
        this.visit(reportGroupTypeControlFooting.getWords(), p);
        this.afterSyntax(reportGroupTypeControlFooting, p);
        return reportGroupTypeControlFooting;
    }

    @Override
    public Cobol visitReportGroupTypeControlHeading(Cobol.ReportGroupTypeControlHeading reportGroupTypeControlHeading, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeControlHeading, Space.Location.REPORT_GROUP_TYPE_CONTROL_HEADING_PREFIX, p);
        this.visit(reportGroupTypeControlHeading.getWords(), p);
        this.afterSyntax(reportGroupTypeControlHeading, p);
        return reportGroupTypeControlHeading;
    }

    @Override
    public Cobol visitReportGroupTypeDetail(Cobol.ReportGroupTypeDetail reportGroupTypeDetail, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeDetail, Space.Location.REPORT_GROUP_TYPE_DETAIL_PREFIX, p);
        this.visit(reportGroupTypeDetail.getWords(), p);
        this.afterSyntax(reportGroupTypeDetail, p);
        return reportGroupTypeDetail;
    }

    @Override
    public Cobol visitReportGroupTypePageFooting(Cobol.ReportGroupTypePageFooting reportGroupTypePageFooting, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypePageFooting, Space.Location.REPORT_GROUP_TYPE_PAGE_FOOTING_PREFIX, p);
        this.visit(reportGroupTypePageFooting.getWords(), p);
        this.afterSyntax(reportGroupTypePageFooting, p);
        return reportGroupTypePageFooting;
    }

    @Override
    public Cobol visitReportGroupTypePageHeading(Cobol.ReportGroupTypePageHeading reportGroupTypePageHeading, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypePageHeading, Space.Location.REPORT_GROUP_TYPE_REPORT_FOOTING_PREFIX, p);
        this.visit(reportGroupTypePageHeading.getWords(), p);
        this.afterSyntax(reportGroupTypePageHeading, p);
        return reportGroupTypePageHeading;
    }

    @Override
    public Cobol visitReportGroupTypeReportFooting(Cobol.ReportGroupTypeReportFooting reportGroupTypeReportFooting, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeReportFooting, Space.Location.REPORT_GROUP_TYPE_PAGE_HEADING_PREFIX, p);
        this.visit(reportGroupTypeReportFooting.getWords(), p);
        this.afterSyntax(reportGroupTypeReportFooting, p);
        return reportGroupTypeReportFooting;
    }

    @Override
    public Cobol visitReportGroupTypeReportHeading(Cobol.ReportGroupTypeReportHeading reportGroupTypeReportHeading, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupTypeReportHeading, Space.Location.REPORT_GROUP_TYPE_REPORT_HEADING_PREFIX, p);
        this.visit(reportGroupTypeReportHeading.getWords(), p);
        this.afterSyntax(reportGroupTypeReportHeading, p);
        return reportGroupTypeReportHeading;
    }

    @Override
    public Cobol visitReportGroupUsageClause(Cobol.ReportGroupUsageClause reportGroupUsageClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupUsageClause, Space.Location.REPORT_GROUP_USAGE_CLAUSE_PREFIX, p);
        this.visit(reportGroupUsageClause.getWords(), p);
        this.afterSyntax(reportGroupUsageClause, p);
        return reportGroupUsageClause;
    }

    @Override
    public Cobol visitReportGroupValueClause(Cobol.ReportGroupValueClause reportGroupValueClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportGroupValueClause, Space.Location.REPORT_GROUP_VALUE_CLAUSE_PREFIX, p);
        this.visit(reportGroupValueClause.getWords(), p);
        this.visit(reportGroupValueClause.getLiteral(), p);
        this.afterSyntax(reportGroupValueClause, p);
        return reportGroupValueClause;
    }

    @Override
    public Cobol visitReportName(Cobol.ReportName reportName, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportName, Space.Location.REPORT_NAME_PREFIX, p);
        this.visit(reportName.getQualifiedDataName(), p);
        this.afterSyntax(reportName, p);
        return reportName;
    }

    @Override
    public Cobol visitReportSection(Cobol.ReportSection reportSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(reportSection, Space.Location.REPORT_SECTION_PREFIX, p);
        this.visit(reportSection.getWords(), p);
        this.visit(reportSection.getDescriptions(), p);
        this.afterSyntax(reportSection, p);
        return reportSection;
    }

    @Override
    public Cobol visitRerunClause(Cobol.RerunClause rerunClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(rerunClause, Space.Location.RERUN_CLAUSE_PREFIX, p);
        this.visit(rerunClause.getRerun(), p);
        this.visit(rerunClause.getOn(), p);
        this.visit(rerunClause.getName(), p);
        this.visit(rerunClause.getEvery(), p);
        this.visit(rerunClause.getAction(), p);
        this.afterSyntax(rerunClause, p);
        return rerunClause;
    }

    @Override
    public Cobol visitRerunEveryClock(Cobol.RerunEveryClock rerunEveryClock, PrintOutputCapture<P> p) {
        this.beforeSyntax(rerunEveryClock, Space.Location.RERUN_EVERY_CLOCK_PREFIX, p);
        this.visit(rerunEveryClock.getIntegerLiteral(), p);
        this.visit(rerunEveryClock.getClockUnits(), p);
        this.afterSyntax(rerunEveryClock, p);
        return rerunEveryClock;
    }

    @Override
    public Cobol visitRerunEveryOf(Cobol.RerunEveryOf rerunEveryOf, PrintOutputCapture<P> p) {
        this.beforeSyntax(rerunEveryOf, Space.Location.RERUN_EVERY_OF_PREFIX, p);
        this.visit(rerunEveryOf.getRecords(), p);
        this.visit(rerunEveryOf.getFileName(), p);
        this.afterSyntax(rerunEveryOf, p);
        return rerunEveryOf;
    }

    @Override
    public Cobol visitRerunEveryRecords(Cobol.RerunEveryRecords rerunEveryRecords, PrintOutputCapture<P> p) {
        this.beforeSyntax(rerunEveryRecords, Space.Location.RERUN_EVERY_RECORDS_PREFIX, p);
        this.visit(rerunEveryRecords.getIntegerLiteral(), p);
        this.visit(rerunEveryRecords.getRecords(), p);
        this.afterSyntax(rerunEveryRecords, p);
        return rerunEveryRecords;
    }

    @Override
    public Cobol visitReserveClause(Cobol.ReserveClause reserveClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reserveClause, Space.Location.RERUN_RESERVE_CLAUSE_PREFIX, p);
        this.visit(reserveClause.getWords(), p);
        this.afterSyntax(reserveClause, p);
        return reserveClause;
    }

    @Override
    public Cobol visitReserveNetworkClause(Cobol.ReserveNetworkClause reserveNetworkClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(reserveNetworkClause, Space.Location.RESERVE_NETWORK_CLAUSE_PREFIX, p);
        this.visit(reserveNetworkClause.getWords(), p);
        this.afterSyntax(reserveNetworkClause, p);
        return reserveNetworkClause;
    }

    @Override
    public Cobol visitReturn(Cobol.Return r, PrintOutputCapture<P> p) {
        this.beforeSyntax(r, Space.Location.RETURN_PREFIX, p);
        this.visit(r.getWord(), p);
        this.visit(r.getFileName(), p);
        this.visit(r.getRecord(), p);
        this.visit(r.getInto(), p);
        this.visit(r.getAtEndPhrase(), p);
        this.visit(r.getNotAtEndPhrase(), p);
        this.visit(r.getEndReturn(), p);
        this.afterSyntax(r, p);
        return r;
    }

    @Override
    public Cobol visitReturnInto(Cobol.ReturnInto r, PrintOutputCapture<P> p) {
        this.beforeSyntax(r, Space.Location.RETURN_INTO_PREFIX, p);
        this.visit(r.getInto(), p);
        this.visit(r.getQualifiedDataName(), p);
        this.afterSyntax(r, p);
        return r;
    }

    @Override
    public Cobol visitRewrite(Cobol.Rewrite rewrite, PrintOutputCapture<P> p) {
        this.beforeSyntax(rewrite, Space.Location.REWRITE_PREFIX, p);
        this.visit(rewrite.getRewrite(), p);
        this.visit(rewrite.getRecordName(), p);
        this.visit(rewrite.getRewriteFrom(), p);
        this.visit(rewrite.getInvalidKeyPhrase(), p);
        this.visit(rewrite.getNotInvalidKeyPhrase(), p);
        this.visit(rewrite.getEndRewrite(), p);
        this.afterSyntax(rewrite, p);
        return rewrite;
    }

    @Override
    public Cobol visitRewriteFrom(Cobol.RewriteFrom rewriteFrom, PrintOutputCapture<P> p) {
        this.beforeSyntax(rewriteFrom, Space.Location.REWRITE_FROM_PREFIX, p);
        this.visit(rewriteFrom.getFrom(), p);
        this.visit(rewriteFrom.getIdentifier(), p);
        this.afterSyntax(rewriteFrom, p);
        return rewriteFrom;
    }

    @Override
    public Cobol visitRoundable(Cobol.Roundable roundable, PrintOutputCapture<P> p) {
        this.beforeSyntax(roundable, Space.Location.ROUNDABLE_PREFIX, p);
        this.visit(roundable.getIdentifier(), p);
        this.visit(roundable.getRounded(), p);
        this.afterSyntax(roundable, p);
        return roundable;
    }

    @Override
    public Cobol visitSameClause(Cobol.SameClause sameClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(sameClause, Space.Location.SAME_CLAUSE_PREFIX, p);
        this.visit(sameClause.getWords(), p);
        this.visit(sameClause.getFileNames(), p);
        this.afterSyntax(sameClause, p);
        return sameClause;
    }

    @Override
    public Cobol visitScreenDescriptionAutoClause(Cobol.ScreenDescriptionAutoClause screenDescriptionAutoClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionAutoClause, Space.Location.SCREEN_DESCRIPTION_AUTO_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionAutoClause.getAuto(), p);
        this.afterSyntax(screenDescriptionAutoClause, p);
        return screenDescriptionAutoClause;
    }

    @Override
    public Cobol visitScreenDescriptionBackgroundColorClause(Cobol.ScreenDescriptionBackgroundColorClause screenDescriptionBackgroundColorClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionBackgroundColorClause, Space.Location.SCREEN_DESCRIPTION_BACKGROUND_COLOR_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionBackgroundColorClause.getBackground(), p);
        this.visit(screenDescriptionBackgroundColorClause.getIs(), p);
        this.visit(screenDescriptionBackgroundColorClause.getValue(), p);
        this.afterSyntax(screenDescriptionBackgroundColorClause, p);
        return screenDescriptionBackgroundColorClause;
    }

    @Override
    public Cobol visitScreenDescriptionBellClause(Cobol.ScreenDescriptionBellClause screenDescriptionBellClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionBellClause, Space.Location.SCREEN_DESCRIPTION_BELL_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionBellClause.getBell(), p);
        this.afterSyntax(screenDescriptionBellClause, p);
        return screenDescriptionBellClause;
    }

    @Override
    public Cobol visitScreenDescriptionBlankClause(Cobol.ScreenDescriptionBlankClause screenDescriptionBlankClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionBlankClause, Space.Location.SCREEN_DESCRIPTION_BLANK_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionBlankClause.getWords(), p);
        this.afterSyntax(screenDescriptionBlankClause, p);
        return screenDescriptionBlankClause;
    }

    @Override
    public Cobol visitScreenDescriptionBlankWhenZeroClause(Cobol.ScreenDescriptionBlankWhenZeroClause screenDescriptionBlankWhenZeroClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionBlankWhenZeroClause, Space.Location.SCREEN_DESCRIPTION_BLANK_WHEN_ZERO_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionBlankWhenZeroClause.getWords(), p);
        this.afterSyntax(screenDescriptionBlankWhenZeroClause, p);
        return screenDescriptionBlankWhenZeroClause;
    }

    @Override
    public Cobol visitScreenDescriptionBlinkClause(Cobol.ScreenDescriptionBlinkClause screenDescriptionBlinkClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionBlinkClause, Space.Location.SCREEN_DESCRIPTION_BLINK_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionBlinkClause.getBlink(), p);
        this.afterSyntax(screenDescriptionBlinkClause, p);
        return screenDescriptionBlinkClause;
    }

    @Override
    public Cobol visitScreenDescriptionColumnClause(Cobol.ScreenDescriptionColumnClause screenDescriptionColumnClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionColumnClause, Space.Location.SCREEN_DESCRIPTION_COLUMN_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionColumnClause.getWords(), p);
        this.visit(screenDescriptionColumnClause.getValue(), p);
        this.afterSyntax(screenDescriptionColumnClause, p);
        return screenDescriptionColumnClause;
    }

    @Override
    public Cobol visitScreenDescriptionControlClause(Cobol.ScreenDescriptionControlClause screenDescriptionControlClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionControlClause, Space.Location.SCREEN_DESCRIPTION_CONTROL_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionControlClause.getWords(), p);
        this.visit(screenDescriptionControlClause.getValue(), p);
        this.afterSyntax(screenDescriptionControlClause, p);
        return screenDescriptionControlClause;
    }

    @Override
    public Cobol visitScreenDescriptionEntry(Cobol.ScreenDescriptionEntry screenDescriptionEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionEntry, Space.Location.SCREEN_DESCRIPTION_ENTRY_PREFIX, p);
        this.visit(screenDescriptionEntry.getWord(), p);
        this.visit(screenDescriptionEntry.getName(), p);
        this.visit(screenDescriptionEntry.getClauses(), p);
        this.visit(screenDescriptionEntry.getDot(), p);
        this.afterSyntax(screenDescriptionEntry, p);
        return screenDescriptionEntry;
    }

    @Override
    public Cobol visitScreenDescriptionEraseClause(Cobol.ScreenDescriptionEraseClause screenDescriptionEraseClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionEraseClause, Space.Location.SCREEN_DESCRIPTION_ERASE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionEraseClause.getWords(), p);
        this.afterSyntax(screenDescriptionEraseClause, p);
        return screenDescriptionEraseClause;
    }

    @Override
    public Cobol visitScreenDescriptionForegroundColorClause(Cobol.ScreenDescriptionForegroundColorClause screenDescriptionForegroundColorClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionForegroundColorClause, Space.Location.SCREEN_DESCRIPTION_FOREGROUND_COLOR_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionForegroundColorClause.getWords(), p);
        this.visit(screenDescriptionForegroundColorClause.getValue(), p);
        this.afterSyntax(screenDescriptionForegroundColorClause, p);
        return screenDescriptionForegroundColorClause;
    }

    @Override
    public Cobol visitScreenDescriptionFromClause(Cobol.ScreenDescriptionFromClause screenDescriptionFromClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionFromClause, Space.Location.SCREEN_DESCRIPTION_FROM_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionFromClause.getFrom(), p);
        this.visit(screenDescriptionFromClause.getValue(), p);
        this.visit(screenDescriptionFromClause.getScreenDescriptionToClause(), p);
        this.afterSyntax(screenDescriptionFromClause, p);
        return screenDescriptionFromClause;
    }

    @Override
    public Cobol visitScreenDescriptionFullClause(Cobol.ScreenDescriptionFullClause screenDescriptionFullClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionFullClause, Space.Location.SCREEN_DESCRIPTION_FULL_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionFullClause.getWord(), p);
        this.afterSyntax(screenDescriptionFullClause, p);
        return screenDescriptionFullClause;
    }

    @Override
    public Cobol visitScreenDescriptionGridClause(Cobol.ScreenDescriptionGridClause screenDescriptionGridClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionGridClause, Space.Location.SCREEN_DESCRIPTION_GRID_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionGridClause.getWord(), p);
        this.afterSyntax(screenDescriptionGridClause, p);
        return screenDescriptionGridClause;
    }

    @Override
    public Cobol visitScreenDescriptionJustifiedClause(Cobol.ScreenDescriptionJustifiedClause screenDescriptionJustifiedClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionJustifiedClause, Space.Location.SCREEN_DESCRIPTION_JUSTIFIED_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionJustifiedClause.getWords(), p);
        this.afterSyntax(screenDescriptionJustifiedClause, p);
        return screenDescriptionJustifiedClause;
    }

    @Override
    public Cobol visitScreenDescriptionLightClause(Cobol.ScreenDescriptionLightClause screenDescriptionLightClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionLightClause, Space.Location.SCREEN_DESCRIPTION_LIGHT_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionLightClause.getLight(), p);
        this.afterSyntax(screenDescriptionLightClause, p);
        return screenDescriptionLightClause;
    }

    @Override
    public Cobol visitScreenDescriptionLineClause(Cobol.ScreenDescriptionLineClause screenDescriptionLineClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionLineClause, Space.Location.SCREEN_DESCRIPTION_LINE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionLineClause.getWords(), p);
        this.visit(screenDescriptionLineClause.getValue(), p);
        this.afterSyntax(screenDescriptionLineClause, p);
        return screenDescriptionLineClause;
    }

    @Override
    public Cobol visitScreenDescriptionPictureClause(Cobol.ScreenDescriptionPictureClause screenDescriptionPictureClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionPictureClause, Space.Location.SCREEN_DESCRIPTION_PICTURE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionPictureClause.getWords(), p);
        this.visit(screenDescriptionPictureClause.getPictureString(), p);
        this.afterSyntax(screenDescriptionPictureClause, p);
        return screenDescriptionPictureClause;
    }

    @Override
    public Cobol visitScreenDescriptionPromptClause(Cobol.ScreenDescriptionPromptClause screenDescriptionPromptClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionPromptClause, Space.Location.SCREEN_DESCRIPTION_PROMPT_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionPromptClause.getWords(), p);
        this.visit(screenDescriptionPromptClause.getName(), p);
        this.visit(screenDescriptionPromptClause.getScreenDescriptionPromptOccursClause(), p);
        this.afterSyntax(screenDescriptionPromptClause, p);
        return screenDescriptionPromptClause;
    }

    @Override
    public Cobol visitScreenDescriptionPromptOccursClause(Cobol.ScreenDescriptionPromptOccursClause screenDescriptionPromptOccursClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionPromptOccursClause, Space.Location.SCREEN_DESCRIPTION_PROMPT_OCCURS_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionPromptOccursClause.getOccurs(), p);
        this.visit(screenDescriptionPromptOccursClause.getInteger(), p);
        this.visit(screenDescriptionPromptOccursClause.getTimes(), p);
        this.afterSyntax(screenDescriptionPromptOccursClause, p);
        return screenDescriptionPromptOccursClause;
    }

    @Override
    public Cobol visitScreenDescriptionRequiredClause(Cobol.ScreenDescriptionRequiredClause screenDescriptionRequiredClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionRequiredClause, Space.Location.SCREEN_DESCRIPTION_REQUIRED_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionRequiredClause.getRequired(), p);
        this.afterSyntax(screenDescriptionRequiredClause, p);
        return screenDescriptionRequiredClause;
    }

    @Override
    public Cobol visitScreenDescriptionReverseVideoClause(Cobol.ScreenDescriptionReverseVideoClause screenDescriptionReverseVideoClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionReverseVideoClause, Space.Location.SCREEN_DESCRIPTION_REVERSE_VIDEO_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionReverseVideoClause.getWord(), p);
        this.afterSyntax(screenDescriptionReverseVideoClause, p);
        return screenDescriptionReverseVideoClause;
    }

    @Override
    public Cobol visitScreenDescriptionSecureClause(Cobol.ScreenDescriptionSecureClause screenDescriptionSecureClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionSecureClause, Space.Location.SCREEN_DESCRIPTION_SECURE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionSecureClause.getWord(), p);
        this.afterSyntax(screenDescriptionSecureClause, p);
        return screenDescriptionSecureClause;
    }

    @Override
    public Cobol visitScreenDescriptionSignClause(Cobol.ScreenDescriptionSignClause screenDescriptionSignClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionSignClause, Space.Location.SCREEN_DESCRIPTION_SIGN_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionSignClause.getWords(), p);
        this.afterSyntax(screenDescriptionSignClause, p);
        return screenDescriptionSignClause;
    }

    @Override
    public Cobol visitScreenDescriptionSizeClause(Cobol.ScreenDescriptionSizeClause screenDescriptionSizeClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionSizeClause, Space.Location.SCREEN_DESCRIPTION_SIZE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionSizeClause.getWords(), p);
        this.visit(screenDescriptionSizeClause.getValue(), p);
        this.afterSyntax(screenDescriptionSizeClause, p);
        return screenDescriptionSizeClause;
    }

    @Override
    public Cobol visitScreenDescriptionToClause(Cobol.ScreenDescriptionToClause screenDescriptionToClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionToClause, Space.Location.SCREEN_DESCRIPTION_TO_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionToClause.getTo(), p);
        this.visit(screenDescriptionToClause.getIdentifier(), p);
        this.afterSyntax(screenDescriptionToClause, p);
        return screenDescriptionToClause;
    }

    @Override
    public Cobol visitScreenDescriptionUnderlineClause(Cobol.ScreenDescriptionUnderlineClause screenDescriptionUnderlineClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionUnderlineClause, Space.Location.SCREEN_DESCRIPTION_UNDERLINE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionUnderlineClause.getUnderline(), p);
        this.afterSyntax(screenDescriptionUnderlineClause, p);
        return screenDescriptionUnderlineClause;
    }

    @Override
    public Cobol visitScreenDescriptionUsageClause(Cobol.ScreenDescriptionUsageClause screenDescriptionUsageClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionUsageClause, Space.Location.SCREEN_DESCRIPTION_USAGE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionUsageClause.getWords(), p);
        this.afterSyntax(screenDescriptionUsageClause, p);
        return screenDescriptionUsageClause;
    }

    @Override
    public Cobol visitScreenDescriptionUsingClause(Cobol.ScreenDescriptionUsingClause screenDescriptionUsingClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionUsingClause, Space.Location.SCREEN_DESCRIPTION_USING_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionUsingClause.getUsing(), p);
        this.visit(screenDescriptionUsingClause.getIdentifier(), p);
        this.afterSyntax(screenDescriptionUsingClause, p);
        return screenDescriptionUsingClause;
    }

    @Override
    public Cobol visitScreenDescriptionValueClause(Cobol.ScreenDescriptionValueClause screenDescriptionValueClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionValueClause, Space.Location.SCREEN_DESCRIPTION_VALUE_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionValueClause.getWords(), p);
        this.visit(screenDescriptionValueClause.getValue(), p);
        this.afterSyntax(screenDescriptionValueClause, p);
        return screenDescriptionValueClause;
    }

    @Override
    public Cobol visitScreenDescriptionZeroFillClause(Cobol.ScreenDescriptionZeroFillClause screenDescriptionZeroFillClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenDescriptionZeroFillClause, Space.Location.SCREEN_DESCRIPTION_ZERO_FILL_CLAUSE_PREFIX, p);
        this.visit(screenDescriptionZeroFillClause.getWord(), p);
        this.afterSyntax(screenDescriptionZeroFillClause, p);
        return screenDescriptionZeroFillClause;
    }

    @Override
    public Cobol visitScreenSection(Cobol.ScreenSection screenSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(screenSection, Space.Location.SCREEN_SECTION_PREFIX, p);
        this.visit(screenSection.getWords(), p);
        this.visit(screenSection.getDot(), p);
        this.visit(screenSection.getDescriptions(), p);
        this.afterSyntax(screenSection, p);
        return screenSection;
    }

    @Override
    public Cobol visitSearch(Cobol.Search s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEARCH_PREFIX, p);
        this.visit(s.getWords(), p);
        this.visit(s.getQualifiedDataName(), p);
        this.visit(s.getSearchVarying(), p);
        this.visit(s.getAtEndPhrase(), p);
        this.visit(s.getSearchWhen(), p);
        this.visit(s.getEndSearch(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSearchVarying(Cobol.SearchVarying s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEARCH_VARYING_PREFIX, p);
        this.visit(s.getVarying(), p);
        this.visit(s.getQualifiedDataName(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSearchWhen(Cobol.SearchWhen s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEARCH_WHEN_PREFIX, p);
        this.visit(s.getWhen(), p);
        this.visit(s.getCondition(), p);
        this.visit(s.getNextSentence(), p);
        this.visit(s.getStatements(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSelectClause(Cobol.SelectClause selectClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(selectClause, Space.Location.SEARCH_CLAUSE_PREFIX, p);
        this.visit(selectClause.getWords(), p);
        this.visit(selectClause.getFileName(), p);
        this.afterSyntax(selectClause, p);
        return selectClause;
    }

    @Override
    public Cobol visitSend(Cobol.Send s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEND_PREFIX, p);
        this.visit(s.getSend(), p);
        this.visit(s.getStatement(), p);
        this.visit(s.getOnExceptionClause(), p);
        this.visit(s.getNotOnExceptionClause(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSendAdvancingLines(Cobol.SendAdvancingLines s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEND_ADVANCING_LINES_PREFIX, p);
        this.visit(s.getName(), p);
        this.visit(s.getLines(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSendPhrase(Cobol.SendPhrase s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEND_PHRASE_PREFIX, p);
        this.visit(s.getWords(), p);
        this.visit(s.getTarget(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSendStatementSync(Cobol.SendStatementSync s, PrintOutputCapture<P> p) {
        this.beforeSyntax(s, Space.Location.SEND_STATEMENT_SYNC_PREFIX, p);
        this.visit(s.getName(), p);
        this.visit(s.getSendFromPhrase(), p);
        this.visit(s.getSendWithPhrase(), p);
        this.visit(s.getSendReplacingPhrase(), p);
        this.visit(s.getSendAdvancingPhrase(), p);
        this.afterSyntax(s, p);
        return s;
    }

    @Override
    public Cobol visitSentence(Cobol.Sentence sentence, PrintOutputCapture<P> p) {
        this.beforeSyntax(sentence, Space.Location.SENTENCE_PREFIX, p);
        this.visit(sentence.getStatements(), p);
        this.visit(sentence.getDot(), p);
        this.afterSyntax(sentence, p);
        return sentence;
    }

    @Override
    public Cobol visitSet(Cobol.Set set, PrintOutputCapture<P> p) {
        this.beforeSyntax(set, Space.Location.SET_PREFIX, p);
        this.visit(set.getSet(), p);
        this.visit(set.getTo(), p);
        this.visit(set.getUpDown(), p);
        this.afterSyntax(set, p);
        return set;
    }

    @Override
    public Cobol visitSetTo(Cobol.SetTo setTo, PrintOutputCapture<P> p) {
        this.beforeSyntax(setTo, Space.Location.SET_TO_PREFIX, p);
        this.visit(setTo.getIdentifiers(), p);
        this.visit(setTo.getTo(), p);
        this.visit(setTo.getValues(), p);
        this.afterSyntax(setTo, p);
        return setTo;
    }

    @Override
    public Cobol visitSetUpDown(Cobol.SetUpDown setUpDown, PrintOutputCapture<P> p) {
        this.beforeSyntax(setUpDown, Space.Location.SET_UP_DOWN_PREFIX, p);
        this.visit(setUpDown.getTo(), p);
        this.visit(setUpDown.getOperation(), p);
        this.visit(setUpDown.getValue(), p);
        this.afterSyntax(setUpDown, p);
        return setUpDown;
    }

    @Override
    public Cobol visitSort(Cobol.Sort sort, PrintOutputCapture<P> p) {
        this.beforeSyntax(sort, Space.Location.SORT_PREFIX, p);
        this.visit(sort.getSort(), p);
        this.visit(sort.getFileName(), p);
        this.visit(sort.getSortOnKeyClause(), p);
        this.visit(sort.getSortDuplicatesPhrase(), p);
        this.visit(sort.getSortCollatingSequencePhrase(), p);
        this.visit(sort.getSortInputProcedurePhrase(), p);
        this.visit(sort.getSortUsing(), p);
        this.visit(sort.getSortOutputProcedurePhrase(), p);
        this.visit(sort.getSortGiving(), p);
        this.afterSyntax(sort, p);
        return sort;
    }

    @Override
    public Cobol visitSortCollatingSequencePhrase(Cobol.SortCollatingSequencePhrase sortCollatingSequencePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(sortCollatingSequencePhrase, Space.Location.SORT_COLLATING_SEQUENCE_PHRASE_PREFIX, p);
        this.visit(sortCollatingSequencePhrase.getWords(), p);
        this.visit(sortCollatingSequencePhrase.getAlphabetNames(), p);
        this.visit(sortCollatingSequencePhrase.getSortCollatingAlphanumeric(), p);
        this.visit(sortCollatingSequencePhrase.getSortCollatingNational(), p);
        this.afterSyntax(sortCollatingSequencePhrase, p);
        return sortCollatingSequencePhrase;
    }

    @Override
    public Cobol visitSortGiving(Cobol.SortGiving sortGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(sortGiving, Space.Location.SORT_GIVING_PREFIX, p);
        this.visit(sortGiving.getFileName(), p);
        this.visit(sortGiving.getWords(), p);
        this.afterSyntax(sortGiving, p);
        return sortGiving;
    }

    @Override
    public Cobol visitSortProcedurePhrase(Cobol.SortProcedurePhrase sortProcedurePhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(sortProcedurePhrase, Space.Location.SORT_PROCEDURE_PHRASE_PREFIX, p);
        this.visit(sortProcedurePhrase.getWords(), p);
        this.visit(sortProcedurePhrase.getProcedureName(), p);
        this.visit(sortProcedurePhrase.getSortInputThrough(), p);
        this.afterSyntax(sortProcedurePhrase, p);
        return sortProcedurePhrase;
    }

    @Override
    public Cobol visitSortable(Cobol.Sortable sortable, PrintOutputCapture<P> p) {
        this.beforeSyntax(sortable, Space.Location.SORTABLE_PREFIX, p);
        this.visit(sortable.getWords(), p);
        this.visit(sortable.getNames(), p);
        this.afterSyntax(sortable, p);
        return sortable;
    }

    @Override
    public Cobol visitSourceComputer(Cobol.SourceComputer sourceComputer, PrintOutputCapture<P> p) {
        this.beforeSyntax(sourceComputer, Space.Location.SOURCE_COMPUTER_PREFIX, p);
        this.visit(sourceComputer.getWords(), p);
        this.visit(sourceComputer.getComputer(), p);
        this.afterSyntax(sourceComputer, p);
        return sourceComputer;
    }

    @Override
    public Cobol visitSourceComputerDefinition(Cobol.SourceComputerDefinition sourceComputerDefinition, PrintOutputCapture<P> p) {
        this.beforeSyntax(sourceComputerDefinition, Space.Location.SOURCE_COMPUTER_DEFINITION_PREFIX, p);
        this.visit(sourceComputerDefinition.getComputerName(), p);
        this.visit(sourceComputerDefinition.getDebuggingMode(), p);
        this.visit(sourceComputerDefinition.getDot(), p);
        this.afterSyntax(sourceComputerDefinition, p);
        return sourceComputerDefinition;
    }

    @Override
    public Space visitSpace(Space space, Space.Location location, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        return space;
    }

    @Override
    public Cobol visitSpecialNames(Cobol.SpecialNames specialNames, PrintOutputCapture<P> p) {
        this.beforeSyntax(specialNames, Space.Location.SPECIAL_NAMES_PREFIX, p);
        this.visit(specialNames.getWord(), p);
        this.visit(specialNames.getDot(), p);
        this.visit(specialNames.getClauses(), p);
        this.visit(specialNames.getDot2(), p);
        this.afterSyntax(specialNames, p);
        return specialNames;
    }

    @Override
    public Cobol visitSpecialRegister(Cobol.SpecialRegister specialRegister, PrintOutputCapture<P> p) {
        this.beforeSyntax(specialRegister, Space.Location.SPECIAL_REGISTER_PREFIX, p);
        this.visit(specialRegister.getWords(), p);
        this.visit(specialRegister.getIdentifier(), p);
        this.afterSyntax(specialRegister, p);
        return specialRegister;
    }

    @Override
    public Cobol visitStart(Cobol.Start start, PrintOutputCapture<P> p) {
        this.beforeSyntax(start, Space.Location.START_PREFIX, p);
        this.visit(start.getStart(), p);
        this.visit(start.getFileName(), p);
        this.visit(start.getStartKey(), p);
        this.visit(start.getInvalidKeyPhrase(), p);
        this.visit(start.getNotInvalidKeyPhrase(), p);
        this.visit(start.getEndStart(), p);
        this.afterSyntax(start, p);
        return start;
    }

    @Override
    public Cobol visitStartKey(Cobol.StartKey startKey, PrintOutputCapture<P> p) {
        this.beforeSyntax(startKey, Space.Location.START_KEY_PREFIX, p);
        this.visit(startKey.getWords(), p);
        this.visit(startKey.getQualifiedDataName(), p);
        this.afterSyntax(startKey, p);
        return startKey;
    }

    @Override
    public Cobol visitStatementPhrase(Cobol.StatementPhrase statementPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(statementPhrase, Space.Location.STATEMENT_PHRASE_PREFIX, p);
        this.visit(statementPhrase.getPhrases(), p);
        this.visit(statementPhrase.getStatements(), p);
        this.afterSyntax(statementPhrase, p);
        return statementPhrase;
    }

    @Override
    public Cobol visitStatusKeyClause(Cobol.StatusKeyClause statusKeyClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(statusKeyClause, Space.Location.STATUS_KEY_CLAUSE_PREFIX, p);
        this.visit(statusKeyClause.getWords(), p);
        this.visit(statusKeyClause.getName(), p);
        this.afterSyntax(statusKeyClause, p);
        return statusKeyClause;
    }

    @Override
    public Cobol visitStop(Cobol.Stop stop, PrintOutputCapture<P> p) {
        this.beforeSyntax(stop, Space.Location.STOP_PREFIX, p);
        this.visit(stop.getWords(), p);
        this.visit(stop.getStatement(), p);
        this.afterSyntax(stop, p);
        return stop;
    }

    @Override
    public Cobol visitStopStatementGiving(Cobol.StopStatementGiving stopStatementGiving, PrintOutputCapture<P> p) {
        this.beforeSyntax(stopStatementGiving, Space.Location.STOP_STATEMENT_GIVING_PREFIX, p);
        this.visit(stopStatementGiving.getWords(), p);
        this.visit(stopStatementGiving.getName(), p);
        this.afterSyntax(stopStatementGiving, p);
        return stopStatementGiving;
    }

    @Override
    public Cobol visitStringDelimitedByPhrase(Cobol.StringDelimitedByPhrase stringDelimitedByPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringDelimitedByPhrase, Space.Location.STRING_DELIMITED_BY_PHRASE_PREFIX, p);
        this.visit(stringDelimitedByPhrase.getWords(), p);
        this.visit(stringDelimitedByPhrase.getIdentifier(), p);
        this.afterSyntax(stringDelimitedByPhrase, p);
        return stringDelimitedByPhrase;
    }

    @Override
    public Cobol visitStringForPhrase(Cobol.StringForPhrase stringForPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringForPhrase, Space.Location.STRING_FOR_PHRASE_PREFIX, p);
        this.visit(stringForPhrase.getWord(), p);
        this.visit(stringForPhrase.getIdentifier(), p);
        this.afterSyntax(stringForPhrase, p);
        return stringForPhrase;
    }

    @Override
    public Cobol visitStringIntoPhrase(Cobol.StringIntoPhrase stringIntoPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringIntoPhrase, Space.Location.STRING_INTO_PHRASE_PREFIX, p);
        this.visit(stringIntoPhrase.getInto(), p);
        this.visit(stringIntoPhrase.getIdentifier(), p);
        this.afterSyntax(stringIntoPhrase, p);
        return stringIntoPhrase;
    }

    @Override
    public Cobol visitStringSendingPhrase(Cobol.StringSendingPhrase stringSendingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringSendingPhrase, Space.Location.STRING_SENDING_PHRASE_PREFIX, p);
        this.visit(stringSendingPhrase.getSendings(), p);
        this.visit(stringSendingPhrase.getPhrase(), p);
        this.afterSyntax(stringSendingPhrase, p);
        return stringSendingPhrase;
    }

    @Override
    public Cobol visitStringStatement(Cobol.StringStatement stringStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringStatement, Space.Location.STRING_STATEMENT_PREFIX, p);
        this.visit(stringStatement.getString(), p);
        this.visit(stringStatement.getStringSendingPhrases(), p);
        this.visit(stringStatement.getStringIntoPhrase(), p);
        this.visit(stringStatement.getStringWithPointerPhrase(), p);
        this.visit(stringStatement.getOnOverflowPhrase(), p);
        this.visit(stringStatement.getNotOnOverflowPhrase(), p);
        this.visit(stringStatement.getEndString(), p);
        this.afterSyntax(stringStatement, p);
        return stringStatement;
    }

    @Override
    public Cobol visitStringWithPointerPhrase(Cobol.StringWithPointerPhrase stringWithPointerPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringWithPointerPhrase, Space.Location.STRING_WITH_POINTER_PHRASE_PREFIX, p);
        this.visit(stringWithPointerPhrase.getWords(), p);
        this.visit(stringWithPointerPhrase.getQualifiedDataName(), p);
        this.afterSyntax(stringWithPointerPhrase, p);
        return stringWithPointerPhrase;
    }

    @Override
    public Cobol visitSubscript(Cobol.Subscript subscript, PrintOutputCapture<P> p) {
        this.beforeSyntax(subscript, Space.Location.SUBSCRIPT_PREFIX, p);
        this.visit(subscript.getFirst(), p);
        this.visit(subscript.getSecond(), p);
        this.afterSyntax(subscript, p);
        return subscript;
    }

    @Override
    public Cobol visitSubtract(Cobol.Subtract subtract, PrintOutputCapture<P> p) {
        this.beforeSyntax(subtract, Space.Location.SUBTRACT_PREFIX, p);
        this.visit(subtract.getSubstract(), p);
        this.visit(subtract.getOperation(), p);
        this.visit(subtract.getOnSizeErrorPhrase(), p);
        this.visit(subtract.getNotOnSizeErrorPhrase(), p);
        this.visit(subtract.getEndSubtract(), p);
        this.afterSyntax(subtract, p);
        return subtract;
    }

    @Override
    public Cobol visitSubtractCorrespondingStatement(Cobol.SubtractCorrespondingStatement subtractCorrespondingStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(subtractCorrespondingStatement, Space.Location.SUBTRACT_CORRESPONDING_STATEMENT_PREFIX, p);
        this.visit(subtractCorrespondingStatement.getCorresponding(), p);
        this.visit(subtractCorrespondingStatement.getQualifiedDataName(), p);
        this.visit(subtractCorrespondingStatement.getFrom(), p);
        this.visit(subtractCorrespondingStatement.getSubtractMinuendCorresponding(), p);
        this.afterSyntax(subtractCorrespondingStatement, p);
        return subtractCorrespondingStatement;
    }

    @Override
    public Cobol visitSubtractFromGivingStatement(Cobol.SubtractFromGivingStatement subtractFromGivingStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(subtractFromGivingStatement, Space.Location.SUBTRACT_FROM_GIVING_STATEMENT_PREFIX, p);
        this.visit(subtractFromGivingStatement.getSubtractSubtrahend(), p);
        this.visit(subtractFromGivingStatement.getFrom(), p);
        this.visit(subtractFromGivingStatement.getSubtractMinuendGiving(), p);
        this.visit(subtractFromGivingStatement.getGiving(), p);
        this.visit(subtractFromGivingStatement.getSubtractGiving(), p);
        this.afterSyntax(subtractFromGivingStatement, p);
        return subtractFromGivingStatement;
    }

    @Override
    public Cobol visitSubtractFromStatement(Cobol.SubtractFromStatement subtractFromStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(subtractFromStatement, Space.Location.SUBTRACT_FROM_STATEMENT_PREFIX, p);
        this.visit(subtractFromStatement.getSubtractSubtrahend(), p);
        this.visit(subtractFromStatement.getFrom(), p);
        this.visit(subtractFromStatement.getSubtractMinuend(), p);
        this.afterSyntax(subtractFromStatement, p);
        return subtractFromStatement;
    }

    @Override
    public Cobol visitSubtractMinuendCorresponding(Cobol.SubtractMinuendCorresponding subtractMinuendCorresponding, PrintOutputCapture<P> p) {
        this.beforeSyntax(subtractMinuendCorresponding, Space.Location.SUBTRACT_MINUEND_CORRESPONDING_PREFIX, p);
        this.visit(subtractMinuendCorresponding.getQualifiedDataName(), p);
        this.visit(subtractMinuendCorresponding.getRounded(), p);
        this.afterSyntax(subtractMinuendCorresponding, p);
        return subtractMinuendCorresponding;
    }

    @Override
    public Cobol visitSymbolicCharacter(Cobol.SymbolicCharacter symbolicCharacter, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicCharacter, Space.Location.SYMBOLIC_CHARACTER_PREFIX, p);
        this.visit(symbolicCharacter.getSymbols(), p);
        this.visit(symbolicCharacter.getWord(), p);
        this.visit(symbolicCharacter.getLiterals(), p);
        this.afterSyntax(symbolicCharacter, p);
        return symbolicCharacter;
    }

    @Override
    public Cobol visitSymbolicCharactersClause(Cobol.SymbolicCharactersClause symbolicCharactersClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicCharactersClause, Space.Location.SYMBOLIC_CHARACTERS_CLAUSE_PREFIX, p);
        this.visit(symbolicCharactersClause.getWords(), p);
        this.visit(symbolicCharactersClause.getSymbols(), p);
        this.visit(symbolicCharactersClause.getInAlphabet(), p);
        this.visit(symbolicCharactersClause.getAlphabetName(), p);
        this.afterSyntax(symbolicCharactersClause, p);
        return symbolicCharactersClause;
    }

    @Override
    public Cobol visitSymbolicDestinationClause(Cobol.SymbolicDestinationClause symbolicDestinationClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicDestinationClause, Space.Location.SYMBOLIC_DESTINATION_CLAUSE_PREFIX, p);
        this.visit(symbolicDestinationClause.getWords(), p);
        this.visit(symbolicDestinationClause.getDataDescName(), p);
        this.afterSyntax(symbolicDestinationClause, p);
        return symbolicDestinationClause;
    }

    @Override
    public Cobol visitSymbolicQueueClause(Cobol.SymbolicQueueClause symbolicQueueClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicQueueClause, Space.Location.SYMBOLIC_QUEUE_CLAUSE_PREFIX, p);
        this.visit(symbolicQueueClause.getWords(), p);
        this.visit(symbolicQueueClause.getDataDescName(), p);
        this.afterSyntax(symbolicQueueClause, p);
        return symbolicQueueClause;
    }

    @Override
    public Cobol visitSymbolicSourceClause(Cobol.SymbolicSourceClause symbolicSourceClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicSourceClause, Space.Location.SYMBOLIC_SOURCE_CLAUSE_PREFIX, p);
        this.visit(symbolicSourceClause.getWords(), p);
        this.visit(symbolicSourceClause.getDataDescName(), p);
        this.afterSyntax(symbolicSourceClause, p);
        return symbolicSourceClause;
    }

    @Override
    public Cobol visitSymbolicSubQueueClause(Cobol.SymbolicSubQueueClause symbolicSubQueueClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicSubQueueClause, Space.Location.SYMBOLIC_SUB_QUEUE_CLAUSE_PREFIX, p);
        this.visit(symbolicSubQueueClause.getWords(), p);
        this.visit(symbolicSubQueueClause.getDataDescName(), p);
        this.afterSyntax(symbolicSubQueueClause, p);
        return symbolicSubQueueClause;
    }

    @Override
    public Cobol visitSymbolicTerminalClause(Cobol.SymbolicTerminalClause symbolicTerminalClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(symbolicTerminalClause, Space.Location.SYMBOLIC_TERMINAL_CLAUSE_PREFIX, p);
        this.visit(symbolicTerminalClause.getWords(), p);
        this.visit(symbolicTerminalClause.getDataDescName(), p);
        this.afterSyntax(symbolicTerminalClause, p);
        return symbolicTerminalClause;
    }

    @Override
    public Cobol visitTableCall(Cobol.TableCall tableCall, PrintOutputCapture<P> p) {
        this.beforeSyntax(tableCall, Space.Location.TABLE_CLAUSE_PREFIX, p);
        this.visit(tableCall.getQualifiedDataName(), p);
        this.visit(tableCall.getSubscripts(), p);
        this.visit(tableCall.getReferenceModifier(), p);
        this.afterSyntax(tableCall, p);
        return tableCall;
    }

    @Override
    public Cobol visitTerminate(Cobol.Terminate terminate, PrintOutputCapture<P> p) {
        this.beforeSyntax(terminate, Space.Location.TERMINATE_PREFIX, p);
        this.visit(terminate.getTerminate(), p);
        this.visit(terminate.getReportName(), p);
        this.afterSyntax(terminate, p);
        return terminate;
    }

    @Override
    public Cobol visitTextLengthClause(Cobol.TextLengthClause textLengthClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(textLengthClause, Space.Location.TEXT_LENGTH_CLAUSE_PREFIX, p);
        this.visit(textLengthClause.getWords(), p);
        this.visit(textLengthClause.getDataDescName(), p);
        this.afterSyntax(textLengthClause, p);
        return textLengthClause;
    }

    @Override
    public Cobol visitUnString(Cobol.UnString unString, PrintOutputCapture<P> p) {
        this.beforeSyntax(unString, Space.Location.UNSTRING_PREFIX, p);
        this.visit(unString.getUnstring(), p);
        this.visit(unString.getUnstringSendingPhrase(), p);
        this.visit(unString.getUnstringIntoPhrase(), p);
        this.visit(unString.getUnstringWithPointerPhrase(), p);
        this.visit(unString.getUnstringTallyingPhrase(), p);
        this.visit(unString.getOnOverflowPhrase(), p);
        this.visit(unString.getNotOnOverflowPhrase(), p);
        this.visit(unString.getEndUnstring(), p);
        this.afterSyntax(unString, p);
        return unString;
    }

    @Override
    public Cobol visitUnstringCountIn(Cobol.UnstringCountIn unstringCountIn, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringCountIn, Space.Location.UNSTRING_COUNT_IN_PREFIX, p);
        this.visit(unstringCountIn.getWords(), p);
        this.visit(unstringCountIn.getIdentifier(), p);
        this.afterSyntax(unstringCountIn, p);
        return unstringCountIn;
    }

    @Override
    public Cobol visitUnstringDelimitedByPhrase(Cobol.UnstringDelimitedByPhrase unstringDelimitedByPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringDelimitedByPhrase, Space.Location.UNSTRING_DELIMITED_BY_PHRASE_PREFIX, p);
        this.visit(unstringDelimitedByPhrase.getWords(), p);
        this.visit(unstringDelimitedByPhrase.getName(), p);
        this.afterSyntax(unstringDelimitedByPhrase, p);
        return unstringDelimitedByPhrase;
    }

    @Override
    public Cobol visitUnstringDelimiterIn(Cobol.UnstringDelimiterIn unstringDelimiterIn, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringDelimiterIn, Space.Location.UNSTRING_DELIMITED_IN_PREFIX, p);
        this.visit(unstringDelimiterIn.getWords(), p);
        this.visit(unstringDelimiterIn.getIdentifier(), p);
        this.afterSyntax(unstringDelimiterIn, p);
        return unstringDelimiterIn;
    }

    @Override
    public Cobol visitUnstringInto(Cobol.UnstringInto unstringInto, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringInto, Space.Location.UNSTRING_INTO_PREFIX, p);
        this.visit(unstringInto.getIdentifier(), p);
        this.visit(unstringInto.getUnstringDelimiterIn(), p);
        this.visit(unstringInto.getUnstringCountIn(), p);
        this.afterSyntax(unstringInto, p);
        return unstringInto;
    }

    @Override
    public Cobol visitUnstringIntoPhrase(Cobol.UnstringIntoPhrase unstringIntoPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringIntoPhrase, Space.Location.UNSTRING_INTO_PHRASE_PREFIX, p);
        this.visit(unstringIntoPhrase.getInto(), p);
        this.visit(unstringIntoPhrase.getUnstringIntos(), p);
        this.afterSyntax(unstringIntoPhrase, p);
        return unstringIntoPhrase;
    }

    @Override
    public Cobol visitUnstringOrAllPhrase(Cobol.UnstringOrAllPhrase unstringOrAllPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringOrAllPhrase, Space.Location.UNSTRING_OR_ALL_PHRASE_PREFIX, p);
        this.visit(unstringOrAllPhrase.getWords(), p);
        this.visit(unstringOrAllPhrase.getName(), p);
        this.afterSyntax(unstringOrAllPhrase, p);
        return unstringOrAllPhrase;
    }

    @Override
    public Cobol visitUnstringSendingPhrase(Cobol.UnstringSendingPhrase unstringSendingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringSendingPhrase, Space.Location.UNSTRING_SENDING_PHRASE_PREFIX, p);
        this.visit(unstringSendingPhrase.getIdentifier(), p);
        this.visit(unstringSendingPhrase.getUnstringDelimitedByPhrase(), p);
        this.visit(unstringSendingPhrase.getUnstringOrAllPhrases(), p);
        this.afterSyntax(unstringSendingPhrase, p);
        return unstringSendingPhrase;
    }

    @Override
    public Cobol visitUnstringTallyingPhrase(Cobol.UnstringTallyingPhrase unstringTallyingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringTallyingPhrase, Space.Location.UNSTRING_TALLYING_PHRASE_PREFIX, p);
        this.visit(unstringTallyingPhrase.getWords(), p);
        this.visit(unstringTallyingPhrase.getQualifiedDataName(), p);
        this.afterSyntax(unstringTallyingPhrase, p);
        return unstringTallyingPhrase;
    }

    @Override
    public Cobol visitUnstringWithPointerPhrase(Cobol.UnstringWithPointerPhrase unstringWithPointerPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(unstringWithPointerPhrase, Space.Location.UNSTRING_WITH_POINTER_PHRASE_PREFIX, p);
        this.visit(unstringWithPointerPhrase.getWords(), p);
        this.visit(unstringWithPointerPhrase.getQualifiedDataName(), p);
        this.afterSyntax(unstringWithPointerPhrase, p);
        return unstringWithPointerPhrase;
    }

    @Override
    public Cobol visitUseAfterClause(Cobol.UseAfterClause useAfterClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(useAfterClause, Space.Location.USE_AFTER_CLAUSE_PREFIX, p);
        this.visit(useAfterClause.getWords(), p);
        this.visit(useAfterClause.getUseAfterOn(), p);
        this.afterSyntax(useAfterClause, p);
        return useAfterClause;
    }

    @Override
    public Cobol visitUseAfterOn(Cobol.UseAfterOn useAfterOn, PrintOutputCapture<P> p) {
        this.beforeSyntax(useAfterOn, Space.Location.USE_AFTER_ON_PREFIX, p);
        this.visit(useAfterOn.getAfterOn(), p);
        this.visit(useAfterOn.getFileNames(), p);
        this.afterSyntax(useAfterOn, p);
        return useAfterOn;
    }

    @Override
    public Cobol visitUseDebugClause(Cobol.UseDebugClause useDebugClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(useDebugClause, Space.Location.USE_DEBUG_CLAUSE_PREFIX, p);
        this.visit(useDebugClause.getWords(), p);
        this.visit(useDebugClause.getUseDebugs(), p);
        this.afterSyntax(useDebugClause, p);
        return useDebugClause;
    }

    @Override
    public Cobol visitUseDebugOn(Cobol.UseDebugOn useDebugOn, PrintOutputCapture<P> p) {
        this.beforeSyntax(useDebugOn, Space.Location.USE_DEBUG_ON_PREFIX, p);
        this.visit(useDebugOn.getWords(), p);
        this.visit(useDebugOn.getName(), p);
        this.afterSyntax(useDebugOn, p);
        return useDebugOn;
    }

    @Override
    public Cobol visitUseStatement(Cobol.UseStatement useStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(useStatement, Space.Location.USE_STATEMENT_PREFIX, p);
        this.visit(useStatement.getUse(), p);
        this.visit(useStatement.getClause(), p);
        this.afterSyntax(useStatement, p);
        return useStatement;
    }

    @Override
    public Cobol visitValueOfClause(Cobol.ValueOfClause valueOfClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(valueOfClause, Space.Location.VALUE_OF_CLAUSE_PREFIX, p);
        this.visit(valueOfClause.getValueOf(), p);
        this.visit(valueOfClause.getValuePairs(), p);
        this.afterSyntax(valueOfClause, p);
        return valueOfClause;
    }

    @Override
    public Cobol visitValuePair(Cobol.ValuePair valuePair, PrintOutputCapture<P> p) {
        this.beforeSyntax(valuePair, Space.Location.VALUE_PAIR_PREFIX, p);
        this.visit(valuePair.getSystemName(), p);
        this.visit(valuePair.getIs(), p);
        this.visit(valuePair.getName(), p);
        this.afterSyntax(valuePair, p);
        return valuePair;
    }

    @Override
    public Cobol visitValuedObjectComputerClause(Cobol.ValuedObjectComputerClause valuedObjectComputerClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(valuedObjectComputerClause, Space.Location.VALUE_OBJECT_COMPUTER_CLAUSE_PREFIX, p);
        this.visit(valuedObjectComputerClause.getWords(), p);
        this.visit(valuedObjectComputerClause.getValue(), p);
        this.visit(valuedObjectComputerClause.getUnits(), p);
        this.afterSyntax(valuedObjectComputerClause, p);
        return valuedObjectComputerClause;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Cobol visitWord(Cobol.Word word, PrintOutputCapture<P> p) {
        CopybookSource copybookSource = null;
        CobolPreprocessor.CopyStatement copyStatement = null;
        for (CobolPreprocessor preprocessorStatement : word.getPreprocessorStatements()) {
            if (preprocessorStatement instanceof CopybookSource) {
                if (preprocessorStatement.getMarkers().findFirst(CopiedStatement.class).isPresent()) continue;
                copybookSource = (CopybookSource)((Object)preprocessorStatement);
                this.getCobolPreprocessorVisitor().visit((CobolPreprocessor)((Object)copybookSource), p);
                if (((CobolPreprocessor)((Object)copybookSource)).getMarkers().findFirst(MissingCopybook.class).isPresent()) continue;
                return word;
            }
            if (preprocessorStatement instanceof CobolPreprocessor.CopyStatement) {
                if (preprocessorStatement.getMarkers().findFirst(CopiedStatement.class).isPresent()) continue;
                copyStatement = (CobolPreprocessor.CopyStatement)preprocessorStatement;
                this.getCobolPreprocessorVisitor().visit(copyStatement, p);
                if (copyStatement.getMarkers().findFirst(MissingCopybook.class).isPresent()) continue;
                return word;
            }
            this.getCobolPreprocessorVisitor().visit(preprocessorStatement, p);
        }
        if (copyStatement == null && copybookSource == null && word.getMarkers().findFirst(CopiedWord.class).isPresent()) {
            return word;
        }
        if (word.getReplacement() != null && copybookSource == null && copyStatement == null) {
            if (word.getReplacement().getType() == Replacement.Type.EQUAL) {
                int startLength = p.getOut().length();
                Replacement.OriginalWord originalWord = word.getReplacement().getOriginalWords().get(0);
                this.visit(originalWord.getOriginal(), p);
                int endLength = p.getOut().length();
                if (!originalWord.isReplacedWithEmpty()) {
                    this.originalReplaceLength = 0;
                    return word;
                }
                this.originalReplaceLength = endLength - startLength;
            } else {
                if (word.getReplacement().getType() == Replacement.Type.ADDITIVE) {
                    return word;
                }
                if (word.getReplacement().getType() == Replacement.Type.REDUCTIVE && !word.getReplacement().isCopiedSource()) {
                    for (Replacement.OriginalWord originalWord : word.getReplacement().getOriginalWords()) {
                        this.visit(originalWord.getOriginal(), p);
                    }
                    if (word.getSequenceArea() != null) {
                        word.getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
                    }
                    if (word.getIndicatorArea() != null) {
                        word.getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
                    }
                    this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
                    p.append(word.getWord());
                    return word;
                }
            }
        }
        if (this.printColumns && word.getLines() != null) {
            for (CobolLine cobolLine : word.getLines()) {
                this.visitMarkers(cobolLine.getMarkers(), p);
                cobolLine.printCobolLine(this, this.getCursor(), p);
            }
        }
        if (word.getContinuation() != null) {
            word.getContinuation().printContinuation(this, this.getCursor(), word, this.printColumns, p);
        } else {
            if (word.getSequenceArea() != null) {
                word.getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (word.getIndicatorArea() != null) {
                word.getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (word.getReplacement() != null && word.getReplacement().getType() == Replacement.Type.EQUAL && word.getReplacement().getOriginalWords().get(0).isReplacedWithEmpty()) {
                p.append(StringUtils.repeat((String)" ", (int)(word.getPrefix().getWhitespace().length() - this.originalReplaceLength)));
                this.originalReplaceLength = 0;
            } else {
                this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
            }
            p.append(word.getWord());
            if (word.getCommentArea() != null && !word.getCommentArea().isAdded()) {
                word.getCommentArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
        }
        this.afterSyntax(word, p);
        return word;
    }

    @Override
    public Cobol visitWorkingStorageSection(Cobol.WorkingStorageSection workingStorageSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(workingStorageSection, Space.Location.WORKING_STORAGE_SECTION_PREFIX, p);
        this.visit(workingStorageSection.getWords(), p);
        this.visit(workingStorageSection.getDot(), p);
        this.visit(workingStorageSection.getDataDescriptions(), p);
        this.afterSyntax(workingStorageSection, p);
        return workingStorageSection;
    }

    @Override
    public Cobol visitWrite(Cobol.Write write, PrintOutputCapture<P> p) {
        this.beforeSyntax(write, Space.Location.WRITE_PREFIX, p);
        this.visit(write.getWrite(), p);
        this.visit(write.getRecordName(), p);
        this.visit(write.getWriteFromPhrase(), p);
        this.visit(write.getWriteAdvancingPhrase(), p);
        this.visit(write.getWriteAtEndOfPagePhrase(), p);
        this.visit(write.getWriteNotAtEndOfPagePhrase(), p);
        this.visit(write.getInvalidKeyPhrase(), p);
        this.visit(write.getNotInvalidKeyPhrase(), p);
        this.visit(write.getEndWrite(), p);
        this.afterSyntax(write, p);
        return write;
    }

    @Override
    public Cobol visitWriteAdvancingLines(Cobol.WriteAdvancingLines writeAdvancingLines, PrintOutputCapture<P> p) {
        this.beforeSyntax(writeAdvancingLines, Space.Location.WRITE_ADVANCING_LINES_PREFIX, p);
        this.visit(writeAdvancingLines.getName(), p);
        this.visit(writeAdvancingLines.getWord(), p);
        this.afterSyntax(writeAdvancingLines, p);
        return writeAdvancingLines;
    }

    @Override
    public Cobol visitWriteAdvancingMnemonic(Cobol.WriteAdvancingMnemonic writeAdvancingMnemonic, PrintOutputCapture<P> p) {
        this.beforeSyntax(writeAdvancingMnemonic, Space.Location.WRITE_ADVANCING_MNEMONIC_PREFIX, p);
        this.visit(writeAdvancingMnemonic.getName(), p);
        this.afterSyntax(writeAdvancingMnemonic, p);
        return writeAdvancingMnemonic;
    }

    @Override
    public Cobol visitWriteAdvancingPage(Cobol.WriteAdvancingPage writeAdvancingPage, PrintOutputCapture<P> p) {
        this.beforeSyntax(writeAdvancingPage, Space.Location.WRITE_ADVANCING_PAGE_PREFIX, p);
        this.visit(writeAdvancingPage.getPage(), p);
        this.afterSyntax(writeAdvancingPage, p);
        return writeAdvancingPage;
    }

    @Override
    public Cobol visitWriteAdvancingPhrase(Cobol.WriteAdvancingPhrase writeAdvancingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(writeAdvancingPhrase, Space.Location.WRITE_ADVANCING_PHRASE_PREFIX, p);
        this.visit(writeAdvancingPhrase.getWords(), p);
        this.visit(writeAdvancingPhrase.getWriteBy(), p);
        this.afterSyntax(writeAdvancingPhrase, p);
        return writeAdvancingPhrase;
    }

    @Override
    public Cobol visitWriteFromPhrase(Cobol.WriteFromPhrase writeFromPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(writeFromPhrase, Space.Location.WRITE_FROM_PHRASE_PREFIX, p);
        this.visit(writeFromPhrase.getFrom(), p);
        this.visit(writeFromPhrase.getName(), p);
        this.afterSyntax(writeFromPhrase, p);
        return writeFromPhrase;
    }

    protected void beforeSyntax(Cobol c, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(c.getPrefix(), c.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(Cobol c, PrintOutputCapture<P> p) {
        this.afterSyntax(c.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
    }
}

