/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;

public class CobolPrinter<P>
extends CobolSourcePrinter<P> {
    private final boolean printColumns;
    private final boolean printOriginalSource;
    private Replacement additiveReplacement = null;

    public CobolPrinter(boolean printColumns, boolean printOriginalSource) {
        super(printColumns);
        this.printColumns = printColumns;
        this.printOriginalSource = printOriginalSource;
    }

    @Override
    public Cobol visitWord(Cobol.Word word, PrintOutputCapture<P> p) {
        if (this.printOriginalSource) {
            return super.visitWord(word, p);
        }
        if (this.printColumns && word.getLines() != null) {
            for (CobolLine cobolLine : word.getLines()) {
                this.visitMarkers(cobolLine.getMarkers(), p);
                cobolLine.printCobolLine(this, this.getCursor(), p);
            }
        }
        if (this.additiveReplacement == null && word.getReplacement() != null && word.getReplacement().getType() == Replacement.Type.ADDITIVE) {
            this.additiveReplacement = word.getReplacement();
        } else if (this.additiveReplacement != null && word.getReplacement() != null && word.getReplacement().getType() == Replacement.Type.ADDITIVE && this.additiveReplacement.getId() != word.getReplacement().getId()) {
            this.additiveReplacement = word.getReplacement();
            p.append("\n");
        } else if (this.additiveReplacement != null && word.getReplacement() == null) {
            this.additiveReplacement = null;
            p.append("\n");
        }
        if (word.getSequenceArea() != null) {
            word.getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
        }
        if (word.getIndicatorArea() != null) {
            word.getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
        }
        if (word.getContinuation() != null && this.printColumns) {
            word.getContinuation().printContinuation(this, this.getCursor(), word, this.printColumns, p);
        } else {
            this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
            p.append(word.getWord());
        }
        if (word.getCommentArea() != null && !word.getCommentArea().isAdded()) {
            word.getCommentArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
        }
        this.afterSyntax(word, p);
        return word;
    }
}

