/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolPrinter;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Space;

public class CobolPreprocessorPrinter<P>
extends CobolPreprocessorSourcePrinter<P> {
    private final CobolPrinter<P> cobolPrinter;
    private final boolean printOriginalSource;

    public CobolPreprocessorPrinter(boolean printOriginalSource, boolean printColumns) {
        super(printColumns);
        this.cobolPrinter = new CobolPrinter(printColumns, printOriginalSource);
        this.printOriginalSource = printOriginalSource;
    }

    @Override
    public CobolPreprocessor visitCopybook(CobolPreprocessor.Copybook copybook, PrintOutputCapture<P> p) {
        this.beforeSyntax(copybook, Space.Location.COPY_BOOK_PREFIX, p);
        this.visit(copybook.getLst(), p);
        this.afterSyntax(copybook, p);
        return copybook;
    }

    @Override
    public CobolPreprocessor visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, PrintOutputCapture<P> p) {
        if (this.printOriginalSource) {
            return super.visitCopyStatement(copyStatement, p);
        }
        if (copyStatement.getCopybook() != null) {
            this.beforeSyntax(copyStatement, Space.Location.COPY_STATEMENT_PREFIX, p);
            this.visit(copyStatement.getCopybook(), p);
            if (!p.getOut().endsWith("\n")) {
                p.append("\n");
            }
            this.afterSyntax(copyStatement, p);
        }
        return copyStatement;
    }

    @Override
    public CobolPreprocessor visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, PrintOutputCapture<P> p) {
        if (this.printOriginalSource) {
            return super.visitExecSqlIncludeStatement(execSqlIncludeStatement, p);
        }
        if (execSqlIncludeStatement.getCopybook() != null) {
            this.beforeSyntax(execSqlIncludeStatement, Space.Location.EXEC_SQL_INCLUDE_STATEMENT_PREFIX, p);
            this.visit(execSqlIncludeStatement.getCopybook(), p);
            if (!p.getOut().endsWith("\n")) {
                p.append("\n");
            }
            this.afterSyntax(execSqlIncludeStatement, p);
        }
        return execSqlIncludeStatement;
    }

    @Override
    public CobolPreprocessor visitWord(CobolPreprocessor.Word word, PrintOutputCapture<P> p) {
        if (this.printOriginalSource) {
            return super.visitWord(word, p);
        }
        this.cobolPrinter.visitWord(word.getCobolWord(), p);
        this.afterSyntax(word, p);
        return word;
    }
}

