/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.format;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.CobolPrinterUtils;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.search.FindWords;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.cobol.tree.Continuation;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.internal.ListUtils;

@Incubating(since="0.0")
public final class RemoveWords
extends CobolIsoVisitor<ExecutionContext> {
    private final List<Cobol.Word> removeWords;

    public RemoveWords(Cobol tree) {
        this.removeWords = FindWords.find(tree);
    }

    public RemoveWords(List<Cobol.Word> removeWords) {
        this.removeWords = removeWords;
    }

    @Override
    public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
        Cobol w = super.visitWord(word, executionContext);
        if (this.removeWords.contains(w) && !((Cobol.Word)w).getWord().trim().isEmpty()) {
            if (word.getReplacement() != null || word.getMarkers().findFirst(CopiedWord.class).isPresent()) {
                throw new UnsupportedOperationException("RemoveWords does not support changes on copied sources or replaced words.");
            }
            if (word.getContinuation() != null) {
                Continuation continuation = word.getContinuation();
                HashMap<Integer, List<ColumnArea>> continuations = new HashMap<Integer, List<ColumnArea>>(continuation.getContinuations().size());
                AtomicBoolean changed = new AtomicBoolean(false);
                for (Map.Entry<Integer, List<ColumnArea>> entry : continuation.getContinuations().entrySet()) {
                    List columnAreas = ListUtils.map(entry.getValue(), it -> {
                        if (it instanceof IndicatorArea && "-".equals(((IndicatorArea)it).getIndicator())) {
                            it = ((IndicatorArea)it).withIndicator(" ");
                            changed.set(true);
                        }
                        return it;
                    });
                    continuations.put(entry.getKey(), columnAreas);
                }
                if (changed.get()) {
                    continuation = continuation.withContinuations(continuations);
                    w = ((Cobol.Word)w).withContinuation(continuation);
                }
            }
            w = ((Cobol.Word)w).withWord(CobolPrinterUtils.fillArea(Character.valueOf(' '), ((Cobol.Word)w).getWord().length()));
        }
        return w;
    }

    public List<Cobol.Word> getRemoveWords() {
        return this.removeWords;
    }

    public String toString() {
        return "RemoveWords(removeWords=" + this.getRemoveWords() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveWords)) {
            return false;
        }
        RemoveWords other = (RemoveWords)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Cobol.Word> this$removeWords = this.getRemoveWords();
        List<Cobol.Word> other$removeWords = other.getRemoveWords();
        return !(this$removeWords == null ? other$removeWords != null : !((Object)this$removeWords).equals(other$removeWords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveWords;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Cobol.Word> $removeWords = this.getRemoveWords();
        result = result * 59 + ($removeWords == null ? 43 : ((Object)$removeWords).hashCode());
        return result;
    }
}

