/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.cobol.CobolPreprocessorParser;
import org.openrewrite.cobol.CopybookParser;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public class PreprocessorAssertions {
    private PreprocessorAssertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
    }

    public static SourceSpecs cobolPreprocess(@Nullable String before) {
        return PreprocessorAssertions.cobolPreprocess(before, (SourceSpec<CobolPreprocessor.CompilationUnit> s) -> {});
    }

    public static SourceSpecs cobolPreprocess(@Nullable String before, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder(), before, SourceSpec.EachResult.noop, PreprocessorAssertions::customizeExecutionContext);
        PreprocessorAssertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs cobolPreprocess(@Nullable String before, @Nullable String after) {
        return PreprocessorAssertions.cobolPreprocess(before, after, s -> {});
    }

    public static SourceSpecs cobolPreprocess(@Nullable String before, @Nullable String after, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder(), before, SourceSpec.EachResult.noop, PreprocessorAssertions::customizeExecutionContext).after(s -> after);
        PreprocessorAssertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs cobolPreprocessorCopy(@Nullable String before) {
        return PreprocessorAssertions.cobolPreprocessorCopy(before, (SourceSpec<CobolPreprocessor.CompilationUnit> s) -> {});
    }

    public static SourceSpecs cobolPreprocessorCopy(@Nullable String before, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        List<SourceFile> copybooks = PreprocessorAssertions.getCopybookSources();
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder().copybooks(copybooks), before, SourceSpec.EachResult.noop, PreprocessorAssertions::customizeExecutionContext);
        PreprocessorAssertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs cobolPreprocessorCopy(@Nullable String before, @Nullable String after) {
        return PreprocessorAssertions.cobolPreprocessorCopy(before, after, s -> {});
    }

    public static SourceSpecs cobolPreprocessorCopy(@Nullable String before, @Nullable String after, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        List<SourceFile> copybooks = PreprocessorAssertions.getCopybookSources();
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder().copybooks(copybooks), before, SourceSpec.EachResult.noop, PreprocessorAssertions::customizeExecutionContext).after(s -> after);
        PreprocessorAssertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    private static void acceptPreprocessorSpec(Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec, SourceSpec<CobolPreprocessor.CompilationUnit> cobol) {
        ThrowingConsumer userSuppliedAfterRecipe = cobol.getAfterRecipe();
        cobol.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        spec.accept(cobol);
    }

    private static List<SourceFile> getCopybookSources() {
        try (ScanResult scan = new ClassGraph().scan();){
            List<Parser.Input> copyInputs = scan.getResourcesWithExtension("cpy").stream().map(res -> new Parser.Input(Paths.get(res.getPath(), new String[0]), () -> {
                try {
                    return new ByteArrayInputStream(res.getContentAsString().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).collect(Collectors.toList());
            List<SourceFile> list = CopybookParser.builder().build().parseInputs(copyInputs, null, (ExecutionContext)new InMemoryExecutionContext()).collect(Collectors.toList());
            return list;
        }
    }
}

