/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.testcontainers;

import java.util.Comparator;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AddTestcontainersAnnotations
extends Recipe {
    private static final String CLASS_RULE_FQN = "org.junit.ClassRule";
    private static final String RULE_FQN = "org.junit.Rule";
    private static final String GENERIC_CONTAINER_FQN = "org.testcontainers.containers.GenericContainer";
    private static final String TESTCONTAINERS_FQN = "org.testcontainers.junit.jupiter.Testcontainers";
    private static final String CONTAINER_FQN = "org.testcontainers.junit.jupiter.Container";

    public String getDisplayName() {
        return "Adopt `@Container` and add `@Testcontainers`";
    }

    public String getDescription() {
        return "Convert Testcontainers `@Rule`/`@ClassRule` to JUnit 5 `@Container` and add `@Testcontainers`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor usesRule = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(RULE_FQN, Boolean.valueOf(true)), new UsesType(CLASS_RULE_FQN, Boolean.valueOf(true))});
        return Preconditions.check((TreeVisitor)usesRule, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
                if (classDeclaration == cd) {
                    return cd;
                }
                this.maybeRemoveImport(AddTestcontainersAnnotations.RULE_FQN);
                this.maybeRemoveImport(AddTestcontainersAnnotations.CLASS_RULE_FQN);
                if (((AnnotationService)this.service(AnnotationService.class)).isAnnotatedWith((J)cd, AddTestcontainersAnnotations.TESTCONTAINERS_FQN)) {
                    return cd;
                }
                this.maybeAddImport(AddTestcontainersAnnotations.TESTCONTAINERS_FQN);
                return (J.ClassDeclaration)JavaTemplate.builder((String)"@Testcontainers").imports(new String[]{AddTestcontainersAnnotations.TESTCONTAINERS_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"testcontainers-1", "junit-jupiter-1"})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations varDecls, ExecutionContext ctx) {
                if (!TypeUtils.isAssignableTo((String)AddTestcontainersAnnotations.GENERIC_CONTAINER_FQN, (JavaType)varDecls.getType())) {
                    return varDecls;
                }
                if (!((AnnotationService)this.service(AnnotationService.class)).isAnnotatedWith((J)varDecls, AddTestcontainersAnnotations.RULE_FQN) && !((AnnotationService)this.service(AnnotationService.class)).isAnnotatedWith((J)varDecls, AddTestcontainersAnnotations.CLASS_RULE_FQN)) {
                    return varDecls;
                }
                J.VariableDeclarations vd = varDecls.withLeadingAnnotations(ListUtils.filter((List)varDecls.getLeadingAnnotations(), ann -> !TypeUtils.isAssignableTo((String)AddTestcontainersAnnotations.RULE_FQN, (JavaType)ann.getType()) && !TypeUtils.isAssignableTo((String)AddTestcontainersAnnotations.CLASS_RULE_FQN, (JavaType)ann.getType())));
                if (vd == varDecls || ((AnnotationService)this.service(AnnotationService.class)).isAnnotatedWith((J)varDecls, AddTestcontainersAnnotations.CONTAINER_FQN)) {
                    return vd;
                }
                this.maybeAddImport(AddTestcontainersAnnotations.CONTAINER_FQN);
                return (J.VariableDeclarations)JavaTemplate.builder((String)"@Container").imports(new String[]{AddTestcontainersAnnotations.CONTAINER_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"testcontainers-1", "junit-jupiter-1"})).build().apply(this.updateCursor((Tree)vd), vd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        });
    }
}

