/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AvoidBoxedBooleanExpressions
extends Recipe {
    public String getDisplayName() {
        return "Avoid boxed boolean expressions";
    }

    public String getDescription() {
        return "Under certain conditions the `java.lang.Boolean` type is used as an expression, and it may throw a `NullPointerException` if the value is null.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S5411");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.Boolean", Boolean.valueOf(true)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext ctx) {
                Expression e = (Expression)super.visitExpression(expression, (Object)ctx);
                if (TypeUtils.isOfClassType((JavaType)e.getType(), (String)"java.lang.Boolean") && this.isControlExpression(expression)) {
                    return (Expression)JavaTemplate.apply((String)"Boolean.TRUE.equals(#{any(java.lang.Boolean)})", (Cursor)this.updateCursor((Tree)e), (JavaCoordinates)e.getCoordinates().replace(), (Object[])new Object[]{e});
                }
                return e;
            }

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J.Unary un = (J.Unary)super.visitUnary(unary, (Object)ctx);
                if (J.Unary.Type.Not == un.getOperator() && TypeUtils.isOfClassType((JavaType)un.getExpression().getType(), (String)"java.lang.Boolean")) {
                    return JavaTemplate.apply((String)"Boolean.FALSE.equals(#{any(java.lang.Boolean)})", (Cursor)this.updateCursor((Tree)un), (JavaCoordinates)un.getCoordinates().replace(), (Object[])new Object[]{un.getExpression()});
                }
                return un;
            }

            private boolean isControlExpression(Expression expression) {
                Cursor parentCursor = this.getCursor().getParentTreeCursor();
                if (parentCursor.getValue() instanceof J.ControlParentheses && parentCursor.getParentTreeCursor().getValue() instanceof J.If) {
                    return true;
                }
                if (parentCursor.getValue() instanceof J.Ternary) {
                    return ((J.Ternary)parentCursor.getValue()).getCondition() == expression;
                }
                return false;
            }
        });
    }
}

