/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class RefineSwitchCases
extends Recipe {
    public String getDisplayName() {
        return "Use switch cases refinement when possible";
    }

    public String getDescription() {
        return "Use guarded switch case labels and guards if all the statements in the switch block do if/else if/else on the guarded label.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Switch visitSwitch(J.Switch sw, ExecutionContext ctx) {
                J.Switch switch_ = super.visitSwitch(sw, (Object)ctx);
                J.Switch mappedSwitch = switch_.withCases(switch_.getCases().withStatements(ListUtils.flatMap((List)switch_.getCases().getStatements(), statement -> {
                    if (statement instanceof J.Case) {
                        J.Case case_ = (J.Case)statement;
                        if (!(case_.getBody() instanceof J.Block) || case_.getGuard() != null) {
                            return statement;
                        }
                        List caseStatements = ((J.Block)case_.getBody()).getStatements();
                        if (caseStatements.size() == 1 && caseStatements.get(0) instanceof J.If) {
                            J.If if_ = (J.If)caseStatements.get(0);
                            if (this.extractLabelVariables(case_).containsAll(this.extractConditionVariables((Expression)if_.getIfCondition().getTree()))) {
                                return this.createGuardedCases(case_, if_);
                            }
                        }
                    }
                    return statement;
                })));
                if (mappedSwitch != switch_) {
                    return new JavaIsoVisitor<ExecutionContext>(){

                        public J.Case visitCase(J.Case case_, ExecutionContext ctx) {
                            J.Block body;
                            if (case_.getBody() instanceof J.Block && (body = (J.Block)case_.getBody()).getStatements().isEmpty() && body.getEnd().getComments().isEmpty() && !body.getEnd().isEmpty()) {
                                return case_.withBody((J)body.withEnd(Space.EMPTY));
                            }
                            return case_;
                        }
                    }.visitSwitch((J.Switch)this.autoFormat((J)mappedSwitch, ctx), (Object)ctx);
                }
                return switch_;
            }

            private Set<String> extractLabelVariables(J.Case case_) {
                return case_.getCaseLabels().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).map(J.VariableDeclarations.NamedVariable::getName).map(J.Identifier::getSimpleName).collect(Collectors.toSet());
            }

            private Set<String> extractConditionVariables(Expression expression) {
                return (Set)new JavaIsoVisitor<Set<String>>(){

                    public J.Identifier visitIdentifier(J.Identifier identifier, Set<String> identifiers) {
                        identifiers.add(identifier.getSimpleName());
                        return super.visitIdentifier(identifier, identifiers);
                    }

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<String> identifiers) {
                        super.visit((Tree)method.getSelect(), identifiers);
                        method.getArguments().forEach(arg -> super.visit((Tree)arg, (Object)identifiers));
                        return method;
                    }
                }.reduce((Tree)expression, new HashSet());
            }

            private List<J.Case> createGuardedCases(J.Case case_, J.If if_) {
                if (case_.getBody() == null) {
                    return Collections.singletonList(case_);
                }
                ArrayList<J.Case> cases = new ArrayList<J.Case>();
                Statement caseBody = if_.getThenPart();
                if (caseBody instanceof J.Block && ((J.Block)caseBody).getStatements().size() == 1) {
                    caseBody = (Statement)((J.Block)caseBody).getStatements().get(0);
                }
                cases.add(case_.withId(Tree.randomId()).withGuard((Expression)((Expression)if_.getIfCondition().getTree()).withPrefix(Space.SINGLE_SPACE)).withBody((J)caseBody));
                if (if_.getElsePart() == null) {
                    if (case_.getBody() instanceof J.Block) {
                        cases.add(case_.withBody((J)J.Block.createEmptyBlock().withPrefix(Space.SINGLE_SPACE)));
                    }
                } else if (if_.getElsePart().getBody() instanceof J.If) {
                    cases.addAll(this.createGuardedCases(case_, (J.If)if_.getElsePart().getBody()));
                } else {
                    cases.add(case_.withBody((J)if_.getElsePart().getBody()));
                }
                return cases;
            }
        });
    }

    @Generated
    public RefineSwitchCases() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "RefineSwitchCases()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefineSwitchCases)) {
            return false;
        }
        RefineSwitchCases other = (RefineSwitchCases)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RefineSwitchCases;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

