/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class StringFormatted
extends Recipe {
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(String, ..)");

    public String getDisplayName() {
        return "Prefer `String.formatted(Object...)`";
    }

    public String getDescription() {
        return "Prefer `String.formatted(Object...)` over `String.format(String, Object...)` in Java 17 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesMethod(STRING_FORMAT)}), (TreeVisitor)new StringFormattedVisitor());
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @Generated
    public StringFormatted() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "StringFormatted()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFormatted)) {
            return false;
        }
        StringFormatted other = (StringFormatted)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof StringFormatted;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class StringFormattedVisitor
    extends JavaVisitor<ExecutionContext> {
        private StringFormattedVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            List arguments;
            methodInvocation = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)ctx);
            if (!STRING_FORMAT.matches((MethodCall)methodInvocation) || methodInvocation.getMethodType() == null) {
                return methodInvocation;
            }
            this.maybeRemoveImport("java.lang.String.format");
            J.MethodInvocation mi = methodInvocation.withName(methodInvocation.getName().withSimpleName("formatted"));
            mi = mi.withMethodType((JavaType.Method)methodInvocation.getMethodType().getDeclaringType().getMethods().stream().filter(it -> it.getName().equals("formatted")).findAny().orElse(null));
            if (mi.getName().getType() != null) {
                mi = mi.withName(mi.getName().withType((JavaType)mi.getMethodType()));
            }
            mi = mi.withSelect((Expression)(StringFormattedVisitor.wrapperNotNeeded((Expression)(arguments = methodInvocation.getArguments()).get(0)) ? (Expression)((Expression)arguments.get(0)).withPrefix(Space.EMPTY) : new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)((Expression)arguments.get(0))))));
            if ((mi = mi.withArguments(arguments.subList(1, arguments.size()))).getArguments().isEmpty()) {
                mi = mi.withArguments(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)));
            }
            return this.maybeAutoFormat((J)methodInvocation, (J)mi, ctx);
        }

        private static boolean wrapperNotNeeded(Expression expression) {
            return expression instanceof J.Identifier || expression instanceof J.Literal || expression instanceof J.MethodInvocation || expression instanceof J.FieldAccess;
        }
    }
}

