/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.MicronautVersionHelper;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.Semver;

public final class UpgradeMicronautGradlePropertiesVersion
extends Recipe {
    private static final String PROPERTY_KEY = "micronautVersion";
    private static final String FILE_MATCHER = "**/gradle.properties";
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="4.x")
    private final String newVersion;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, null));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade gradle.properties Micronaut version";
    }

    public String getDescription() {
        return "Set the gradle.properties version number according to a node-style semver selector or to a specific version number.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new HasSourcePath(FILE_MATCHER), (TreeVisitor)new ChangePropertyValueVisitor(this.newVersion));
    }

    @ConstructorProperties(value={"newVersion"})
    public UpgradeMicronautGradlePropertiesVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    public String toString() {
        return "UpgradeMicronautGradlePropertiesVersion(newVersion=" + this.getNewVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeMicronautGradlePropertiesVersion)) {
            return false;
        }
        UpgradeMicronautGradlePropertiesVersion other = (UpgradeMicronautGradlePropertiesVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeMicronautGradlePropertiesVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }

    private static class ChangePropertyValueVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private final String newVersion;

        public ChangePropertyValueVisitor(String newVersion) {
            this.newVersion = newVersion;
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
            if (entry.getKey().equals(UpgradeMicronautGradlePropertiesVersion.PROPERTY_KEY)) {
                String latestVersion;
                String currentVersion = entry.getValue().getText();
                try {
                    latestVersion = MicronautVersionHelper.getNewerVersion(this.newVersion, currentVersion, ctx).orElse(null);
                }
                catch (MavenDownloadingException e) {
                    return (Properties)Markup.warn((Tree)entry, (Throwable)e);
                }
                if (latestVersion != null && !currentVersion.equals(latestVersion)) {
                    entry = entry.withValue(entry.getValue().withText(latestVersion));
                }
            }
            return super.visitEntry(entry, (Object)ctx);
        }
    }
}

