/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.FindYamlConfig;
import org.openrewrite.yaml.CopyValue;
import org.openrewrite.yaml.DeleteKey;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.cleanup.RemoveUnused;

public class UpdateSecurityYamlIfNeeded
extends Recipe {
    private final List<Recipe> recipeList = new ArrayList<Recipe>();
    private final String newYamlKeysSnippet = "generator:\n  access-token:\n    expiration:\ncookie:\n  enabled:\n  cookie-max-age:\n  cookie-path:\n  cookie-domain:\n  cookie-same-site:\nbearer:\n  enabled:";
    private final String TOKEN_PATH = "$.micronaut.security.token";

    public String getDisplayName() {
        return "Update relocated Micronaut Security config yaml keys";
    }

    public String getDescription() {
        return "This recipe will update relocated security config keys in Micronaut configuration yaml files.";
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    public UpdateSecurityYamlIfNeeded() {
        this.recipeList.add((Recipe)new MergeYaml("$.micronaut.security.token", "generator:\n  access-token:\n    expiration:\ncookie:\n  enabled:\n  cookie-max-age:\n  cookie-path:\n  cookie-domain:\n  cookie-same-site:\nbearer:\n  enabled:", Boolean.TRUE, null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.generator.access-token.expiration", "$.micronaut.security.token.generator.access-token.expiration"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.enabled", "$.micronaut.security.token.cookie.enabled"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-max-age", "$.micronaut.security.token.cookie.cookie-max-age"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-path", "$.micronaut.security.token.cookie.cookie-path"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-domain", "$.micronaut.security.token.cookie.cookie-domain"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-same-site", "$.micronaut.security.token.cookie.cookie-same-site"));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.bearer.enabled", "$.micronaut.security.token.bearer.enabled"));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.generator"));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.cookie"));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.bearer"));
        this.recipeList.add((Recipe)new RemoveUnused());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new FindYamlConfig().getVisitor()), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (!UpdateSecurityYamlIfNeeded.this.recipeList.isEmpty()) {
                    UpdateSecurityYamlIfNeeded.this.recipeList.clear();
                }
                return super.visit(tree, (Object)executionContext);
            }
        });
    }
}

