/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class TypeRequiresIntrospection
extends ScanningRecipe<Accumulator> {
    private static final Collection<String> typesRequiringIntrospection = Arrays.asList("io.micronaut.http.annotation.Controller", "io.micronaut.http.client.annotation.Client");

    public String getDisplayName() {
        return "Add `@Introspected` to classes requiring a map representation";
    }

    public String getDescription() {
        return "In Micronaut 2.x a reflection-based strategy was used to retrieve that information if the class was not annotated with `@Introspected`. As of Micronaut 3.x it is required to annotate classes with `@Introspected` that are used in this way.";
    }

    private static boolean parentRequiresIntrospection(@Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        for (JavaType.FullyQualified fullyQualified : type.getAnnotations()) {
            if (!typesRequiringIntrospection.contains(fullyQualified.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                FindParamsAndReturnTypes findParamsAndReturnTypes = new FindParamsAndReturnTypes();
                if (tree instanceof J.CompilationUnit) {
                    J.CompilationUnit cu = (J.CompilationUnit)tree;
                    for (J.ClassDeclaration classDeclaration : cu.getClasses()) {
                        if (!TypeRequiresIntrospection.parentRequiresIntrospection(classDeclaration.getType())) continue;
                        findParamsAndReturnTypes.visit((Tree)classDeclaration, acc.getIntrospectableTypes());
                    }
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof J.CompilationUnit) {
                    J.CompilationUnit cu = (J.CompilationUnit)tree;
                    for (J.ClassDeclaration aClass : cu.getClasses()) {
                        if (!acc.getIntrospectableTypes().contains(aClass.getType())) continue;
                        return new AddIntrospectionAnnotationVisitor().visit((Tree)cu, acc.getIntrospectableTypes());
                    }
                }
                return tree;
            }
        };
    }

    static class Accumulator {
        Set<JavaType.FullyQualified> introspectableTypes = new HashSet<JavaType.FullyQualified>();

        public Set<JavaType.FullyQualified> getIntrospectableTypes() {
            return this.introspectableTypes;
        }

        public void setIntrospectableTypes(Set<JavaType.FullyQualified> introspectableTypes) {
            this.introspectableTypes = introspectableTypes;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<JavaType.FullyQualified> this$introspectableTypes = this.getIntrospectableTypes();
            Set<JavaType.FullyQualified> other$introspectableTypes = other.getIntrospectableTypes();
            return !(this$introspectableTypes == null ? other$introspectableTypes != null : !((Object)this$introspectableTypes).equals(other$introspectableTypes));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Accumulator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaType.FullyQualified> $introspectableTypes = this.getIntrospectableTypes();
            result = result * 59 + ($introspectableTypes == null ? 43 : ((Object)$introspectableTypes).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "TypeRequiresIntrospection.Accumulator(introspectableTypes=" + this.getIntrospectableTypes() + ")";
        }
    }

    private static class AddIntrospectionAnnotationVisitor
    extends JavaIsoVisitor<Set<JavaType.FullyQualified>> {
        final String introspectedAnnotationFqn = "io.micronaut.core.annotation.Introspected";
        final AnnotationMatcher INTROSPECTION_ANNOTATION_MATCHER = new AnnotationMatcher("@io.micronaut.core.annotation.Introspected");
        final JavaTemplate templ = JavaTemplate.builder((String)"@Introspected").imports(new String[]{"io.micronaut.core.annotation.Introspected"}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package io.micronaut.core.annotation; public @interface Introspected {}"})).build();

        private AddIntrospectionAnnotationVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<JavaType.FullyQualified> introspectableTypes) {
            if (!introspectableTypes.contains(TypeUtils.asFullyQualified((JavaType)classDecl.getType()))) {
                return classDecl;
            }
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, introspectableTypes);
            if (cd.getLeadingAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)this.INTROSPECTION_ANNOTATION_MATCHER).matches(arg_0))) {
                cd = (J.ClassDeclaration)this.templ.apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                this.maybeAddImport("io.micronaut.core.annotation.Introspected");
            }
            return cd;
        }
    }

    private static final class FindParamsAndReturnTypes
    extends JavaIsoVisitor<Set<JavaType.FullyQualified>> {
        private FindParamsAndReturnTypes() {
        }

        private void maybeAddType(@Nullable JavaType.FullyQualified type, Set<JavaType.FullyQualified> foundTypes) {
            if (type != null && !TypeRequiresIntrospection.parentRequiresIntrospection(type)) {
                foundTypes.add(type);
            }
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<JavaType.FullyQualified> foundTypes) {
            if (method.isConstructor()) {
                return method;
            }
            for (Statement param : method.getParameters()) {
                if (!(param instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)param;
                for (J.VariableDeclarations.NamedVariable namedVariable : variableDeclarations.getVariables()) {
                    if (namedVariable.getType() instanceof JavaType.Parameterized) {
                        for (JavaType type : ((JavaType.Parameterized)namedVariable.getType()).getTypeParameters()) {
                            this.maybeAddType(TypeUtils.asFullyQualified((JavaType)type), foundTypes);
                        }
                        continue;
                    }
                    this.maybeAddType(TypeUtils.asFullyQualified((JavaType)namedVariable.getType()), foundTypes);
                }
            }
            if (method.getReturnTypeExpression() instanceof J.ParameterizedType) {
                J.ParameterizedType parameterizedType = (J.ParameterizedType)method.getReturnTypeExpression();
                if (parameterizedType.getTypeParameters() != null) {
                    for (Expression typeParam : parameterizedType.getTypeParameters()) {
                        this.maybeAddType(TypeUtils.asFullyQualified((JavaType)typeParam.getType()), foundTypes);
                    }
                }
            } else if (method.getReturnTypeExpression() != null && method.getReturnTypeExpression().getType() != null) {
                this.maybeAddType(TypeUtils.asFullyQualified((JavaType)method.getReturnTypeExpression().getType()), foundTypes);
            }
            return method;
        }
    }
}

