/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class SubclassesReturnedFromFactoriesNotInjectable
extends Recipe {
    private static final AnnotationMatcher FACTORY_ANNOTATION_MATCHER = new AnnotationMatcher("@io.micronaut.context.annotation.Factory");

    public String getDisplayName() {
        return "Change factory method return types to reflect their resolved return type";
    }

    public String getDescription() {
        return "As of Micronaut 3.x It is no longer possible to inject the internal implementation type from beans produced via factories. Factory method return types are changed to reflect the resolved return type if the method returns a single non-null type that does not match the method declaration return type.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("io.micronaut.context.annotation.Factory", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                if (cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)FACTORY_ANNOTATION_MATCHER).matches(arg_0))) {
                    this.doAfterVisit((TreeVisitor)new FactoryBeansAreTypeVisitor());
                }
                return cd;
            }
        });
    }

    private static class FactoryBeansAreTypeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final List<AnnotationMatcher> BEAN_ANNOTATION_MATCHERS = Stream.concat(Stream.of("io.micronaut.context.annotation.Context", "io.micronaut.context.annotation.Prototype", "io.micronaut.context.annotation.Infrastructure", "io.micronaut.runtime.context.scope.Refreshable", "io.micronaut.runtime.http.scope.RequestScope").map(it -> new AnnotationMatcher("@" + it)), Stream.of("@javax.inject", "@jakarta.inject").map(it -> new AnnotationMatcher(it + ".Singleton"))).map(AnnotationMatcher.class::cast).collect(Collectors.toList());

        private FactoryBeansAreTypeVisitor() {
        }

        private static boolean isBeanAnnotation(J.Annotation annotation) {
            return BEAN_ANNOTATION_MATCHERS.stream().anyMatch(m -> m.matches(annotation));
        }

        public J.Return visitReturn(J.Return _return, ExecutionContext executionContext) {
            J.Return rtn = super.visitReturn(_return, (Object)executionContext);
            J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
            Expression returnExpression = rtn.getExpression();
            if (md != null && returnExpression != null && !(returnExpression.getType() instanceof JavaType.Primitive) && md.getLeadingAnnotations().stream().anyMatch(FactoryBeansAreTypeVisitor::isBeanAnnotation)) {
                Cursor methodDeclCursor = this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance);
                JavaType returnedType = returnExpression.getType();
                if (returnedType != null) {
                    ((HashSet)methodDeclCursor.computeMessageIfAbsent("return-types", v -> new HashSet())).add(returnedType);
                }
            }
            return rtn;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)executionContext);
            Set returnTypes = (Set)this.getCursor().pollMessage("return-types");
            if (returnTypes != null && returnTypes.size() == 1) {
                JavaType returnedType = (JavaType)returnTypes.iterator().next();
                JavaType.FullyQualified methodReturnType = md.getReturnTypeExpression() != null ? TypeUtils.asFullyQualified((JavaType)md.getReturnTypeExpression().getType()) : null;
                JavaType.FullyQualified returnedTypeFqn = TypeUtils.asFullyQualified((JavaType)returnedType);
                if (returnedTypeFqn != null && methodReturnType != null && !TypeUtils.isOfType((JavaType)methodReturnType, (JavaType)returnedType)) {
                    J.Identifier resolvedReturnType = new J.Identifier(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), returnedTypeFqn.getClassName(), returnedType, null);
                    if (returnedType instanceof JavaType.Parameterized && md.getReturnTypeExpression() instanceof J.ParameterizedType) {
                        J.ParameterizedType mdReturnTypeExpression = (J.ParameterizedType)md.getReturnTypeExpression();
                        mdReturnTypeExpression = mdReturnTypeExpression.withClazz((NameTree)resolvedReturnType);
                        md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withReturnTypeExpression((TypeTree)mdReturnTypeExpression), (J)md.getName(), executionContext, this.getCursor().getParent());
                    } else {
                        md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withReturnTypeExpression((TypeTree)resolvedReturnType), (J)md.getName(), executionContext, this.getCursor().getParent());
                    }
                    this.maybeRemoveImport(methodReturnType.getFullyQualifiedName());
                }
            }
            return md;
        }
    }
}

