/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class OncePerRequestHttpServerFilterToHttpServerFilter
extends Recipe {
    private static final String oncePerRequestHttpServerFilterFqn = "io.micronaut.http.filter.OncePerRequestHttpServerFilter";

    public String getDisplayName() {
        return "Convert `OncePerRequestServerFilter` extensions to `HttpServerFilter`";
    }

    public String getDescription() {
        return "Starting in Micronaut 3.0 all filters are executed once per request. Directly implement `HttpServerFilter` instead of extending `OncePerRequestHttpServerFilter` and replace any usages of `micronaut.once` attributes with a custom attribute name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(oncePerRequestHttpServerFilterFqn, Boolean.valueOf(false)), (TreeVisitor)new OncePerRequestHttpServerFilterToHttpServerFilterVisitor());
    }

    private static class OncePerRequestHttpServerFilterToHttpServerFilterVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher keyMethodMatcher = new MethodMatcher("io.micronaut.http.filter.OncePerRequestHttpServerFilter getKey(Class)");
        private static final MethodMatcher doFilterOnceMethodMatcher = new MethodMatcher("* doFilterOnce(io.micronaut.http.HttpRequest, io.micronaut.http.filter.ServerFilterChain)");

        private OncePerRequestHttpServerFilterToHttpServerFilterVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
            if (cd.getExtends() != null && cd.getExtends().getType() != null && TypeUtils.isOfClassType((JavaType)cd.getExtends().getType(), (String)OncePerRequestHttpServerFilterToHttpServerFilter.oncePerRequestHttpServerFilterFqn)) {
                cd = cd.withExtends(null);
                J.Identifier newImplementsIdentifier = new J.Identifier(UUID.randomUUID(), Space.format((String)" "), Markers.EMPTY, Collections.emptyList(), "HttpServerFilter", JavaType.buildType((String)"io.micronaut.http.filter.HttpServerFilter"), null);
                J.Block body = cd.getBody();
                cd = (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)cd.withBody(null).withImplements(ListUtils.concat((List)cd.getImplements(), (Object)newImplementsIdentifier)), executionContext, this.getCursor());
                if ((cd = cd.withBody(body)).getType() != null) {
                    this.doAfterVisit(new ChangeMethodName(cd.getType().getFullyQualifiedName() + " doFilterOnce(io.micronaut.http.HttpRequest, io.micronaut.http.filter.ServerFilterChain)", "doFilter", Boolean.valueOf(true), Boolean.valueOf(false)).getVisitor());
                }
                this.maybeAddImport("io.micronaut.http.filter.HttpServerFilter");
                this.maybeRemoveImport(OncePerRequestHttpServerFilterToHttpServerFilter.oncePerRequestHttpServerFilterFqn);
            }
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            J.MethodDeclaration methodDeclaration = super.visitMethodDeclaration(method, (Object)executionContext);
            J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (classDeclaration != null && doFilterOnceMethodMatcher.matches(methodDeclaration, classDeclaration)) {
                methodDeclaration = methodDeclaration.withModifiers(ListUtils.map((List)methodDeclaration.getModifiers(), mod -> mod.getType() == J.Modifier.Type.Private || mod.getType() == J.Modifier.Type.Protected ? mod.withType(J.Modifier.Type.Public) : mod));
            }
            return methodDeclaration;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
            String todoCommentText = "TODO: See `Server Filter Behavior` in https://docs.micronaut.io/3.0.x/guide/#breaks for details";
            if (keyMethodMatcher.matches((MethodCall)mi) && mi.getComments().stream().noneMatch(c -> c instanceof TextComment && ((TextComment)c).getText().equals(todoCommentText))) {
                mi = (J.MethodInvocation)mi.withComments(ListUtils.concat((List)mi.getComments(), (Object)new TextComment(true, todoCommentText, " ", Markers.EMPTY)));
            }
            return mi;
        }
    }
}

