/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class FixDeprecatedExceptionHandlerConstructors
extends Recipe {
    private static final List<String> exception_handlers = Arrays.asList("io.micronaut.http.server.netty.converters.DuplicateRouteHandler", "io.micronaut.http.server.netty.converters.UnsatisfiedRouteHandler", "io.micronaut.http.server.exceptions.ContentLengthExceededHandler", "io.micronaut.http.server.exceptions.ConversionErrorHandler", "io.micronaut.http.server.exceptions.HttpStatusHandler", "io.micronaut.http.server.exceptions.JsonExceptionHandler", "io.micronaut.http.server.exceptions.URISyntaxHandler", "io.micronaut.http.server.exceptions.UnsatisfiedArgumentHandler", "io.micronaut.validation.exceptions.ConstraintExceptionHandler", "io.micronaut.validation.exceptions.ValidationExceptionHandler");
    private static final TreeVisitor<?, ExecutionContext> precondition = Preconditions.or((TreeVisitor[])((TreeVisitor[])exception_handlers.stream().map(fqn -> new UsesType(fqn, Boolean.valueOf(false))).toArray(TreeVisitor[]::new)));
    private static final AnnotationMatcher javax_matcher = new AnnotationMatcher("@javax.inject.Inject");
    private static final AnnotationMatcher jakarta_matcher = new AnnotationMatcher("@jakarta.inject.Inject");

    public String getDisplayName() {
        return "Fix deprecated no-arg `ExceptionHandler` constructors";
    }

    public String getDescription() {
        return "Adds `ErrorResponseProcessor` argument to deprecated no-arg `ExceptionHandler` constructors.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(precondition, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final JavaParser.Builder<?, ?> parser = JavaParser.fromJavaVersion().dependsOn(new String[]{"package jakarta.inject; public @interface Inject {}", "package io.micronaut.http.server.exceptions.response; public interface ErrorContext {}", "package io.micronaut.http; public interface MutableHttpResponse<B> {}", "package io.micronaut.http.server.exceptions.response; public interface ErrorResponseProcessor<T> {MutableHttpResponse<T> processResponse(ErrorContext errorContext, MutableHttpResponse<?> baseResponse);}", "package io.micronaut.validation.exceptions; public class ConstraintExceptionHandler { public ConstraintExceptionHandler(ErrorResponseProcessor<?> responseProcessor){}}"});
            final JavaTemplate injectTemplate = JavaTemplate.builder((String)"@Inject").javaParser(this.parser).imports(new String[]{"jakarta.inject.Inject"}).build();
            private final String errorResponseProcessorFqn = "io.micronaut.http.server.exceptions.response.ErrorResponseProcessor";

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd != null && "super".equals(mi.getSimpleName()) && this.isClassExceptionHandler(cd)) {
                    if (mi.getArguments().stream().noneMatch(exp -> TypeUtils.isOfClassType((JavaType)exp.getType(), (String)"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor"))) {
                        mi = mi.withArguments(Collections.singletonList(new J.Identifier(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "errorResponseProcessor", JavaType.buildType((String)"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor"), null)));
                    }
                    if (mi.getArguments().stream().anyMatch(exp -> TypeUtils.isOfClassType((JavaType)exp.getType(), (String)"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor"))) {
                        this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).putMessage("super-invocation-exists", (Object)Boolean.TRUE);
                    }
                }
                return mi;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)executionContext);
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd != null && this.isClassExceptionHandler(cd) && md.isConstructor()) {
                    this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("constructor-exists", (Object)Boolean.TRUE);
                    if (md.getLeadingAnnotations().stream().noneMatch(anno -> jakarta_matcher.matches(anno) || javax_matcher.matches(anno))) {
                        md = (J.MethodDeclaration)this.injectTemplate.apply(new Cursor(this.getCursor().getParent(), (Object)md), md.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    }
                    this.maybeAddImport("jakarta.inject.Inject");
                    if (md.getParameters().stream().noneMatch(this::isErrorProcessorParameter)) {
                        List params = md.getParameters().stream().filter(j -> !(j instanceof J.Empty)).collect(Collectors.toList());
                        params.add("ErrorResponseProcessor errorResponseProcessor");
                        JavaTemplate paramsTemplate = JavaTemplate.builder((String)params.stream().map(p -> "#{}").collect(Collectors.joining(", "))).contextSensitive().imports(new String[]{"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor"}).javaParser(this.parser).build();
                        md = (J.MethodDeclaration)paramsTemplate.apply(new Cursor(this.getCursor().getParent(), (Object)md), md.getCoordinates().replaceParameters(), params.toArray());
                    }
                    if (this.getCursor().pollMessage("super-invocation-exists") == null) {
                        Optional<J.Identifier> errorResponseVar = md.getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).filter(v -> TypeUtils.isOfClassType((JavaType)v.getType(), (String)"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor")).map(v -> ((J.VariableDeclarations.NamedVariable)v.getVariables().get(0)).getName()).findFirst();
                        if (errorResponseVar.isPresent() && md.getBody() != null && this.getCursor().getParent() != null) {
                            JavaTemplate superInvocationTemplate = JavaTemplate.builder((String)"super(#{any(io.micronaut.http.server.exceptions.response.ErrorResponseProcessor)});").contextSensitive().imports(new String[]{"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor"}).javaParser(this.parser).build();
                            md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)((J.MethodDeclaration)superInvocationTemplate.apply(this.getCursor(), md.getBody().getCoordinates().lastStatement(), new Object[]{errorResponseVar.get()})), executionContext, this.getCursor().getParent());
                            assert (md.getBody() != null);
                            md = md.withBody(this.moveLastStatementToFirst(md.getBody()));
                        }
                    }
                    this.maybeAddImport("io.micronaut.http.server.exceptions.response.ErrorResponseProcessor");
                }
                return md;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                JavaType.FullyQualified cdFq;
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                JavaType.FullyQualified fullyQualified = cdFq = cd.getExtends() != null ? TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType()) : null;
                if (cdFq != null && exception_handlers.stream().anyMatch(fqn -> TypeUtils.isOfClassType((JavaType)cdFq, (String)fqn)) && !Boolean.TRUE.equals(this.getCursor().pollMessage("constructor-exists"))) {
                    JavaTemplate template = JavaTemplate.builder((String)("@Inject\npublic " + cd.getSimpleName() + "(ErrorResponseProcessor errorResponseProcessor) {super(errorResponseProcessor);}")).contextSensitive().imports(new String[]{"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor", "jakarta.inject.Inject", cdFq.getFullyQualifiedName()}).javaParser(this.parser).build();
                    cd = (J.ClassDeclaration)template.apply(this.getCursor(), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                    cd = cd.withBody(this.moveLastStatementToFirst(cd.getBody()));
                    this.maybeAddImport("jakarta.inject.Inject");
                }
                return cd;
            }

            private boolean isErrorProcessorParameter(Statement statement) {
                return statement instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)statement).getType(), (String)"io.micronaut.http.server.exceptions.response.ErrorResponseProcessor");
            }

            private boolean isClassExceptionHandler(J.ClassDeclaration cd) {
                JavaType.FullyQualified cdFq = cd.getExtends() != null ? TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType()) : null;
                return cdFq != null && exception_handlers.stream().anyMatch(fqn -> TypeUtils.isOfClassType((JavaType)cdFq, (String)fqn));
            }

            private J.Block moveLastStatementToFirst(J.Block block) {
                if (block.getStatements().size() > 1) {
                    List statements = block.getStatements();
                    Statement stmt = (Statement)statements.get(statements.size() - 1);
                    statements.remove(stmt);
                    statements.add(0, stmt);
                    block = block.withStatements(statements);
                }
                return block;
            }
        });
    }
}

