/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.MavenExclusions;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.MapTagChildrenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeAnnotationProcessorPath
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="my-deprecated-annotation-processor")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="my-new-annotation-processor", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An version string for the annotation processor path. Version strings that start with 'micronaut.' will be treated specially. ", example="micronaut.validation", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Exclusions", description="A list of exclusions to apply to the annotation processor path in the format groupId:artifactId", example="io.micronaut:micronaut-inject", required=false)
    @Nullable
    private final List<String> exclusions;

    public String getDisplayName() {
        return "Change Maven annotation processor path";
    }

    public String getDescription() {
        return "Change the groupId, artifactId, and version of a Maven annotation processor path.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeAnnotationProcessorPath.this.oldGroupId + ":" + ChangeAnnotationProcessorPath.this.oldArtifactId)).getValue());
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag plugin = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin") && (plugin = this.maybeUpdatePlugin(plugin, ctx)) != tag) {
                    this.maybeUpdateModel();
                }
                return plugin;
            }

            private Xml.Tag maybeUpdatePlugin(Xml.Tag plugin, ExecutionContext ctx) {
                return MapTagChildrenVisitor.mapTagChildren((Xml.Tag)plugin, childTag -> "configuration".equals(childTag.getName()) ? this.maybeUpdateConfiguration((Xml.Tag)childTag, ctx) : childTag);
            }

            private Xml.Tag maybeUpdateConfiguration(Xml.Tag configuration, ExecutionContext ctx) {
                return MapTagChildrenVisitor.mapTagChildren((Xml.Tag)configuration, childTag -> "annotationProcessorPaths".equals(childTag.getName()) ? this.maybeUpdateAnnotationProcessorPaths((Xml.Tag)childTag, ctx) : childTag);
            }

            private Xml.Tag maybeUpdateAnnotationProcessorPaths(Xml.Tag annotationProcessorPaths, ExecutionContext ctx) {
                return MapTagChildrenVisitor.mapTagChildren((Xml.Tag)annotationProcessorPaths, childTag -> {
                    if ("path".equals(childTag.getName()) && this.isPathMatch((Xml.Tag)childTag)) {
                        Xml.Tag path = childTag;
                        if (ChangeAnnotationProcessorPath.this.newGroupId != null && !ChangeAnnotationProcessorPath.this.newGroupId.equals(path.getChildValue("groupId").orElse(""))) {
                            path = this.changeChildTagValue(path, "groupId", ChangeAnnotationProcessorPath.this.newGroupId, ctx);
                        }
                        if (ChangeAnnotationProcessorPath.this.newArtifactId != null && !ChangeAnnotationProcessorPath.this.newArtifactId.equals(path.getChildValue("artifactId").orElse(""))) {
                            path = this.changeChildTagValue(path, "artifactId", ChangeAnnotationProcessorPath.this.newArtifactId, ctx);
                        }
                        if (ChangeAnnotationProcessorPath.this.newVersion != null) {
                            String versionToUpdate;
                            String string = versionToUpdate = ChangeAnnotationProcessorPath.this.newVersion.startsWith("micronaut.") ? "${" + ChangeAnnotationProcessorPath.this.newVersion + "}" : ChangeAnnotationProcessorPath.this.newVersion;
                            if (!versionToUpdate.equals(path.getChildValue("version").orElse(""))) {
                                path = this.changeChildTagValue(path, "version", versionToUpdate, ctx);
                            }
                        }
                        if (ChangeAnnotationProcessorPath.this.exclusions == null) {
                            path = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)path, child -> !"exclusions".equals(child.getName()));
                        } else {
                            this.maybeAddExclusionsToPath(path, ChangeAnnotationProcessorPath.this.exclusions.stream().filter(s -> !StringUtils.isBlank((String)s)).collect(Collectors.toList()));
                        }
                        childTag = path;
                    }
                    return childTag;
                });
            }

            private void maybeAddExclusionsToPath(@NonNull Xml.Tag path, @NonNull List<String> exclusionsToAdd) {
                if (!exclusionsToAdd.isEmpty()) {
                    Xml.Tag exclusionsTag = Xml.Tag.build((String)("\n<exclusions>\n" + MavenExclusions.buildContent(exclusionsToAdd) + "</exclusions>"));
                    this.doAfterVisit((TreeVisitor)new AddOrUpdateChild(path, exclusionsTag));
                }
            }

            private boolean isPathMatch(Xml.Tag path) {
                return this.depMatcher.matches(path.getChildValue("groupId").orElse(""), path.getChildValue("artifactId").orElse(""));
            }

            private Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, (Object)ctx);
                }
                return tag;
            }
        };
    }

    @ConstructorProperties(value={"oldGroupId", "oldArtifactId", "newGroupId", "newArtifactId", "newVersion", "exclusions"})
    public ChangeAnnotationProcessorPath(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable List<String> exclusions) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.exclusions = exclusions;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @NonNull
    public String toString() {
        return "ChangeAnnotationProcessorPath(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", exclusions=" + this.getExclusions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAnnotationProcessorPath)) {
            return false;
        }
        ChangeAnnotationProcessorPath other = (ChangeAnnotationProcessorPath)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeAnnotationProcessorPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }
}

