/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.AddDependency;
import org.openrewrite.java.micronaut.FindYamlConfig;

public class AddSnakeYamlDependencyIfNeeded
extends ScanningRecipe<YamlAccumulator> {
    private final List<Recipe> recipeList = new ArrayList<Recipe>();

    public AddSnakeYamlDependencyIfNeeded() {
        this.recipeList.add((Recipe)new AddDependency("org.yaml", "snakeyaml", null, null, "io.micronaut.runtime.Micronaut", null, null, null, "runtimeOnly", "runtime", null, null, null, null));
    }

    public YamlAccumulator getInitialValue(ExecutionContext ctx) {
        return new YamlAccumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final YamlAccumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                acc.usingYamlConfig = acc.usingYamlConfig | sourceFile != new FindYamlConfig().getVisitor().visit((Tree)sourceFile, (Object)ctx);
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(YamlAccumulator acc) {
        return Preconditions.check((!acc.usingYamlConfig ? 1 : 0) != 0, (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (!AddSnakeYamlDependencyIfNeeded.this.recipeList.isEmpty()) {
                    AddSnakeYamlDependencyIfNeeded.this.recipeList.clear();
                }
                return super.visit(tree, (Object)executionContext);
            }
        });
    }

    public String getDisplayName() {
        return "Add `snakeyaml` dependency if needed";
    }

    public String getDescription() {
        return "This recipe will add the `snakeyaml` dependency to a Micronaut 4 application that uses yaml configuration.";
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    static class YamlAccumulator {
        boolean usingYamlConfig = false;

        YamlAccumulator() {
        }
    }
}

