/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddHttpRequestTypeParameter
extends Recipe {
    private static final String IO_MICRONAUT_HTTP_HTTP_REQUEST = "io.micronaut.http.HttpRequest";
    private static final List<String> CANDIDATE_INTERFACES = Arrays.asList("io.micronaut.security.authentication.AuthenticationProvider", "io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator", "io.micronaut.security.token.jwt.validator.JwtClaimsValidator", "io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder", "io.micronaut.security.oauth2.url.AbsoluteUrlBuilder", "io.micronaut.security.oauth2.url.OauthRouteUrlBuilder", "io.micronaut.security.endpoints.introspection.IntrospectionProcessor", "io.micronaut.security.filters.AuthenticationFetcher", "io.micronaut.security.token.reader.TokenReader", "io.micronaut.security.token.reader.TokenResolver", "io.micronaut.security.token.validator.TokenValidator");

    public String getDisplayName() {
        return "Add `HttpRequest` type parameter for implemented interfaces";
    }

    public String getDescription() {
        return "Add an `HttpRequest` type parameter to a class `implements` statement for interfaces that have been generically parameterized where they previously specified `HttpRequest` explicitly.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)executionContext);
                List mappedInterfaceTypes = ListUtils.map((List)c.getImplements(), interfaceType -> {
                    JavaType.FullyQualified fqInterfaceType = (JavaType.FullyQualified)interfaceType.getType();
                    if (fqInterfaceType != null && this.isCandidateInterface(fqInterfaceType)) {
                        JavaType httpRequestType = JavaType.buildType((String)AddHttpRequestTypeParameter.IO_MICRONAUT_HTTP_HTTP_REQUEST);
                        J.Identifier httpRequestIdentifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "HttpRequest", httpRequestType, null);
                        J.ParameterizedType httpRequestParameterized = new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)httpRequestIdentifier, JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Wildcard(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null)))), httpRequestType);
                        J.Identifier nameTree = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), fqInterfaceType.getClassName(), null, null);
                        return new J.ParameterizedType(Tree.randomId(), interfaceType.getPrefix(), Markers.EMPTY, (NameTree)nameTree, JContainer.build(Collections.singletonList(JRightPadded.build((Object)httpRequestParameterized))), (JavaType)fqInterfaceType);
                    }
                    return interfaceType;
                });
                return c.withImplements(mappedInterfaceTypes);
            }

            private boolean isCandidateInterface(JavaType.FullyQualified fqInterfaceType) {
                if (CANDIDATE_INTERFACES.contains(fqInterfaceType.getFullyQualifiedName())) {
                    for (JavaType javaType : fqInterfaceType.getTypeParameters()) {
                        if (!TypeUtils.isAssignableTo((String)AddHttpRequestTypeParameter.IO_MICRONAUT_HTTP_HTTP_REQUEST, (JavaType)javaType)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

