/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.MavenExclusions;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AddAnnotationProcessorPath
extends ScanningRecipe<Scanned> {
    @Option(displayName="GroupId", description="The groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String groupId;
    @Option(displayName="ArtifactId", description="The artifactId to use.", example="my-new-annotation-processor")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version string for the annotation processor path.", example="${micronaut.validation}")
    private final String version;
    @Option(displayName="Only if using", description="Used to determine if the annotation processor will be added.", example="jakarta.validation.constraints.*")
    private final String onlyIfUsing;
    @Option(displayName="Exclusions", description="A list of exclusions to apply to the annotation processor path in the format groupId:artifactId", example="io.micronaut:micronaut-inject", required=false)
    @Nullable
    private final List<String> exclusions;

    public String getDisplayName() {
        return "Add Maven annotation processor path";
    }

    public String getDescription() {
        return "Add the groupId, artifactId, version, and exclusions of a Maven annotation processor path.";
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (tree instanceof JavaSourceFile) {
                    boolean sourceFileUsesType = sourceFile != new UsesType(AddAnnotationProcessorPath.this.onlyIfUsing, Boolean.valueOf(true)).visit((Tree)sourceFile, (Object)ctx);
                    acc.usingType |= sourceFileUsesType;
                }
                return sourceFile;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Scanned acc) {
        return Preconditions.check((boolean)acc.usingType, (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                return (Xml)new CheckAnnotationProcessorPathVisitor().visitNonNull((Tree)document, ctx);
            }
        });
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version", "onlyIfUsing", "exclusions"})
    public AddAnnotationProcessorPath(String groupId, String artifactId, String version, String onlyIfUsing, @Nullable List<String> exclusions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.onlyIfUsing = onlyIfUsing;
        this.exclusions = exclusions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @NonNull
    public String toString() {
        return "AddAnnotationProcessorPath(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", exclusions=" + this.getExclusions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddAnnotationProcessorPath)) {
            return false;
        }
        AddAnnotationProcessorPath other = (AddAnnotationProcessorPath)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddAnnotationProcessorPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }

    public static class Scanned {
        boolean usingType;
    }

    private class InsertAnnotationProcessorPath
    extends MavenIsoVisitor<ExecutionContext> {
        private final XPathMatcher ANNOTATION_PROCESSOR_PATHS_MATCHER = new XPathMatcher("/project/build/plugins/plugin/configuration/annotationProcessorPaths");

        private InsertAnnotationProcessorPath() {
        }

        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.ANNOTATION_PROCESSOR_PATHS_MATCHER.matches(this.getCursor())) {
                Xml.Tag pathTag = Xml.Tag.build((String)("\n<path>\n<groupId>" + AddAnnotationProcessorPath.this.groupId + "</groupId>\n<artifactId>" + AddAnnotationProcessorPath.this.artifactId + "</artifactId>\n<version>" + AddAnnotationProcessorPath.this.version + "</version>\n" + this.buildExclusionsContent() + "</path>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, pathTag));
                this.maybeUpdateModel();
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        private String buildExclusionsContent() {
            if (AddAnnotationProcessorPath.this.exclusions == null) {
                return "";
            }
            return "<exclusions>\n" + MavenExclusions.buildContent(AddAnnotationProcessorPath.this.exclusions) + "</exclusions>";
        }
    }

    private class CheckAnnotationProcessorPathVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final XPathMatcher ANNOTATION_PROCESSOR_PATH_MATCHER = new XPathMatcher("/project/build/plugins/plugin/configuration/annotationProcessorPaths/path");

        private CheckAnnotationProcessorPathVisitor() {
        }

        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.ANNOTATION_PROCESSOR_PATH_MATCHER.matches(this.getCursor()) && AddAnnotationProcessorPath.this.groupId.equals(tag.getChildValue("groupId").orElse(null)) && AddAnnotationProcessorPath.this.artifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
                this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "alreadyHasAnnotationProcessor", (Object)true);
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            Xml.Document maven = super.visitDocument(document, (Object)ctx);
            if (((Boolean)this.getCursor().getMessage("alreadyHasAnnotationProcessor", (Object)false)).booleanValue()) {
                return document;
            }
            this.doAfterVisit((TreeVisitor)new InsertAnnotationProcessorPath());
            return maven;
        }
    }
}

