/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jenkins.BomLookup;
import org.openrewrite.jenkins.Jenkins;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddPluginsBom
extends Recipe {
    private static final BomLookup LOOKUP = new BomLookup();
    private static final String PLUGINS_BOM_GROUP_ID = "io.jenkins.tools.bom";

    public String getDisplayName() {
        return "Add or correct Jenkins plugins BOM";
    }

    public String getDescription() {
        return "Adds [Jenkins plugins BOM](https://www.jenkins.io/doc/developer/plugin-development/dependency-management/#jenkins-plugin-bom) at the latest release if the project depends on any managed versions or an outdated BOM is present. BOMs are expected to be synchronized to Jenkins LTS versions, so this will also remove any mismatched BOMs (Such as using Jenkins 2.387.3, but importing bom-2.319.x). If the expected BOM is already added, the version will not be upgraded.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            private boolean alreadyChanged = false;
            private String bomName = "";

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml.Document d = super.visitDocument(document, (Object)executionContext);
                Markers m = document.getMarkers();
                Optional maybeMavenResult = m.findFirst(MavenResolutionResult.class);
                if (!maybeMavenResult.isPresent()) {
                    return d;
                }
                MavenResolutionResult result = (MavenResolutionResult)maybeMavenResult.get();
                ResolvedPom resolvedPom = result.getPom();
                Pom pom = resolvedPom.getRequested();
                List dependencyManagement = pom.getDependencyManagement();
                boolean bomFound = false;
                for (ManagedDependency md : dependencyManagement) {
                    if (!AddPluginsBom.PLUGINS_BOM_GROUP_ID.equals(md.getGroupId())) continue;
                    bomFound = true;
                    break;
                }
                boolean hasDependencyInBom = false;
                List dependencies = pom.getDependencies();
                for (Dependency dependency : dependencies) {
                    String groupId = dependency.getGroupId();
                    String version = dependency.getVersion();
                    if (groupId == null || version == null || !LOOKUP.inBom(groupId, dependency.getArtifactId())) continue;
                    hasDependencyInBom = true;
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(groupId, dependency.getArtifactId(), Boolean.valueOf(false), null).getVisitor());
                }
                if (!bomFound && hasDependencyInBom) {
                    this.doAfterVisit(new AddManagedDependency(AddPluginsBom.PLUGINS_BOM_GROUP_ID, this.bomName, "latest.release", "import", "pom", null, null, Boolean.valueOf(true), null, null).getVisitor());
                }
                return document;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag t = super.visitTag(tag, (Object)executionContext);
                if (this.isManagedDependencyTag()) {
                    String groupId = tag.getChildValue("groupId").orElse("");
                    String artifactId = tag.getChildValue("artifactId").orElse("");
                    if (AddPluginsBom.PLUGINS_BOM_GROUP_ID.equals(groupId) && !artifactId.isEmpty()) {
                        if (this.alreadyChanged) {
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)t, true));
                        } else {
                            this.alreadyChanged = true;
                            if (!Objects.equals(this.bomName, artifactId)) {
                                this.doAfterVisit(new ChangeManagedDependencyGroupIdAndArtifactId(groupId, artifactId, groupId, this.bomName, "latest.release").getVisitor());
                            }
                        }
                    }
                } else if (this.isPropertyTag() && Objects.equals("jenkins.version", t.getName())) {
                    String jenkinsVersion = (String)t.getValue().orElseThrow(() -> new IllegalStateException("No value found for jenkins.version property tag"));
                    this.bomName = Jenkins.bomNameForJenkinsVersion(jenkinsVersion);
                }
                return t;
            }
        };
    }

    @NonNull
    public String toString() {
        return "AddPluginsBom()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginsBom)) {
            return false;
        }
        AddPluginsBom other = (AddPluginsBom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginsBom;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static final class Artifact {
        private final String groupId;
        private final String artifactId;

        @ConstructorProperties(value={"groupId", "artifactId"})
        public Artifact(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Artifact)) {
                return false;
            }
            Artifact other = (Artifact)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddPluginsBom.Artifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
        }
    }
}

