/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceStreamWriteCapability
extends Recipe {
    private static final MethodMatcher CAN_WRITE_BINARY_NATIVELY = new MethodMatcher("com.fasterxml.jackson.core.JsonGenerator canWriteBinaryNatively()");
    private static final MethodMatcher CAN_WRITE_FORMATTED_NUMBERS = new MethodMatcher("com.fasterxml.jackson.core.JsonGenerator canWriteFormattedNumbers()");

    public String getDisplayName() {
        return "Replace removed `JsonGenerator` capability methods with `StreamWriteCapability`";
    }

    public String getDescription() {
        return "In Jackson 3, `JsonGenerator.canWriteBinaryNatively()` and `canWriteFormattedNumbers()` were removed and replaced with the `StreamWriteCapability` enum. This recipe updates these method calls to use `getWriteCapabilities().isEnabled(StreamWriteCapability.*)` instead.";
    }

    public Set<String> getTags() {
        return Collections.singleton("jackson-3");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(CAN_WRITE_BINARY_NATIVELY), new UsesMethod(CAN_WRITE_FORMATTED_NUMBERS)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (CAN_WRITE_BINARY_NATIVELY.matches((MethodCall)mi)) {
                    this.maybeAddImport("com.fasterxml.jackson.core.StreamWriteCapability");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(com.fasterxml.jackson.core.JsonGenerator)}.getWriteCapabilities().isEnabled(StreamWriteCapability.CAN_WRITE_BINARY_NATIVELY)").imports(new String[]{"com.fasterxml.jackson.core.StreamWriteCapability"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2.+"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
                if (CAN_WRITE_FORMATTED_NUMBERS.matches((MethodCall)mi)) {
                    this.maybeAddImport("com.fasterxml.jackson.core.StreamWriteCapability");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(com.fasterxml.jackson.core.JsonGenerator)}.getWriteCapabilities().isEnabled(StreamWriteCapability.CAN_WRITE_FORMATTED_NUMBERS)").imports(new String[]{"com.fasterxml.jackson.core.StreamWriteCapability"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2.+"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                }
                return mi;
            }
        });
    }
}

