/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ChangeArgumentToTimeValue
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="org.apache.http.impl.nio.reactor.IOReactorConfig.Builder setSelectInterval(long)")
    private final String methodPattern;
    @Option(displayName="Time unit", description="The TimeUnit enum value we want to use to turn the original value into a TimeValue. Defaults to `MILLISECONDS`.", example="MILLISECONDS", required=false)
    private final @Nullable TimeUnit timeUnit;

    public String getDisplayName() {
        return "Changes an argument to a `TimeValue` for matched method invocations";
    }

    public String getDescription() {
        return "In Apache Http Client 5.x migration, some methods that previously took a single long argument have changed to take a `TimeValue`. Previously in 4.x, all these methods were implicitly having the value expressed in milliseconds. By default this recipe uses `TimeUnit.MILLISECONDS` for the `TimeUnit` when creating a `TimeValue`. It is possible to specify this as a parameter. Since all affected methods of the Apache Http Client 5.x migration only have one long argument, the recipe applies with matched method invocations of exactly one parameter.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher matcher = new MethodMatcher(this.methodPattern);
        return Preconditions.check((TreeVisitor)new UsesMethod(matcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (matcher.matches((MethodCall)m) && m.getArguments().size() == 1) {
                    this.maybeAddImport("org.apache.hc.core5.util.TimeValue");
                    this.maybeAddImport("java.util.concurrent.TimeUnit");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"TimeValue.of(#{any()}, TimeUnit.#{})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).imports(new String[]{"org.apache.hc.core5.util.TimeValue", "java.util.concurrent.TimeUnit"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0), ChangeArgumentToTimeValue.this.timeUnit != null ? ChangeArgumentToTimeValue.this.timeUnit : TimeUnit.MILLISECONDS});
                }
                return m;
            }
        });
    }

    @Generated
    public ChangeArgumentToTimeValue(String methodPattern, @Nullable TimeUnit timeUnit) {
        this.methodPattern = methodPattern;
        this.timeUnit = timeUnit;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public String toString() {
        return "ChangeArgumentToTimeValue(methodPattern=" + this.getMethodPattern() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeArgumentToTimeValue)) {
            return false;
        }
        ChangeArgumentToTimeValue other = (ChangeArgumentToTimeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeArgumentToTimeValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }
}

