/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient4;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateDefaultHttpClient
extends Recipe {
    public String getDisplayName() {
        return "Migrates deprecated `DefaultHttpClient`";
    }

    public String getDescription() {
        return "Since `DefaultHttpClient` is deprecated, we need to change it to the `CloseableHttpClient`. It only covers the default scenario with no custom `HttpParams` or `ConnectionManager`.\n\nOf note: the `DefaultHttpClient` [does not support TLS 1.2](https://find-sec-bugs.github.io/bugs.htm#DEFAULT_HTTP_CLIENT).\n\nReferences:\n - [Find Sec Bugs](https://find-sec-bugs.github.io/bugs.htm#DEFAULT_HTTP_CLIENT) - [IBM Support Pages](https://www.ibm.com/support/pages/im-using-apache-httpclient-make-outbound-call-my-web-application-running-websphere-application-server-traditional-and-im-getting-ssl-handshake-error-how-can-i-debug)";
    }

    public Set<String> getTags() {
        return Collections.singleton("CWE-326");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.apache.http.impl.client.DefaultHttpClient", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final MethodMatcher noArgsMatcher = new MethodMatcher("org.apache.http.impl.client.DefaultHttpClient <constructor>()");
            final JavaTemplate noArgsTemplate = JavaTemplate.builder((String)"HttpClients.createDefault()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).imports(new String[]{"org.apache.http.impl.client.HttpClients"}).build();

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                if (this.noArgsMatcher.matches((MethodCall)newClass)) {
                    this.maybeAddImport("org.apache.http.impl.client.HttpClients");
                    this.doAfterVisit(new ChangeType("org.apache.http.impl.client.DefaultHttpClient", "org.apache.http.impl.client.CloseableHttpClient", Boolean.valueOf(true)).getVisitor());
                    return this.noArgsTemplate.apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[0]);
                }
                return super.visitNewClass(newClass, (Object)ctx);
            }
        });
    }
}

