/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow.global;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.analysis.FlowGraph;
import org.openrewrite.analysis.dataflow.analysis.ForwardFlow;
import org.openrewrite.analysis.dataflow.global.AlwaysFalseSummary;
import org.openrewrite.analysis.dataflow.global.GlobalDataFlow;
import org.openrewrite.analysis.dataflow.global.MethodTypeUtils;
import org.openrewrite.analysis.trait.expr.Call;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

final class GlobalDataFlowAccumulator
implements GlobalDataFlow.Accumulator {
    private static final InvocationMatcher MATCHES_ALL = e -> true;
    private final DataFlowSpec spec;
    private final FlowGraph.Factory flowGraphFactory = new JMappedFlowGraphFactory();
    private final Set<FlowGraph> sourceFlowGraphs = new HashSet<FlowGraph>();
    private final Map<JavaType.Method, Set<FlowGraph>> methodCallFlowGraphs = new HashMap<JavaType.Method, Set<FlowGraph>>();
    private final Map<JavaType.Method, List<Set<FlowGraph>>> parameterFlowGraphs = new HashMap<JavaType.Method, List<Set<FlowGraph>>>();
    private final Map<JavaType.Method, List<Set<FlowGraph>>> argumentFlowGraphs = new HashMap<JavaType.Method, List<Set<FlowGraph>>>();
    private final Map<JavaType.Method, Set<FlowGraph>> methodReturnFlowGraphs = new HashMap<JavaType.Method, Set<FlowGraph>>();

    @Override
    public TreeVisitor<?, ExecutionContext> scanner() {
        final GlobalDataFlowSpec globalDataFlowSpec = new GlobalDataFlowSpec(this.spec);
        return new JavaVisitor<ExecutionContext>(){

            public J visitExpression(Expression expression, ExecutionContext e) {
                DataFlowNode.of(this.getCursor()).forEach(n -> {
                    FlowGraph source = ForwardFlow.findAllFlows(n, globalDataFlowSpec, GlobalDataFlowAccumulator.this.flowGraphFactory);
                    if (GlobalDataFlowAccumulator.this.spec.isSource((DataFlowNode)n)) {
                        GlobalDataFlowAccumulator.this.sourceFlowGraphs.add(source);
                    }
                    this.walkFlowGraphConnecting(source);
                });
                return expression;
            }

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                DataFlowNode.of(this.getCursor()).forEach(n -> n.asParameter().forEach(p -> p.getCallable().getMethodType().forEach(m -> {
                    FlowGraph g = ForwardFlow.findAllFlows(n, globalDataFlowSpec, GlobalDataFlowAccumulator.this.flowGraphFactory);
                    ((Set)GlobalDataFlowAccumulator.this.parameterFlowGraphs.computeIfAbsent(m, __ -> GlobalDataFlowAccumulator.flowGraphList(p.getCallable().getParameters().size())).get(p.getPosition())).add(g);
                    if (GlobalDataFlowAccumulator.this.argumentFlowGraphs.containsKey(m)) {
                        for (FlowGraph parameterFlowGraph : (Set)((List)GlobalDataFlowAccumulator.this.argumentFlowGraphs.get(m)).get(p.getPosition())) {
                            parameterFlowGraph.addEdge(g);
                        }
                    }
                    if (GlobalDataFlowAccumulator.this.spec.isSource((DataFlowNode)n)) {
                        GlobalDataFlowAccumulator.this.sourceFlowGraphs.add(g);
                    }
                    this.walkFlowGraphConnecting(g);
                })));
                return super.visitVariable(variable, (Object)executionContext);
            }

            private void walkFlowGraphConnecting(FlowGraph flowGraph) {
                this.walkFlowGraphConnectingRecursive(flowGraph, new HashSet<FlowGraph>());
            }

            private void walkFlowGraphConnectingRecursive(FlowGraph flowGraph, Set<FlowGraph> visited) {
                J.Return aReturn;
                DataFlowNode n = flowGraph.getNode();
                n.asExprParent(Call.class).bind(Call::getMethodType).forEach(methodType -> {
                    JavaType.Method declaredMethodType = MethodTypeUtils.getDeclarationMethod(methodType);
                    GlobalDataFlowAccumulator.this.methodCallFlowGraphs.computeIfAbsent(declaredMethodType, __ -> Collections.newSetFromMap(new IdentityHashMap())).add(flowGraph);
                    if (GlobalDataFlowAccumulator.this.methodReturnFlowGraphs.containsKey(declaredMethodType)) {
                        ((Set)GlobalDataFlowAccumulator.this.methodReturnFlowGraphs.get(declaredMethodType)).forEach(returnGraph -> returnGraph.addEdge(flowGraph));
                    }
                });
                if (GlobalDataFlowAccumulator.isAnyMethodArgument(n)) {
                    MethodCall methodCall = (MethodCall)n.getCursor().getParentTreeCursor().firstEnclosing(MethodCall.class);
                    assert (methodCall != null);
                    JavaType.Method methodType2 = methodCall.getMethodType();
                    if (methodType2 != null) {
                        int argumentIndex = methodCall.getArguments().indexOf(n.getCursor().getValue());
                        JavaType.Method declaredMethodType = MethodTypeUtils.getDeclarationMethod(methodType2);
                        ((Set)GlobalDataFlowAccumulator.this.argumentFlowGraphs.computeIfAbsent(declaredMethodType, __ -> GlobalDataFlowAccumulator.flowGraphList(methodCall.getArguments().size())).get(argumentIndex)).add(flowGraph);
                        if (GlobalDataFlowAccumulator.this.parameterFlowGraphs.containsKey(declaredMethodType)) {
                            for (FlowGraph argumentFlow : (Set)((List)GlobalDataFlowAccumulator.this.parameterFlowGraphs.get(declaredMethodType)).get(argumentIndex)) {
                                flowGraph.addEdge(argumentFlow);
                            }
                        }
                    }
                }
                if ((aReturn = (J.Return)n.getCursor().firstEnclosing(J.Return.class)) != null && Expression.unwrap((Expression)aReturn.getExpression()) == flowGraph.getNode().getCursor().getValue()) {
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)n.getCursor().firstEnclosing(J.MethodDeclaration.class);
                    assert (methodDeclaration != null);
                    JavaType.Method methodType3 = methodDeclaration.getMethodType();
                    if (methodType3 != null) {
                        GlobalDataFlowAccumulator.this.methodReturnFlowGraphs.computeIfAbsent(methodType3, __ -> Collections.newSetFromMap(new IdentityHashMap())).add(flowGraph);
                        if (GlobalDataFlowAccumulator.this.methodCallFlowGraphs.containsKey(methodType3)) {
                            ((Set)GlobalDataFlowAccumulator.this.methodCallFlowGraphs.get(methodType3)).forEach(flowGraph::addEdge);
                        }
                    }
                }
                if (visited.add(flowGraph)) {
                    flowGraph.getEdges().forEach(edge -> this.walkFlowGraphConnectingRecursive((FlowGraph)edge, visited));
                }
            }
        };
    }

    private Set<Cursor> pruneFlowGraphs() {
        Set<FlowGraph> copiedSourceFlowGraphs = Collections.newSetFromMap(new IdentityHashMap());
        for (FlowGraph source : this.sourceFlowGraphs) {
            this.firstPassPruneDepthFirst(source, new HashSet<FlowGraph>());
            FlowGraph copy = GlobalDataFlowAccumulator.copy(source);
            this.secondPassPruneDepthFirst(copy, new ArrayDeque<MethodCall>(), new HashSet<FlowGraph>());
            copiedSourceFlowGraphs.add(copy);
        }
        Set<FlowGraph> foundParticipants = this.findParticipantsBreadthFirst(copiedSourceFlowGraphs);
        return foundParticipants.stream().map(FlowGraph::getNode).map(DataFlowNode::getCursor).collect(Collectors.toSet());
    }

    private static FlowGraph copy(FlowGraph flowGraph) {
        return GlobalDataFlowAccumulator.copy(flowGraph, new IdentityHashMap<FlowGraph, FlowGraph>());
    }

    private static FlowGraph copy(FlowGraph oldFlowGraph, Map<FlowGraph, FlowGraph> oldToNew) {
        FlowGraph newFlowGraph = oldToNew.computeIfAbsent(oldFlowGraph, __ -> new FlowGraph(FlowGraph.Factory.throwing(), oldFlowGraph.getNode()));
        for (FlowGraph oldEdge : oldFlowGraph.getEdges()) {
            if (oldToNew.containsKey(oldEdge)) {
                newFlowGraph.addEdge(oldToNew.get(oldEdge));
                continue;
            }
            FlowGraph newEdge = oldToNew.computeIfAbsent(oldEdge, __ -> new FlowGraph(FlowGraph.Factory.throwing(), oldEdge.getNode()));
            newFlowGraph.addEdge(newEdge);
            GlobalDataFlowAccumulator.copy(oldEdge, oldToNew);
        }
        return newFlowGraph;
    }

    private void firstPassPruneDepthFirst(FlowGraph flowGraph, Set<FlowGraph> visited) {
        if (!visited.add(flowGraph)) {
            return;
        }
        this.firstPassPruneFlowGraph(flowGraph);
        for (FlowGraph toVisit : flowGraph.getEdges()) {
            this.firstPassPruneDepthFirst(toVisit, visited);
        }
    }

    private void firstPassPruneFlowGraph(FlowGraph flowGraph) {
        if (GlobalDataFlowAccumulator.isAnyMethodArgument(flowGraph.getNode())) {
            for (FlowGraph edge : flowGraph.getEdges()) {
                if (!GlobalDataFlowSpec.isAdditionalGlobalDataFlowStep(flowGraph.getNode(), edge.getNode()) || this.spec.isFlowStep(flowGraph.getNode(), edge.getNode())) continue;
                flowGraph.removeEdge(edge);
            }
        }
    }

    private void secondPassPruneDepthFirst(FlowGraph flowGraph, Deque<MethodCall> stack, Set<FlowGraph> visited) {
        this.secondPassPruneFlowGraph(flowGraph, stack);
        if (!visited.add(flowGraph)) {
            return;
        }
        boolean pushedMethodCall = false;
        if (MATCHES_ALL.advanced().isAnyArgument(flowGraph.getNode().getCursor())) {
            MethodCall methodCall = (MethodCall)flowGraph.getNode().getCursor().getParentTreeCursor().firstEnclosing(MethodCall.class);
            assert (methodCall != null);
            assert (methodCall.getArguments().contains(flowGraph.getNode().getCursor().getValue()));
            stack.push(methodCall);
            pushedMethodCall = true;
        }
        for (FlowGraph toVisit : flowGraph.getEdges()) {
            this.secondPassPruneDepthFirst(toVisit, stack, visited);
        }
        if (pushedMethodCall) {
            stack.pop();
        }
    }

    private void secondPassPruneFlowGraph(FlowGraph flowGraph, Deque<MethodCall> stack) {
        J.Return aReturn = (J.Return)flowGraph.getNode().getCursor().firstEnclosing(J.Return.class);
        if (aReturn != null && Expression.unwrap((Expression)aReturn.getExpression()) == flowGraph.getNode().getCursor().getValue()) {
            for (FlowGraph edge : flowGraph.getEdges()) {
                edge.getNode().asExprParent(Call.class).forEach(call -> {
                    Object value = edge.getNode().getCursor().getValue();
                    if (value instanceof MethodCall && !stack.contains(value) && !stack.isEmpty()) {
                        flowGraph.removeEdge(edge);
                    }
                });
            }
        }
    }

    private Set<FlowGraph> findParticipantsBreadthFirst(Set<FlowGraph> flowGraphs) {
        MemoizeReachabilityHolder memoizeReachabilityHolder = new MemoizeReachabilityHolder();
        HashSet<FlowGraph> foundParticipants = new HashSet<FlowGraph>();
        HashSet<FlowGraph> visited = new HashSet<FlowGraph>();
        ArrayDeque<FlowGraph> toVisit = new ArrayDeque<FlowGraph>(flowGraphs);
        while (!toVisit.isEmpty()) {
            FlowGraph current = (FlowGraph)toVisit.poll();
            if (visited.contains(current)) continue;
            if (memoizeReachabilityHolder.isSinkReachable(current)) {
                foundParticipants.add(current);
                toVisit.addAll(current.getEdges());
            }
            visited.add(current);
        }
        return foundParticipants;
    }

    @Override
    public GlobalDataFlow.Summary summary(Cursor cursor) {
        Set<Cursor> prunedParticipatingNodes = this.pruneFlowGraphs();
        if (prunedParticipatingNodes.isEmpty()) {
            return AlwaysFalseSummary.INSTANCE;
        }
        return (GlobalDataFlow.Summary)DataFlowNode.of(cursor).map(n -> new ResultSummary((DataFlowNode)n, prunedParticipatingNodes)).orSome((Object)AlwaysFalseSummary.INSTANCE);
    }

    private static boolean isAnyMethodArgument(DataFlowNode node) {
        return (Boolean)node.asExpr().map(e -> MATCHES_ALL.advanced().isAnyArgument(node.getCursor())).orSome((Object)false);
    }

    private static List<Set<FlowGraph>> flowGraphList(int size) {
        ArrayList<Set<FlowGraph>> flowGraphs = new ArrayList<Set<FlowGraph>>(size);
        for (int i = 0; i < size; ++i) {
            flowGraphs.add(Collections.newSetFromMap(new IdentityHashMap()));
        }
        return flowGraphs;
    }

    @Generated
    public DataFlowSpec getSpec() {
        return this.spec;
    }

    @Generated
    public FlowGraph.Factory getFlowGraphFactory() {
        return this.flowGraphFactory;
    }

    @Generated
    public Set<FlowGraph> getSourceFlowGraphs() {
        return this.sourceFlowGraphs;
    }

    @Generated
    public Map<JavaType.Method, Set<FlowGraph>> getMethodCallFlowGraphs() {
        return this.methodCallFlowGraphs;
    }

    @Generated
    public Map<JavaType.Method, List<Set<FlowGraph>>> getParameterFlowGraphs() {
        return this.parameterFlowGraphs;
    }

    @Generated
    public Map<JavaType.Method, List<Set<FlowGraph>>> getArgumentFlowGraphs() {
        return this.argumentFlowGraphs;
    }

    @Generated
    public Map<JavaType.Method, Set<FlowGraph>> getMethodReturnFlowGraphs() {
        return this.methodReturnFlowGraphs;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalDataFlowAccumulator)) {
            return false;
        }
        GlobalDataFlowAccumulator other = (GlobalDataFlowAccumulator)o;
        DataFlowSpec this$spec = this.getSpec();
        DataFlowSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        FlowGraph.Factory this$flowGraphFactory = this.getFlowGraphFactory();
        FlowGraph.Factory other$flowGraphFactory = other.getFlowGraphFactory();
        if (this$flowGraphFactory == null ? other$flowGraphFactory != null : !this$flowGraphFactory.equals(other$flowGraphFactory)) {
            return false;
        }
        Set<FlowGraph> this$sourceFlowGraphs = this.getSourceFlowGraphs();
        Set<FlowGraph> other$sourceFlowGraphs = other.getSourceFlowGraphs();
        if (this$sourceFlowGraphs == null ? other$sourceFlowGraphs != null : !((Object)this$sourceFlowGraphs).equals(other$sourceFlowGraphs)) {
            return false;
        }
        Map<JavaType.Method, Set<FlowGraph>> this$methodCallFlowGraphs = this.getMethodCallFlowGraphs();
        Map<JavaType.Method, Set<FlowGraph>> other$methodCallFlowGraphs = other.getMethodCallFlowGraphs();
        if (this$methodCallFlowGraphs == null ? other$methodCallFlowGraphs != null : !((Object)this$methodCallFlowGraphs).equals(other$methodCallFlowGraphs)) {
            return false;
        }
        Map<JavaType.Method, List<Set<FlowGraph>>> this$parameterFlowGraphs = this.getParameterFlowGraphs();
        Map<JavaType.Method, List<Set<FlowGraph>>> other$parameterFlowGraphs = other.getParameterFlowGraphs();
        if (this$parameterFlowGraphs == null ? other$parameterFlowGraphs != null : !((Object)this$parameterFlowGraphs).equals(other$parameterFlowGraphs)) {
            return false;
        }
        Map<JavaType.Method, List<Set<FlowGraph>>> this$argumentFlowGraphs = this.getArgumentFlowGraphs();
        Map<JavaType.Method, List<Set<FlowGraph>>> other$argumentFlowGraphs = other.getArgumentFlowGraphs();
        if (this$argumentFlowGraphs == null ? other$argumentFlowGraphs != null : !((Object)this$argumentFlowGraphs).equals(other$argumentFlowGraphs)) {
            return false;
        }
        Map<JavaType.Method, Set<FlowGraph>> this$methodReturnFlowGraphs = this.getMethodReturnFlowGraphs();
        Map<JavaType.Method, Set<FlowGraph>> other$methodReturnFlowGraphs = other.getMethodReturnFlowGraphs();
        return !(this$methodReturnFlowGraphs == null ? other$methodReturnFlowGraphs != null : !((Object)this$methodReturnFlowGraphs).equals(other$methodReturnFlowGraphs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataFlowSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        FlowGraph.Factory $flowGraphFactory = this.getFlowGraphFactory();
        result = result * 59 + ($flowGraphFactory == null ? 43 : $flowGraphFactory.hashCode());
        Set<FlowGraph> $sourceFlowGraphs = this.getSourceFlowGraphs();
        result = result * 59 + ($sourceFlowGraphs == null ? 43 : ((Object)$sourceFlowGraphs).hashCode());
        Map<JavaType.Method, Set<FlowGraph>> $methodCallFlowGraphs = this.getMethodCallFlowGraphs();
        result = result * 59 + ($methodCallFlowGraphs == null ? 43 : ((Object)$methodCallFlowGraphs).hashCode());
        Map<JavaType.Method, List<Set<FlowGraph>>> $parameterFlowGraphs = this.getParameterFlowGraphs();
        result = result * 59 + ($parameterFlowGraphs == null ? 43 : ((Object)$parameterFlowGraphs).hashCode());
        Map<JavaType.Method, List<Set<FlowGraph>>> $argumentFlowGraphs = this.getArgumentFlowGraphs();
        result = result * 59 + ($argumentFlowGraphs == null ? 43 : ((Object)$argumentFlowGraphs).hashCode());
        Map<JavaType.Method, Set<FlowGraph>> $methodReturnFlowGraphs = this.getMethodReturnFlowGraphs();
        result = result * 59 + ($methodReturnFlowGraphs == null ? 43 : ((Object)$methodReturnFlowGraphs).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GlobalDataFlowAccumulator(spec=" + this.getSpec() + ", flowGraphFactory=" + this.getFlowGraphFactory() + ", sourceFlowGraphs=" + this.getSourceFlowGraphs() + ", methodCallFlowGraphs=" + this.getMethodCallFlowGraphs() + ", parameterFlowGraphs=" + this.getParameterFlowGraphs() + ", argumentFlowGraphs=" + this.getArgumentFlowGraphs() + ", methodReturnFlowGraphs=" + this.getMethodReturnFlowGraphs() + ")";
    }

    @Generated
    GlobalDataFlowAccumulator(DataFlowSpec spec) {
        this.spec = spec;
    }

    private static class GlobalDataFlowSpec
    extends DataFlowSpec {
        private final DataFlowSpec decorated;

        @Override
        public boolean isSource(DataFlowNode srcNode) {
            return this.decorated.isSource(srcNode);
        }

        @Override
        public boolean isSink(DataFlowNode sinkNode) {
            return false;
        }

        @Override
        public boolean isAdditionalFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
            return this.decorated.isAdditionalFlowStep(srcNode, sinkNode) || GlobalDataFlowSpec.isAdditionalGlobalDataFlowStep(srcNode, sinkNode);
        }

        @Override
        public boolean isBarrier(DataFlowNode node) {
            return this.decorated.isBarrier(node);
        }

        @Override
        public boolean isBarrierGuard(Guard guard, boolean branch) {
            return this.decorated.isBarrierGuard(guard, branch);
        }

        static boolean isAdditionalGlobalDataFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
            return (Boolean)sinkNode.asExprParent(Call.class).map(call -> call.methodTypeMatcher().advanced().isAnyArgument(srcNode.getCursor())).orSome((Object)false);
        }

        @Generated
        public GlobalDataFlowSpec(DataFlowSpec decorated) {
            this.decorated = decorated;
        }
    }

    private class MemoizeReachabilityHolder {
        private final Map<FlowGraph, Boolean> reachable = new IdentityHashMap<FlowGraph, Boolean>();

        private MemoizeReachabilityHolder() {
        }

        private boolean isSinkReachable(FlowGraph flowGraph) {
            return this.reachable.computeIfAbsent(flowGraph, fg -> this.isSinkReachable((FlowGraph)fg, (Set<FlowGraph>)new HashSet<FlowGraph>()));
        }

        private boolean isSinkReachable(FlowGraph flowGraph, Set<FlowGraph> visited) {
            if (this.reachable.getOrDefault(flowGraph, false).booleanValue() || GlobalDataFlowAccumulator.this.spec.isSink(flowGraph.getNode())) {
                return true;
            }
            if (!visited.add(flowGraph)) {
                return false;
            }
            for (FlowGraph edge : flowGraph.getEdges()) {
                if (!this.isSinkReachable(edge, visited)) continue;
                return true;
            }
            return false;
        }
    }

    static class JMappedFlowGraphFactory
    implements FlowGraph.Factory {
        Map<J, FlowGraph> flowGraphs = new IdentityHashMap<J, FlowGraph>();

        JMappedFlowGraphFactory() {
        }

        @Override
        public FlowGraph create(DataFlowNode node) {
            return this.flowGraphs.computeIfAbsent((J)node.getCursor().getValue(), t -> new FlowGraph(this, node));
        }
    }

    private class ResultSummary
    implements GlobalDataFlow.Summary {
        private final DataFlowNode node;
        private final Set<Cursor> prunedParticipatingCursors;
        private final AtomicReference<Object> prunedParticipating = new AtomicReference();

        @Override
        public boolean isSource() {
            return GlobalDataFlowAccumulator.this.spec.isSource(this.node) && this.isFlowParticipant();
        }

        @Override
        public boolean isSink() {
            return GlobalDataFlowAccumulator.this.spec.isSink(this.node) && this.isFlowParticipant();
        }

        @Override
        public boolean isFlowParticipant() {
            return this.getPrunedParticipating().contains(this.node.getCursor().getValue());
        }

        @Generated
        public ResultSummary(DataFlowNode node, Set<Cursor> prunedParticipatingCursors) {
            this.node = node;
            this.prunedParticipatingCursors = prunedParticipatingCursors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public Set<J> getPrunedParticipating() {
            Object $value = this.prunedParticipating.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.prunedParticipating;
                synchronized (atomicReference) {
                    $value = this.prunedParticipating.get();
                    if ($value == null) {
                        Set actualValue = this.prunedParticipatingCursors.stream().map(Cursor::getValue).collect(Collectors.toSet());
                        $value = actualValue == null ? this.prunedParticipating : actualValue;
                        this.prunedParticipating.set($value);
                    }
                }
            }
            return (Set)($value == this.prunedParticipating ? null : $value);
        }
    }
}

