/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransmittanceRange
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransmittanceRange.class);
    private PercentFraction transmittance;
    private Length cutInTolerance;
    private Length cutOutTolerance;
    private Length cutIn;
    private Length cutOut;

    public TransmittanceRange() {
    }

    public TransmittanceRange(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public TransmittanceRange(TransmittanceRange orig) {
        this.transmittance = orig.transmittance;
        this.cutInTolerance = orig.cutInTolerance;
        this.cutOutTolerance = orig.cutOutTolerance;
        this.cutIn = orig.cutIn;
        this.cutOut = orig.cutOut;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        NonNegativeFloat baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Transmittance")) {
            this.setTransmittance(PercentFraction.valueOf(element.getAttribute("Transmittance")));
        }
        if (element.hasAttribute("CutInTolerance")) {
            unitSymbol = element.getAttribute("CutInToleranceUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = TransmittanceRange.getCutInToleranceUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = NonNegativeFloat.valueOf(element.getAttribute("CutInTolerance"));
            if (baseValue != null) {
                this.setCutInTolerance(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("CutOutTolerance")) {
            unitSymbol = element.getAttribute("CutOutToleranceUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = TransmittanceRange.getCutOutToleranceUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = NonNegativeFloat.valueOf(element.getAttribute("CutOutTolerance"));
            if (baseValue != null) {
                this.setCutOutTolerance(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("CutIn")) {
            unitSymbol = element.getAttribute("CutInUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = TransmittanceRange.getCutInUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = PositiveFloat.valueOf(element.getAttribute("CutIn"));
            if (baseValue != null) {
                this.setCutIn(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("CutOut")) {
            unitSymbol = element.getAttribute("CutOutUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = TransmittanceRange.getCutOutUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = PositiveFloat.valueOf(element.getAttribute("CutOut"));
            if (baseValue != null) {
                this.setCutOut(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PercentFraction getTransmittance() {
        return this.transmittance;
    }

    public void setTransmittance(PercentFraction transmittance) {
        this.transmittance = transmittance;
    }

    public Length getCutInTolerance() {
        return this.cutInTolerance;
    }

    public void setCutInTolerance(Length cutInTolerance) {
        this.cutInTolerance = cutInTolerance;
    }

    public Length getCutOutTolerance() {
        return this.cutOutTolerance;
    }

    public void setCutOutTolerance(Length cutOutTolerance) {
        this.cutOutTolerance = cutOutTolerance;
    }

    public static String getCutOutToleranceUnitXsdDefault() {
        return "nm";
    }

    public static String getCutInToleranceUnitXsdDefault() {
        return "nm";
    }

    public Length getCutIn() {
        return this.cutIn;
    }

    public void setCutIn(Length cutIn) {
        this.cutIn = cutIn;
    }

    public static String getCutOutUnitXsdDefault() {
        return "nm";
    }

    public static String getCutInUnitXsdDefault() {
        return "nm";
    }

    public Length getCutOut() {
        return this.cutOut;
    }

    public void setCutOut(Length cutOut) {
        this.cutOut = cutOut;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element TransmittanceRange_element) {
        UnitsLength enumUnits;
        if (TransmittanceRange_element == null) {
            TransmittanceRange_element = document.createElementNS(NAMESPACE, "TransmittanceRange");
        }
        super.asXMLElement(document, TransmittanceRange_element);
        if (this.transmittance != null) {
            TransmittanceRange_element.setAttribute("Transmittance", this.transmittance.toString());
        }
        if (this.cutInTolerance != null) {
            if (this.cutInTolerance.value() != null) {
                TransmittanceRange_element.setAttribute("CutInTolerance", this.cutInTolerance.value().toString());
            }
            if (this.cutInTolerance.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.cutInTolerance.unit().getSymbol());
                    TransmittanceRange_element.setAttribute("CutInToleranceUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for TransmittanceRange:CutInToleranceUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.cutOutTolerance != null) {
            if (this.cutOutTolerance.value() != null) {
                TransmittanceRange_element.setAttribute("CutOutTolerance", this.cutOutTolerance.value().toString());
            }
            if (this.cutOutTolerance.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.cutOutTolerance.unit().getSymbol());
                    TransmittanceRange_element.setAttribute("CutOutToleranceUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for TransmittanceRange:CutOutToleranceUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.cutIn != null) {
            if (this.cutIn.value() != null) {
                TransmittanceRange_element.setAttribute("CutIn", this.cutIn.value().toString());
            }
            if (this.cutIn.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.cutIn.unit().getSymbol());
                    TransmittanceRange_element.setAttribute("CutInUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for TransmittanceRange:CutInUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.cutOut != null) {
            if (this.cutOut.value() != null) {
                TransmittanceRange_element.setAttribute("CutOut", this.cutOut.value().toString());
            }
            if (this.cutOut.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.cutOut.unit().getSymbol());
                    TransmittanceRange_element.setAttribute("CutOutUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for TransmittanceRange:CutOutUnit: {}", (Object)e.toString());
                }
            }
        }
        return TransmittanceRange_element;
    }
}

