/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.BinData;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Mask
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Mask.class);
    private Double y;
    private Double x;
    private Double height;
    private Double width;
    private BinData binData;

    public Mask() {
    }

    public Mask(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Mask(Mask orig) {
        super(orig);
        this.y = orig.y;
        this.x = orig.x;
        this.height = orig.height;
        this.width = orig.width;
        this.binData = orig.binData;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> BinData_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
        if (element.hasAttribute("Height")) {
            this.setHeight(Double.valueOf(element.getAttribute("Height")));
        }
        if (element.hasAttribute("Width")) {
            this.setWidth(Double.valueOf(element.getAttribute("Width")));
        }
        if ((BinData_nodeList = Mask.getChildrenByTagName(element, "BinData")).size() > 1) {
            throw new RuntimeException(String.format("BinData node list size %d != 1", BinData_nodeList.size()));
        }
        if (BinData_nodeList.size() != 0) {
            this.setBinData(new BinData(BinData_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public BinData getBinData() {
        return this.binData;
    }

    public void setBinData(BinData binData) {
        this.binData = binData;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Mask_element) {
        if (Mask_element == null) {
            Mask_element = document.createElementNS(NAMESPACE, "Mask");
        }
        super.asXMLElement(document, Mask_element);
        if (this.y != null) {
            Mask_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Mask_element.setAttribute("X", this.x.toString());
        }
        if (this.height != null) {
            Mask_element.setAttribute("Height", this.height.toString());
        }
        if (this.width != null) {
            Mask_element.setAttribute("Width", this.width.toString());
        }
        if (this.binData != null) {
            Element child = document.createElementNS(NAMESPACE, "BinData");
            this.binData.asXMLElement(document, child);
            Mask_element.appendChild(child);
        }
        return Mask_element;
    }
}

