/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Power;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Instrument;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsPower;
import ome.xml.model.enums.handlers.UnitsPowerEnumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LightSource
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightSource.class);
    private String id;
    private Power power;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Instrument instrument;

    public LightSource() {
    }

    public LightSource(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public LightSource(LightSource orig) {
        super(orig);
        this.id = orig.id;
        this.power = orig.power;
        this.annotationLinks = orig.annotationLinks;
        this.instrument = orig.instrument;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("LightSource missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Power")) {
            String unitSymbol = element.getAttribute("PowerUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = LightSource.getPowerUnitXsdDefault();
            }
            UnitsPower modelUnit = UnitsPower.fromString(unitSymbol);
            Double baseValue = Double.valueOf(element.getAttribute("Power"));
            if (baseValue != null) {
                this.setPower(UnitsPowerEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        List<Element> AnnotationRef_nodeList = LightSource.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkLightSource(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public static String getPowerUnitXsdDefault() {
        return "mW";
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Power getPower() {
        return this.power;
    }

    public void setPower(Power power) {
        this.power = power;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkLightSource(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkLightSource(this);
        return this.annotationLinks.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element LightSource_element) {
        if (LightSource_element == null) {
            LightSource_element = document.createElementNS(NAMESPACE, "LightSource");
        }
        super.asXMLElement(document, LightSource_element);
        if (this.id != null) {
            LightSource_element.setAttribute("ID", this.id.toString());
        }
        if (this.power != null) {
            if (this.power.value() != null) {
                LightSource_element.setAttribute("Power", this.power.value().toString());
            }
            if (this.power.unit() != null) {
                try {
                    UnitsPower enumUnits = UnitsPower.fromString(this.power.unit().getSymbol());
                    LightSource_element.setAttribute("PowerUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for LightSource:PowerUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                LightSource_element.appendChild(child);
            }
        }
        if (this.instrument != null) {
            // empty if block
        }
        return LightSource_element;
    }
}

