/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BlockNode;
import org.openl.binding.impl.CastNode;
import org.openl.binding.impl.IfNode;
import org.openl.binding.impl.LoopNode;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.method.table.TableMethod;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.validation.BoundNodeAnalyzingUtils;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public class MethodUnreachableStatementValidator
implements IOpenLValidator {
    public static MethodUnreachableStatementValidator getInstance() {
        return Holder.INSTANCE;
    }

    private MethodUnreachableStatementValidator() {
    }

    public ValidationResult validate(IOpenClass openClass) {
        ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
        this.visit(openClass.getMethods(), messages);
        return ValidationUtils.withMessages(messages);
    }

    private void visit(Collection<IOpenMethod> methods, List<OpenLMessage> messages) {
        for (IOpenMethod method : methods) {
            if (method instanceof OpenMethodDispatcher) {
                this.visit(((OpenMethodDispatcher)method).getCandidates(), messages);
                continue;
            }
            this.visit(WrapperLogic.unwrapOpenMethod(method), messages);
        }
    }

    private void visit(IOpenMethod method, List<OpenLMessage> messages) {
        if (!(method instanceof TableMethod)) {
            return;
        }
        IBoundMethodNode boundNode = ((TableMethod)method).getCompositeMethod().getMethodBodyBoundNode();
        this.visitStatement((IBoundNode)boundNode, messages);
    }

    private void visitStatement(IBoundNode blockNode, List<OpenLMessage> messages) {
        if (blockNode == null) {
            return;
        }
        if (blockNode instanceof LoopNode) {
            this.visitStatement(((LoopNode)blockNode).getBlockCodeNode(), messages);
        } else if (blockNode instanceof IfNode) {
            this.visitStatement(((IfNode)blockNode).getThenNode(), messages);
            this.visitStatement(((IfNode)blockNode).getElseNode(), messages);
        } else if (blockNode instanceof CastNode) {
            this.visitStatement(blockNode.getChildren()[0], messages);
        } else if (blockNode instanceof BlockNode) {
            IBoundNode[] children = blockNode.getChildren();
            if (children.length == 0) {
                return;
            }
            for (int i = 0; i < children.length - 1; ++i) {
                this.checkPair(children[i], children[i + 1], messages);
                this.visitStatement(children[i], messages);
            }
            this.visitStatement(children[children.length - 1], messages);
        }
    }

    private void checkPair(IBoundNode prevNode, IBoundNode node, List<OpenLMessage> messages) {
        if (!BoundNodeAnalyzingUtils.nodeMayCompleteNormally(prevNode)) {
            messages.add(OpenLMessagesUtils.newWarnMessage((String)"Unreachable statement", (ISyntaxNode)node.getSyntaxNode()));
        }
    }

    private static class Holder {
        private static final MethodUnreachableStatementValidator INSTANCE = new MethodUnreachableStatementValidator();

        private Holder() {
        }
    }
}

