/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.util.Objects;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.testmethod.result.GenericComparator;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;

class ObjectComparator
extends GenericComparator<Object> {
    private static final ObjectComparator INSTANCE = new ObjectComparator();
    private Double delta;

    private ObjectComparator() {
    }

    ObjectComparator(Double delta) {
        this.delta = delta;
    }

    @Override
    boolean equals(Object expectedValue, Object actualValue) {
        TestResultComparator comparator;
        Class<?> actualClass;
        Class<?> expectedClass = expectedValue.getClass();
        if (expectedClass != (actualClass = actualValue.getClass()) && String.class == expectedClass) {
            try {
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(actualClass);
                expectedValue = convertor.parse((String)expectedValue, null);
            }
            catch (Exception convertor) {
                // empty catch block
            }
        }
        if ((comparator = TestResultComparatorFactory.getComparator(expectedValue.getClass(), this.delta)).getClass() != this.getClass()) {
            return comparator.isEqual(expectedValue, actualValue);
        }
        return Objects.equals(expectedValue, actualValue);
    }

    public static TestResultComparator getInstance() {
        return INSTANCE;
    }
}

