/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openl.binding.impl.CastToWiderType;
import org.openl.rules.testmethod.export.ExportUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.OpenClassUtils;

class FieldDescriptor {
    private final IOpenField field;
    private final List<FieldDescriptor> children;

    static List<FieldDescriptor> nonEmptyFields(IOpenClass type, List<?> values) {
        return FieldDescriptor.nonEmptyFieldsForFlatten(type, ExportUtils.flatten(values));
    }

    private static List<FieldDescriptor> nonEmptyFieldsForFlatten(IOpenClass type, List<?> values) {
        if ((type = OpenClassUtils.getRootComponentClass((IOpenClass)type)).isSimple() || ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
            return null;
        }
        ArrayList<FieldDescriptor> result = new ArrayList<FieldDescriptor>();
        block0: for (IOpenField field : type.getFields()) {
            if (field.getType().equals(JavaOpenClass.CLASS)) continue;
            IOpenClass fieldType = field.getType();
            List<Object> childFieldValues = ExportUtils.flatten(ExportUtils.fieldValues(values, field));
            for (Object value : values) {
                Object fieldValue = value == null ? null : field.get(value, null);
                if (fieldValue == null || field.getType().isArray() && Array.getLength(fieldValue) <= 0) continue;
                if (fieldValue instanceof Collection) {
                    fieldType = CastToWiderType.defineCollectionWiderType((Collection)((Collection)fieldValue));
                }
                List<FieldDescriptor> children = FieldDescriptor.nonEmptyFieldsForFlatten(fieldType, childFieldValues);
                result.add(new FieldDescriptor(field, children));
                continue block0;
            }
        }
        result.sort(Comparator.comparing(FieldDescriptor::isArray));
        return result;
    }

    private FieldDescriptor(IOpenField field, List<FieldDescriptor> children) {
        this.field = field;
        this.children = children;
    }

    public IOpenField getField() {
        return this.field;
    }

    public List<FieldDescriptor> getChildren() {
        return this.children;
    }

    public boolean isArray() {
        return this.field.getType().isArray();
    }

    public int getLeafNodeCount() {
        if (this.children == null) {
            return 1;
        }
        int width = 0;
        for (FieldDescriptor child : this.children) {
            width += child.getLeafNodeCount();
        }
        return width;
    }

    public int getMaxArraySize(Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass().isArray()) {
            int count = Array.getLength(object);
            int height = 0;
            for (int i = 0; i < count; ++i) {
                height += this.getMaxArraySize(Array.get(object, i));
            }
            return height == 0 ? 1 : height;
        }
        Object fieldValue = ExportUtils.fieldValue(object, this.getField());
        return this.calcArraySizeForChild(fieldValue);
    }

    private int calcArraySizeForChild(Object fieldValue) {
        if (fieldValue == null) {
            return 1;
        }
        if (this.children == null) {
            return 1;
        }
        if (fieldValue.getClass().isArray()) {
            int size = 0;
            int count = Array.getLength(fieldValue);
            for (int i = 0; i < count; ++i) {
                size += this.calcArraySizeForChild(Array.get(fieldValue, i));
            }
            return size == 0 ? 1 : size;
        }
        int max = 1;
        for (FieldDescriptor child : this.children) {
            int childSize = child.getMaxArraySize(fieldValue);
            if (childSize <= max) continue;
            max = childSize;
        }
        return max;
    }
}

