/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.source.IOpenSourceCodeModule;

public final class ConversionRulesController {
    private final ConversionRuleBean[] conversionRules = AlgorithmTableParserManager.getInstance().getFixedConversionRules();

    public static ConversionRulesController getInstance() {
        return new ConversionRulesController();
    }

    private ConversionRulesController() {
    }

    public ConversionRuleBean getConvertionRule(List<AlgorithmTreeNode> nodesToCompile, IBindingContext bindingContext) {
        assert (!nodesToCompile.isEmpty());
        ArrayList<String> groupedOperationNames = new ArrayList<String>(nodesToCompile.size());
        for (AlgorithmTreeNode node : nodesToCompile) {
            groupedOperationNames.add(node.getSpecificationKeyword().toUpperCase());
        }
        String operationGroupName = AlgorithmTableParserManager.getInstance().whatIsOperationsGroupName(groupedOperationNames);
        boolean isMultilineOperation = nodesToCompile.get(0).getSpecification().isMultiline();
        for (ConversionRuleBean conversionRule : this.conversionRules) {
            if (!conversionRule.getOperation().equals(operationGroupName) || conversionRule.isMultiLine() != isMultilineOperation) continue;
            return conversionRule;
        }
        List<String> predecessorOperations = Arrays.asList(nodesToCompile.get(0).getSpecification().getPredecessorOperations());
        String errorMessage = String.format("The operations sequence is wrong: %2$s. Operations %1$s must precede the %2$s", predecessorOperations, groupedOperationNames);
        IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
        BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        return null;
    }
}

