/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmOperationSource;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;

public final class AlgorithmCompilerTool {
    public static final String FIELD_SEPARATOR = ".";

    private AlgorithmCompilerTool() {
    }

    private static String extractFieldName(String instruction) {
        return instruction.split(Pattern.quote(FIELD_SEPARATOR))[1];
    }

    private static String extractOperationName(String instruction) {
        return instruction.split(Pattern.quote(FIELD_SEPARATOR))[0];
    }

    public static AlgorithmTreeNode extractOperationNode(List<AlgorithmTreeNode> candidateNodes, String instruction, IBindingContext bindingContext) {
        AlgorithmTreeNode operationNode = null;
        String operationName = AlgorithmCompilerTool.extractOperationName(instruction);
        for (AlgorithmTreeNode node : candidateNodes) {
            if (!AlgorithmCompilerTool.isOperationNode(operationName, node)) continue;
            operationNode = node;
        }
        if (operationNode == null) {
            IOpenSourceCodeModule errorSource = candidateNodes.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
            BindHelper.processError((String)String.format("Compilation failure. Cannot find %s in operations sequence %s", operationName, candidateNodes), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        }
        return operationNode;
    }

    private static boolean isOperationNode(String operationName, AlgorithmTreeNode node) {
        return operationName.equalsIgnoreCase(node.getAlgorithmRow().getOperation().getValue());
    }

    public static Map<String, AlgorithmTreeNode> getAllDeclaredLables(List<AlgorithmTreeNode> nodesToSearch) {
        HashMap<String, AlgorithmTreeNode> labels = new HashMap<String, AlgorithmTreeNode>();
        for (AlgorithmTreeNode node : nodesToSearch) {
            for (StringValue labelOfNode : node.getLabels()) {
                labels.put(labelOfNode.getValue(), node);
            }
            labels.putAll(AlgorithmCompilerTool.getAllDeclaredLables(node.getChildren()));
        }
        return labels;
    }

    public static StringValue getCellContent(List<AlgorithmTreeNode> candidateNodes, String instruction, IBindingContext bindingContext) {
        String fieldName = AlgorithmCompilerTool.extractFieldName(instruction);
        IOpenField codeField = JavaOpenClass.getOpenClass(AlgorithmRow.class).getField(fieldName);
        if (codeField == null) {
            IOpenSourceCodeModule errorSource = candidateNodes.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
            BindHelper.processError((String)String.format("Compilation failure. Cannot find '%s' field", fieldName), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
            return new StringValue("");
        }
        AlgorithmTreeNode executionNode = AlgorithmCompilerTool.extractOperationNode(candidateNodes, instruction, bindingContext);
        return (StringValue)codeField.get((Object)executionNode.getAlgorithmRow(), null);
    }

    public static AlgorithmTreeNode getLastExecutableOperation(List<AlgorithmTreeNode> nodes) {
        AlgorithmTreeNode lastOperation = nodes.get(nodes.size() - 1);
        if (lastOperation.getSpecificationKeyword().startsWith(TBasicSpecificationKey.END.toString())) {
            lastOperation = AlgorithmCompilerTool.getLastExecutableOperation(nodes.subList(0, nodes.size() - 1));
        } else if (!lastOperation.getChildren().isEmpty()) {
            lastOperation = AlgorithmCompilerTool.getLastExecutableOperation(lastOperation.getChildren());
        }
        return lastOperation;
    }

    public static int getLinkedNodesGroupSize(List<AlgorithmTreeNode> nodesToProcess, int firstNodeIndex) {
        int linkedNodesGroupSize;
        AlgorithmTreeNode currentNodeToProcess = nodesToProcess.get(firstNodeIndex);
        String currentNodeKeyword = currentNodeToProcess.getSpecificationKeyword();
        String[] operationNamesToGroup = AlgorithmTableParserManager.getInstance().whatOperationsToGroup(currentNodeKeyword);
        if (operationNamesToGroup != null) {
            AlgorithmTreeNode groupCandidateNode;
            List<String> operationsToGroupWithCurrent = Arrays.asList(operationNamesToGroup);
            for (linkedNodesGroupSize = 1; linkedNodesGroupSize < nodesToProcess.size() - firstNodeIndex && operationsToGroupWithCurrent.contains((groupCandidateNode = nodesToProcess.get(firstNodeIndex + linkedNodesGroupSize)).getSpecificationKeyword()); ++linkedNodesGroupSize) {
            }
        }
        return linkedNodesGroupSize;
    }

    public static List<AlgorithmTreeNode> getNestedInstructionsBlock(List<AlgorithmTreeNode> candidateNodes, String instruction, IBindingContext bindingContext) {
        AlgorithmTreeNode executionNode = AlgorithmCompilerTool.extractOperationNode(candidateNodes, instruction, bindingContext);
        return executionNode.getChildren();
    }

    public static AlgorithmOperationSource getOperationSource(List<AlgorithmTreeNode> nodesToCompile, String instruction, IBindingContext bindingContext) {
        AlgorithmTreeNode sourceNode;
        String operationValueName = null;
        if (AlgorithmCompilerTool.isOperationFieldInstruction(instruction)) {
            sourceNode = AlgorithmCompilerTool.extractOperationNode(nodesToCompile, instruction, bindingContext);
            operationValueName = AlgorithmCompilerTool.extractFieldName(instruction);
        } else {
            sourceNode = nodesToCompile.get(0);
        }
        return new AlgorithmOperationSource(sourceNode, operationValueName);
    }

    public static boolean isOperationFieldInstruction(String instruction) {
        boolean isInstruction = false;
        if (instruction != null) {
            isInstruction = instruction.split(Pattern.quote(FIELD_SEPARATOR)).length == 2;
        }
        return isInstruction;
    }
}

