/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.meta.StringValue;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AlgorithmMetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.RowParser;
import org.openl.rules.tbasic.TableParserSpecificationBean;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AlgorithmBuilder.class);
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String OPERATION1 = "operation";
    public static final String CONDITION = "condition";
    public static final String ACTION = "action";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String CELL = "cell";
    private static final String UNDERSCORE = "_";
    private static final String OPERATION = "Operation";
    public static final CellMetaInfo CELL_META_INFO;
    private final IBindingContext bindingContext;
    private final Algorithm algorithm;
    private final TableSyntaxNode tsn;
    private Map<String, AlgorithmColumn> columns;

    public AlgorithmBuilder(IBindingContext ctx, Algorithm algorithm, TableSyntaxNode tsn) {
        this.bindingContext = ctx;
        this.algorithm = algorithm;
        this.tsn = tsn;
    }

    public void build(IBindingContext cxt, ILogicalTable tableBody) throws Exception {
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid table. Provide table body", null, (ISyntaxNode)this.tsn);
        }
        if (tableBody.getHeight() <= 2) {
            throw SyntaxNodeExceptionUtils.createError((String)"Insufficient rows. Must be more than 2.", null, (ISyntaxNode)this.tsn);
        }
        this.prepareColumns(tableBody);
        List<AlgorithmRow> algorithmRows = this.buildRows(tableBody);
        RowParser rowParser = new RowParser(algorithmRows, AlgorithmTableParserManager.getInstance().getAlgorithmSpecification());
        List<AlgorithmTreeNode> parsedNodes = rowParser.parse();
        AlgorithmCompiler compiler = new AlgorithmCompiler(this.bindingContext, this.algorithm.getHeader(), parsedNodes);
        compiler.compile(this.algorithm, cxt);
    }

    private List<AlgorithmRow> buildRows(ILogicalTable tableBody) throws SyntaxNodeException {
        ArrayList<AlgorithmRow> result = new ArrayList<AlgorithmRow>();
        IGridTable grid = ((ILogicalTable)tableBody.getRows(2)).getSource();
        for (int r = 0; r < grid.getHeight(); ++r) {
            AlgorithmRow aRow = new AlgorithmRow();
            aRow.setRowNumber(r + 1);
            IGridTable rowTable = (IGridTable)grid.getRow(r);
            aRow.setGridRegion(rowTable.getRegion());
            for (AlgorithmColumn column : this.columns.values()) {
                int c = column.columnIndex;
                IGridTable valueTable = (IGridTable)rowTable.getColumn(c);
                aRow.setValueGridRegion(column.id, valueTable.getRegion());
                String value = grid.getCell(c, r).getStringValue();
                if (value == null) {
                    value = "";
                }
                StringValue sv = new StringValue(value, CELL + r + UNDERSCORE + c, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(grid, c, r, this.bindingContext));
                this.setRowField(aRow, column.id, sv);
                if (!OPERATION.equalsIgnoreCase(column.id)) continue;
                ICellStyle cellStyle = grid.getCell(c, r).getStyle();
                int i = cellStyle == null ? 0 : cellStyle.getIndent();
                aRow.setOperationLevel(i);
                if (this.bindingContext.isExecutionMode() || !(this.tsn.getMetaInfoReader() instanceof AlgorithmMetaInfoReader)) continue;
                int operationColumn = grid.getCell(c, r).getAbsoluteColumn();
                ((AlgorithmMetaInfoReader)this.tsn.getMetaInfoReader()).setOperationColumn(operationColumn);
            }
            result.add(aRow);
        }
        return result;
    }

    private void prepareColumns(ILogicalTable tableBody) throws SyntaxNodeException {
        this.columns = new HashMap<String, AlgorithmColumn>();
        ILogicalTable ids = (ILogicalTable)tableBody.getRow(0);
        for (int c = 0; c < ids.getWidth(); ++c) {
            String id = AlgorithmBuilder.safeId(((ILogicalTable)ids.getColumn(c)).getSource().getCell(0, 0).getStringValue());
            if (id.length() == 0) continue;
            if (this.columns.get(id) != null) {
                throw SyntaxNodeExceptionUtils.createError((String)("Duplicate column '" + id + "'."), null, (ISyntaxNode)this.tsn);
            }
            this.columns.put(id, new AlgorithmColumn(id, c));
        }
    }

    private static String safeId(String s) {
        String id = "";
        if (s != null) {
            id = s.trim().toLowerCase();
        }
        return id;
    }

    private void setRowField(AlgorithmRow row, String column, StringValue sv) throws SyntaxNodeException {
        if (LABEL.equalsIgnoreCase(column)) {
            row.setLabel(sv);
        } else if (DESCRIPTION.equalsIgnoreCase(column)) {
            row.setDescription(sv);
        } else if (OPERATION1.equalsIgnoreCase(column)) {
            row.setOperation(sv);
        } else if (CONDITION.equalsIgnoreCase(column)) {
            row.setCondition(sv);
        } else if (ACTION.equalsIgnoreCase(column)) {
            row.setAction(sv);
        } else if (BEFORE.equalsIgnoreCase(column)) {
            row.setBefore(sv);
        } else if (AFTER.equalsIgnoreCase(column)) {
            row.setAfter(sv);
        } else {
            throw SyntaxNodeExceptionUtils.createError((String)("Invalid column id '" + column + "'."), null, (ISyntaxNode)this.tsn);
        }
    }

    static {
        try {
            AlgorithmTableParserManager tbasicParser = AlgorithmTableParserManager.getInstance();
            TableParserSpecificationBean[] algSpecifications = tbasicParser.getAlgorithmSpecification();
            LinkedHashSet<String> algorithmOperations = new LinkedHashSet<String>();
            for (TableParserSpecificationBean specification : algSpecifications) {
                algorithmOperations.add(specification.getKeyword());
            }
            Object[] algorithmOperationsArray = algorithmOperations.toArray(StringUtils.EMPTY_STRING_ARRAY);
            CELL_META_INFO = new CellMetaInfo((IOpenClass)new DomainOpenClass(OPERATION1, (IOpenClass)JavaOpenClass.STRING, (IDomain)new EnumDomain(algorithmOperationsArray), null, null), false);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static final class AlgorithmColumn {
        private final String id;
        private final int columnIndex;

        private AlgorithmColumn(String id, int columnIndex) {
            this.id = id;
            this.columnIndex = columnIndex;
        }
    }
}

