/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openl.rules.table.IGridRegion;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;

public class XlsUrlParser {
    private final String wbPath;
    private final String wbName;
    private final String wsName;
    private final String range;
    private final String cell;

    public XlsUrlParser(String url) {
        String file;
        HashMap<String, String> map = new HashMap<String, String>();
        int indexQuestionMark = url.indexOf(63);
        if (indexQuestionMark >= 0) {
            file = url.substring(0, indexQuestionMark);
            String query = url.substring(indexQuestionMark + 1);
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int idx = pair.indexOf(61);
                if (idx < 0) {
                    map.put(pair, "");
                    continue;
                }
                String key = pair.substring(0, idx);
                String value = pair.substring(idx + 1);
                if ("sheet".equals(key)) {
                    value = StringTool.decodeURL((String)value);
                }
                map.put(key, value);
            }
        } else {
            file = url;
        }
        file = StringTool.decodeURL((String)file);
        this.wsName = (String)map.get("sheet");
        String range = (String)map.get("range");
        String cell = (String)map.get("cell");
        if (range == null) {
            range = cell;
        }
        if (cell == null && range != null) {
            cell = range.substring(0, range.indexOf(":"));
        }
        this.range = range;
        this.cell = cell;
        if ("null".equals(file)) {
            this.wbPath = "/unexistingPath/";
            this.wbName = "unexistingSourceFile.xls";
        } else {
            if (file != null && file.startsWith("file:/")) {
                int prefixSize = file.length() > 7 && file.charAt(7) == ':' ? 6 : 5;
                file = file.substring(prefixSize);
            }
            try {
                File f = new File(file).getCanonicalFile();
                this.wbPath = f.getParent();
                this.wbName = f.getName();
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public boolean intersects(XlsUrlParser p2) {
        if (!(this.wbPath.equals(p2.wbPath) && this.wbName.equals(p2.wbName) && this.wsName.equals(p2.wsName))) {
            return false;
        }
        if (this.range == null || p2.range == null) {
            return false;
        }
        IGridRegion i1 = IGridRegion.Tool.makeRegion(this.range);
        return IGridRegion.Tool.intersects(i1, IGridRegion.Tool.makeRegion(p2.range));
    }

    public String getWbPath() {
        return this.wbPath;
    }

    public String getWbName() {
        return this.wbName;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getRange() {
        return this.range;
    }

    public String getCell() {
        return this.cell;
    }
}

