/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.util.Date;
import java.util.Locale;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.table.formatters.ArrayFormatter;
import org.openl.rules.table.formatters.SmartNumberFormatter;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.util.formatters.BooleanFormatter;
import org.openl.util.formatters.DateFormatter;
import org.openl.util.formatters.DefaultFormatter;
import org.openl.util.formatters.EnumFormatter;
import org.openl.util.formatters.FormatterAdapter;
import org.openl.util.formatters.IFormatter;
import org.openl.util.formatters.NumberFormatter;

public final class FormattersManager {
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DEFAULT_NUMBER_FORMAT = "#.#################";

    private FormattersManager() {
    }

    static IFormatter getFormatter(Object value) {
        FormatterAdapter formatter;
        if (value != null) {
            Class<?> clazz = value.getClass();
            formatter = FormattersManager.getFormatter(clazz);
            if (formatter instanceof DefaultFormatter) {
                formatter = new FormatterAdapter();
            }
        } else {
            formatter = new FormatterAdapter();
        }
        return formatter;
    }

    public static String format(Object value) {
        return FormattersManager.getFormatter(value).format(value);
    }

    public static IFormatter getFormatter(Class<?> clazz, String format) {
        Object formatter;
        if (ClassUtils.isAssignable(clazz, Number.class)) {
            if (StringUtils.isBlank((CharSequence)format) && NumberUtils.isFloatPointType(clazz)) {
                return new SmartNumberFormatter(Locale.US);
            }
            String numberFormat = StringUtils.isNotBlank((CharSequence)format) ? format : DEFAULT_NUMBER_FORMAT;
            formatter = new NumberFormatter(numberFormat, Locale.US);
        } else if (clazz == Date.class) {
            String dateFormat = StringUtils.isNotBlank((CharSequence)format) ? format : DEFAULT_DATE_FORMAT;
            formatter = new DateFormatter(dateFormat);
        } else if (ClassUtils.isAssignable(clazz, Boolean.class)) {
            formatter = new BooleanFormatter();
        } else if (clazz.isEnum()) {
            formatter = new EnumFormatter(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            IFormatter componentFormatter = FormattersManager.getFormatter(componentType);
            formatter = new ArrayFormatter(componentFormatter, componentType);
        } else {
            formatter = new DefaultFormatter();
        }
        return formatter;
    }

    public static IFormatter getFormatter(Class<?> clazz) {
        return FormattersManager.getFormatter(clazz, null);
    }
}

