/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableCopyValueAction
extends AUndoableCellAction {
    private final int colFrom;
    private final int rowFrom;
    private GridRegion toRestore;
    private GridRegion toRemove;

    public UndoableCopyValueAction(int colFrom, int rowFrom, int colTo, int rowTo, MetaInfoWriter metaInfoWriter) {
        super(colTo, rowTo, metaInfoWriter);
        this.colFrom = colFrom;
        this.rowFrom = rowFrom;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.savePrevCell(grid);
        grid.copyCell(this.colFrom, this.rowFrom, this.getCol(), this.getRow());
        CellMetaInfo metaInfo = this.metaInfoWriter.getMetaInfo(this.rowFrom, this.colFrom);
        if (metaInfo != null && metaInfo.getUsedNodes() != null) {
            metaInfo = new CellMetaInfo(metaInfo.getDataType(), metaInfo.isMultiValue());
        }
        this.metaInfoWriter.setMetaInfo(this.getRow(), this.getCol(), metaInfo);
        this.moveRegion(grid);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (this.toRemove != null) {
            grid.removeMergedRegion(this.toRemove);
        }
        if (this.toRestore != null) {
            grid.addMergedRegion(this.toRestore);
        }
        this.restorePrevCell(grid);
    }

    private void moveRegion(IWritableGrid wgrid) {
        IGridRegion rrFrom = wgrid.getRegionStartingAt(this.colFrom, this.rowFrom);
        IGridRegion rrTo = wgrid.getRegionStartingAt(this.getCol(), this.getRow());
        if (rrTo != null) {
            this.toRestore = new GridRegion(rrTo);
            wgrid.removeMergedRegion(this.toRestore);
        }
        if (rrFrom != null) {
            GridRegion copyFrom = new GridRegion(rrFrom.getTop() + this.getRow() - this.rowFrom, rrFrom.getLeft() + this.getCol() - this.colFrom, rrFrom.getBottom() + this.getRow() - this.rowFrom, rrFrom.getRight() + this.getCol() - this.colFrom);
            wgrid.addMergedRegion(copyFrom);
            this.toRemove = copyFrom;
        }
    }
}

