/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.IUndoableGridTableAction;

public class MergeCellsAction
implements IUndoableGridTableAction {
    private final IGridRegion region;
    private List<IGridRegion> removedRegions;

    public MergeCellsAction(IGridRegion region) {
        this.region = region;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.removedRegions = new ArrayList<IGridRegion>();
        int nregions = grid.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            IGridRegion reg = grid.getMergedRegion(i);
            if (!IGridRegion.Tool.contains(this.region, reg.getLeft(), reg.getTop())) continue;
            this.removedRegions.add(reg);
        }
        for (IGridRegion regionToRemove : this.removedRegions) {
            grid.removeMergedRegion(regionToRemove);
        }
        grid.addMergedRegion(this.region);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.removeMergedRegion(this.region);
        for (IGridRegion mergedRegion : this.removedRegions) {
            grid.addMergedRegion(mergedRegion);
        }
    }
}

