/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.range;

import java.text.ParseException;
import org.openl.rules.range.Range;
import org.openl.rules.range.Separator;
import org.openl.util.StringUtils;

public class RangeParser {
    Range.Type type;
    String left;
    String right;

    private RangeParser(Range.Type type, String left, String right) {
        this.type = type;
        this.left = left;
        this.right = right;
    }

    RangeParser(Range.Type type, String text) {
        this.type = type;
        this.left = type.left == Range.Bound.UNBOUND ? null : text;
        this.right = type.right == Range.Bound.UNBOUND ? null : text;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(20);
        Range.Type type = this.getType();
        switch (type) {
            case OPEN: 
            case CLOSED: 
            case OPEN_CLOSED: 
            case CLOSED_OPEN: {
                s.append(type.left == Range.Bound.OPEN ? (char)'(' : '[');
                s.append(this.left).append(" .. ").append(this.right);
                s.append(type.right == Range.Bound.OPEN ? (char)')' : ']');
                break;
            }
            case LEFT_OPEN: {
                s.append(">").append(this.left);
                break;
            }
            case LEFT_CLOSED: {
                s.append(">=").append(this.left);
                break;
            }
            case RIGHT_OPEN: {
                s.append("<").append(this.right);
                break;
            }
            case RIGHT_CLOSED: {
                s.append("<=").append(this.right);
                break;
            }
            default: {
                s.append((Object)type).append(": ").append(this.left).append(" - ").append(this.right);
            }
        }
        return s.toString();
    }

    public Range.Type getType() {
        return this.type;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public static RangeParser parse(String text) throws ParseException {
        int first = 0;
        int last = text.length() - 1;
        first = RangeParser.nextNonSpace(text, first, last);
        last = RangeParser.prevNonSpace(text, first, last);
        char ch = text.charAt(first);
        char ch2 = text.charAt(last);
        if (ch == '[' || ch == '(') {
            if (ch2 != ']' && ch2 != ')') {
                throw new ParseException("An illegal opening bracket without closing", first);
            }
            ++first;
            first = RangeParser.nextNonSpace(text, first, last);
            --last;
            RangeParser result = RangeParser.parseRangeBySeparator(text, first, last = RangeParser.prevNonSpace(text, first, last));
            if (result == null) {
                throw new ParseException("No required bounds separator is found inside the range", first);
            }
            result.type = ch == '(' ? (ch2 == ')' ? Range.Type.OPEN : Range.Type.OPEN_CLOSED) : (ch2 == ')' ? Range.Type.CLOSED_OPEN : Range.Type.CLOSED);
            return result;
        }
        if (ch == '>' || ch == '<') {
            Range.Type type;
            if (++first > last) {
                throw new ParseException("No comparable value", last);
            }
            ch2 = text.charAt(first);
            if (ch2 == '=') {
                type = ch == '>' ? Range.Type.LEFT_CLOSED : Range.Type.RIGHT_CLOSED;
                ++first;
            } else {
                type = ch == '>' ? Range.Type.LEFT_OPEN : Range.Type.RIGHT_OPEN;
            }
            first = RangeParser.nextNonSpace(text, first, last);
            int last2 = last;
            for (int i = first; i <= last; ++i) {
                ch2 = text.charAt(i);
                if (ch2 != '>' && ch2 != '<') continue;
                if (ch == ch2) {
                    throw new ParseException("Duplicated comparison sign is found in the range", i);
                }
                last = RangeParser.prevNonSpace(text, first, i - 1);
                int first2 = i;
                if (++first2 > last2) {
                    throw new ParseException("No comparable value for the second comparison sign", last2);
                }
                ch = text.charAt(first2);
                if (ch == '=') {
                    ++first2;
                }
                first2 = RangeParser.nextNonSpace(text, first2, last2);
                if (ch2 == '>') {
                    i = first;
                    first = first2;
                    first2 = i;
                    i = last;
                    last = last2;
                    last2 = i;
                }
                switch (type) {
                    case LEFT_CLOSED: {
                        type = ch == '=' ? Range.Type.CLOSED : Range.Type.CLOSED_OPEN;
                        break;
                    }
                    case RIGHT_CLOSED: {
                        type = ch == '=' ? Range.Type.CLOSED : Range.Type.OPEN_CLOSED;
                        break;
                    }
                    case LEFT_OPEN: {
                        type = ch == '=' ? Range.Type.OPEN_CLOSED : Range.Type.OPEN;
                        break;
                    }
                    case RIGHT_OPEN: {
                        type = ch == '=' ? Range.Type.CLOSED_OPEN : Range.Type.OPEN;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(type.name());
                    }
                }
                return new RangeParser(type, text.substring(first, last + 1), text.substring(first2, last2 + 1));
            }
            return new RangeParser(type, text.substring(first, last + 1));
        }
        if (ch2 == '+') {
            --last;
            last = RangeParser.prevNonSpace(text, first, last);
            return new RangeParser(Range.Type.LEFT_CLOSED, text.substring(first, last + 1));
        }
        int index = RangeParser.findPrevWord(" and more", text, first, last);
        if (index >= 0) {
            return new RangeParser(Range.Type.LEFT_CLOSED, text.substring(first, index + 1));
        }
        index = RangeParser.findPrevWord(" or less", text, first, last);
        if (index >= 0) {
            return new RangeParser(Range.Type.RIGHT_CLOSED, text.substring(first, index + 1));
        }
        index = RangeParser.findNextWord("less than ", text, first, last);
        if (index >= 0) {
            return new RangeParser(Range.Type.RIGHT_OPEN, text.substring(index, last + 1));
        }
        index = RangeParser.findNextWord("more than ", text, first, last);
        if (index >= 0) {
            return new RangeParser(Range.Type.LEFT_OPEN, text.substring(index, last + 1));
        }
        return RangeParser.parseRangeBySeparator(text, first, last);
    }

    private static RangeParser parseRangeBySeparator(String text, int first, int last) throws ParseException {
        Separator sep;
        int index = RangeParser.findSep(text, first, last);
        if (index < 0) {
            return null;
        }
        int sepLeft = RangeParser.prevNonSpace(text, first, index - 1);
        if ((index += (sep = Separator.recognize(text, index)).length()) > last) {
            throw new ParseException("No required bounds separator is found inside the range", last);
        }
        int sepRight = RangeParser.nextNonSpace(text, index, last);
        if (!Character.isWhitespace(text.charAt(sepLeft + 1)) || !Character.isWhitespace(text.charAt(index))) {
            index = sepRight - 1;
            while (index < last && (index = RangeParser.findSep(text, index, last)) >= 0) {
                Separator sep2;
                if (!Character.isWhitespace(text.charAt(index - 1))) continue;
                int prev = index;
                if ((index += (sep2 = Separator.recognize(text, index)).length()) >= last || !Character.isWhitespace(text.charAt(index))) continue;
                sep = sep2;
                sepLeft = RangeParser.prevNonSpace(text, first, prev - 1);
                sepRight = RangeParser.nextNonSpace(text, index, last);
                break;
            }
        }
        return new RangeParser(sep.getType(), text.substring(first, sepLeft + 1), text.substring(sepRight, last + 1));
    }

    private static int nextNonSpace(CharSequence text, int start, int end) throws ParseException {
        int index = StringUtils.firstNonSpace((CharSequence)text, (int)start, (int)(end + 1));
        if (index < 0) {
            throw new ParseException("Unexpected whitespace", start);
        }
        return index;
    }

    private static int prevNonSpace(CharSequence text, int start, int end) throws ParseException {
        int index = StringUtils.lastNonSpace((CharSequence)text, (int)start, (int)(end + 1));
        if (index < 0) {
            throw new ParseException("Unexpected whitespace", start);
        }
        return index;
    }

    private static int findSep(CharSequence text, int start, int end) {
        if (start == -1) {
            return -1;
        }
        block4: for (int i = ++start; i < end; ++i) {
            switch (text.charAt(i)) {
                case '-': 
                case ';': 
                case '\u2026': {
                    return i;
                }
                case '.': {
                    if (i + 1 >= end || text.charAt(i + 1) != '.') continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    private static int findNextWord(CharSequence word, CharSequence text, int start, int end) {
        if (start == -1) {
            return -1;
        }
        int length = word.length();
        if (start + length > end) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            char ch = word.charAt(i);
            char at = text.charAt(start);
            ++start;
            if (Character.isWhitespace(ch)) {
                if (!Character.isWhitespace(at)) {
                    return -1;
                }
                if ((start = StringUtils.firstNonSpace((CharSequence)text, (int)start, (int)(end + 1))) >= 0) continue;
                return -1;
            }
            if (at == ch) continue;
            return -1;
        }
        return start;
    }

    private static int findPrevWord(CharSequence word, CharSequence text, int start, int end) {
        int length = word.length();
        if (start + length > end) {
            return -1;
        }
        for (int i = length - 1; i >= 0; --i) {
            char ch = word.charAt(i);
            char at = text.charAt(end);
            --end;
            if (Character.isWhitespace(ch)) {
                if (!Character.isWhitespace(at)) {
                    return -1;
                }
                try {
                    end = RangeParser.prevNonSpace(text, start, end);
                    continue;
                }
                catch (ParseException ex) {
                    return -1;
                }
            }
            if (at == ch) continue;
            return -1;
        }
        return end;
    }
}

