/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.beans.Transient;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.range.Range;
import org.openl.rules.range.RangeParser;

@XmlRootElement
public class IntRange
extends Range<Long>
implements INumberRange {
    private static final int TO_INT_RANGE_CAST_DISTANCE = 38;
    protected long min;
    protected long max;
    protected final Range.Type type;

    public IntRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.type = max == Long.MAX_VALUE ? Range.Type.LEFT_CLOSED : (min == Long.MIN_VALUE ? Range.Type.RIGHT_CLOSED : Range.Type.CLOSED);
        this.validate();
    }

    public IntRange(long number) {
        this.min = number;
        this.max = number;
        this.type = Range.Type.DEGENERATE;
    }

    public IntRange() {
        this.min = 0L;
        this.max = 0L;
        this.type = Range.Type.DEGENERATE;
    }

    @Override
    public boolean contains(BigInteger value) {
        if (value == null) {
            return false;
        }
        try {
            return this.contains(value.longValueExact());
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    @Override
    public boolean contains(Number n) {
        return n != null && this.contains(n.longValue());
    }

    public IntRange(String range) {
        Range.Type type;
        try {
            RangeParser parser = this.parse(range);
            if (parser == null) {
                type = Range.Type.DEGENERATE;
                this.max = this.min = IntRange.convertToLong(range.trim());
            } else {
                type = parser.getType();
                String left = parser.getLeft();
                String right = parser.getRight();
                this.min = left == null ? Long.MIN_VALUE : IntRange.convertToLong(left);
                this.max = right == null ? Long.MAX_VALUE : IntRange.convertToLong(right);
            }
        }
        catch (RuntimeException ex) {
            try {
                if (!range.contains("less") && !range.contains("more")) {
                    throw ex;
                }
                range = range.replaceAll("less\\s+than", "<").replaceAll("more\\s+than", ">").replaceAll("(\\S+)\\s+or\\s+less", "<=$1").replaceAll("(\\S+)\\s+and\\s+more", ">=$1");
                RangeParser parser = this.parse(range);
                type = parser.getType();
                String left = parser.getLeft();
                String right = parser.getRight();
                this.min = left == null ? Long.MIN_VALUE : IntRange.convertToLong(left);
                this.max = right == null ? Long.MAX_VALUE : IntRange.convertToLong(right);
            }
            catch (Exception ignore) {
                throw ex;
            }
        }
        this.type = type;
        this.validate();
    }

    @Override
    @Transient
    public Range.Type getType() {
        return this.type;
    }

    @Override
    protected Long getLeft() {
        return this.min;
    }

    @Override
    protected Long getRight() {
        return this.max;
    }

    @Override
    protected int compare(Long left, Long right) {
        return Long.compare(left, right);
    }

    public static IntRange autocast(byte x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(byte x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(short x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(short x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(int x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(int x, IntRange y) {
        return 38;
    }

    public static IntRange autocast(long x, IntRange y) {
        return new IntRange(x);
    }

    public static int distance(long x, IntRange y) {
        return 38;
    }

    public static IntRange cast(float x, IntRange y) {
        return new IntRange((long)x);
    }

    public static int distance(float x, IntRange y) {
        return 38;
    }

    public static IntRange cast(double x, IntRange y) {
        return new IntRange((long)x);
    }

    public static int distance(double x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigInteger x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigInteger x, IntRange y) {
        return 38;
    }

    public static IntRange cast(BigDecimal x, IntRange y) {
        return new IntRange(x.longValue());
    }

    public static int distance(BigDecimal x, IntRange y) {
        return 38;
    }

    private static long convertToLong(String text) {
        long multiplier = 1L;
        int start = 0;
        if (text.startsWith("$")) {
            ++start;
        }
        if (text.charAt(start) == ',') {
            throw new NumberFormatException("For input string: \"" + text + "\"");
        }
        int end = text.length();
        switch (text.charAt(end - 1)) {
            case 'B': {
                multiplier *= 1000L;
            }
            case 'M': {
                multiplier *= 1000L;
            }
            case 'K': {
                multiplier *= 1000L;
                --end;
            }
        }
        if (!Character.isDigit(text.charAt(end - 1))) {
            throw new NumberFormatException("For input string: \"" + text + "\"");
        }
        text = text.substring(start, end).replace(",", "");
        long value = Long.parseLong(text);
        return Math.multiplyExact(value, multiplier);
    }
}

