/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.helpers.NumberUtils;

public class EqualsIndex
extends ARuleIndex {
    private final Map<Object, DecisionTableRuleNode> valueNodes;

    public EqualsIndex(DecisionTableRuleNode emptyOrFormulaNodes, Map<Object, DecisionTableRuleNode> valueNodes, ConditionCasts conditionCasts) {
        super(emptyOrFormulaNodes, conditionCasts);
        this.valueNodes = Objects.requireNonNull(valueNodes, "valueNodes cannot be null");
    }

    @Override
    DecisionTableRuleNode findNodeInIndex(Object value) {
        if (value != null) {
            return this.valueNodes.get(value);
        }
        return null;
    }

    public Iterable<DecisionTableRuleNode> nodes() {
        return this.valueNodes.values();
    }

    public static class Builder {
        private Map<Object, DecisionTableRuleNodeBuilder> map = null;
        private Map<Object, DecisionTableRuleNode> nodeMap = null;
        private final DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        private boolean comparatorBasedMap = false;
        private ConditionCasts conditionCasts;

        public void putEmptyRule(int ruleN) {
            this.emptyBuilder.addRule(ruleN);
            if (this.map != null) {
                for (DecisionTableRuleNodeBuilder nodeBuilder : this.map.values()) {
                    nodeBuilder.addRule(ruleN);
                }
            }
        }

        public void setConditionCasts(ConditionCasts conditionCasts) {
            this.conditionCasts = conditionCasts;
        }

        public void putValueToRule(Object value, int ruleN) {
            if (this.comparatorBasedMap && !(value instanceof Comparable)) {
                throw new IllegalArgumentException("Invalid state! Index based on comparable interface.");
            }
            if (this.map == null) {
                if (NumberUtils.isObjectFloatPointNumber(value)) {
                    if (value instanceof BigDecimal) {
                        this.map = new TreeMap<Object, DecisionTableRuleNodeBuilder>();
                        this.nodeMap = new TreeMap<Object, DecisionTableRuleNode>();
                    } else {
                        this.map = new TreeMap<Object, DecisionTableRuleNodeBuilder>(FloatTypeComparator.getInstance());
                        this.nodeMap = new TreeMap<Object, DecisionTableRuleNode>(FloatTypeComparator.getInstance());
                    }
                    this.comparatorBasedMap = true;
                } else {
                    this.map = new HashMap<Object, DecisionTableRuleNodeBuilder>();
                    this.nodeMap = new HashMap<Object, DecisionTableRuleNode>();
                }
            }
            DecisionTableRuleNodeBuilder builder = this.map.computeIfAbsent(value, e -> new DecisionTableRuleNodeBuilder(this.emptyBuilder));
            builder.addRule(ruleN);
        }

        public EqualsIndex build() {
            if (this.map == null) {
                this.nodeMap = Collections.emptyMap();
            } else {
                for (Map.Entry<Object, DecisionTableRuleNodeBuilder> element : this.map.entrySet()) {
                    this.nodeMap.put(element.getKey(), element.getValue().makeNode());
                }
            }
            return new EqualsIndex(this.emptyBuilder.makeNode(), this.nodeMap, this.conditionCasts);
        }
    }
}

