/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.dt.ADtColumnsDefinitionTableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DtColumnsDefinitionMetaInfoReader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.util.TableNameChecker;

public abstract class ADtColumnsDefinitionTableBinder
extends DataNodeBinder {
    String tableNamePrefix;

    public ADtColumnsDefinitionTableBinder(String tableNamePrefix) {
        if (tableNamePrefix == null) {
            throw new NullPointerException();
        }
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        ADtColumnsDefinitionTableBoundNode aDtColumnsDefinitionTableBoundNode = this.makeNode(tsn, module, openl);
        IdentifierNode in = this.parseHeader(tsn);
        if (in != null) {
            String tableName = in.getIdentifier();
            if (TableNameChecker.isInvalidJavaIdentifier((String)tableName)) {
                String formattedPrefix = this.tableNamePrefix.substring(0, this.tableNamePrefix.length() - 2);
                String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", formattedPrefix + " table", tableName);
                bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)in));
            }
            aDtColumnsDefinitionTableBoundNode.setTableName(tableName);
        }
        tsn.setMetaInfoReader(new DtColumnsDefinitionMetaInfoReader(aDtColumnsDefinitionTableBoundNode));
        aDtColumnsDefinitionTableBoundNode.preBind(module, (IBindingContext)bindingContext);
        return aDtColumnsDefinitionTableBoundNode;
    }

    private IdentifierNode parseHeader(TableSyntaxNode tsn) throws OpenLCompilationException {
        IOpenSourceCodeModule src = tsn.getHeader().getModule();
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
        if (parsedHeader.length > 1) {
            return parsedHeader[1];
        }
        return null;
    }

    protected abstract ADtColumnsDefinitionTableBoundNode makeNode(TableSyntaxNode var1, XlsModuleOpenClass var2, OpenL var3);
}

