/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.Arrays;
import java.util.Objects;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.syntax.impl.IdentifierNode;

public class IdentifierNodesBucket {
    private final IdentifierNode[] node;
    private int length;
    private String[] ids;

    public IdentifierNodesBucket(IdentifierNode[] node) {
        this.node = node;
        if (node != null) {
            this.length = node.length;
            if (DataTableBindHelper.isPrecisionNode(node[this.length - 1])) {
                --this.length;
            }
            this.ids = new String[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.ids[i] = node[i].getIdentifier();
            }
        }
    }

    public IdentifierNode[] getNode() {
        return this.node;
    }

    public int getLength() {
        return this.length;
    }

    public String[] getIds() {
        return this.ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierNodesBucket that = (IdentifierNodesBucket)o;
        if (this.length != that.getLength()) {
            return false;
        }
        if (this.node == null || that.getNode() == null) {
            return false;
        }
        return Arrays.equals(this.ids, that.getIds());
    }

    public int hashCode() {
        return Objects.hash(this.length, Arrays.hashCode(this.ids));
    }
}

