/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.ConstantsTableMetaInfoReader;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.FieldMetaInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.ParserUtils;
import org.openl.util.StringUtils;
import org.openl.util.TableNameChecker;

public class ConstantsTableBoundNode
implements IMemberBoundNode {
    private final TableSyntaxNode tableSyntaxNode;
    private final ModuleOpenClass moduleOpenClass;
    private final ILogicalTable table;
    private ILogicalTable normalizedData;
    private final OpenL openl;
    private Collection<ConstantOpenField> constantOpenFields = new ArrayList<ConstantOpenField>();

    ConstantsTableBoundNode(TableSyntaxNode syntaxNode, XlsModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl) {
        this.tableSyntaxNode = syntaxNode;
        this.moduleOpenClass = moduleOpenClass;
        this.table = table;
        this.openl = openl;
    }

    public void addTo(ModuleOpenClass openClass) {
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public ModuleOpenClass getModuleOpenClass() {
        return this.moduleOpenClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRow(ILogicalTable row, IBindingContext cxt) {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        if (ParserUtils.isBlankOrCommented((String)rowSrc.getCode())) {
            return;
        }
        if (row.getWidth() < 2) {
            String errorMessage = "Bad table structure: expected {header} / {type | name}.";
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)rowSrc, (IBindingContext)cxt);
            return;
        }
        GridCellSourceCodeModule typeCellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 0);
        String typeName = typeCellSource.getCode();
        IOpenClass constantType = OpenLManager.makeType((OpenL)cxt.getOpenL(), (String)typeName, (IOpenSourceCodeModule)typeCellSource, (IBindingContext)cxt);
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 1);
        String constantName = nameCellSource.getCode();
        if (TableNameChecker.isInvalidJavaIdentifier((String)constantName)) {
            String errorMessage = String.format("Bad constant name: %s", constantName);
            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)nameCellSource, (IBindingContext)cxt);
        }
        String value = null;
        Object objectValue = null;
        if (row.getWidth() > 2) {
            GridCellSourceCodeModule defaultValueSrc = DatatypeTableBoundNode.getCellSource(row, cxt, 2);
            value = defaultValueSrc.getCode();
            if (ParserUtils.isCommented((String)value) || StringUtils.isBlank((CharSequence)value)) {
                value = null;
            }
            if ("_DEFAULT_".equals(value)) {
                objectValue = constantType.newInstance(this.openl.getVm().getRuntimeEnv());
            } else if (RuleRowHelper.isFormula(value)) {
                SubTextSourceCodeModule source = new SubTextSourceCodeModule((IOpenSourceCodeModule)defaultValueSrc, 1);
                OpenMethodHeader methodHeader = new OpenMethodHeader(constantName, constantType, (IMethodSignature)new MethodSignature(new IParameterDeclaration[0]), null);
                try {
                    boolean noErrors;
                    CompositeMethod compositeMethod;
                    cxt.pushErrors();
                    try {
                        compositeMethod = OpenLManager.makeMethod((OpenL)this.openl, (IOpenSourceCodeModule)source, (IOpenMethodHeader)methodHeader, (IBindingContext)cxt);
                    }
                    finally {
                        List syntaxNodeExceptions = cxt.popErrors();
                        noErrors = syntaxNodeExceptions.isEmpty();
                        syntaxNodeExceptions.forEach(arg_0 -> ((IBindingContext)cxt).addError(arg_0));
                    }
                    if (noErrors) {
                        objectValue = compositeMethod.invoke(null, IBoundNode.EMPTY_RESULT, this.openl.getVm().getRuntimeEnv());
                    }
                }
                catch (Exception ex) {
                    BindHelper.processError((Throwable)ex, (IOpenSourceCodeModule)defaultValueSrc, (IBindingContext)cxt);
                }
            } else if (String.class == constantType.getInstanceClass()) {
                objectValue = value;
            } else if (value != null) {
                if (constantType.getName().startsWith("[[")) {
                    BindHelper.processError((String)"Multi-dimensional arrays are not supported.", (IOpenSourceCodeModule)defaultValueSrc, (IBindingContext)cxt);
                } else {
                    try {
                        objectValue = RuleRowHelper.loadNativeValue(((ILogicalTable)row.getColumn(2)).getCell(0, 0), constantType);
                        if (objectValue == null) {
                            objectValue = String2DataConvertorFactory.parse(constantType.getInstanceClass(), value, cxt);
                        }
                    }
                    catch (RuntimeException e) {
                        String message = String.format("Cannot parse cell value '%s'.", value);
                        BindHelper.processError((String)message, (Throwable)e, (IOpenSourceCodeModule)defaultValueSrc, (IBindingContext)cxt);
                    }
                }
            }
        }
        try {
            FieldMetaInfo fieldMetaInfo = new FieldMetaInfo(constantType.getName(), constantName, (ISyntaxNode)this.tableSyntaxNode, this.tableSyntaxNode.getUri());
            ConstantOpenField constantField = new ConstantOpenField(constantName, objectValue, value, constantType, this.moduleOpenClass, (IMemberMetaInfo)fieldMetaInfo);
            this.moduleOpenClass.addField((IOpenField)constantField);
            this.constantOpenFields.add(constantField);
        }
        catch (Exception t) {
            BindHelper.processError((Throwable)t, (IOpenSourceCodeModule)rowSrc, (IBindingContext)cxt);
        }
    }

    private void addConstants(IBindingContext bindingContext) {
        ILogicalTable dataTable;
        this.normalizedData = dataTable = DatatypeHelper.getNormalizedDataPartTable(this.table, this.openl, bindingContext);
        int tableHeight = 0;
        if (dataTable != null) {
            tableHeight = dataTable.getHeight();
        }
        for (int i = 0; i < tableHeight; ++i) {
            this.processRow((ILogicalTable)dataTable.getRow(i), bindingContext);
        }
    }

    public void finalizeBind(IBindingContext bindingContext) {
        if (!bindingContext.isExecutionMode()) {
            this.getTableSyntaxNode().setMetaInfoReader(new ConstantsTableMetaInfoReader(this));
        }
        this.addConstants(bindingContext);
        ILogicalTable tableBody = this.getTableSyntaxNode().getTableBody();
        this.getTableSyntaxNode().getSubTables().put("business", tableBody);
    }

    public void removeDebugInformation(IBindingContext bindingContext) {
        if (bindingContext.isExecutionMode()) {
            for (ConstantOpenField constantOpenField : this.constantOpenFields) {
                constantOpenField.setMemberMetaInfo(null);
            }
            this.constantOpenFields = null;
        }
    }

    public ILogicalTable getNormalizedData() {
        return this.normalizedData;
    }

    public Collection<ConstantOpenField> getConstantOpenFields() {
        return this.constantOpenFields;
    }
}

