/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.constants;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.constants.ConstantsTableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.util.TableNameChecker;

public class ConstantsTableBinder
extends AXlsTableBinder {
    private static final byte CONSTANTS_TABLE_NAME_INDEX = 1;

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        String constantsTableName;
        ILogicalTable table = tsn.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), (IBindingContext)bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        if (parsedHeader.length > 1 && TableNameChecker.isInvalidJavaIdentifier((String)(constantsTableName = parsedHeader[1].getIdentifier()))) {
            String message = String.format("%s '%s' name error. Name can only have letters, digits, _, $ and should not start with a digit.", "Constants table", constantsTableName);
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)message, (ISyntaxNode)parsedHeader[1]));
        }
        return new ConstantsTableBoundNode(tsn, module, table, openl);
    }
}

